/*
 * Decompiled with CFR 0.152.
 */
package crypto.reporting;

import com.google.common.base.Joiner;
import crypto.analysis.errors.AbstractError;
import crypto.reporting.Reporter;
import crypto.rules.CrySLRule;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.SootClass;
import soot.SootMethod;

public class CSVReporter
extends Reporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(CSVReporter.class);
    private static final String CSV_SEPARATOR = ";";
    private static final String REPORT_NAME = "CryptoAnalysis-Report.csv";
    private List<String> headers = new ArrayList<String>();
    private List<String> contents = new ArrayList<String>();

    public CSVReporter(String reportDir, String softwareId, List<CrySLRule> rules, long callGraphConstructionTime, boolean includeStatistics) {
        super(reportDir != null ? new File(reportDir) : new File(System.getProperty("user.dir")), softwareId, rules, callGraphConstructionTime, includeStatistics);
        for (Headers headers : Headers.values()) {
            this.headers.add(headers.toString());
        }
        if (this.includeStatistics()) {
            for (Enum enum_ : StatisticHeaders.values()) {
                this.headers.add(enum_.toString());
            }
        }
    }

    @Override
    public void handleAnalysisResults() {
        int idCount = 0;
        for (SootClass c : this.errorMarkers.rowKeySet()) {
            String className = c.getName();
            for (Map.Entry e : this.errorMarkers.row(c).entrySet()) {
                String methodName = ((SootMethod)e.getKey()).getSubSignature();
                for (AbstractError marker : (Set)e.getValue()) {
                    String errorType = marker.getClass().getSimpleName();
                    String violatingClass = marker.getRule().getClassName();
                    String errorMessage = marker.toErrorMarkerString();
                    int lineNumber = marker.getErrorLocation().getUnit().get().getJavaSourceStartLineNumber();
                    String statement = marker.getErrorLocation().getUnit().get().toString();
                    String line = idCount + CSV_SEPARATOR + errorType + CSV_SEPARATOR + violatingClass + CSV_SEPARATOR + className + CSV_SEPARATOR + methodName + CSV_SEPARATOR + lineNumber + CSV_SEPARATOR + statement + CSV_SEPARATOR + errorMessage;
                    if (this.includeStatistics()) {
                        line = line + CSV_SEPARATOR + this.getStatistics().getSoftwareID() + CSV_SEPARATOR + this.getStatistics().getSeedObjectCount() + CSV_SEPARATOR + this.getStatistics().getAnalysisTime() + CSV_SEPARATOR + this.getStatistics().getCallgraphTime() + CSV_SEPARATOR + this.getStatistics().getCallgraphReachableMethods() + CSV_SEPARATOR + this.getStatistics().getCallgraphReachableMethodsWithActiveBodies() + CSV_SEPARATOR + this.getStatistics().getDataflowVisitedMethods();
                    }
                    this.contents.add(line);
                    ++idCount;
                }
            }
        }
        this.writeToFile();
    }

    private void writeToFile() {
        try {
            FileWriter writer = new FileWriter(this.getOutputFolder() + File.separator + REPORT_NAME);
            writer.write(Joiner.on(CSV_SEPARATOR).join(this.headers) + "\n");
            for (String line : this.contents) {
                writer.write(line + "\n");
            }
            writer.close();
            LOGGER.info("CSV Report generated to file : " + this.getOutputFolder().getAbsolutePath() + File.separator + REPORT_NAME);
        }
        catch (IOException e) {
            LOGGER.error("Could not write to " + this.getOutputFolder().getAbsolutePath() + File.separator + REPORT_NAME, e);
        }
    }

    private static enum StatisticHeaders {
        SoftwareID,
        SeedObjectCount,
        CryptoAnalysisTime_ms,
        CallGraphTime_ms,
        CallGraphReachableMethods,
        CallGraphReachableMethods_ActiveBodies,
        DataflowVisitedMethod;

    }

    private static enum Headers {
        ErrorID,
        ErrorType,
        ViolatingClass,
        Class,
        Method,
        LineNumber,
        Statement,
        Message;

    }
}

