/*
 * Decompiled with CFR 0.152.
 */
package crypto.cryslhandler;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import crypto.cryslhandler.CryslReaderUtils;
import crypto.rules.CrySLMethod;
import crypto.rules.StateMachineGraph;
import crypto.rules.StateNode;
import crypto.rules.TransitionEdge;
import de.darmstadt.tu.crossing.crySL.Event;
import de.darmstadt.tu.crossing.crySL.Expression;
import de.darmstadt.tu.crossing.crySL.RequiredBlock;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class StateMachineGraphBuilder {
    private final Expression order;
    private final StateMachineGraph result;
    private final Set<CrySLMethod> allMethods;

    public StateMachineGraphBuilder(Expression order, RequiredBlock events) {
        this.order = order;
        this.allMethods = this.retrieveAllMethodsFromEVENTSBlock(events);
        this.result = new StateMachineGraph();
    }

    private Set<CrySLMethod> retrieveAllMethodsFromEVENTSBlock(RequiredBlock events) {
        return events.getReq_event().parallelStream().flatMap(event -> CryslReaderUtils.resolveAggregateToMethodeNames(event).stream()).collect(Collectors.toSet());
    }

    private Set<StateNode> parseOrderAndGetEndStates(Expression order, Collection<StateNode> startNodes) {
        StateNode oneStartNode = startNodes.iterator().next();
        Set<TransitionEdge> initialEdgesOnOneStartNode = this.result.getAllOutgoingEdges(oneStartNode);
        HashSet<StateNode> endNodes = Sets.newHashSet();
        if (order.getOrderop() == null) {
            StateNode endNode2 = this.result.createNewNode();
            endNodes.add(endNode2);
            List<CrySLMethod> label = !order.getOrderEv().isEmpty() ? CryslReaderUtils.resolveAggregateToMethodeNames((Event)order.getOrderEv().get(0)) : Lists.newArrayList(this.allMethods);
            for (StateNode startNode : startNodes) {
                this.result.createNewEdge(label, startNode, endNode2);
            }
        } else if (order.getOrderop().equals(",")) {
            endNodes.addAll(this.parseOrderAndGetEndStates(order.getRight(), this.parseOrderAndGetEndStates(order.getLeft(), startNodes)));
        } else if (order.getOrderop().equals("|")) {
            endNodes.addAll(this.parseOrderAndGetEndStates(order.getLeft(), startNodes));
            endNodes.addAll(this.parseOrderAndGetEndStates(order.getRight(), startNodes));
            Set endNodesWithOutgoingEdges = this.result.getEdges().parallelStream().map(edge -> edge.from()).filter(node -> endNodes.contains(node)).collect(Collectors.toSet());
            if (endNodesWithOutgoingEdges.size() < endNodes.size() - 1) {
                endNodes.removeAll(endNodesWithOutgoingEdges);
                StateNode aggrNode = this.result.aggregateNodesToOneNode(endNodes, (StateNode)endNodes.iterator().next());
                endNodes.clear();
                endNodes.add(aggrNode);
                endNodes.addAll(endNodesWithOutgoingEdges);
            }
        }
        String elementop = order.getElementop();
        if (elementop != null) {
            if (!elementop.equals("?")) {
                Set<TransitionEdge> newOutgoingEdgesOnStartNodes = this.result.getAllOutgoingEdges(oneStartNode);
                newOutgoingEdgesOnStartNodes.removeAll(initialEdgesOnOneStartNode);
                for (TransitionEdge newEdge : newOutgoingEdgesOnStartNodes) {
                    endNodes.forEach(endNode -> this.result.createNewEdge(newEdge.getLabel(), (StateNode)endNode, newEdge.getRight()));
                }
            }
            if (!elementop.equals("+")) {
                endNodes.addAll(startNodes);
            }
        }
        return endNodes;
    }

    public StateMachineGraph buildSMG() {
        StateNode initialNode = new StateNode("-1", true, true);
        this.result.addNode(initialNode);
        if (this.order != null) {
            Set<StateNode> acceptingNodes = this.parseOrderAndGetEndStates(this.order, Sets.newHashSet(this.result.getNodes()));
            acceptingNodes.parallelStream().forEach(node -> node.setAccepting(true));
        }
        if (this.result.getAllTransitions().isEmpty()) {
            this.result.createNewEdge(Lists.newArrayList(), initialNode, initialNode);
        }
        return this.result;
    }
}

