/*
 * Decompiled with CFR 0.152.
 */
package crypto.constraints;

import boomerang.jimple.Statement;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import crypto.analysis.AlternativeReqPredicate;
import crypto.analysis.AnalysisSeedWithSpecification;
import crypto.analysis.ClassSpecification;
import crypto.analysis.CrySLResultsReporter;
import crypto.analysis.RequiredCrySLPredicate;
import crypto.analysis.errors.AbstractError;
import crypto.analysis.errors.ConstraintError;
import crypto.analysis.errors.ForbiddenMethodError;
import crypto.analysis.errors.HardCodedError;
import crypto.analysis.errors.ImpreciseValueExtractionError;
import crypto.analysis.errors.InstanceOfError;
import crypto.analysis.errors.NeverTypeOfError;
import crypto.extractparameter.CallSiteWithExtractedValue;
import crypto.extractparameter.CallSiteWithParamIndex;
import crypto.extractparameter.ExtractedValue;
import crypto.interfaces.ICrySLPredicateParameter;
import crypto.interfaces.ISLConstraint;
import crypto.rules.CrySLArithmeticConstraint;
import crypto.rules.CrySLComparisonConstraint;
import crypto.rules.CrySLConstraint;
import crypto.rules.CrySLMethod;
import crypto.rules.CrySLObject;
import crypto.rules.CrySLPredicate;
import crypto.rules.CrySLSplitter;
import crypto.rules.CrySLValueConstraint;
import crypto.typestate.CrySLMethodToSootMethod;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Body;
import soot.IntType;
import soot.SootMethod;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.jimple.AssignStmt;
import soot.jimple.Constant;
import soot.jimple.IntConstant;
import soot.jimple.InvokeExpr;
import soot.jimple.LongConstant;
import soot.jimple.NewExpr;
import soot.jimple.Stmt;
import soot.jimple.StringConstant;
import soot.jimple.internal.JNewArrayExpr;

public class ConstraintSolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConstraintSolver.class);
    private final List<ISLConstraint> allConstraints;
    private final Set<ISLConstraint> relConstraints = Sets.newHashSet();
    private final List<ISLConstraint> requiredPredicates = Lists.newArrayList();
    private final Collection<Statement> collectedCalls;
    private final Multimap<CallSiteWithParamIndex, ExtractedValue> parsAndVals;
    public static final List<String> predefinedPreds = Arrays.asList("callTo", "noCallTo", "neverTypeOf", "length", "notHardCoded", "instanceOf");
    private final CrySLResultsReporter reporter;
    private final AnalysisSeedWithSpecification object;
    private final ClassSpecification classSpec;
    private Collection<CallSiteWithParamIndex> parameterAnalysisQuerySites;
    private Multimap<CallSiteWithParamIndex, Type> propagatedTypes;

    public ConstraintSolver(AnalysisSeedWithSpecification object, Collection<Statement> collectedCalls, CrySLResultsReporter crySLResultsReporter) {
        this.object = object;
        this.classSpec = object.getSpec();
        this.parsAndVals = object.getParameterAnalysis().getCollectedValues();
        this.propagatedTypes = object.getParameterAnalysis().getPropagatedTypes();
        this.parameterAnalysisQuerySites = object.getParameterAnalysis().getAllQuerySites();
        this.collectedCalls = collectedCalls;
        this.allConstraints = this.classSpec.getRule().getConstraints();
        for (ISLConstraint cons : this.allConstraints) {
            Set<String> involvedVarNames = cons.getInvolvedVarNames();
            for (CallSiteWithParamIndex cwpi : this.parameterAnalysisQuerySites) {
                involvedVarNames.remove(cwpi.getVarName());
            }
            if (!involvedVarNames.isEmpty() && (!cons.toString().contains("speccedKey") || involvedVarNames.size() != 1)) continue;
            if (cons instanceof CrySLPredicate) {
                CrySLPredicate innerPred;
                RequiredCrySLPredicate pred = this.retrieveValuesForPred(cons);
                if (pred == null || (innerPred = pred.getPred()) == null) continue;
                this.relConstraints.add(innerPred);
                this.requiredPredicates.add(pred);
                continue;
            }
            if (cons instanceof CrySLConstraint) {
                ISLConstraint right = ((CrySLConstraint)cons).getRight();
                if (right instanceof CrySLPredicate && !predefinedPreds.contains(((CrySLPredicate)right).getPredName())) {
                    this.requiredPredicates.add(this.collectAlternativePredicates((CrySLConstraint)cons, null));
                    continue;
                }
                this.relConstraints.add(cons);
                continue;
            }
            this.relConstraints.add(cons);
        }
        this.reporter = crySLResultsReporter;
    }

    private ISLConstraint collectAlternativePredicates(CrySLConstraint cons, AlternativeReqPredicate alt) {
        CrySLPredicate right = (CrySLPredicate)cons.getRight();
        if (alt == null) {
            alt = new AlternativeReqPredicate(right, right.getLocation());
        } else {
            alt.addAlternative(right);
        }
        if (!(cons.getLeft() instanceof CrySLPredicate)) {
            return this.collectAlternativePredicates((CrySLConstraint)cons.getLeft(), alt);
        }
        alt.addAlternative((CrySLPredicate)cons.getLeft());
        return alt;
    }

    private RequiredCrySLPredicate retrieveValuesForPred(ISLConstraint cons) {
        CrySLPredicate pred = (CrySLPredicate)cons;
        for (CallSiteWithParamIndex cwpi : this.parameterAnalysisQuerySites) {
            for (ICrySLPredicateParameter p : pred.getParameters()) {
                if (p.getName().equals("transformation") || !cwpi.getVarName().equals(p.getName())) continue;
                return new RequiredCrySLPredicate(pred, cwpi.stmt());
            }
        }
        return null;
    }

    private static String retrieveConstantFromValue(Value val) {
        if (val instanceof StringConstant) {
            return ((StringConstant)val).value;
        }
        if (val instanceof IntConstant || val.getType() instanceof IntType) {
            return val.toString();
        }
        if (val instanceof LongConstant) {
            return val.toString().replaceAll("L", "");
        }
        return "";
    }

    public int evaluateRelConstraints() {
        int fail = 0;
        block0: for (ISLConstraint con : this.relConstraints) {
            EvaluableConstraint currentConstraint = this.createConstraint(con);
            currentConstraint.evaluate();
            for (AbstractError e : currentConstraint.getErrors()) {
                if (e instanceof ImpreciseValueExtractionError) {
                    this.reporter.reportError(this.object, new ImpreciseValueExtractionError(con, e.getErrorLocation(), e.getRule()));
                    continue block0;
                }
                ++fail;
                this.reporter.reportError(this.object, e);
            }
        }
        return fail;
    }

    public EvaluableConstraint createConstraint(ISLConstraint con) {
        if (con instanceof CrySLComparisonConstraint) {
            return new ComparisonConstraint((CrySLComparisonConstraint)con);
        }
        if (con instanceof CrySLValueConstraint) {
            return new ValueConstraint((CrySLValueConstraint)con);
        }
        if (con instanceof CrySLPredicate) {
            return new PredicateConstraint((CrySLPredicate)con);
        }
        if (con instanceof CrySLConstraint) {
            return new BinaryConstraint((CrySLConstraint)con);
        }
        return null;
    }

    public List<ISLConstraint> getAllConstraints() {
        return this.allConstraints;
    }

    public Set<ISLConstraint> getRelConstraints() {
        return this.relConstraints;
    }

    public List<ISLConstraint> getRequiredPredicates() {
        return this.requiredPredicates;
    }

    protected boolean isSubType(String typeOne, String typeTwo) {
        boolean subTypes = typeOne.equals(typeTwo);
        if (!(subTypes |= (typeOne + "[]").equals(typeTwo))) {
            try {
                subTypes = Class.forName(typeOne).isAssignableFrom(Class.forName(typeTwo));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return subTypes;
    }

    public boolean isHardCoded(ExtractedValue val) {
        return val.getValue() instanceof IntConstant || val.getValue() instanceof StringConstant || val.getValue() instanceof NewExpr && ((NewExpr)val.getValue()).getType().toString().equals("java.math.BigInteger");
    }

    public abstract class EvaluableConstraint {
        Set<AbstractError> errors = Sets.newHashSet();
        ISLConstraint origin;

        public abstract void evaluate();

        public EvaluableConstraint(ISLConstraint con) {
            this.origin = con;
        }

        protected Collection<AbstractError> getErrors() {
            return this.errors;
        }

        public boolean hasErrors() {
            return !this.errors.isEmpty();
        }

        protected Map<String, CallSiteWithExtractedValue> extractValueAsString(String varName, ISLConstraint cons) {
            HashMap<String, CallSiteWithExtractedValue> varVal = Maps.newHashMap();
            for (CallSiteWithParamIndex wrappedCallSite : ConstraintSolver.this.parsAndVals.keySet()) {
                Stmt callSite = wrappedCallSite.stmt().getUnit().get();
                for (ExtractedValue wrappedAllocSite : ConstraintSolver.this.parsAndVals.get(wrappedCallSite)) {
                    Stmt allocSite = wrappedAllocSite.stmt().getUnit().get();
                    if (!wrappedCallSite.getVarName().equals(varName)) continue;
                    InvokeExpr invoker = callSite.getInvokeExpr();
                    if (callSite.equals(allocSite)) {
                        varVal.put(ConstraintSolver.retrieveConstantFromValue(invoker.getArg(wrappedCallSite.getIndex())), new CallSiteWithExtractedValue(wrappedCallSite, wrappedAllocSite));
                        continue;
                    }
                    if (!(allocSite instanceof AssignStmt)) continue;
                    if (wrappedAllocSite.getValue() instanceof Constant) {
                        String retrieveConstantFromValue = ConstraintSolver.retrieveConstantFromValue(wrappedAllocSite.getValue());
                        int pos = -1;
                        for (int i = 0; i < invoker.getArgs().size(); ++i) {
                            if (!((AssignStmt)allocSite).getLeftOpBox().getValue().toString().equals(invoker.getArgs().get(i).toString())) continue;
                            pos = i;
                        }
                        if (pos > -1 && "boolean".equals(invoker.getMethodRef().getParameterType(pos).toQuotedString())) {
                            varVal.put("0".equals(retrieveConstantFromValue) ? "false" : "true", new CallSiteWithExtractedValue(wrappedCallSite, wrappedAllocSite));
                            continue;
                        }
                        varVal.put(retrieveConstantFromValue, new CallSiteWithExtractedValue(wrappedCallSite, wrappedAllocSite));
                        continue;
                    }
                    if (!(wrappedAllocSite.getValue() instanceof JNewArrayExpr)) continue;
                    varVal.putAll(this.extractSootArray(wrappedCallSite, wrappedAllocSite));
                }
            }
            return varVal;
        }

        protected Map<String, CallSiteWithExtractedValue> extractSootArray(CallSiteWithParamIndex callSite, ExtractedValue allocSite) {
            Value arrayLocal = allocSite.getValue();
            Body methodBody = allocSite.stmt().getMethod().getActiveBody();
            HashMap<String, CallSiteWithExtractedValue> arrVal = Maps.newHashMap();
            if (methodBody != null) {
                Iterator unitIterator = methodBody.getUnits().snapshotIterator();
                while (unitIterator.hasNext()) {
                    Unit unit = (Unit)unitIterator.next();
                    if (!(unit instanceof AssignStmt)) continue;
                    AssignStmt uStmt = (AssignStmt)unit;
                    Value leftValue = uStmt.getLeftOp();
                    Value rightValue = uStmt.getRightOp();
                    if (!leftValue.toString().contains(arrayLocal.toString()) || rightValue.toString().contains("newarray")) continue;
                    arrVal.put(ConstraintSolver.retrieveConstantFromValue(rightValue), new CallSiteWithExtractedValue(callSite, allocSite));
                }
            }
            return arrVal;
        }
    }

    public class ValueConstraint
    extends EvaluableConstraint {
        public ValueConstraint(CrySLValueConstraint c) {
            super(c);
        }

        @Override
        public void evaluate() {
            CrySLValueConstraint valCons = (CrySLValueConstraint)this.origin;
            CrySLObject var = valCons.getVar();
            List<Map.Entry<String, CallSiteWithExtractedValue>> vals = this.getValFromVar(var, valCons);
            if (vals.isEmpty()) {
                return;
            }
            for (Map.Entry<String, CallSiteWithExtractedValue> val : vals) {
                List values = valCons.getValueRange().parallelStream().map(e -> e.toLowerCase()).collect(Collectors.toList());
                if (values.contains(val.getKey().toLowerCase())) continue;
                this.errors.add(new ConstraintError(val.getValue(), ConstraintSolver.this.classSpec.getRule(), ConstraintSolver.this.object, valCons));
            }
        }

        private List<Map.Entry<String, CallSiteWithExtractedValue>> getValFromVar(CrySLObject var, ISLConstraint cons) {
            String varName = var.getVarName();
            Map<String, CallSiteWithExtractedValue> valueCollection = this.extractValueAsString(varName, cons);
            ArrayList<Map.Entry<String, CallSiteWithExtractedValue>> vals = new ArrayList<Map.Entry<String, CallSiteWithExtractedValue>>();
            if (valueCollection.isEmpty()) {
                return vals;
            }
            for (Map.Entry<String, CallSiteWithExtractedValue> e : valueCollection.entrySet()) {
                CrySLSplitter splitter = var.getSplitter();
                CallSiteWithExtractedValue location = e.getValue();
                String val = e.getKey();
                if (splitter != null) {
                    int ind = splitter.getIndex();
                    String splitElement = splitter.getSplitter();
                    if (ind > 0) {
                        String[] splits = val.split(splitElement);
                        if (splits.length > ind) {
                            vals.add(new AbstractMap.SimpleEntry<String, CallSiteWithExtractedValue>(splits[ind], location));
                            continue;
                        }
                        vals.add(new AbstractMap.SimpleEntry<String, CallSiteWithExtractedValue>("", location));
                        continue;
                    }
                    vals.add(new AbstractMap.SimpleEntry<String, CallSiteWithExtractedValue>(val.split(splitElement)[ind], location));
                    continue;
                }
                vals.add(new AbstractMap.SimpleEntry<String, CallSiteWithExtractedValue>(val, location));
            }
            return vals;
        }
    }

    public class ComparisonConstraint
    extends EvaluableConstraint {
        public ComparisonConstraint(CrySLComparisonConstraint c) {
            super(c);
        }

        @Override
        public void evaluate() {
            CrySLComparisonConstraint compConstraint = (CrySLComparisonConstraint)this.origin;
            Map<Integer, CallSiteWithExtractedValue> left = this.evaluate(compConstraint.getLeft());
            Map<Integer, CallSiteWithExtractedValue> right = this.evaluate(compConstraint.getRight());
            for (Map.Entry<Integer, CallSiteWithExtractedValue> entry : right.entrySet()) {
                if (entry.getKey() != Integer.MIN_VALUE) continue;
                this.errors.add(new ConstraintError(entry.getValue(), ConstraintSolver.this.classSpec.getRule(), ConstraintSolver.this.object, compConstraint));
                return;
            }
            for (Map.Entry<Integer, CallSiteWithExtractedValue> leftie : left.entrySet()) {
                if (leftie.getKey() == Integer.MIN_VALUE) {
                    this.errors.add(new ConstraintError(leftie.getValue(), ConstraintSolver.this.classSpec.getRule(), ConstraintSolver.this.object, compConstraint));
                    return;
                }
                for (Map.Entry<Integer, CallSiteWithExtractedValue> rightie : right.entrySet()) {
                    boolean cons = true;
                    switch (compConstraint.getOperator()) {
                        case eq: {
                            cons = leftie.getKey().equals(rightie.getKey());
                            break;
                        }
                        case g: {
                            cons = leftie.getKey() > rightie.getKey();
                            break;
                        }
                        case ge: {
                            cons = leftie.getKey() >= rightie.getKey();
                            break;
                        }
                        case l: {
                            cons = leftie.getKey() < rightie.getKey();
                            break;
                        }
                        case le: {
                            cons = leftie.getKey() <= rightie.getKey();
                            break;
                        }
                        case neq: {
                            cons = leftie.getKey() != rightie.getKey();
                            break;
                        }
                        default: {
                            cons = false;
                        }
                    }
                    if (cons) continue;
                    this.errors.add(new ConstraintError(leftie.getValue(), ConstraintSolver.this.classSpec.getRule(), ConstraintSolver.this.object, this.origin));
                    return;
                }
            }
        }

        private Map<Integer, CallSiteWithExtractedValue> evaluate(CrySLArithmeticConstraint arith) {
            Map<Integer, CallSiteWithExtractedValue> left = this.extractValueAsInt(arith.getLeft(), arith);
            Map<Integer, CallSiteWithExtractedValue> right = this.extractValueAsInt(arith.getRight(), arith);
            for (Map.Entry<Integer, CallSiteWithExtractedValue> rightie : right.entrySet()) {
                if (rightie.getKey() != Integer.MIN_VALUE) continue;
                return left;
            }
            HashMap<Integer, CallSiteWithExtractedValue> results = new HashMap<Integer, CallSiteWithExtractedValue>();
            for (Map.Entry<Integer, CallSiteWithExtractedValue> leftie : left.entrySet()) {
                if (leftie.getKey() == Integer.MIN_VALUE) {
                    return left;
                }
                for (Map.Entry<Integer, CallSiteWithExtractedValue> rightie : right.entrySet()) {
                    int sum = 0;
                    switch (arith.getOperator()) {
                        case n: {
                            sum = leftie.getKey() - rightie.getKey();
                            break;
                        }
                        case p: {
                            sum = leftie.getKey() + rightie.getKey();
                            break;
                        }
                        case m: {
                            sum = leftie.getKey() % rightie.getKey();
                            break;
                        }
                        default: {
                            sum = 0;
                        }
                    }
                    if (rightie.getValue() != null) {
                        results.put(sum, rightie.getValue());
                        continue;
                    }
                    results.put(sum, leftie.getValue());
                }
            }
            return results;
        }

        private Map<Integer, CallSiteWithExtractedValue> extractValueAsInt(ICrySLPredicateParameter par, CrySLArithmeticConstraint arith) {
            if (par instanceof CrySLPredicate) {
                PredicateConstraint predicateConstraint = new PredicateConstraint((CrySLPredicate)par);
                predicateConstraint.evaluate();
                if (!predicateConstraint.getErrors().isEmpty()) {
                    for (AbstractError err : predicateConstraint.getErrors()) {
                        this.errors.add(new ImpreciseValueExtractionError(arith, err.getErrorLocation(), err.getRule()));
                    }
                    predicateConstraint.errors.clear();
                }
                return new HashMap<Integer, CallSiteWithExtractedValue>();
            }
            return this.extractValueAsInt(par.getName(), (ISLConstraint)arith);
        }

        private Map<Integer, CallSiteWithExtractedValue> extractValueAsInt(String exp, ISLConstraint cons) {
            HashMap<Integer, CallSiteWithExtractedValue> valuesInt = new HashMap<Integer, CallSiteWithExtractedValue>();
            if (exp.equalsIgnoreCase("true")) {
                valuesInt.put(1, null);
                return valuesInt;
            }
            if (exp.equalsIgnoreCase("false")) {
                valuesInt.put(0, null);
                return valuesInt;
            }
            try {
                valuesInt.put(Integer.parseInt(exp), null);
                return valuesInt;
            }
            catch (NumberFormatException ex) {
                Map<String, CallSiteWithExtractedValue> valueCollection = this.extractValueAsString(exp, cons);
                if (valueCollection.isEmpty()) {
                    return valuesInt;
                }
                try {
                    for (Map.Entry<String, CallSiteWithExtractedValue> value : valueCollection.entrySet()) {
                        if (value.getKey().equals("true")) {
                            valuesInt.put(1, value.getValue());
                            continue;
                        }
                        if (value.getKey().equals("false")) {
                            valuesInt.put(0, value.getValue());
                            continue;
                        }
                        valuesInt.put(Integer.parseInt(value.getKey()), value.getValue());
                    }
                }
                catch (NumberFormatException ex1) {
                    LOGGER.error("An exception occured when extracting value as Integer.", ex1);
                }
                return valuesInt;
            }
        }
    }

    public class PredicateConstraint
    extends EvaluableConstraint {
        public PredicateConstraint(CrySLPredicate c) {
            super(c);
        }

        @Override
        public void evaluate() {
            CrySLPredicate predicateConstraint = (CrySLPredicate)this.origin;
            String predName = predicateConstraint.getPredName();
            if (predefinedPreds.contains(predName)) {
                this.handlePredefinedNames(predicateConstraint);
            }
        }

        private void handlePredefinedNames(CrySLPredicate pred) {
            List<ICrySLPredicateParameter> parameters = pred.getParameters();
            switch (pred.getPredName()) {
                case "callTo": {
                    List<ICrySLPredicateParameter> predMethods = parameters;
                    for (ICrySLPredicateParameter predMethod : predMethods) {
                        CrySLMethod reqMethod = (CrySLMethod)predMethod;
                        for (Statement unit : ConstraintSolver.this.collectedCalls) {
                            if (!unit.isCallsite()) continue;
                            SootMethod foundCall = unit.getUnit().get().getInvokeExpr().getMethod();
                            Collection<SootMethod> convert = CrySLMethodToSootMethod.v().convert(reqMethod);
                            if (!convert.contains(foundCall)) continue;
                            return;
                        }
                    }
                    return;
                }
                case "noCallTo": {
                    if (ConstraintSolver.this.collectedCalls.isEmpty()) {
                        return;
                    }
                    List<ICrySLPredicateParameter> predForbiddenMethods = parameters;
                    for (ICrySLPredicateParameter predForbMethod : predForbiddenMethods) {
                        CrySLMethod reqMethod = (CrySLMethod)predForbMethod;
                        for (Statement call : ConstraintSolver.this.collectedCalls) {
                            if (!call.isCallsite()) continue;
                            SootMethod foundCall = call.getUnit().get().getInvokeExpr().getMethod();
                            Collection<SootMethod> convert = CrySLMethodToSootMethod.v().convert(reqMethod);
                            if (!convert.contains(foundCall)) continue;
                            this.errors.add(new ForbiddenMethodError(call, ConstraintSolver.this.classSpec.getRule(), foundCall, convert));
                            return;
                        }
                    }
                    return;
                }
                case "neverTypeOf": {
                    String varName = ((CrySLObject)parameters.get(0)).getVarName();
                    for (CallSiteWithParamIndex cs : ConstraintSolver.this.parameterAnalysisQuerySites) {
                        if (!cs.getVarName().equals(varName)) continue;
                        Collection vals = ConstraintSolver.this.propagatedTypes.get(cs);
                        for (Type t : vals) {
                            if (!t.toQuotedString().equals(parameters.get(1).getName())) continue;
                            for (ExtractedValue v : ConstraintSolver.this.parsAndVals.get(cs)) {
                                this.errors.add(new NeverTypeOfError(new CallSiteWithExtractedValue(cs, v), ConstraintSolver.this.classSpec.getRule(), ConstraintSolver.this.object, pred));
                            }
                            return;
                        }
                    }
                    return;
                }
                case "length": {
                    return;
                }
                case "notHardCoded": {
                    CrySLObject varNotToBeHardCoded = (CrySLObject)pred.getParameters().get(0);
                    String name = varNotToBeHardCoded.getVarName();
                    String type = varNotToBeHardCoded.getJavaType();
                    for (CallSiteWithParamIndex cs : ConstraintSolver.this.parsAndVals.keySet()) {
                        if (!cs.getVarName().equals(name)) continue;
                        Collection values = ConstraintSolver.this.parsAndVals.get(cs);
                        for (ExtractedValue v : values) {
                            if (!ConstraintSolver.this.isSubType(type, v.getValue().getType().toQuotedString()) || !ConstraintSolver.this.isHardCoded(v) && !this.isHardCodedArray(this.extractSootArray(cs, v))) continue;
                            this.errors.add(new HardCodedError(new CallSiteWithExtractedValue(cs, v), ConstraintSolver.this.classSpec.getRule(), ConstraintSolver.this.object, pred));
                        }
                    }
                    return;
                }
                case "instanceOf": {
                    String varName = ((CrySLObject)parameters.get(0)).getVarName();
                    for (CallSiteWithParamIndex cs : ConstraintSolver.this.parameterAnalysisQuerySites) {
                        Collection vals;
                        if (!cs.getVarName().equals(varName) || (vals = ConstraintSolver.this.propagatedTypes.get(cs)).parallelStream().anyMatch(e -> ConstraintSolver.this.isSubType(e.toQuotedString(), ((ICrySLPredicateParameter)parameters.get(1)).getName()) || ConstraintSolver.this.isSubType(((ICrySLPredicateParameter)parameters.get(1)).getName(), e.toQuotedString()))) continue;
                        for (ExtractedValue v : ConstraintSolver.this.parsAndVals.get(cs)) {
                            this.errors.add(new InstanceOfError(new CallSiteWithExtractedValue(cs, v), ConstraintSolver.this.classSpec.getRule(), ConstraintSolver.this.object, pred));
                        }
                    }
                    return;
                }
            }
        }

        private boolean isHardCodedArray(Map<String, CallSiteWithExtractedValue> extractSootArray) {
            return extractSootArray.keySet().size() != 1 || !extractSootArray.containsKey("");
        }
    }

    private class BinaryConstraint
    extends EvaluableConstraint {
        public BinaryConstraint(CrySLConstraint c) {
            super(c);
        }

        @Override
        public void evaluate() {
            CrySLConstraint binaryConstraint = (CrySLConstraint)this.origin;
            EvaluableConstraint left = ConstraintSolver.this.createConstraint(binaryConstraint.getLeft());
            EvaluableConstraint right = ConstraintSolver.this.createConstraint(binaryConstraint.getRight());
            left.evaluate();
            CrySLConstraint.LogOps ops = binaryConstraint.getOperator();
            if (ops.equals((Object)CrySLConstraint.LogOps.implies)) {
                if (left.hasErrors()) {
                    return;
                }
                right.evaluate();
                this.errors.addAll(right.getErrors());
                return;
            }
            if (ops.equals((Object)CrySLConstraint.LogOps.or)) {
                right.evaluate();
                this.errors.addAll(left.getErrors());
                this.errors.addAll(right.getErrors());
                return;
            }
            if (ops.equals((Object)CrySLConstraint.LogOps.and)) {
                if (left.hasErrors()) {
                    this.errors.addAll(left.getErrors());
                    return;
                }
                right.evaluate();
                this.errors.addAll(right.getErrors());
                return;
            }
            if (ops.equals((Object)CrySLConstraint.LogOps.eq)) {
                right.evaluate();
                if (left.hasErrors() && right.hasErrors() || !left.hasErrors() && !right.hasErrors()) {
                    return;
                }
                this.errors.addAll(right.getErrors());
                return;
            }
            this.errors.addAll(left.getErrors());
        }
    }
}

