/*
 * Decompiled with CFR 0.152.
 */
package crypto.analysis.errors;

import boomerang.jimple.Statement;
import crypto.analysis.errors.AbstractError;
import crypto.analysis.errors.ErrorVisitor;
import crypto.extractparameter.CallSiteWithExtractedValue;
import crypto.rules.CrySLPredicate;
import crypto.rules.CrySLRule;

public class RequiredPredicateError
extends AbstractError {
    private CrySLPredicate contradictedPredicate;
    private CallSiteWithExtractedValue extractedValues;

    public RequiredPredicateError(CrySLPredicate contradictedPredicate, Statement location, CrySLRule rule, CallSiteWithExtractedValue multimap) {
        super(location, rule);
        this.contradictedPredicate = contradictedPredicate;
        this.extractedValues = multimap;
    }

    public CrySLPredicate getContradictedPredicate() {
        return this.contradictedPredicate;
    }

    public CallSiteWithExtractedValue getExtractedValues() {
        return this.extractedValues;
    }

    @Override
    public void accept(ErrorVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public String toErrorMarkerString() {
        String msg = this.extractedValues.toString();
        msg = msg + " was not properly generated as ";
        String predicateName = this.getContradictedPredicate().getPredName();
        String[] parts = predicateName.split("(?=[A-Z])");
        msg = msg + parts[0];
        for (int i = 1; i < parts.length; ++i) {
            msg = msg + parts[i];
        }
        if (predicateName.equals("preparedIV") && this.extractedValues.toString().equals("Third parameter")) {
            msg = msg + " [ with CBC, It's required to use IVParameterSpec]";
        }
        return msg;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.contradictedPredicate == null ? 0 : this.contradictedPredicate.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RequiredPredicateError other = (RequiredPredicateError)obj;
        return !(this.contradictedPredicate == null ? other.contradictedPredicate != null : !this.contradictedPredicate.equals(other.contradictedPredicate));
    }
}

