/*
 * Decompiled with CFR 0.152.
 */
package crypto.analysis.errors;

import boomerang.jimple.Statement;
import boomerang.jimple.Val;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import crypto.analysis.IAnalysisSeed;
import crypto.analysis.errors.ErrorVisitor;
import crypto.analysis.errors.ErrorWithObjectAllocation;
import crypto.rules.CrySLRule;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import soot.SootMethod;
import soot.jimple.InvokeExpr;
import soot.jimple.Stmt;

public class IncompleteOperationError
extends ErrorWithObjectAllocation {
    private Val errorVariable;
    private Collection<SootMethod> expectedMethodCalls;
    private Set<String> expectedMethodCallsSet = Sets.newHashSet();

    public IncompleteOperationError(Statement errorLocation, Val errorVariable, CrySLRule rule, IAnalysisSeed objectLocation, Collection<SootMethod> expectedMethodsToBeCalled) {
        super(errorLocation, rule, objectLocation);
        this.errorVariable = errorVariable;
        this.expectedMethodCalls = expectedMethodsToBeCalled;
        for (SootMethod method : this.expectedMethodCalls) {
            this.expectedMethodCallsSet.add(method.getSignature());
        }
    }

    public Val getErrorVariable() {
        return this.errorVariable;
    }

    public Collection<SootMethod> getExpectedMethodCalls() {
        return this.expectedMethodCalls;
    }

    @Override
    public void accept(ErrorVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public String toErrorMarkerString() {
        Collection<SootMethod> expectedCalls = this.getExpectedMethodCalls();
        StringBuilder msg = new StringBuilder();
        msg.append("Operation");
        msg.append(this.getObjectType());
        msg.append(" object not completed. Expected call to ");
        HashSet<String> altMethods = new HashSet<String>();
        for (SootMethod expectedCall : expectedCalls) {
            if (this.stmtInvokesExpectedCallName(expectedCall.getName())) {
                altMethods.add(expectedCall.getSignature().replace("<", "").replace(">", ""));
                continue;
            }
            altMethods.add(expectedCall.getName().replace("<", "").replace(">", ""));
        }
        msg.append(Joiner.on(", ").join(altMethods));
        return msg.toString();
    }

    private boolean stmtInvokesExpectedCallName(String expectedCallName) {
        InvokeExpr call;
        SootMethod calledMethod;
        Stmt stmt;
        Optional<Stmt> stmtOptional;
        Statement errorLocation = this.getErrorLocation();
        return errorLocation.isCallsite() && (stmtOptional = errorLocation.getUnit()).isPresent() && (stmt = stmtOptional.get()).containsInvokeExpr() && (calledMethod = (call = stmt.getInvokeExpr()).getMethod()).getName().equals(expectedCallName);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.expectedMethodCallsSet == null ? 0 : this.expectedMethodCallsSet.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IncompleteOperationError other = (IncompleteOperationError)obj;
        return !(this.expectedMethodCalls == null ? other.expectedMethodCalls != null : this.expectedMethodCallsSet != other.expectedMethodCallsSet);
    }

    private int expectedMethodCallsHashCode(Collection<SootMethod> expectedMethodCalls) {
        HashSet<String> expectedMethodCallsSet = Sets.newHashSet();
        for (SootMethod method : expectedMethodCalls) {
            expectedMethodCallsSet.add(method.getSignature());
        }
        return expectedMethodCallsSet.hashCode();
    }
}

