/*
 * Decompiled with CFR 0.152.
 */
package crypto.analysis;

import com.google.common.collect.Lists;
import crypto.exceptions.CryptoAnalysisException;
import crypto.rules.CrySLRule;
import crypto.rules.CrySLRuleReader;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrySLRulesetSelector {
    private static final Logger LOGGER = LoggerFactory.getLogger(CrySLRulesetSelector.class);

    public static List<CrySLRule> makeFromRuleset(String rulesBasePath, RuleFormat ruleFormat, Ruleset ... set) throws CryptoAnalysisException {
        ArrayList<CrySLRule> rules = Lists.newArrayList();
        for (Ruleset s2 : set) {
            rules.addAll(CrySLRulesetSelector.getRulesset(rulesBasePath, ruleFormat, s2));
        }
        if (rules.isEmpty()) {
            LOGGER.info("No CrySL rules found for rulesset " + set);
        }
        return rules;
    }

    public static List<CrySLRule> makeFromRulesetString(String rulesBasePath, RuleFormat ruleFormat, String rulesetString) throws CryptoAnalysisException {
        String[] set = rulesetString.split(",");
        ArrayList<Ruleset> ruleset = Lists.newArrayList();
        for (String s2 : set) {
            if (s2.equalsIgnoreCase(Ruleset.JavaCryptographicArchitecture.name())) {
                ruleset.add(Ruleset.JavaCryptographicArchitecture);
            }
            if (s2.equalsIgnoreCase(Ruleset.BouncyCastle.name())) {
                ruleset.add(Ruleset.BouncyCastle);
            }
            if (!s2.equalsIgnoreCase(Ruleset.Tink.name())) continue;
            ruleset.add(Ruleset.Tink);
        }
        if (ruleset.isEmpty()) {
            throw new CryptoAnalysisException("Could not parse " + rulesetString + ". Was not able to find rulesets.");
        }
        return CrySLRulesetSelector.makeFromRuleset(rulesBasePath, ruleFormat, ruleset.toArray(new Ruleset[ruleset.size()]));
    }

    private static List<CrySLRule> getRulesset(String rulesBasePath, RuleFormat ruleFormat, Ruleset s2) throws CryptoAnalysisException {
        File[] listFiles;
        ArrayList<CrySLRule> rules = Lists.newArrayList();
        for (File file : listFiles = new File(rulesBasePath + (Object)((Object)s2) + "/").listFiles()) {
            CrySLRule rule = CrySLRuleReader.readFromSourceFile(file);
            if (rule == null) continue;
            rules.add(rule);
        }
        if (rules.isEmpty()) {
            throw new CryptoAnalysisException("No CrySL rules found in " + rulesBasePath + (Object)((Object)s2) + "/");
        }
        return rules;
    }

    public static CrySLRule makeSingleRule(String rulesBasePath, RuleFormat ruleFormat, Ruleset ruleset, String rulename) throws CryptoAnalysisException {
        File file = new File(rulesBasePath + "/" + (Object)((Object)ruleset) + "/" + rulename + (Object)((Object)RuleFormat.SOURCE));
        if (file.exists() && file.isFile()) {
            CrySLRule rule = CrySLRuleReader.readFromSourceFile(file);
            if (rule != null) {
                return rule;
            }
            throw new CryptoAnalysisException("CrySL rule couldn't created from path " + file.getAbsolutePath());
        }
        throw new CryptoAnalysisException("The specified path is not a file " + file.getAbsolutePath());
    }

    @Deprecated
    public static List<CrySLRule> makeFromPath(File resourcesPath, RuleFormat ruleFormat) throws CryptoAnalysisException {
        return CrySLRuleReader.readFromDirectory(resourcesPath);
    }

    @Deprecated
    public static List<CrySLRule> makeFromZip(File resourcesPath) throws CryptoAnalysisException {
        return CrySLRuleReader.readFromZipFile(resourcesPath);
    }

    public static enum Ruleset {
        JavaCryptographicArchitecture,
        BouncyCastle,
        Tink;

    }

    public static enum RuleFormat {
        SOURCE{

            public String toString() {
                return ".crysl";
            }
        };

    }
}

