/*
 * Decompiled with CFR 0.152.
 */
package crypto.analysis;

import boomerang.callgraph.ObservableICFG;
import boomerang.debugger.Debugger;
import boomerang.jimple.AllocVal;
import boomerang.jimple.Statement;
import boomerang.jimple.Val;
import boomerang.results.ForwardBoomerangResults;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import crypto.analysis.AlternativeReqPredicate;
import crypto.analysis.AnalysisSeedWithEnsuredPredicate;
import crypto.analysis.ClassSpecification;
import crypto.analysis.CrySLResultsReporter;
import crypto.analysis.CryptoScanner;
import crypto.analysis.EnsuredCrySLPredicate;
import crypto.analysis.IAnalysisSeed;
import crypto.analysis.RequiredCrySLPredicate;
import crypto.analysis.ResultsHandler;
import crypto.analysis.errors.IncompleteOperationError;
import crypto.analysis.errors.TypestateError;
import crypto.constraints.ConstraintSolver;
import crypto.extractparameter.CallSiteWithParamIndex;
import crypto.extractparameter.ExtractParameterAnalysis;
import crypto.extractparameter.ExtractedValue;
import crypto.interfaces.ICrySLPredicateParameter;
import crypto.interfaces.ISLConstraint;
import crypto.rules.CrySLCondPredicate;
import crypto.rules.CrySLConstraint;
import crypto.rules.CrySLMethod;
import crypto.rules.CrySLObject;
import crypto.rules.CrySLPredicate;
import crypto.rules.StateNode;
import crypto.rules.TransitionEdge;
import crypto.typestate.CrySLMethodToSootMethod;
import crypto.typestate.ExtendedIDEALAnaylsis;
import crypto.typestate.ReportingErrorStateNode;
import crypto.typestate.SootBasedStateMachineGraph;
import crypto.typestate.WrappedState;
import ideal.IDEALSeedSolver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import soot.IntType;
import soot.Local;
import soot.RefType;
import soot.SootMethod;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.jimple.AssignStmt;
import soot.jimple.Constant;
import soot.jimple.IntConstant;
import soot.jimple.InvokeExpr;
import soot.jimple.StringConstant;
import soot.jimple.ThrowStmt;
import sync.pds.solver.nodes.Node;
import typestate.TransitionFunction;
import typestate.finiteautomata.ITransition;
import typestate.finiteautomata.State;

public class AnalysisSeedWithSpecification
extends IAnalysisSeed {
    private final ClassSpecification spec;
    private ExtendedIDEALAnaylsis analysis;
    private ForwardBoomerangResults<TransitionFunction> results;
    private Collection<EnsuredCrySLPredicate> ensuredPredicates = Sets.newHashSet();
    private Multimap<Statement, State> typeStateChange = HashMultimap.create();
    private Collection<EnsuredCrySLPredicate> indirectlyEnsuredPredicates = Sets.newHashSet();
    private Set<ISLConstraint> missingPredicates = Sets.newHashSet();
    private ConstraintSolver constraintSolver;
    private boolean internalConstraintSatisfied;
    protected Map<Statement, SootMethod> allCallsOnObject = Maps.newLinkedHashMap();
    private ExtractParameterAnalysis parameterAnalysis;
    private Set<ResultsHandler> resultHandlers = Sets.newHashSet();
    private boolean secure = true;
    private static final List<String> trackedTypes = Arrays.asList("java.lang.String", "int", "java.lang.Integer");

    public AnalysisSeedWithSpecification(final CryptoScanner cryptoScanner, Statement stmt, Val val, final ClassSpecification spec) {
        super(cryptoScanner, stmt, val, spec.getFSM().getInitialWeight(stmt));
        this.spec = spec;
        this.analysis = new ExtendedIDEALAnaylsis(){

            @Override
            public SootBasedStateMachineGraph getStateMachine() {
                return spec.getFSM();
            }

            @Override
            protected ObservableICFG<Unit, SootMethod> icfg() {
                return cryptoScanner.icfg();
            }

            @Override
            protected Debugger<TransitionFunction> debugger(IDEALSeedSolver<TransitionFunction> solver) {
                return cryptoScanner.debugger(solver, AnalysisSeedWithSpecification.this);
            }

            @Override
            public CrySLResultsReporter analysisListener() {
                return cryptoScanner.getAnalysisListener();
            }
        };
    }

    @Override
    public String toString() {
        return "AnalysisSeed [" + super.toString() + " with spec " + this.spec.getRule().getClassName() + "]";
    }

    @Override
    public void execute() {
        this.cryptoScanner.getAnalysisListener().seedStarted(this);
        this.runTypestateAnalysis();
        if (this.results == null) {
            return;
        }
        this.allCallsOnObject = this.results.getInvokedMethodOnInstance();
        this.runExtractParameterAnalysis();
        this.checkInternalConstraints();
        HashMultimap<Statement, ? extends State> unitToStates = HashMultimap.create();
        for (Table.Cell<Statement, Val, TransitionFunction> c : this.results.asStatementValWeightTable().cellSet()) {
            unitToStates.putAll(c.getRowKey(), this.getTargetStates(c.getValue()));
            for (EnsuredCrySLPredicate pred : this.indirectlyEnsuredPredicates) {
                this.predicateHandler.addNewPred(this, c.getRowKey(), c.getColumnKey(), pred);
            }
        }
        this.computeTypestateErrorUnits();
        this.computeTypestateErrorsForEndOfObjectLifeTime();
        this.cryptoScanner.getAnalysisListener().onSeedFinished(this, this.results);
        this.cryptoScanner.getAnalysisListener().collectedValues(this, this.parameterAnalysis.getCollectedValues());
    }

    private void checkInternalConstraints() {
        this.cryptoScanner.getAnalysisListener().beforeConstraintCheck(this);
        this.constraintSolver = new ConstraintSolver(this, this.allCallsOnObject.keySet(), this.cryptoScanner.getAnalysisListener());
        this.cryptoScanner.getAnalysisListener().checkedConstraints(this, this.constraintSolver.getRelConstraints());
        this.internalConstraintSatisfied = 0 == this.constraintSolver.evaluateRelConstraints();
        this.cryptoScanner.getAnalysisListener().afterConstraintCheck(this);
    }

    private void runTypestateAnalysis() {
        this.analysis.run(this);
        this.results = this.analysis.getResults();
        if (this.results != null) {
            for (ResultsHandler handler : Lists.newArrayList(this.resultHandlers)) {
                handler.done(this.results);
            }
        }
    }

    public void registerResultsHandler(ResultsHandler handler) {
        if (this.results != null) {
            handler.done(this.results);
        } else {
            this.resultHandlers.add(handler);
        }
    }

    private void runExtractParameterAnalysis() {
        this.parameterAnalysis = new ExtractParameterAnalysis(this.cryptoScanner, this.allCallsOnObject, this.spec.getFSM());
        this.parameterAnalysis.run();
    }

    private void computeTypestateErrorUnits() {
        HashSet<Statement> allTypestateChangeStatements = Sets.newHashSet();
        for (Table.Cell<Statement, Val, TransitionFunction> c : this.results.asStatementValWeightTable().cellSet()) {
            allTypestateChangeStatements.addAll(c.getValue().getLastStateChangeStatements());
        }
        for (Table.Cell<Statement, Val, TransitionFunction> c : this.results.asStatementValWeightTable().cellSet()) {
            Statement curr = c.getRowKey();
            if (!allTypestateChangeStatements.contains(curr)) continue;
            Collection<? extends State> targetStates = this.getTargetStates(c.getValue());
            for (State state : targetStates) {
                this.typeStateChangeAtStatement(curr, state);
            }
        }
    }

    private void computeTypestateErrorsForEndOfObjectLifeTime() {
        Table<Statement, Val, TransitionFunction> endPathOfPropagation = this.results.getObjectDestructingStatements();
        for (Table.Cell<Statement, Val, TransitionFunction> c : endPathOfPropagation.cellSet()) {
            HashSet<SootMethod> expectedMethodsToBeCalled = Sets.newHashSet();
            for (ITransition n : c.getValue().values()) {
                if (n.to() == null || n.to().isAccepting() || !(n.to() instanceof WrappedState)) continue;
                WrappedState wrappedState = (WrappedState)n.to();
                for (TransitionEdge t : this.spec.getRule().getUsagePattern().getAllTransitions()) {
                    if (!t.getLeft().equals(wrappedState.delegate()) || t.from().equals(t.to())) continue;
                    Collection<SootMethod> converted = CrySLMethodToSootMethod.v().convert(t.getLabel());
                    expectedMethodsToBeCalled.addAll(converted);
                }
            }
            if (expectedMethodsToBeCalled.isEmpty()) continue;
            Statement s2 = c.getRowKey();
            Val val = c.getColumnKey();
            if (s2.getUnit().get() instanceof ThrowStmt) continue;
            this.cryptoScanner.getAnalysisListener().reportError(this, new IncompleteOperationError(s2, val, this.getSpec().getRule(), this, expectedMethodsToBeCalled));
        }
    }

    private void typeStateChangeAtStatement(Statement curr, State stateNode) {
        if (this.typeStateChange.put(curr, stateNode) && stateNode instanceof ReportingErrorStateNode) {
            ReportingErrorStateNode errorStateNode = (ReportingErrorStateNode)stateNode;
            this.cryptoScanner.getAnalysisListener().reportError(this, new TypestateError(curr, this.getSpec().getRule(), this, errorStateNode.getExpectedCalls()));
        }
        this.onAddedTypestateChange(curr, stateNode);
    }

    private void onAddedTypestateChange(Statement curr, State stateNode) {
        for (CrySLPredicate predToBeEnsured : this.spec.getRule().getPredicates()) {
            if (predToBeEnsured.isNegated().booleanValue() || !this.isPredicateGeneratingState(predToBeEnsured, stateNode)) continue;
            this.ensuresPred(predToBeEnsured, curr, stateNode);
        }
    }

    private void ensuresPred(CrySLPredicate predToBeEnsured, Statement currStmt, State stateNode) {
        if (predToBeEnsured.isNegated().booleanValue()) {
            return;
        }
        boolean satisfiesConstraintSytem = this.checkConstraintSystem();
        if (predToBeEnsured.getConstraint() != null) {
            ArrayList temp = new ArrayList();
            temp.add(predToBeEnsured.getConstraint());
            satisfiesConstraintSytem = !this.evaluatePredCond(predToBeEnsured);
        }
        for (ICrySLPredicateParameter predicateParam : predToBeEnsured.getParameters()) {
            if (!predicateParam.getName().equals("this")) continue;
            this.expectPredicateWhenThisObjectIsInState(stateNode, currStmt, predToBeEnsured, satisfiesConstraintSytem);
        }
        if (currStmt.isCallsite()) {
            InvokeExpr ie = currStmt.getUnit().get().getInvokeExpr();
            SootMethod invokedMethod = ie.getMethod();
            Collection<CrySLMethod> convert = CrySLMethodToSootMethod.v().convert(invokedMethod);
            for (CrySLMethod crySLMethod : convert) {
                Map.Entry<String, String> retObject = crySLMethod.getRetObject();
                if (!retObject.getKey().equals("_") && currStmt.getUnit().get() instanceof AssignStmt && this.predicateParameterEquals(predToBeEnsured.getParameters(), retObject.getKey())) {
                    AssignStmt as = (AssignStmt)currStmt.getUnit().get();
                    Value leftOp = as.getLeftOp();
                    AllocVal val = new AllocVal(leftOp, currStmt.getMethod(), as.getRightOp(), new Statement(as, currStmt.getMethod()));
                    this.expectPredicateOnOtherObject(predToBeEnsured, currStmt, val, satisfiesConstraintSytem);
                }
                int i = 0;
                for (Map.Entry<String, String> p : crySLMethod.getParameters()) {
                    Value param;
                    if (this.predicateParameterEquals(predToBeEnsured.getParameters(), p.getKey()) && (param = ie.getArg(i)) instanceof Local) {
                        Val val = new Val(param, currStmt.getMethod());
                        this.expectPredicateOnOtherObject(predToBeEnsured, currStmt, val, satisfiesConstraintSytem);
                    }
                    ++i;
                }
            }
        }
    }

    private boolean predicateParameterEquals(List<ICrySLPredicateParameter> parameters, String key) {
        for (ICrySLPredicateParameter predicateParam : parameters) {
            if (!key.equals(predicateParam.getName())) continue;
            return true;
        }
        return false;
    }

    private void expectPredicateOnOtherObject(CrySLPredicate predToBeEnsured, Statement currStmt, Val accessGraph, boolean satisfiesConstraintSytem) {
        boolean matched = false;
        for (ClassSpecification spec : this.cryptoScanner.getClassSpecifictions()) {
            Type baseType;
            if (accessGraph.value() == null || !((baseType = accessGraph.value().getType()) instanceof RefType)) continue;
            RefType refType = (RefType)baseType;
            if (!spec.getRule().getClassName().equals(refType.getSootClass().getName()) && !spec.getRule().getClassName().equals(refType.getSootClass().getShortName()) || !satisfiesConstraintSytem) continue;
            AnalysisSeedWithSpecification seed = this.cryptoScanner.getOrCreateSeedWithSpec(new AnalysisSeedWithSpecification(this.cryptoScanner, currStmt, accessGraph, spec));
            matched = true;
            seed.addEnsuredPredicateFromOtherRule(new EnsuredCrySLPredicate(predToBeEnsured, this.parameterAnalysis.getCollectedValues()));
        }
        if (matched) {
            return;
        }
        AnalysisSeedWithEnsuredPredicate seed = this.cryptoScanner.getOrCreateSeed(new Node<Statement, Val>(currStmt, accessGraph));
        this.predicateHandler.expectPredicate(seed, currStmt, predToBeEnsured);
        if (satisfiesConstraintSytem) {
            seed.addEnsuredPredicate(new EnsuredCrySLPredicate(predToBeEnsured, this.parameterAnalysis.getCollectedValues()));
        } else {
            this.missingPredicates.add(new RequiredCrySLPredicate(predToBeEnsured, currStmt));
        }
    }

    private void addEnsuredPredicateFromOtherRule(EnsuredCrySLPredicate ensuredCrySLPredicate) {
        this.indirectlyEnsuredPredicates.add(ensuredCrySLPredicate);
        if (this.results == null) {
            return;
        }
        for (Table.Cell<Statement, Val, TransitionFunction> c : this.results.asStatementValWeightTable().cellSet()) {
            for (EnsuredCrySLPredicate pred : this.indirectlyEnsuredPredicates) {
                this.predicateHandler.addNewPred(this, c.getRowKey(), c.getColumnKey(), pred);
            }
        }
    }

    private void expectPredicateWhenThisObjectIsInState(State stateNode, Statement currStmt, CrySLPredicate predToBeEnsured, boolean satisfiesConstraintSytem) {
        this.predicateHandler.expectPredicate(this, currStmt, predToBeEnsured);
        if (!satisfiesConstraintSytem) {
            return;
        }
        for (Table.Cell<Statement, Val, TransitionFunction> e : this.results.asStatementValWeightTable().cellSet()) {
            if (!this.containsTargetState(e.getValue(), stateNode)) continue;
            this.predicateHandler.addNewPred(this, e.getRowKey(), e.getColumnKey(), new EnsuredCrySLPredicate(predToBeEnsured, this.parameterAnalysis.getCollectedValues()));
        }
    }

    private boolean containsTargetState(TransitionFunction value, State stateNode) {
        return this.getTargetStates(value).contains(stateNode);
    }

    private Collection<? extends State> getTargetStates(TransitionFunction value) {
        HashSet<State> res = Sets.newHashSet();
        for (ITransition t : value.values()) {
            if (t.to() == null) continue;
            res.add(t.to());
        }
        return res;
    }

    private boolean checkConstraintSystem() {
        this.cryptoScanner.getAnalysisListener().beforePredicateCheck(this);
        Set<ISLConstraint> relConstraints = this.constraintSolver.getRelConstraints();
        boolean checkPredicates = this.checkPredicates(relConstraints);
        this.cryptoScanner.getAnalysisListener().afterPredicateCheck(this);
        if (!checkPredicates) {
            return false;
        }
        return this.internalConstraintSatisfied;
    }

    private boolean checkPredicates(Collection<ISLConstraint> relConstraints) {
        ArrayList<ISLConstraint> requiredPredicates = Lists.newArrayList();
        for (ISLConstraint con : this.constraintSolver.getRequiredPredicates()) {
            if (ConstraintSolver.predefinedPreds.contains(con instanceof RequiredCrySLPredicate ? ((RequiredCrySLPredicate)con).getPred().getPredName() : ((AlternativeReqPredicate)con).getAlternatives().get(0).getPredName())) continue;
            requiredPredicates.add(con);
        }
        HashSet remainingPredicates = Sets.newHashSet(requiredPredicates);
        this.missingPredicates.removeAll(remainingPredicates);
        block1: for (ISLConstraint pred : requiredPredicates) {
            if (pred instanceof RequiredCrySLPredicate) {
                RequiredCrySLPredicate reqPred = (RequiredCrySLPredicate)pred;
                if (reqPred.getPred().isNegated().booleanValue()) {
                    for (EnsuredCrySLPredicate ensPred : this.ensuredPredicates) {
                        if (!ensPred.getPredicate().equals(reqPred.getPred())) continue;
                        return false;
                    }
                    remainingPredicates.remove(pred);
                    continue;
                }
                for (EnsuredCrySLPredicate ensPred : this.ensuredPredicates) {
                    if (!ensPred.getPredicate().equals(reqPred.getPred()) || !this.doPredsMatch(reqPred.getPred(), ensPred)) continue;
                    remainingPredicates.remove(pred);
                }
                continue;
            }
            AlternativeReqPredicate alt = (AlternativeReqPredicate)pred;
            List<CrySLPredicate> alternatives = alt.getAlternatives();
            boolean satisfied = false;
            List negatives = alternatives.parallelStream().filter(e -> e.isNegated()).collect(Collectors.toList());
            if (negatives.size() == alternatives.size()) {
                for (EnsuredCrySLPredicate ensPred : this.ensuredPredicates) {
                    if (!alternatives.parallelStream().anyMatch(e -> e.getPredName().equals(ensPred.getPredicate().getPredName()))) continue;
                    return false;
                }
                remainingPredicates.remove(pred);
                continue;
            }
            if (negatives.isEmpty()) {
                for (EnsuredCrySLPredicate ensPred : this.ensuredPredicates) {
                    if (!alternatives.parallelStream().anyMatch(e -> ensPred.getPredicate().equals(e) && this.doPredsMatch((CrySLPredicate)e, ensPred))) continue;
                    remainingPredicates.remove(pred);
                    continue block1;
                }
                continue;
            }
            boolean neg = true;
            for (EnsuredCrySLPredicate ensPred : this.ensuredPredicates) {
                if (negatives.parallelStream().anyMatch(e -> e.equals(ensPred.getPredicate()))) {
                    neg = false;
                }
                alternatives.removeAll(negatives);
                if (alternatives.parallelStream().allMatch(e -> ensPred.getPredicate().equals(e) && this.doPredsMatch((CrySLPredicate)e, ensPred))) {
                    satisfied = true;
                }
                if (!(satisfied | neg)) continue;
                remainingPredicates.remove(pred);
            }
        }
        for (ISLConstraint rem : Lists.newArrayList(remainingPredicates)) {
            List<CrySLPredicate> altPred;
            if (rem instanceof RequiredCrySLPredicate) {
                RequiredCrySLPredicate singlePred = (RequiredCrySLPredicate)rem;
                if (!this.evaluatePredCond(singlePred.getPred())) continue;
                remainingPredicates.remove(singlePred);
                continue;
            }
            if (!(rem instanceof CrySLConstraint) || !(altPred = ((AlternativeReqPredicate)rem).getAlternatives()).parallelStream().anyMatch(e -> this.evaluatePredCond((CrySLPredicate)e))) continue;
            remainingPredicates.remove(rem);
        }
        this.missingPredicates.addAll(remainingPredicates);
        return remainingPredicates.isEmpty();
    }

    private boolean evaluatePredCond(CrySLPredicate pred) {
        ISLConstraint conditional = pred.getConstraint();
        if (conditional != null) {
            ConstraintSolver.EvaluableConstraint evalCons = this.constraintSolver.createConstraint(conditional);
            evalCons.evaluate();
            if (evalCons.hasErrors()) {
                return true;
            }
        }
        return false;
    }

    private boolean doPredsMatch(CrySLPredicate pred, EnsuredCrySLPredicate ensPred) {
        boolean requiredPredicatesExist = true;
        for (int i = 0; i < pred.getParameters().size(); ++i) {
            String var = pred.getParameters().get(i).getName();
            if (this.isOfNonTrackableType(var)) continue;
            if (pred.getInvolvedVarNames().contains(var)) {
                CrySLObject obj;
                String parameterI = ensPred.getPredicate().getParameters().get(i).getName();
                Collection<Object> actVals = Collections.emptySet();
                Collection<Object> expVals = Collections.emptySet();
                for (CallSiteWithParamIndex cswpi : ensPred.getParametersToValues().keySet()) {
                    if (!cswpi.getVarName().equals(parameterI)) continue;
                    actVals = this.retrieveValueFromUnit(cswpi, ensPred.getParametersToValues().get(cswpi));
                }
                for (CallSiteWithParamIndex cswpi : this.parameterAnalysis.getCollectedValues().keySet()) {
                    if (!cswpi.getVarName().equals(var)) continue;
                    expVals = this.retrieveValueFromUnit(cswpi, this.parameterAnalysis.getCollectedValues().get(cswpi));
                }
                String splitter = "";
                int index = -1;
                if (pred.getParameters().get(i) instanceof CrySLObject && (obj = (CrySLObject)pred.getParameters().get(i)).getSplitter() != null) {
                    splitter = obj.getSplitter().getSplitter();
                    index = obj.getSplitter().getIndex();
                }
                for (String foundVal : expVals) {
                    if (index > -1) {
                        foundVal = foundVal.split(splitter)[index];
                    }
                    actVals = actVals.parallelStream().map(e -> e.toLowerCase()).collect(Collectors.toList());
                    requiredPredicatesExist &= actVals.contains(foundVal.toLowerCase());
                }
                continue;
            }
            requiredPredicatesExist = false;
        }
        return pred.isNegated() != requiredPredicatesExist;
    }

    private Collection<String> retrieveValueFromUnit(CallSiteWithParamIndex cswpi, Collection<ExtractedValue> collection) {
        ArrayList<String> values = new ArrayList<String>();
        for (ExtractedValue q : collection) {
            Unit u = q.stmt().getUnit().get();
            if (cswpi.stmt().equals(q.stmt())) {
                if (u instanceof AssignStmt) {
                    values.add(this.retrieveConstantFromValue(((AssignStmt)u).getRightOp().getUseBoxes().get(cswpi.getIndex()).getValue()));
                    continue;
                }
                values.add(this.retrieveConstantFromValue(u.getUseBoxes().get(cswpi.getIndex()).getValue()));
                continue;
            }
            if (!(u instanceof AssignStmt)) continue;
            Value rightSide = ((AssignStmt)u).getRightOp();
            if (rightSide instanceof Constant) {
                values.add(this.retrieveConstantFromValue(rightSide));
                continue;
            }
            List<ValueBox> list = rightSide.getUseBoxes();
        }
        return values;
    }

    private String retrieveConstantFromValue(Value val) {
        if (val instanceof StringConstant) {
            return ((StringConstant)val).value;
        }
        if (val instanceof IntConstant || val.getType() instanceof IntType) {
            return val.toString();
        }
        return "";
    }

    private boolean isOfNonTrackableType(String varName) {
        for (Map.Entry<String, String> object : this.spec.getRule().getObjects()) {
            if (!object.getValue().equals(varName) || !trackedTypes.contains(object.getKey())) continue;
            return false;
        }
        return true;
    }

    public ClassSpecification getSpec() {
        return this.spec;
    }

    public void addEnsuredPredicate(EnsuredCrySLPredicate ensPred) {
        if (this.ensuredPredicates.add(ensPred)) {
            for (Map.Entry<Statement, State> e : this.typeStateChange.entries()) {
                this.onAddedTypestateChange(e.getKey(), e.getValue());
            }
        }
    }

    private boolean isPredicateGeneratingState(CrySLPredicate ensPred, State stateNode) {
        return ensPred instanceof CrySLCondPredicate && this.isConditionalState(((CrySLCondPredicate)ensPred).getConditionalMethods(), stateNode) || !(ensPred instanceof CrySLCondPredicate) && stateNode.isAccepting();
    }

    private boolean isConditionalState(Set<StateNode> conditionalMethods, State state) {
        if (conditionalMethods == null) {
            return false;
        }
        for (StateNode s2 : conditionalMethods) {
            if (!new WrappedState(s2).equals(state)) continue;
            return true;
        }
        return false;
    }

    public Set<ISLConstraint> getMissingPredicates() {
        return this.missingPredicates;
    }

    public ExtractParameterAnalysis getParameterAnalysis() {
        return this.parameterAnalysis;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.spec == null ? 0 : this.spec.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AnalysisSeedWithSpecification other = (AnalysisSeedWithSpecification)obj;
        return !(this.spec == null ? other.spec != null : !this.spec.equals(other.spec));
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    @Override
    public Set<Node<Statement, Val>> getDataFlowPath() {
        return this.results.getDataFlowPath();
    }

    public Map<Statement, SootMethod> getAllCallsOnObject() {
        return this.allCallsOnObject;
    }
}

