/*
 * Decompiled with CFR 0.152.
 */
package crypto.analysis;

import boomerang.jimple.Statement;
import crypto.interfaces.ISLConstraint;
import crypto.rules.CrySLPredicate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class AlternativeReqPredicate
implements ISLConstraint {
    private static final long serialVersionUID = 9111353268603202392L;
    private final List<CrySLPredicate> alternatives = new ArrayList<CrySLPredicate>();
    private Statement stmt;

    public AlternativeReqPredicate(CrySLPredicate alternativeOne, Statement stmt) {
        this.alternatives.add(alternativeOne);
        this.stmt = stmt;
    }

    public AlternativeReqPredicate(CrySLPredicate alternativeOne, CrySLPredicate alternativeTwo, Statement stmt) {
        this.alternatives.add(alternativeOne);
        this.alternatives.add(alternativeTwo);
        this.stmt = stmt;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.alternatives == null ? 0 : this.alternatives.hashCode());
        result = 31 * result + (this.stmt == null ? 0 : this.stmt.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AlternativeReqPredicate other = (AlternativeReqPredicate)obj;
        if (this.alternatives == null ? other.alternatives != null : !this.alternatives.equals(other.alternatives)) {
            return false;
        }
        return !(this.stmt == null ? other.stmt != null : !this.stmt.equals(other.stmt));
    }

    @Override
    public Statement getLocation() {
        return this.stmt;
    }

    public String toString() {
        return "misses " + this.alternatives.stream().map(e -> e.toString()).collect(Collectors.joining(" OR ")) + (this.stmt != null ? " @ " + this.stmt.toString() : "");
    }

    @Override
    public String getName() {
        return this.alternatives.stream().map(e -> e.getName()).collect(Collectors.joining(" OR "));
    }

    @Override
    public Set<String> getInvolvedVarNames() {
        HashSet<String> involvedVarNames = new HashSet<String>();
        for (CrySLPredicate alt : this.alternatives) {
            involvedVarNames.addAll(alt.getInvolvedVarNames());
        }
        return involvedVarNames;
    }

    @Override
    public void setLocation(Statement location) {
        throw new UnsupportedOperationException();
    }

    public List<CrySLPredicate> getAlternatives() {
        return this.alternatives;
    }

    public boolean addAlternative(CrySLPredicate newAlt) {
        return this.alternatives.add(newAlt);
    }
}

