/*
 * Decompiled with CFR 0.152.
 */
package boomerang.util;

import boomerang.jimple.Field;
import boomerang.jimple.Val;
import boomerang.util.AccessPath;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import soot.Local;
import soot.RefType;
import soot.SootField;
import soot.SootMethod;
import soot.Type;
import soot.util.Chain;

public class AccessPathParser {
    public static Collection<? extends AccessPath> parseAllFromString(String value, SootMethod m3) {
        HashSet<AccessPath> results = Sets.newHashSet();
        for (String v : value.split(";")) {
            results.add(AccessPathParser.parseAccessPathFromString(v, m3));
        }
        return results;
    }

    private static AccessPath parseAccessPathFromString(String value, SootMethod m3) {
        String baseName;
        ArrayList<Object> fieldNames = Lists.newArrayList();
        boolean overApproximated = value.endsWith("*");
        if (!value.contains("[")) {
            baseName = value;
        } else {
            int i = value.indexOf("[");
            baseName = value.substring(0, i);
            fieldNames = Lists.newArrayList(value.substring(i + 1, value.length() - (!overApproximated ? 1 : 2)).split(","));
        }
        ArrayList<Field> fields = Lists.newArrayList();
        Local base = AccessPathParser.getLocal(m3, baseName);
        Type type = base.getType();
        for (String fieldName : fieldNames) {
            if (!(type instanceof RefType)) continue;
            RefType refType = (RefType)type;
            SootField fieldByName = refType.getSootClass().getFieldByName(fieldName);
            fields.add(new Field(fieldByName));
            type = fieldByName.getType();
        }
        return new AccessPath(new Val(base, m3), !overApproximated ? fields : Sets.newHashSet(fields));
    }

    private static Local getLocal(SootMethod m3, String baseName) {
        Chain<Local> locals = m3.getActiveBody().getLocals();
        for (Local l : locals) {
            if (!l.getName().equals(baseName)) continue;
            return l;
        }
        throw new RuntimeException("Could not find local with name " + baseName + " in method " + m3);
    }
}

