/*
 * Decompiled with CFR 0.152.
 */
package boomerang.solver;

import boomerang.BoomerangOptions;
import boomerang.ForwardQuery;
import boomerang.callgraph.CalleeListener;
import boomerang.callgraph.ObservableICFG;
import boomerang.jimple.Field;
import boomerang.jimple.Statement;
import boomerang.jimple.StaticFieldVal;
import boomerang.jimple.Val;
import boomerang.jimple.ValWithFalseVariable;
import boomerang.solver.AbstractBoomerangSolver;
import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import soot.Body;
import soot.Local;
import soot.NullType;
import soot.SootMethod;
import soot.Unit;
import soot.Value;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.CastExpr;
import soot.jimple.IfStmt;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InstanceOfExpr;
import soot.jimple.IntConstant;
import soot.jimple.InvokeExpr;
import soot.jimple.NullConstant;
import soot.jimple.ReturnStmt;
import soot.jimple.StaticFieldRef;
import soot.jimple.Stmt;
import soot.jimple.ThrowStmt;
import soot.jimple.internal.AbstractJimpleIntBinopExpr;
import soot.jimple.internal.JEqExpr;
import soot.jimple.internal.JNeExpr;
import sync.pds.solver.SyncPDSSolver;
import sync.pds.solver.nodes.CallPopNode;
import sync.pds.solver.nodes.ExclusionNode;
import sync.pds.solver.nodes.GeneratedState;
import sync.pds.solver.nodes.INode;
import sync.pds.solver.nodes.Node;
import sync.pds.solver.nodes.NodeWithLocation;
import sync.pds.solver.nodes.PopNode;
import sync.pds.solver.nodes.PushNode;
import wpds.impl.NestedWeightedPAutomatons;
import wpds.impl.Weight;
import wpds.interfaces.State;

public abstract class ForwardBoomerangSolver<W extends Weight>
extends AbstractBoomerangSolver<W> {
    public ForwardBoomerangSolver(ObservableICFG<Unit, SootMethod> icfg, ForwardQuery query, Map<Map.Entry<INode<Node<Statement, Val>>, Field>, INode<Node<Statement, Val>>> genField, BoomerangOptions options, NestedWeightedPAutomatons<Statement, INode<Val>, W> callSummaries, NestedWeightedPAutomatons<Field, INode<Node<Statement, Val>>, W> fieldSummaries) {
        super(icfg, query, genField, options, callSummaries, fieldSummaries);
    }

    public Collection<? extends State> computeCallFlow(SootMethod caller, Statement callSite, InvokeExpr invokeExpr, Val fact, SootMethod callee, Stmt calleeSp) {
        InstanceInvokeExpr iie;
        if (!callee.hasActiveBody() || callee.isStaticInitializer()) {
            return Collections.emptySet();
        }
        Body calleeBody = callee.getActiveBody();
        HashSet<PushNode<Statement, Val, Statement>> out = Sets.newHashSet();
        if (invokeExpr instanceof InstanceInvokeExpr && (iie = (InstanceInvokeExpr)invokeExpr).getBase().equals(fact.value()) && !callee.isStatic()) {
            out.add(new PushNode<Statement, Val, Statement>(new Statement(calleeSp, callee), new Val(calleeBody.getThisLocal(), callee), callSite, SyncPDSSolver.PDSSystem.CALLS));
        }
        int i = 0;
        List<Local> parameterLocals = calleeBody.getParameterLocals();
        for (Value arg : invokeExpr.getArgs()) {
            if (arg.equals(fact.value()) && parameterLocals.size() > i) {
                Local param = parameterLocals.get(i);
                out.add(new PushNode<Statement, Val, Statement>(new Statement(calleeSp, callee), new Val(param, callee), callSite, SyncPDSSolver.PDSSystem.CALLS));
            }
            ++i;
        }
        if (fact.isStatic()) {
            out.add(new PushNode<Statement, StaticFieldVal, Statement>(new Statement(calleeSp, callee), new StaticFieldVal(fact.value(), ((StaticFieldVal)fact).field(), callee), callSite, SyncPDSSolver.PDSSystem.CALLS));
        }
        return out;
    }

    @Override
    public INode<Node<Statement, Val>> generateFieldState(INode<Node<Statement, Val>> d, Field loc) {
        AbstractMap.SimpleEntry<INode<Node<Statement, Val>>, Field> e = new AbstractMap.SimpleEntry<INode<Node<Statement, Val>>, Field>(d, loc);
        if (!this.generatedFieldState.containsKey(e)) {
            this.generatedFieldState.put(e, new GeneratedState((INode)this.fieldAutomaton.getInitialState(), loc));
        }
        return (INode)this.generatedFieldState.get(e);
    }

    @Override
    protected boolean killFlow(SootMethod m3, Stmt curr, Val value) {
        if (!m3.getActiveBody().getLocals().contains(value.value()) && !value.isStatic()) {
            return true;
        }
        if (curr instanceof AssignStmt) {
            AssignStmt as = (AssignStmt)curr;
            if (as.getLeftOp().equals(value.value())) {
                InstanceFieldRef iie;
                return !(as.getRightOp() instanceof InstanceFieldRef) || !(iie = (InstanceFieldRef)as.getRightOp()).getBase().equals(value.value());
            }
            if (as.getLeftOp() instanceof StaticFieldRef) {
                StaticFieldRef sfr = (StaticFieldRef)as.getLeftOp();
                if (value.isStatic() && value.equals(new StaticFieldVal(as.getLeftOp(), sfr.getField(), m3))) {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public void computeSuccessor(Node<Statement, Val> node) {
        Statement stmt = node.stmt();
        Optional<Stmt> unit = stmt.getUnit();
        if (unit.isPresent()) {
            Stmt curr = unit.get();
            Val value = node.fact();
            SootMethod method = (SootMethod)this.icfg.getMethodOf(curr);
            if (method == null) {
                return;
            }
            if (this.icfg.isExitStmt(curr)) {
                this.returnFlow(method, node);
                return;
            }
            for (Unit unit2 : this.icfg.getSuccsOf(curr)) {
                Stmt nextStmt = (Stmt)unit2;
                if (this.query.getType() instanceof NullType && curr instanceof IfStmt && this.killAtIfStmt((IfStmt)curr, value, unit2)) continue;
                if (nextStmt.containsInvokeExpr() && (this.isParameter(value, nextStmt) || value.isStatic())) {
                    this.callFlow(method, node, nextStmt, nextStmt.getInvokeExpr());
                    continue;
                }
                if (this.killFlow(method, nextStmt, value)) continue;
                Collection<State> out = this.computeNormalFlow(method, curr, value, nextStmt);
                for (State s2 : out) {
                    this.propagate(node, s2);
                }
            }
        }
    }

    private boolean killAtIfStmt(IfStmt ifStmt, Val fact, Unit succ) {
        Value op2;
        Value op1;
        AbstractJimpleIntBinopExpr eqExpr;
        Stmt target = ifStmt.getTarget();
        Value condition = ifStmt.getCondition();
        if (condition instanceof JEqExpr) {
            eqExpr = (JEqExpr)condition;
            op1 = eqExpr.getOp1();
            op2 = eqExpr.getOp2();
            if (fact instanceof ValWithFalseVariable) {
                ValWithFalseVariable valWithFalseVar = (ValWithFalseVariable)fact;
                if (op1.equals(valWithFalseVar.getFalseVariable()) && op2.equals(IntConstant.v(0)) && !succ.equals(target)) {
                    return true;
                }
                if (op2.equals(valWithFalseVar.getFalseVariable()) && op1.equals(IntConstant.v(0)) && !succ.equals(target)) {
                    return true;
                }
            }
            if (op1 instanceof NullConstant ? op2.equals(fact.value()) && !succ.equals(target) : op2 instanceof NullConstant && op1.equals(fact.value()) && !succ.equals(target)) {
                return true;
            }
        }
        if (condition instanceof JNeExpr) {
            eqExpr = (JNeExpr)condition;
            op1 = eqExpr.getOp1();
            op2 = eqExpr.getOp2();
            if (op1 instanceof NullConstant ? op2.equals(fact.value()) && succ.equals(target) : op2 instanceof NullConstant && op1.equals(fact.value()) && succ.equals(target)) {
                return true;
            }
        }
        return false;
    }

    protected Collection<State> normalFlow(SootMethod method, Stmt curr, Val value) {
        HashSet<State> out = Sets.newHashSet();
        for (Unit unit : this.icfg.getSuccsOf(curr)) {
            Collection<State> flow = this.computeNormalFlow(method, curr, value, (Stmt)unit);
            out.addAll(flow);
        }
        return out;
    }

    @Override
    public Collection<State> computeNormalFlow(SootMethod method, Stmt curr, Val fact, Stmt succ) {
        HashSet<State> out = Sets.newHashSet();
        if (!this.isFieldWriteWithBase(succ, fact)) {
            if (!this.options.trackReturnOfInstanceOf() || !this.isInstanceOfStatement(succ, fact)) {
                out.add(new Node<Statement, Val>(new Statement(succ, method), fact));
            }
        } else {
            out.add(new ExclusionNode<Statement, Val, Field>(new Statement(succ, method), fact, this.getWrittenField(succ)));
        }
        if (succ instanceof AssignStmt) {
            InstanceOfExpr instanceOfExpr;
            ArrayRef arrayRef;
            StaticFieldRef sfr;
            InstanceFieldRef ifr;
            AssignStmt assignStmt = (AssignStmt)succ;
            Value leftOp = assignStmt.getLeftOp();
            Value rightOp = assignStmt.getRightOp();
            if (rightOp.equals(fact.value())) {
                if (leftOp instanceof InstanceFieldRef) {
                    ifr = (InstanceFieldRef)leftOp;
                    if (this.options.trackFields()) {
                        out.add(new PushNode<Statement, Val, Field>(new Statement(succ, method), new Val(ifr.getBase(), method), new Field(ifr.getField()), SyncPDSSolver.PDSSystem.FIELDS));
                    }
                } else if (leftOp instanceof StaticFieldRef) {
                    sfr = (StaticFieldRef)leftOp;
                    if (this.options.trackFields() && this.options.staticFlows()) {
                        out.add(new Node<Statement, StaticFieldVal>(new Statement(succ, method), new StaticFieldVal(leftOp, sfr.getField(), method)));
                    }
                } else if (leftOp instanceof ArrayRef) {
                    arrayRef = (ArrayRef)leftOp;
                    if (this.options.trackFields() && this.options.arrayFlows()) {
                        out.add(new PushNode<Statement, Val, Field>(new Statement(succ, method), new Val(arrayRef.getBase(), method), Field.array(), SyncPDSSolver.PDSSystem.FIELDS));
                    }
                } else {
                    out.add(new Node<Statement, Val>(new Statement(succ, method), new Val(leftOp, method)));
                }
            }
            if (rightOp instanceof InstanceFieldRef) {
                ifr = (InstanceFieldRef)rightOp;
                Value base = ifr.getBase();
                if (base.equals(fact.value())) {
                    NodeWithLocation<Statement, Val, Field> succNode = new NodeWithLocation<Statement, Val, Field>(new Statement(succ, method), new Val(leftOp, method), new Field(ifr.getField()));
                    out.add(new PopNode<NodeWithLocation<Statement, Val, Field>>(succNode, SyncPDSSolver.PDSSystem.FIELDS));
                }
            } else if (rightOp instanceof StaticFieldRef) {
                sfr = (StaticFieldRef)rightOp;
                if (fact.isStatic() && fact.equals(new StaticFieldVal(rightOp, sfr.getField(), method))) {
                    out.add(new Node<Statement, Val>(new Statement(succ, method), new Val(leftOp, method)));
                }
            } else if (rightOp instanceof ArrayRef) {
                arrayRef = (ArrayRef)rightOp;
                Value base = arrayRef.getBase();
                if (base.equals(fact.value())) {
                    NodeWithLocation<Statement, Val, Field> succNode = new NodeWithLocation<Statement, Val, Field>(new Statement(succ, method), new Val(leftOp, method), Field.array());
                    out.add(new PopNode<NodeWithLocation<Statement, Val, Field>>(succNode, SyncPDSSolver.PDSSystem.FIELDS));
                }
            } else if (rightOp instanceof CastExpr) {
                CastExpr castExpr = (CastExpr)rightOp;
                if (castExpr.getOp().equals(fact.value())) {
                    out.add(new Node<Statement, Val>(new Statement(succ, method), new Val(leftOp, method)));
                }
            } else if (rightOp instanceof InstanceOfExpr && this.query.getType() instanceof NullType && this.options.trackReturnOfInstanceOf() && (instanceOfExpr = (InstanceOfExpr)rightOp).getOp().equals(fact.value())) {
                out.add(new Node<Statement, ValWithFalseVariable>(new Statement(succ, method), new ValWithFalseVariable(fact.value(), method, leftOp)));
            }
        }
        return out;
    }

    private boolean isInstanceOfStatement(Stmt curr, Val fact) {
        InstanceOfExpr instanceOfExpr;
        AssignStmt as;
        return curr instanceof AssignStmt && (as = (AssignStmt)curr).getRightOp() instanceof InstanceOfExpr && this.query.getType() instanceof NullType && (instanceOfExpr = (InstanceOfExpr)as.getRightOp()).getOp().equals(fact.value());
    }

    protected void callFlow(SootMethod caller, Node<Statement, Val> currNode, Stmt callSite, InvokeExpr invokeExpr) {
        assert (this.icfg.isCallStmt(callSite));
        if (invokeExpr.getMethod().getDeclaringClass().isPhantom() || invokeExpr.getMethod().isNative()) {
            for (State s2 : this.computeNormalFlow(caller, currNode.stmt().getUnit().get(), currNode.fact(), callSite)) {
                this.propagate(currNode, s2);
            }
            for (Statement returnSite : this.getSuccsOf(currNode.stmt())) {
                for (State s3 : this.getEmptyCalleeFlow(caller, callSite, currNode.fact(), returnSite.getUnit().get())) {
                    this.propagate(currNode, s3);
                }
            }
        }
        this.icfg.addCalleeListener(new CallSiteCalleeListener(caller, callSite, currNode, invokeExpr));
    }

    @Override
    public Collection<? extends State> computeReturnFlow(SootMethod method, Stmt curr, Val value, Stmt callSite, Stmt returnSite) {
        Value op;
        Statement returnSiteStatement = new Statement(callSite, (SootMethod)this.icfg.getMethodOf(callSite));
        if (curr instanceof ThrowStmt && !this.options.throwFlows()) {
            return Collections.emptySet();
        }
        HashSet<CallPopNode<Val, Statement>> out = Sets.newHashSet();
        if (curr instanceof ReturnStmt && (op = ((ReturnStmt)curr).getOp()).equals(value.value()) && callSite instanceof AssignStmt) {
            out.add(new CallPopNode<Val, Statement>(new Val(((AssignStmt)callSite).getLeftOp(), (SootMethod)this.icfg.getMethodOf(callSite)), SyncPDSSolver.PDSSystem.CALLS, returnSiteStatement));
        }
        if (!method.isStatic() && method.getActiveBody().getThisLocal().equals(value.value()) && callSite.containsInvokeExpr() && callSite.getInvokeExpr() instanceof InstanceInvokeExpr) {
            InstanceInvokeExpr iie = (InstanceInvokeExpr)callSite.getInvokeExpr();
            out.add(new CallPopNode<Val, Statement>(new Val(iie.getBase(), (SootMethod)this.icfg.getMethodOf(callSite)), SyncPDSSolver.PDSSystem.CALLS, returnSiteStatement));
        }
        int index = 0;
        for (Local param : method.getActiveBody().getParameterLocals()) {
            if (param.equals(value.value()) && callSite.containsInvokeExpr()) {
                InvokeExpr iie = callSite.getInvokeExpr();
                out.add(new CallPopNode<Val, Statement>(new Val(iie.getArg(index), (SootMethod)this.icfg.getMethodOf(callSite)), SyncPDSSolver.PDSSystem.CALLS, returnSiteStatement));
            }
            ++index;
        }
        if (value.isStatic()) {
            out.add(new CallPopNode<StaticFieldVal, Statement>(new StaticFieldVal(value.value(), ((StaticFieldVal)value).field(), (SootMethod)this.icfg.getMethodOf(callSite)), SyncPDSSolver.PDSSystem.CALLS, returnSiteStatement));
        }
        return out;
    }

    private final class CallSiteCalleeListener
    implements CalleeListener<Unit, SootMethod> {
        private final SootMethod caller;
        private final Stmt callSite;
        private final Node<Statement, Val> currNode;
        private final InvokeExpr invokeExpr;

        private CallSiteCalleeListener(SootMethod caller, Stmt callSite, Node<Statement, Val> currNode, InvokeExpr invokeExpr) {
            this.caller = caller;
            this.callSite = callSite;
            this.currNode = currNode;
            this.invokeExpr = invokeExpr;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.callSite == null ? 0 : this.callSite.hashCode());
            result = 31 * result + (this.caller == null ? 0 : this.caller.hashCode());
            result = 31 * result + (this.currNode == null ? 0 : this.currNode.hashCode());
            result = 31 * result + (this.invokeExpr == null ? 0 : this.invokeExpr.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CallSiteCalleeListener other = (CallSiteCalleeListener)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.callSite == null ? other.callSite != null : !this.callSite.equals(other.callSite)) {
                return false;
            }
            if (this.caller == null ? other.caller != null : !this.caller.equals(other.caller)) {
                return false;
            }
            if (this.currNode == null ? other.currNode != null : !this.currNode.equals(other.currNode)) {
                return false;
            }
            return !(this.invokeExpr == null ? other.invokeExpr != null : !this.invokeExpr.equals(other.invokeExpr));
        }

        @Override
        public void onCalleeAdded(Unit callSite, SootMethod callee) {
            if (callee.isStaticInitializer()) {
                return;
            }
            if (!callee.hasActiveBody()) {
                for (State s2 : ForwardBoomerangSolver.this.computeNormalFlow(this.caller, this.currNode.stmt().getUnit().get(), this.currNode.fact(), (Stmt)callSite)) {
                    ForwardBoomerangSolver.this.propagate(this.currNode, s2);
                }
                return;
            }
            for (Unit calleeSp : ForwardBoomerangSolver.this.icfg.getStartPointsOf(callee)) {
                HashSet<State> out = Sets.newHashSet();
                Collection<State> res = ForwardBoomerangSolver.this.computeCallFlow(this.caller, new Statement((Stmt)callSite, this.caller), this.invokeExpr, this.currNode.fact(), callee, (Stmt)calleeSp);
                out.addAll(res);
                for (State s3 : out) {
                    ForwardBoomerangSolver.this.propagate(this.currNode, s3);
                }
            }
            ForwardBoomerangSolver.this.addReachable(callee);
        }

        @Override
        public Unit getObservedCaller() {
            return this.callSite;
        }

        private ForwardBoomerangSolver getOuterType() {
            return ForwardBoomerangSolver.this;
        }
    }
}

