/*
 * Decompiled with CFR 0.152.
 */
package boomerang.seedfactory;

import boomerang.Query;
import boomerang.callgraph.CalleeListener;
import boomerang.callgraph.ObservableICFG;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import soot.Scene;
import soot.SootMethod;
import soot.Unit;
import soot.jimple.Stmt;

public abstract class SimpleSeedFactory {
    protected ObservableICFG<Unit, SootMethod> icfg;

    public SimpleSeedFactory(ObservableICFG<Unit, SootMethod> icfg) {
        this.icfg = icfg;
    }

    public Collection<Query> computeSeeds() {
        ArrayList<Query> seeds = new ArrayList<Query>();
        final ArrayList<SootMethod> worklist = new ArrayList<SootMethod>(Scene.v().getEntryPoints());
        final HashSet<SootMethod> visited = new HashSet<SootMethod>();
        while (!worklist.isEmpty()) {
            SootMethod m3 = (SootMethod)worklist.get(0);
            visited.add(m3);
            worklist.remove(m3);
            if (!m3.hasActiveBody()) continue;
            for (final Unit u : m3.getActiveBody().getUnits()) {
                final HashSet<SootMethod> calledMethods = new HashSet<SootMethod>();
                if (this.icfg.isCallStmt(u)) {
                    this.icfg.addCalleeListener(new CalleeListener<Unit, SootMethod>(){

                        @Override
                        public Unit getObservedCaller() {
                            return u;
                        }

                        @Override
                        public void onCalleeAdded(Unit unit, SootMethod sootMethod) {
                            calledMethods.add(sootMethod);
                            if (!visited.contains(sootMethod) && !worklist.contains(sootMethod)) {
                                worklist.add(sootMethod);
                            }
                        }
                    });
                }
                seeds.addAll(this.generate(m3, (Stmt)u, calledMethods));
            }
        }
        return seeds;
    }

    protected abstract Collection<? extends Query> generate(SootMethod var1, Stmt var2, Collection<SootMethod> var3);
}

