/*
 * Decompiled with CFR 0.152.
 */
package boomerang.poi;

import boomerang.WeightedBoomerang;
import boomerang.jimple.Field;
import boomerang.jimple.Statement;
import boomerang.jimple.Val;
import boomerang.poi.AbstractPOI;
import boomerang.solver.AbstractBoomerangSolver;
import boomerang.solver.BackwardBoomerangSolver;
import boomerang.solver.StatementBasedCallTransitionListener;
import boomerang.solver.StatementBasedFieldTransitionListener;
import sync.pds.solver.nodes.GeneratedState;
import sync.pds.solver.nodes.INode;
import sync.pds.solver.nodes.Node;
import sync.pds.solver.nodes.SingleNode;
import wpds.impl.Transition;
import wpds.impl.Weight;
import wpds.impl.WeightedPAutomaton;
import wpds.interfaces.WPAStateListener;
import wpds.interfaces.WPAUpdateListener;

public abstract class ExecuteImportFieldStmtPOI<W extends Weight> {
    protected final AbstractBoomerangSolver<W> baseSolver;
    protected final AbstractBoomerangSolver<W> flowSolver;
    protected final Statement curr;
    protected final Statement succ;
    protected final WeightedPAutomaton<Field, INode<Node<Statement, Val>>, W> baseAutomaton;
    protected final WeightedPAutomaton<Field, INode<Node<Statement, Val>>, W> flowAutomaton;
    private final Val baseVar;
    private final Val storedVar;
    private final Field field;
    boolean active = false;
    private WeightedBoomerang<W> boomerang;

    public ExecuteImportFieldStmtPOI(WeightedBoomerang<W> boomerang, AbstractBoomerangSolver<W> baseSolver, AbstractBoomerangSolver<W> flowSolver, AbstractPOI<Statement, Val, Field> poi, Statement succ) {
        this.boomerang = boomerang;
        this.baseSolver = baseSolver;
        this.flowSolver = flowSolver;
        this.baseAutomaton = baseSolver.getFieldAutomaton();
        this.flowAutomaton = flowSolver.getFieldAutomaton();
        this.curr = poi.getStmt();
        this.succ = succ;
        this.baseVar = poi.getBaseVar();
        this.storedVar = poi.getStoredVar();
        this.field = poi.getField();
    }

    public void solve() {
        if (this.baseSolver.equals(this.flowSolver)) {
            return;
        }
        this.baseSolver.registerStatementFieldTransitionListener(new BaseVarPointsTo(this.curr, this));
    }

    protected void flowsTo() {
        if (this.active) {
            return;
        }
        this.active = true;
        this.handlingAtFieldStatements();
        this.handlingAtCallSites();
    }

    private void handlingAtFieldStatements() {
        this.baseSolver.registerStatementFieldTransitionListener(new ImportIndirectAliases(this.succ, this.flowSolver, this.baseSolver));
        this.flowSolver.registerStatementCallTransitionListener(new ImportIndirectCallAliases(this.curr, this.flowSolver));
    }

    private void handlingAtCallSites() {
        this.flowSolver.getCallAutomaton().registerListener(new ForAnyCallSiteOrExitStmt(this.baseSolver));
    }

    protected boolean isBackward() {
        return this.flowSolver instanceof BackwardBoomerangSolver;
    }

    protected void importStartingFrom(Transition<Field, INode<Node<Statement, Val>>> t) {
        if (((Field)t.getLabel()).equals(Field.epsilon())) {
            return;
        }
        if (((Field)t.getLabel()).equals(Field.empty())) {
            this.activate((INode)t.getStart());
        } else {
            this.flowSolver.getFieldAutomaton().addTransition(new Transition<Object, INode<Node<Statement, Val>>>(this.convert((INode)t.getStart()), t.getLabel(), this.convert((INode)t.getTarget())));
            this.baseSolver.getFieldAutomaton().registerListener(new ImportToSolver((INode)t.getTarget(), this.flowSolver));
        }
    }

    private INode<Node<Statement, Val>> convert(INode<Node<Statement, Val>> target) {
        if (!this.isBackward()) {
            return target;
        }
        if (target instanceof GeneratedState) {
            GeneratedState generatedState = (GeneratedState)target;
            return new GeneratedState(this.flowSolver.getFieldAutomaton().getInitialState(), generatedState.location());
        }
        return target;
    }

    public abstract void activate(INode<Node<Statement, Val>> var1);

    public void trigger(INode<Node<Statement, Val>> start) {
        INode intermediateState = this.flowSolver.getFieldAutomaton().createState(new SingleNode<Node<Statement, Val>>(new Node<Statement, Val>(this.succ, this.baseVar)), this.field);
        this.flowSolver.getFieldAutomaton().addTransition(new Transition<Field, INode>(start, this.field, intermediateState));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.baseSolver == null ? 0 : this.baseSolver.hashCode());
        result = 31 * result + (this.flowSolver == null ? 0 : this.flowSolver.hashCode());
        result = 31 * result + (this.curr == null ? 0 : this.curr.hashCode());
        result = 31 * result + (this.succ == null ? 0 : this.succ.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExecuteImportFieldStmtPOI other = (ExecuteImportFieldStmtPOI)obj;
        if (this.baseSolver == null ? other.baseSolver != null : !this.baseSolver.equals(other.baseSolver)) {
            return false;
        }
        if (this.flowSolver == null ? other.flowSolver != null : !this.flowSolver.equals(other.flowSolver)) {
            return false;
        }
        if (this.curr == null ? other.curr != null : !this.curr.equals(other.curr)) {
            return false;
        }
        return !(this.succ == null ? other.succ != null : !this.succ.equals(other.succ));
    }

    private final class ImportToSolver
    extends WPAStateListener<Field, INode<Node<Statement, Val>>, W> {
        private AbstractBoomerangSolver<W> flowSolver;

        public ImportToSolver(INode<Node<Statement, Val>> target, AbstractBoomerangSolver<W> flowSolver) {
            super(target);
            this.flowSolver = flowSolver;
        }

        @Override
        public void onOutTransitionAdded(Transition<Field, INode<Node<Statement, Val>>> t, W w, WeightedPAutomaton<Field, INode<Node<Statement, Val>>, W> weightedPAutomaton) {
            if (((Field)t.getLabel()).equals(Field.epsilon())) {
                return;
            }
            ExecuteImportFieldStmtPOI.this.importStartingFrom(t);
        }

        @Override
        public void onInTransitionAdded(Transition<Field, INode<Node<Statement, Val>>> t, W w, WeightedPAutomaton<Field, INode<Node<Statement, Val>>, W> weightedPAutomaton) {
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.flowSolver == null ? 0 : this.flowSolver.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ImportToSolver other = (ImportToSolver)obj;
            return !(this.flowSolver == null ? other.flowSolver != null : !this.flowSolver.equals(other.flowSolver));
        }
    }

    private final class CallSiteOrExitStmtImport
    extends StatementBasedFieldTransitionListener<W> {
        private AbstractBoomerangSolver<W> flowSolver;
        private AbstractBoomerangSolver<W> baseSolver;
        private Val fact;

        private CallSiteOrExitStmtImport(AbstractBoomerangSolver<W> flowSolver, AbstractBoomerangSolver<W> baseSolver, Node<Statement, Val> reachableNode) {
            super(reachableNode.stmt());
            this.flowSolver = flowSolver;
            this.baseSolver = baseSolver;
            this.fact = reachableNode.fact();
        }

        @Override
        public void onAddedTransition(Transition<Field, INode<Node<Statement, Val>>> innerT) {
            if (((Field)innerT.getLabel()).equals(Field.epsilon())) {
                return;
            }
            if (!(innerT.getStart() instanceof GeneratedState) && ((Val)((Node)((INode)innerT.getStart()).fact()).fact()).equals(this.fact)) {
                ExecuteImportFieldStmtPOI.this.importStartingFrom(innerT);
            }
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.baseSolver == null ? 0 : this.baseSolver.hashCode());
            result = 31 * result + (this.flowSolver == null ? 0 : this.flowSolver.hashCode());
            result = 31 * result + (this.fact == null ? 0 : this.fact.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CallSiteOrExitStmtImport other = (CallSiteOrExitStmtImport)obj;
            if (this.baseSolver == null ? other.baseSolver != null : !this.baseSolver.equals(other.baseSolver)) {
                return false;
            }
            if (this.flowSolver == null ? other.flowSolver != null : !this.flowSolver.equals(other.flowSolver)) {
                return false;
            }
            return !(this.fact == null ? other.fact != null : !this.fact.equals(other.fact));
        }
    }

    private final class ImportIndirectAliases
    extends StatementBasedFieldTransitionListener<W> {
        private AbstractBoomerangSolver<W> flowSolver;
        private AbstractBoomerangSolver<W> baseSolver;

        public ImportIndirectAliases(Statement succ, AbstractBoomerangSolver<W> flowSolver, AbstractBoomerangSolver<W> baseSolver) {
            super(succ);
            this.flowSolver = flowSolver;
            this.baseSolver = baseSolver;
        }

        @Override
        public void onAddedTransition(Transition<Field, INode<Node<Statement, Val>>> t) {
            if (((Field)t.getLabel()).equals(Field.epsilon())) {
                return;
            }
            if (!(t.getStart() instanceof GeneratedState)) {
                ExecuteImportFieldStmtPOI.this.importStartingFrom(t);
            }
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.baseSolver == null ? 0 : this.baseSolver.hashCode());
            result = 31 * result + (this.flowSolver == null ? 0 : this.flowSolver.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ImportIndirectAliases other = (ImportIndirectAliases)obj;
            if (this.baseSolver == null ? other.baseSolver != null : !this.baseSolver.equals(other.baseSolver)) {
                return false;
            }
            return !(this.flowSolver == null ? other.flowSolver != null : !this.flowSolver.equals(other.flowSolver));
        }
    }

    private static final class ImportIndirectCallAliasesAtSucc
    extends StatementBasedCallTransitionListener<W> {
        private INode<Val> target;
        private W w;
        final /* synthetic */ ExecuteImportFieldStmtPOI this$0;

        public ImportIndirectCallAliasesAtSucc(Statement succ, INode<Val> target, W w) {
            this.this$0 = var1_1;
            super(succ);
            this.target = target;
            this.w = w;
        }

        @Override
        public void onAddedTransition(Transition<Statement, INode<Val>> t, W w) {
            this.this$0.flowSolver.getCallAutomaton().addWeightForTransition(new Transition<Object, INode<Val>>((INode<Val>)t.getStart(), t.getLabel(), this.target), this.w);
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.target == null ? 0 : this.target.hashCode());
            result = 31 * result + (this.w == null ? 0 : this.w.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ImportIndirectCallAliasesAtSucc other = (ImportIndirectCallAliasesAtSucc)obj;
            if (this.target == null ? other.target != null : !this.target.equals(other.target)) {
                return false;
            }
            return !(this.w == null ? other.w != null : !this.w.equals(other.w));
        }
    }

    private final class ImportIndirectCallAliases
    extends StatementBasedCallTransitionListener<W> {
        private AbstractBoomerangSolver<W> flowSolver;

        public ImportIndirectCallAliases(Statement stmt, AbstractBoomerangSolver<W> flowSolver) {
            super(stmt);
            this.flowSolver = flowSolver;
        }

        @Override
        public void onAddedTransition(Transition<Statement, INode<Val>> t, W w) {
            if (((Val)((INode)t.getStart()).fact()).equals(ExecuteImportFieldStmtPOI.this.storedVar)) {
                ExecuteImportFieldStmtPOI.this.baseSolver.registerStatementCallTransitionListener(new ImportIndirectCallAliasesAtSucc(ExecuteImportFieldStmtPOI.this, ExecuteImportFieldStmtPOI.this.succ, (INode)t.getTarget(), w));
            }
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.flowSolver == null ? 0 : this.flowSolver.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ImportIndirectCallAliases other = (ImportIndirectCallAliases)obj;
            return !(this.flowSolver == null ? other.flowSolver != null : !this.flowSolver.equals(other.flowSolver));
        }
    }

    private class BaseVarPointsTo
    extends StatementBasedFieldTransitionListener<W> {
        private ExecuteImportFieldStmtPOI<W> poi;

        public BaseVarPointsTo(Statement curr, ExecuteImportFieldStmtPOI<W> executeImportFieldStmtPOI2) {
            super(curr);
            this.poi = executeImportFieldStmtPOI2;
        }

        @Override
        public void onAddedTransition(Transition<Field, INode<Node<Statement, Val>>> t) {
            Val alias;
            INode aliasedVariableAtStmt = (INode)t.getStart();
            if (ExecuteImportFieldStmtPOI.this.active) {
                return;
            }
            if (!(aliasedVariableAtStmt instanceof GeneratedState) && (alias = (Val)((Node)aliasedVariableAtStmt.fact()).fact()).equals(this.poi.baseVar) && ((Field)t.getLabel()).equals(Field.empty())) {
                ExecuteImportFieldStmtPOI.this.flowsTo();
            }
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.poi == null ? 0 : this.poi.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BaseVarPointsTo other = (BaseVarPointsTo)obj;
            return !(this.poi == null ? other.poi != null : !this.poi.equals(other.poi));
        }
    }

    private class ForAnyCallSiteOrExitStmt
    implements WPAUpdateListener<Statement, INode<Val>, W> {
        private AbstractBoomerangSolver<W> baseSolver;

        public ForAnyCallSiteOrExitStmt(AbstractBoomerangSolver<W> baseSolver) {
            this.baseSolver = baseSolver;
        }

        @Override
        public void onWeightAdded(Transition<Statement, INode<Val>> t, W w, WeightedPAutomaton<Statement, INode<Val>, W> aut) {
            boolean predIsCallStmt;
            if (t.getStart() instanceof GeneratedState) {
                return;
            }
            if (((Statement)t.getLabel()).equals(Statement.epsilon())) {
                return;
            }
            Statement returnSiteOrExitStmt = t.getString();
            if (!returnSiteOrExitStmt.getUnit().isPresent() && returnSiteOrExitStmt.getUnit() != null) {
                return;
            }
            if (!ExecuteImportFieldStmtPOI.this.boomerang.icfg().isReachable(t.getString().getUnit().get())) {
                return;
            }
            boolean bl = predIsCallStmt = returnSiteOrExitStmt.isCallsite() && ExecuteImportFieldStmtPOI.this.flowSolver.valueUsedInStatement(returnSiteOrExitStmt.getUnit().get(), (Val)((INode)t.getStart()).fact());
            if (predIsCallStmt) {
                this.importSolvers(returnSiteOrExitStmt, (INode)t.getTarget(), w);
            } else if (ExecuteImportFieldStmtPOI.this.isBackward() && ExecuteImportFieldStmtPOI.this.boomerang.icfg().isExitStmt(returnSiteOrExitStmt.getUnit().get())) {
                for (Statement next : ExecuteImportFieldStmtPOI.this.flowSolver.getSuccsOf(returnSiteOrExitStmt)) {
                    this.importSolvers(next, (INode)t.getTarget(), w);
                }
            }
        }

        private void importSolvers(final Statement callSiteOrExitStmt, final INode<Val> node, W w) {
            this.baseSolver.submit(callSiteOrExitStmt.getMethod(), new Runnable((Weight)w){
                final /* synthetic */ Weight val$w;
                {
                    this.val$w = weight;
                }

                @Override
                public void run() {
                    ForAnyCallSiteOrExitStmt.this.baseSolver.registerStatementCallTransitionListener(new ImportOnReachStatement(ExecuteImportFieldStmtPOI.this.flowSolver, callSiteOrExitStmt));
                    ForAnyCallSiteOrExitStmt.this.baseSolver.registerStatementCallTransitionListener(new ImportTransitionFromCall(ExecuteImportFieldStmtPOI.this, ExecuteImportFieldStmtPOI.this.flowSolver, callSiteOrExitStmt, node, this.val$w));
                }
            });
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.baseSolver == null ? 0 : this.baseSolver.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ForAnyCallSiteOrExitStmt other = (ForAnyCallSiteOrExitStmt)obj;
            return !(this.baseSolver == null ? other.baseSolver != null : !this.baseSolver.equals(other.baseSolver));
        }
    }

    private final class ImportOnReachStatement
    extends StatementBasedCallTransitionListener<W> {
        private final Statement callSiteOrExitStmt;
        private AbstractBoomerangSolver<W> flowSolver;

        private ImportOnReachStatement(AbstractBoomerangSolver<W> flowSolver, Statement callSiteOrExitStmt) {
            super(callSiteOrExitStmt);
            this.flowSolver = flowSolver;
            this.callSiteOrExitStmt = callSiteOrExitStmt;
        }

        @Override
        public void onAddedTransition(Transition<Statement, INode<Val>> t, W w) {
            if (t.getStart() instanceof GeneratedState) {
                return;
            }
            if (((Statement)t.getLabel()).equals(this.callSiteOrExitStmt)) {
                ExecuteImportFieldStmtPOI.this.baseSolver.registerStatementFieldTransitionListener(new CallSiteOrExitStmtImport(this.flowSolver, ExecuteImportFieldStmtPOI.this.baseSolver, new Node(t.getLabel(), ((INode)t.getStart()).fact())));
            }
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.callSiteOrExitStmt == null ? 0 : this.callSiteOrExitStmt.hashCode());
            result = 31 * result + (this.flowSolver == null ? 0 : this.flowSolver.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ImportOnReachStatement other = (ImportOnReachStatement)obj;
            if (this.callSiteOrExitStmt == null ? other.callSiteOrExitStmt != null : !this.callSiteOrExitStmt.equals(other.callSiteOrExitStmt)) {
                return false;
            }
            return !(this.flowSolver == null ? other.flowSolver != null : !this.flowSolver.equals(other.flowSolver));
        }
    }

    private static final class ImportTransitionFromCall
    extends StatementBasedCallTransitionListener<W> {
        private AbstractBoomerangSolver<W> flowSolver;
        private INode<Val> target;
        private W w;
        final /* synthetic */ ExecuteImportFieldStmtPOI this$0;

        public ImportTransitionFromCall(AbstractBoomerangSolver<W> flowSolver, Statement stmt, INode<Val> target, W w) {
            this.this$0 = var1_1;
            super(stmt);
            this.flowSolver = flowSolver;
            this.target = target;
            this.w = w;
        }

        @Override
        public void onAddedTransition(Transition<Statement, INode<Val>> t, W w) {
            if (t.getStart() instanceof GeneratedState) {
                return;
            }
            this.flowSolver.getCallAutomaton().addWeightForTransition(new Transition<Object, INode<Val>>((INode<Val>)t.getStart(), t.getLabel(), this.target), this.w);
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.flowSolver == null ? 0 : this.flowSolver.hashCode());
            result = 31 * result + (this.target == null ? 0 : this.target.hashCode());
            result = 31 * result + (this.w == null ? 0 : this.w.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ImportTransitionFromCall other = (ImportTransitionFromCall)obj;
            if (this.flowSolver == null ? other.flowSolver != null : !this.flowSolver.equals(other.flowSolver)) {
                return false;
            }
            if (this.target == null ? other.target != null : !this.target.equals(other.target)) {
                return false;
            }
            return !(this.w == null ? other.w != null : !this.w.equals(other.w));
        }
    }
}

