/*
 * Decompiled with CFR 0.152.
 */
package boomerang.jimple;

import boomerang.jimple.Statement;
import soot.Local;
import soot.NullType;
import soot.SootMethod;
import soot.Type;
import soot.Value;

public class Val {
    protected final SootMethod m;
    private final Value v;
    private final String rep;
    protected final Statement unbalancedStmt;
    private static Val zeroInstance;

    public Val(Value v, SootMethod m3) {
        this(v, m3, null);
    }

    protected Val(Value v, SootMethod m3, Statement unbalanced) {
        if (v == null) {
            throw new RuntimeException("Value must not be null!");
        }
        this.v = v;
        this.m = m3;
        this.rep = null;
        if (!this.isStatic()) {
            if (!m3.hasActiveBody()) {
                throw new RuntimeException("No active body for method");
            }
            if (v instanceof Local && !m3.getActiveBody().getLocals().contains(v)) {
                throw new RuntimeException("Creating a Local with wrong method. " + v + " " + m3);
            }
        }
        this.unbalancedStmt = unbalanced;
    }

    private Val(String rep) {
        this.rep = rep;
        this.m = null;
        this.v = null;
        this.unbalancedStmt = null;
    }

    public Value value() {
        return this.v;
    }

    public Type getType() {
        return this.v == null ? NullType.v() : this.v.getType();
    }

    public SootMethod m() {
        return this.m;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.rep == null ? 0 : this.rep.hashCode());
        result = 31 * result + (this.v == null ? 0 : this.v.hashCode());
        result = 31 * result + (this.unbalancedStmt == null ? 0 : this.unbalancedStmt.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        Val other = (Val)obj;
        if (this.rep == null ? other.rep != null : !this.rep.equals(other.rep)) {
            return false;
        }
        if (this.v == null ? other.v != null : !this.v.equals(other.v)) {
            return false;
        }
        return !(this.unbalancedStmt == null ? other.unbalancedStmt != null : !this.unbalancedStmt.equals(other.unbalancedStmt));
    }

    public String toString() {
        if (this.rep != null) {
            return this.rep;
        }
        return this.v.toString() + " (" + this.m.getDeclaringClass().getShortName() + "." + this.m.getName() + ")" + (this.isUnbalanced() ? " unbalanaced " + this.unbalancedStmt : "");
    }

    public static Val zero() {
        if (zeroInstance == null) {
            zeroInstance = new Val("ZERO");
        }
        return zeroInstance;
    }

    public boolean isStatic() {
        return false;
    }

    public boolean isNewExpr() {
        return false;
    }

    public boolean isUnbalanced() {
        return this.unbalancedStmt != null && this.rep == null;
    }

    public Val asUnbalanced(Statement stmt) {
        return new Val(this.v, this.m, stmt);
    }
}

