/*
 * Decompiled with CFR 0.152.
 */
package boomerang.jimple;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import java.util.HashMap;
import java.util.Map;
import soot.SootMethod;
import soot.jimple.AssignStmt;
import soot.jimple.IdentityStmt;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.NewExpr;
import soot.jimple.Stmt;
import wpds.interfaces.Empty;
import wpds.interfaces.Location;

public class Statement
implements Location {
    private static Statement epsilon;
    private final Stmt delegate;
    private final SootMethod method;
    private final String rep;
    private static boolean DEBUG;
    private static Map<SootMethod, Integer> methodToInteger;
    private static Map<Stmt, Integer> statementToInteger;

    public Statement(Stmt delegate, SootMethod m3) {
        this.delegate = delegate;
        this.method = m3;
        this.rep = null;
    }

    private Statement(String rep) {
        this.rep = rep;
        this.delegate = null;
        this.method = null;
    }

    public Optional<Stmt> getUnit() {
        if (this.delegate == null) {
            return Optional.absent();
        }
        return Optional.of(this.delegate);
    }

    public boolean isCallsite() {
        return this.delegate != null && this.delegate.containsInvokeExpr();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.delegate == null ? 0 : this.delegate.hashCode());
        result = 31 * result + (this.rep == null ? 0 : this.rep.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Statement other = (Statement)obj;
        if (this.rep == null ? other.rep != null : !this.rep.equals(other.rep)) {
            return false;
        }
        return !(this.delegate == null ? other.delegate != null : !this.delegate.equals(other.delegate));
    }

    public static Statement epsilon() {
        if (epsilon == null) {
            epsilon = new EpsStatement();
        }
        return epsilon;
    }

    public String toString() {
        if (this.delegate == null) {
            return this.rep;
        }
        if (DEBUG) {
            return this.method.getName() + " " + this.shortName(this.delegate);
        }
        return "[" + Integer.toString(this.methodToInt(this.method)) + "]" + Integer.toString(this.stmtToInt(this.delegate));
    }

    private String shortName(Stmt s2) {
        if (s2.containsInvokeExpr()) {
            String base = "";
            if (s2.getInvokeExpr() instanceof InstanceInvokeExpr) {
                InstanceInvokeExpr iie = (InstanceInvokeExpr)s2.getInvokeExpr();
                base = iie.getBase().toString() + ".";
            }
            String assign = "";
            if (s2 instanceof AssignStmt) {
                assign = ((AssignStmt)s2).getLeftOp() + " = ";
            }
            return assign + base + s2.getInvokeExpr().getMethod().getName() + "(" + Joiner.on(",").join(s2.getInvokeExpr().getArgs()) + ")";
        }
        if (s2 instanceof IdentityStmt) {
            return "id";
        }
        if (s2 instanceof AssignStmt) {
            AssignStmt assignStmt = (AssignStmt)s2;
            if (assignStmt.getLeftOp() instanceof InstanceFieldRef) {
                InstanceFieldRef ifr = (InstanceFieldRef)assignStmt.getLeftOp();
                return ifr.getBase() + "." + ifr.getField().getName() + " = " + assignStmt.getRightOp();
            }
            if (assignStmt.getRightOp() instanceof InstanceFieldRef) {
                InstanceFieldRef ifr = (InstanceFieldRef)assignStmt.getRightOp();
                return assignStmt.getLeftOp() + " = " + ifr.getBase() + "." + ifr.getField().getName();
            }
            if (assignStmt.getRightOp() instanceof NewExpr) {
                NewExpr newExpr = (NewExpr)assignStmt.getRightOp();
                return assignStmt.getLeftOp() + " = new " + newExpr.getBaseType().getSootClass().getShortName();
            }
        }
        return s2.toString();
    }

    public int stmtToInt(Stmt s2) {
        if (!statementToInteger.containsKey(s2)) {
            statementToInteger.put(s2, statementToInteger.size());
        }
        return statementToInteger.get(s2);
    }

    public int methodToInt(SootMethod method) {
        if (!methodToInteger.containsKey(method)) {
            methodToInteger.put(method, methodToInteger.size());
        }
        return methodToInteger.get(method);
    }

    public SootMethod getMethod() {
        return this.method;
    }

    static {
        DEBUG = true;
        methodToInteger = new HashMap<SootMethod, Integer>();
        statementToInteger = new HashMap<Stmt, Integer>();
    }

    private static class EpsStatement
    extends Statement
    implements Empty {
        public EpsStatement() {
            super("Eps_s");
        }
    }
}

