/*
 * Decompiled with CFR 0.152.
 */
package boomerang;

import boomerang.jimple.Statement;
import boomerang.jimple.Val;
import boomerang.solver.AbstractBoomerangSolver;
import boomerang.solver.BackwardBoomerangSolver;
import sync.pds.solver.nodes.INode;
import sync.pds.solver.nodes.SingleNode;
import wpds.impl.Transition;
import wpds.impl.Weight;

public class UnbalancedPopHandler<W extends Weight> {
    private INode<Val> returningFact;
    private Transition<Statement, INode<Val>> trans;
    private W weight;

    public UnbalancedPopHandler(INode<Val> returningFact, Transition<Statement, INode<Val>> trans, W weight) {
        this.returningFact = returningFact;
        this.trans = trans;
        this.weight = weight;
    }

    public void trigger(Statement callStatement, AbstractBoomerangSolver<W> solver) {
        boolean valueUsedInStatement = solver.valueUsedInStatement(callStatement.getUnit().get(), this.returningFact.fact());
        if (valueUsedInStatement) {
            this.unbalancedReturnFlow(callStatement, this.returningFact, this.trans, this.weight, solver);
        }
    }

    private void unbalancedReturnFlow(final Statement callStatement, final INode<Val> returningFact, final Transition<Statement, INode<Val>> trans, W weight, final AbstractBoomerangSolver<W> solver) {
        solver.submit(callStatement.getMethod(), new Runnable(){

            @Override
            public void run() {
                if (solver instanceof BackwardBoomerangSolver) {
                    for (Statement returnSite : solver.getSuccsOf(callStatement)) {
                        Val unbalancedFact = ((Val)returningFact.fact()).asUnbalanced(returnSite);
                        SingleNode<Val> unbalancedState = new SingleNode<Val>(unbalancedFact);
                        solver.getCallAutomaton().addUnbalancedState(unbalancedState);
                        solver.getCallAutomaton().addWeightForTransition(new Transition<Statement, SingleNode<Val>>((SingleNode<Val>)trans.getTarget(), returnSite, unbalancedState), solver.getCallAutomaton().getOne());
                    }
                } else {
                    Val unbalancedFact = ((Val)returningFact.fact()).asUnbalanced(callStatement);
                    SingleNode<Val> unbalancedState = new SingleNode<Val>(unbalancedFact);
                    solver.getCallAutomaton().addUnbalancedState(unbalancedState);
                    solver.getCallAutomaton().addWeightForTransition(new Transition<Statement, SingleNode<Val>>((SingleNode<Val>)trans.getTarget(), callStatement, unbalancedState), solver.getCallAutomaton().getOne());
                }
            }
        });
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.returningFact == null ? 0 : this.returningFact.hashCode());
        result = 31 * result + (this.trans == null ? 0 : this.trans.hashCode());
        result = 31 * result + (this.weight == null ? 0 : this.weight.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UnbalancedPopHandler other = (UnbalancedPopHandler)obj;
        if (this.returningFact == null ? other.returningFact != null : !this.returningFact.equals(other.returningFact)) {
            return false;
        }
        if (this.trans == null ? other.trans != null : !this.trans.equals(other.trans)) {
            return false;
        }
        return !(this.weight == null ? other.weight != null : !this.weight.equals(other.weight));
    }
}

