/*-
 * ========================LICENSE_START=================================
 * ids-api
 * %%
 * Copyright (C) 2018 Fraunhofer AISEC
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =========================LICENSE_END==================================
 */
package de.fhg.aisec.ids.api.internal;

import java.rmi.Remote;

/**
 * Internal interface of the IDS core platform, i.e. methods the IDS Core Platform provides to other
 * containers within the same connector.
 *
 * @author Julian Schütte (julian.schuette@aisec.fraunhofer.de)
 */
public interface InternalAPI extends Remote {

  /**
   * Returns an array of broker endpoints used by Communication Manager.
   *
   * @return
   */
  public String[] getBrokerEndpoints();
}
