/*-
 * ========================LICENSE_START=================================
 * Camel IDS Component
 * %%
 * Copyright (C) 2017 - 2018 Fraunhofer AISEC
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =========================LICENSE_END==================================
 */
/*
 * Copyright 2018 toni.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package de.fhg.aisec.ids.api.infomodel;

import de.fraunhofer.iais.eis.Connector;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface InfoModel {

  /**
   * Retrieve Connector object based on stored properties
   *
   * @return currently stored Connector object
   */
  @Nullable Connector getConnector();

  /**
   * Save/Update Connector object to preferences
   *
   * @param profile Basic connector profile from GUI
   * @return update success
   */
  boolean setConnector(@NonNull ConnectorProfile profile);

  /**
   * Get connector self-description as JSON-LD
   *
   * @return Connector self-description as JSON-LD
   */
  @NonNull String getConnectorAsJsonLd();

  /**
   * Set static connector self-description as JSON-LD,
   * or remove if "null" is passed
   */
  void setConnectorByJsonLd(@Nullable String jsonLd);

}
