/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.passes.scopes;

import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.statements.BreakStatement;
import de.fraunhofer.aisec.cpg.graph.statements.ContinueStatement;
import de.fraunhofer.aisec.cpg.graph.statements.DoStatement;
import de.fraunhofer.aisec.cpg.graph.statements.ForEachStatement;
import de.fraunhofer.aisec.cpg.graph.statements.ForStatement;
import de.fraunhofer.aisec.cpg.graph.statements.Statement;
import de.fraunhofer.aisec.cpg.graph.statements.WhileStatement;
import de.fraunhofer.aisec.cpg.helpers.SubgraphWalker;
import de.fraunhofer.aisec.cpg.passes.scopes.Breakable;
import de.fraunhofer.aisec.cpg.passes.scopes.Continuable;
import de.fraunhofer.aisec.cpg.passes.scopes.ValueDeclarationScope;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoopScope
extends ValueDeclarationScope
implements Breakable,
Continuable {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoopScope.class);
    private List<Node> starts = new ArrayList<Node>();
    private List<Node> conditions = new ArrayList<Node>();
    private final List<BreakStatement> breaks = new ArrayList<BreakStatement>();
    private final List<ContinueStatement> continues = new ArrayList<ContinueStatement>();

    public LoopScope(Statement loopStatement) {
        super(loopStatement);
    }

    public List<Node> getStarts() {
        return this.starts;
    }

    public void setStarts(List<Node> starts) {
        this.starts = starts;
    }

    public List<Node> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<Node> conditions) {
        this.conditions = conditions;
    }

    @Override
    public void addBreakStatement(BreakStatement breakStatement) {
        this.breaks.add(breakStatement);
    }

    @Override
    public void addContinueStatement(ContinueStatement continueStatement) {
        this.continues.add(continueStatement);
    }

    @Override
    public List<BreakStatement> getBreakStatements() {
        return this.breaks;
    }

    @Override
    public List<ContinueStatement> getContinueStatements() {
        return this.continues;
    }

    public List<Node> starts() {
        if (this.astNode instanceof WhileStatement) {
            WhileStatement ws = (WhileStatement)this.astNode;
            if (ws.getConditionDeclaration() != null) {
                return SubgraphWalker.getEOGPathEdges(ws.getConditionDeclaration()).getEntries();
            }
            if (ws.getCondition() != null) {
                return SubgraphWalker.getEOGPathEdges(ws.getCondition()).getEntries();
            }
            return SubgraphWalker.getEOGPathEdges(ws.getStatement()).getEntries();
        }
        if (this.astNode instanceof ForStatement) {
            ForStatement fs = (ForStatement)this.astNode;
            if (fs.getConditionDeclaration() != null) {
                return SubgraphWalker.getEOGPathEdges(fs.getConditionDeclaration()).getEntries();
            }
            if (fs.getCondition() != null) {
                return SubgraphWalker.getEOGPathEdges(fs.getCondition()).getEntries();
            }
            return SubgraphWalker.getEOGPathEdges(fs.getStatement()).getEntries();
        }
        if (this.astNode instanceof ForEachStatement) {
            ForEachStatement fs = (ForEachStatement)this.astNode;
            return SubgraphWalker.getEOGPathEdges(fs).getEntries();
        }
        if (this.astNode instanceof DoStatement) {
            return SubgraphWalker.getEOGPathEdges(((DoStatement)this.astNode).getStatement()).getEntries();
        }
        LOGGER.error("Currently the component {} is not supported as loop scope.", this.astNode.getClass());
        return new ArrayList<Node>();
    }
}

