/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.helpers;

import java.time.Duration;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B%\b\u0007\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0011\u001a\u00020\u000bR\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lde/fraunhofer/aisec/cpg/helpers/Benchmark;", "", "c", "Ljava/lang/Class;", "message", "", "debug", "", "(Ljava/lang/Class;Ljava/lang/String;Z)V", "caller", "<set-?>", "", "duration", "getDuration", "()J", "start", "Ljava/time/Instant;", "stop", "Companion", "cpg-library"})
public class Benchmark {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String message;
    private boolean debug;
    @NotNull
    private final String caller;
    @NotNull
    private final Instant start;
    private long duration;
    private static final Logger log = LoggerFactory.getLogger(Benchmark.class);

    @JvmOverloads
    public Benchmark(@NotNull Class<?> c, @NotNull String message, boolean debug) {
        Intrinsics.checkNotNullParameter(c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.message = message;
        this.debug = debug;
        this.duration = -1L;
        Object object = c.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"c.simpleName");
        this.caller = object;
        object = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"now()");
        this.start = object;
        String msg = this.caller + ": " + this.message;
        if (this.debug) {
            log.debug(msg);
        } else {
            log.info(msg);
        }
    }

    public /* synthetic */ Benchmark(Class clazz, String string, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        this(clazz, string, bl);
    }

    public final long getDuration() {
        return this.duration;
    }

    public final long stop() {
        this.duration = Duration.between(this.start, Instant.now()).toMillis();
        String msg = this.caller + ": " + this.message + " done in " + this.duration + " ms";
        if (this.debug) {
            log.debug(msg);
        } else {
            log.info(msg);
        }
        return this.duration;
    }

    @JvmOverloads
    public Benchmark(@NotNull Class<?> c, @NotNull String message) {
        Intrinsics.checkNotNullParameter(c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this(c, message, false, 4, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lde/fraunhofer/aisec/cpg/helpers/Benchmark$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "cpg-library"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

