/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.graph.statements.expressions;

import de.fraunhofer.aisec.cpg.graph.HasType;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.TypeManager;
import de.fraunhofer.aisec.cpg.graph.statements.Statement;
import de.fraunhofer.aisec.cpg.graph.types.FunctionPointerType;
import de.fraunhofer.aisec.cpg.graph.types.ReferenceType;
import de.fraunhofer.aisec.cpg.graph.types.Type;
import de.fraunhofer.aisec.cpg.graph.types.UnknownType;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.neo4j.ogm.annotation.Transient;

public class Expression
extends Statement
implements HasType {
    protected Type type = UnknownType.getUnknownType();
    @Transient
    private final Set<HasType.TypeListener> typeListeners = new HashSet<HasType.TypeListener>();
    private Set<Type> possibleSubTypes = new HashSet<Type>();

    @Override
    public Type getType() {
        Type result = TypeManager.isTypeSystemActive() ? (this.type != null ? this.type : UnknownType.getUnknownType()) : (Type)TypeManager.getInstance().getTypeCache().computeIfAbsent(this, n -> Collections.emptySet()).stream().findAny().orElse(UnknownType.getUnknownType());
        return result;
    }

    @Override
    public Type getPropagationType() {
        if (this.type instanceof ReferenceType) {
            return ((ReferenceType)this.type).getElementType();
        }
        return this.getType();
    }

    @Override
    public void updateType(Type type) {
        this.type = type;
    }

    @Override
    public void updatePossibleSubtypes(Set<Type> types) {
        this.possibleSubTypes = types;
    }

    @Override
    public void setType(Type type, HasType root) {
        if (!TypeManager.isTypeSystemActive()) {
            TypeManager.getInstance().cacheType(this, type);
            return;
        }
        if (type == null || root == this) {
            return;
        }
        if (this.type instanceof FunctionPointerType && !(type instanceof FunctionPointerType)) {
            return;
        }
        Type oldType = this.type;
        if (TypeManager.getInstance().isUnknown(type) || TypeManager.getInstance().stopPropagation(oldType, type)) {
            return;
        }
        type = type.duplicate();
        type.setQualifier(this.type.getQualifier().merge(type.getQualifier()));
        Set<Type> subTypes = new HashSet<Type>();
        for (Type t : this.getPossibleSubTypes()) {
            if (t.isSimilar(type)) continue;
            subTypes.add(t);
        }
        subTypes.add(type);
        this.type = TypeManager.getInstance().registerType(TypeManager.getInstance().getCommonType(subTypes).orElse(type));
        subTypes = subTypes.stream().filter(s -> TypeManager.getInstance().isSupertypeOf(this.type, (Type)s)).collect(Collectors.toSet());
        subTypes = subTypes.stream().map(s -> TypeManager.getInstance().registerType(s)).collect(Collectors.toSet());
        this.setPossibleSubTypes(subTypes);
        if (!Objects.equals(oldType, type)) {
            this.typeListeners.stream().filter(l -> !l.equals(this)).forEach(l -> l.typeChanged(this, root == null ? this : root, oldType));
        }
    }

    @Override
    public Set<Type> getPossibleSubTypes() {
        if (!TypeManager.isTypeSystemActive()) {
            return TypeManager.getInstance().getTypeCache().getOrDefault(this, Collections.emptySet());
        }
        return this.possibleSubTypes;
    }

    @Override
    public void setPossibleSubTypes(Set<Type> possibleSubTypes, HasType root) {
        possibleSubTypes = possibleSubTypes.stream().filter(Predicate.not(TypeManager.getInstance()::isUnknown)).collect(Collectors.toSet());
        if (!TypeManager.isTypeSystemActive()) {
            possibleSubTypes.forEach(t -> TypeManager.getInstance().cacheType(this, (Type)t));
            return;
        }
        if (root == this) {
            return;
        }
        if (possibleSubTypes.stream().allMatch(TypeManager.getInstance()::isPrimitive) && !this.possibleSubTypes.isEmpty()) {
            return;
        }
        Set<Type> oldSubTypes = this.possibleSubTypes;
        this.possibleSubTypes = new HashSet<Type>(possibleSubTypes);
        if (!this.getPossibleSubTypes().equals(oldSubTypes)) {
            this.typeListeners.stream().filter(l -> !l.equals(this)).forEach(l -> l.possibleSubTypesChanged(this, root == null ? this : root, oldSubTypes));
        }
    }

    @Override
    public void resetTypes(Type type) {
        HashSet<Type> oldSubTypes = new HashSet<Type>(this.getPossibleSubTypes());
        Type oldType = this.type;
        this.type = type;
        this.possibleSubTypes = new HashSet<Type>();
        if (!Objects.equals(oldType, type)) {
            this.typeListeners.stream().filter(l -> !l.equals(this)).forEach(l -> l.typeChanged(this, this, oldType));
        }
        if (oldSubTypes.size() != 1 || !oldSubTypes.contains(type)) {
            this.typeListeners.stream().filter(l -> !l.equals(this)).forEach(l -> l.possibleSubTypesChanged(this, this, oldSubTypes));
        }
    }

    @Override
    public void registerTypeListener(HasType.TypeListener listener) {
        this.typeListeners.add(listener);
        listener.typeChanged(this, this, this.type);
        listener.possibleSubTypesChanged(this, this, this.possibleSubTypes);
    }

    @Override
    public void unregisterTypeListener(HasType.TypeListener listener) {
        this.typeListeners.remove(listener);
    }

    @Override
    public Set<HasType.TypeListener> getTypeListeners() {
        return this.typeListeners;
    }

    @Override
    public void refreshType() {
        this.typeListeners.forEach(l -> {
            l.typeChanged(this, this, this.type);
            l.possibleSubTypesChanged(this, this, this.possibleSubTypes);
        });
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, Node.TO_STRING_STYLE).appendSuper(super.toString()).append("type", (Object)this.type).toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Expression)) {
            return false;
        }
        Expression that = (Expression)o;
        return super.equals(that) && Objects.equals(this.type, that.type) && Objects.equals(this.possibleSubTypes, that.possibleSubTypes);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

