/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.frontends.typescript;

import de.fraunhofer.aisec.cpg.ExperimentalTypeScript;
import de.fraunhofer.aisec.cpg.frontends.Handler;
import de.fraunhofer.aisec.cpg.frontends.HandlerInterface;
import de.fraunhofer.aisec.cpg.frontends.LanguageFrontend;
import de.fraunhofer.aisec.cpg.frontends.typescript.TypeScriptLanguageFrontend;
import de.fraunhofer.aisec.cpg.frontends.typescript.TypeScriptNode;
import de.fraunhofer.aisec.cpg.graph.NodeBuilder;
import de.fraunhofer.aisec.cpg.graph.declarations.FunctionDeclaration;
import de.fraunhofer.aisec.cpg.graph.statements.CompoundStatement;
import de.fraunhofer.aisec.cpg.graph.statements.ReturnStatement;
import de.fraunhofer.aisec.cpg.graph.statements.Statement;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.CallExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.DeclaredReferenceExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Expression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.ExpressionList;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.InitializerListExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.KeyValueExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.LambdaExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Literal;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.MemberExpression;
import de.fraunhofer.aisec.cpg.graph.types.Type;
import de.fraunhofer.aisec.cpg.graph.types.TypeParser;
import de.fraunhofer.aisec.cpg.graph.types.UnknownType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.FunctionReferenceImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ExperimentalTypeScript
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003H\u0002J\u0010\u0010\n\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0003H\u0002J\u0010\u0010\u000b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0003H\u0002J\u0010\u0010\f\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0003H\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\u0003H\u0002J\u0010\u0010\u000f\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0003H\u0002J\u0010\u0010\u0010\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0003H\u0002J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003H\u0002J\u0010\u0010\u0012\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0003H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\u0003H\u0002J\u0010\u0010\u0015\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0003H\u0002J\u0010\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\u0003H\u0002J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\t\u001a\u00020\u0003H\u0002\u00a8\u0006\u001a"}, d2={"Lde/fraunhofer/aisec/cpg/frontends/typescript/ExpressionHandler;", "Lde/fraunhofer/aisec/cpg/frontends/Handler;", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/Expression;", "Lde/fraunhofer/aisec/cpg/frontends/typescript/TypeScriptNode;", "Lde/fraunhofer/aisec/cpg/frontends/typescript/TypeScriptLanguageFrontend;", "lang", "(Lde/fraunhofer/aisec/cpg/frontends/typescript/TypeScriptLanguageFrontend;)V", "handeJsxElement", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/ExpressionList;", "node", "handleArrowFunction", "handleCallExpression", "handleIdentifier", "handleJsxAttribute", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/KeyValueExpression;", "handleJsxClosingElement", "handleJsxExpression", "handleJsxOpeningElement", "handleNode", "handleObjectLiteralExpression", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/InitializerListExpression;", "handlePropertyAccessExpression", "handlePropertyAssignment", "handleStringLiteral", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/Literal;", "", "cpg-library"})
public final class ExpressionHandler
extends Handler<Expression, TypeScriptNode, TypeScriptLanguageFrontend> {
    public ExpressionHandler(@NotNull TypeScriptLanguageFrontend lang) {
        Intrinsics.checkNotNullParameter((Object)lang, (String)"lang");
        super(Expression::new, (LanguageFrontend)lang);
        this.map.put(TypeScriptNode.class, new HandlerInterface(){

            @NotNull
            public final Expression handle(@NotNull TypeScriptNode p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ExpressionHandler.this.handleNode(p0);
            }

            @NotNull
            public final Function<?> getFunctionDelegate() {
                return (Function)new FunctionReferenceImpl(1, (Object)ExpressionHandler.this, ExpressionHandler.class, "handleNode", "handleNode(Lde/fraunhofer/aisec/cpg/frontends/typescript/TypeScriptNode;)Lde/fraunhofer/aisec/cpg/graph/statements/expressions/Expression;", 0);
            }

            public final boolean equals(@Nullable Object other) {
                return other instanceof HandlerInterface ? (other instanceof FunctionAdapter ? Intrinsics.areEqual(this.getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return this.getFunctionDelegate().hashCode();
            }
        });
    }

    private final Expression handleNode(TypeScriptNode node) {
        switch (node.getType()) {
            case "CallExpression": {
                return this.handleCallExpression(node);
            }
            case "PropertyAccessExpression": {
                return this.handlePropertyAccessExpression(node);
            }
            case "Identifier": {
                return this.handleIdentifier(node);
            }
            case "FirstTemplateToken": {
                return this.handleStringLiteral(node);
            }
            case "TemplateExpression": {
                return this.handleStringLiteral(node);
            }
            case "NoSubstitutionTemplateLiteral": {
                return this.handleStringLiteral(node);
            }
            case "StringLiteral": {
                return this.handleStringLiteral(node);
            }
            case "ObjectLiteralExpression": {
                return this.handleObjectLiteralExpression(node);
            }
            case "PropertyAssignment": {
                return this.handlePropertyAssignment(node);
            }
            case "ArrowFunction": {
                return this.handleArrowFunction(node);
            }
            case "FunctionExpression": {
                return this.handleArrowFunction(node);
            }
            case "JsxElement": {
                return this.handeJsxElement(node);
            }
            case "JsxOpeningElement": {
                return this.handleJsxOpeningElement(node);
            }
            case "JsxAttribute": {
                return this.handleJsxAttribute(node);
            }
            case "JsxText": {
                return this.handleStringLiteral(node);
            }
            case "JsxExpression": {
                return this.handleJsxExpression(node);
            }
            case "JsxClosingElement": {
                return this.handleJsxClosingElement(node);
            }
        }
        return new Expression();
    }

    private final KeyValueExpression handleJsxAttribute(TypeScriptNode node) {
        List<TypeScriptNode> list = node.getChildren();
        Expression key = (Expression)this.handle(list == null ? null : (TypeScriptNode)CollectionsKt.first(list));
        List<TypeScriptNode> list2 = node.getChildren();
        Expression value = (Expression)this.handle(list2 == null ? null : (TypeScriptNode)CollectionsKt.last(list2));
        KeyValueExpression keyValue = NodeBuilder.newKeyValueExpression(key, value, ((TypeScriptLanguageFrontend)this.lang).getCodeFromRawNode(node));
        return keyValue;
    }

    private final Expression handleJsxClosingElement(TypeScriptNode node) {
        ExpressionList tag = NodeBuilder.newExpressionList(((TypeScriptLanguageFrontend)this.lang).getCodeFromRawNode(node));
        String it = ((TypeScriptLanguageFrontend)this.lang).getIdentifierName$cpg_library(node);
        boolean bl = false;
        tag.setName("</" + it + '>');
        return tag;
    }

    private final Expression handleJsxExpression(TypeScriptNode node) {
        List<TypeScriptNode> list = node.getChildren();
        Object s = this.handle(list == null ? null : (TypeScriptNode)CollectionsKt.first(list));
        Intrinsics.checkNotNullExpressionValue(s, (String)"this.handle(node.children?.first())");
        return (Expression)s;
    }

    /*
     * WARNING - void declaration
     */
    private final ExpressionList handleJsxOpeningElement(TypeScriptNode node) {
        List list;
        ExpressionList tag = NodeBuilder.newExpressionList(((TypeScriptLanguageFrontend)this.lang).getCodeFromRawNode(node));
        String it = ((TypeScriptLanguageFrontend)this.lang).getIdentifierName$cpg_library(node);
        boolean bl = false;
        tag.setName('<' + it + '>');
        ExpressionList expressionList = tag;
        TypeScriptNode typeScriptNode = node.firstChild("JsxAttributes");
        if (typeScriptNode == null) {
            list = null;
        } else {
            List<TypeScriptNode> list2 = typeScriptNode.getChildren();
            if (list2 == null) {
                list = null;
            } else {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable iterable = list2;
                ExpressionList expressionList2 = expressionList;
                boolean $i$f$map = false;
                void var7_8 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it2;
                    TypeScriptNode typeScriptNode2 = (TypeScriptNode)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add((Expression)this.handle(it2));
                }
                list = (List)destination$iv$iv;
                expressionList = expressionList2;
            }
        }
        List list3 = list;
        if (list == null) {
            list3 = CollectionsKt.emptyList();
        }
        expressionList.setExpressions(list3);
        return tag;
    }

    /*
     * WARNING - void declaration
     */
    private final ExpressionList handeJsxElement(TypeScriptNode node) {
        List list;
        ExpressionList jsx;
        ExpressionList expressionList = jsx = NodeBuilder.newExpressionList(((TypeScriptLanguageFrontend)this.lang).getCodeFromRawNode(node));
        List<TypeScriptNode> list2 = node.getChildren();
        if (list2 == null) {
            list = null;
        } else {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = list2;
            ExpressionList expressionList2 = expressionList;
            boolean $i$f$map = false;
            void var5_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                TypeScriptNode typeScriptNode = (TypeScriptNode)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add((Expression)this.handle(it));
            }
            list = (List)destination$iv$iv;
            expressionList = expressionList2;
        }
        expressionList.setExpressions(list);
        return jsx;
    }

    /*
     * WARNING - void declaration
     */
    private final Expression handleArrowFunction(TypeScriptNode node) {
        FunctionDeclaration func;
        Object s = ((TypeScriptLanguageFrontend)this.lang).getDeclarationHandler().handle(node);
        FunctionDeclaration functionDeclaration = func = s instanceof FunctionDeclaration ? (FunctionDeclaration)s : null;
        if (Intrinsics.areEqual((Object)(functionDeclaration == null ? null : functionDeclaration.getType()), (Object)UnknownType.getUnknownType())) {
            Expression returnValue;
            Statement statement;
            FunctionDeclaration $this$bodyOrNull_u24default$iv = func;
            int n$iv = 0;
            boolean $i$f$bodyOrNull = false;
            if ($this$bodyOrNull_u24default$iv.getBody() instanceof CompoundStatement) {
                Statement statement2 = $this$bodyOrNull_u24default$iv.getBody();
                CompoundStatement compoundStatement = statement2 instanceof CompoundStatement ? (CompoundStatement)statement2 : null;
                if (compoundStatement == null) {
                    statement = null;
                } else {
                    List<Statement> list = compoundStatement.getStatements();
                    if (list == null) {
                        statement = null;
                    } else {
                        void $this$filterIsInstanceTo$iv$iv$iv;
                        Iterable $this$filterIsInstance$iv$iv = list;
                        boolean $i$f$filterIsInstance = false;
                        Iterable iterable = $this$filterIsInstance$iv$iv;
                        Collection destination$iv$iv$iv = new ArrayList();
                        boolean $i$f$filterIsInstanceTo = false;
                        for (Object element$iv$iv$iv : $this$filterIsInstanceTo$iv$iv$iv) {
                            if (!(element$iv$iv$iv instanceof ReturnStatement)) continue;
                            destination$iv$iv$iv.add(element$iv$iv$iv);
                        }
                        List list2 = (List)destination$iv$iv$iv;
                        statement = (Statement)CollectionsKt.getOrNull((List)list2, (int)n$iv);
                    }
                }
            } else if ($this$bodyOrNull_u24default$iv.getBody() instanceof ReturnStatement) {
                Statement statement3 = $this$bodyOrNull_u24default$iv.getBody();
                if (statement3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.statements.ReturnStatement");
                }
                statement = (ReturnStatement)statement3;
            } else {
                statement = null;
            }
            ReturnStatement returnStatement = (ReturnStatement)statement;
            Expression expression = returnValue = returnStatement == null ? null : returnStatement.getReturnValue();
            Type type = expression == null ? null : expression.getType();
            if (type == null) {
                UnknownType unknownType = UnknownType.getUnknownType();
                Intrinsics.checkNotNullExpressionValue((Object)unknownType, (String)"getUnknownType()");
                type = unknownType;
            }
            Type returnType = type;
            func.setType(returnType);
        }
        LambdaExpression lambda = NodeBuilder.INSTANCE.newLambdaExpression(((TypeScriptLanguageFrontend)this.lang).getCodeFromRawNode(node));
        lambda.setFunction(func);
        return lambda;
    }

    private final KeyValueExpression handlePropertyAssignment(TypeScriptNode node) {
        List<TypeScriptNode> list = node.getChildren();
        Expression key = (Expression)this.handle(list == null ? null : (TypeScriptNode)CollectionsKt.first(list));
        List<TypeScriptNode> list2 = node.getChildren();
        Expression value = (Expression)this.handle(list2 == null ? null : (TypeScriptNode)CollectionsKt.last(list2));
        KeyValueExpression keyValue = NodeBuilder.newKeyValueExpression(key, value, ((TypeScriptLanguageFrontend)this.lang).getCodeFromRawNode(node));
        return keyValue;
    }

    /*
     * WARNING - void declaration
     */
    private final InitializerListExpression handleObjectLiteralExpression(TypeScriptNode node) {
        List list;
        InitializerListExpression ile;
        InitializerListExpression initializerListExpression = ile = NodeBuilder.newInitializerListExpression(((TypeScriptLanguageFrontend)this.lang).getCodeFromRawNode(node));
        List<TypeScriptNode> list2 = node.getChildren();
        if (list2 == null) {
            list = null;
        } else {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = list2;
            InitializerListExpression initializerListExpression2 = initializerListExpression;
            boolean $i$f$map = false;
            void var5_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                TypeScriptNode typeScriptNode = (TypeScriptNode)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add((Expression)this.handle(it));
            }
            list = (List)destination$iv$iv;
            initializerListExpression = initializerListExpression2;
        }
        List list3 = list;
        if (list == null) {
            list3 = CollectionsKt.emptyList();
        }
        initializerListExpression.setInitializers(list3);
        return ile;
    }

    private final Literal<String> handleStringLiteral(TypeScriptNode node) {
        String string;
        String string2;
        String string3;
        String string4;
        String string5 = ((TypeScriptLanguageFrontend)this.lang).getCodeFromRawNode(node);
        String value = string5 == null ? "" : ((string4 = ((Object)StringsKt.trim((CharSequence)string5)).toString()) == null ? "" : ((string3 = StringsKt.replace$default((String)string4, (String)"\"", (String)"", (boolean)false, (int)4, null)) == null ? "" : ((string2 = StringsKt.replace$default((String)string3, (String)"`", (String)"", (boolean)false, (int)4, null)) == null ? "" : ((string = StringsKt.replace$default((String)string2, (String)"'", (String)"", (boolean)false, (int)4, null)) == null ? "" : string))));
        return NodeBuilder.newLiteral(value, TypeParser.createFrom("String", false), ((TypeScriptLanguageFrontend)this.lang).getCodeFromRawNode(node));
    }

    private final Expression handleIdentifier(TypeScriptNode node) {
        String string = ((TypeScriptLanguageFrontend)this.lang).getCodeFromRawNode(node);
        String name = string == null ? null : ((Object)StringsKt.trim((CharSequence)string)).toString();
        DeclaredReferenceExpression ref = NodeBuilder.newDeclaredReferenceExpression(name, UnknownType.getUnknownType(), ((TypeScriptLanguageFrontend)this.lang).getCodeFromRawNode(node));
        return ref;
    }

    private final Expression handlePropertyAccessExpression(TypeScriptNode node) {
        List<TypeScriptNode> list = node.getChildren();
        Expression base = (Expression)this.handle(list == null ? null : (TypeScriptNode)CollectionsKt.first(list));
        List<TypeScriptNode> list2 = node.getChildren();
        String name = ((TypeScriptLanguageFrontend)this.lang).getCodeFromRawNode(list2 == null ? null : (TypeScriptNode)CollectionsKt.last(list2));
        MemberExpression memberExpression = NodeBuilder.newMemberExpression(base, UnknownType.getUnknownType(), name, ".", ((TypeScriptLanguageFrontend)this.lang).getCodeFromRawNode(node));
        return memberExpression;
    }

    private final Expression handleCallExpression(TypeScriptNode node) {
        List remainingNodes;
        CallExpression call = null;
        TypeScriptNode propertyAccess = node.firstChild("PropertyAccessExpression");
        if (propertyAccess != null) {
            Object s = this.handle(propertyAccess);
            if (s == null) {
                throw new NullPointerException("null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.statements.expressions.MemberExpression");
            }
            MemberExpression memberExpression = (MemberExpression)s;
            DeclaredReferenceExpression member = NodeBuilder.newDeclaredReferenceExpression(memberExpression.getName(), memberExpression.getType(), memberExpression.getName());
            String fqn = memberExpression.getName();
            call = NodeBuilder.newMemberCallExpression(memberExpression.getName(), fqn, memberExpression.getBase(), member, ".", ((TypeScriptLanguageFrontend)this.lang).getCodeFromRawNode(node));
        } else {
            String name;
            String fqn = name = ((TypeScriptLanguageFrontend)this.lang).getIdentifierName$cpg_library(node);
            call = NodeBuilder.newCallExpression(name, fqn, ((TypeScriptLanguageFrontend)this.lang).getCodeFromRawNode(node), false);
        }
        List<TypeScriptNode> list = node.getChildren();
        List list2 = remainingNodes = list == null ? null : CollectionsKt.drop((Iterable)list, (int)1);
        if (list2 != null) {
            Iterable $this$forEach$iv = list2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TypeScriptNode it = (TypeScriptNode)element$iv;
                boolean bl = false;
                call.addArgument((Expression)this.handle(it));
            }
        }
        return call;
    }
}

