/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.frontends.typescript;

import de.fraunhofer.aisec.cpg.ExperimentalTypeScript;
import de.fraunhofer.aisec.cpg.frontends.Handler;
import de.fraunhofer.aisec.cpg.frontends.HandlerInterface;
import de.fraunhofer.aisec.cpg.frontends.LanguageFrontend;
import de.fraunhofer.aisec.cpg.frontends.typescript.TypeScriptLanguageFrontend;
import de.fraunhofer.aisec.cpg.frontends.typescript.TypeScriptNode;
import de.fraunhofer.aisec.cpg.graph.NodeBuilder;
import de.fraunhofer.aisec.cpg.graph.declarations.Declaration;
import de.fraunhofer.aisec.cpg.graph.declarations.FieldDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.FunctionDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.MethodDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.ParamVariableDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.RecordDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.TranslationUnitDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.VariableDeclaration;
import de.fraunhofer.aisec.cpg.graph.statements.Statement;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Expression;
import de.fraunhofer.aisec.cpg.graph.types.Type;
import de.fraunhofer.aisec.cpg.graph.types.UnknownType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.FunctionReferenceImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ExperimentalTypeScript
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003H\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u0003H\u0002J\u0010\u0010\f\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0003H\u0002J\u0010\u0010\r\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0003H\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\u0003H\u0002J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\u0003J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\u0003H\u0002\u00a8\u0006\u0014"}, d2={"Lde/fraunhofer/aisec/cpg/frontends/typescript/DeclarationHandler;", "Lde/fraunhofer/aisec/cpg/frontends/Handler;", "Lde/fraunhofer/aisec/cpg/graph/declarations/Declaration;", "Lde/fraunhofer/aisec/cpg/frontends/typescript/TypeScriptNode;", "Lde/fraunhofer/aisec/cpg/frontends/typescript/TypeScriptLanguageFrontend;", "lang", "(Lde/fraunhofer/aisec/cpg/frontends/typescript/TypeScriptLanguageFrontend;)V", "handleClassDeclaration", "Lde/fraunhofer/aisec/cpg/graph/declarations/RecordDeclaration;", "node", "handleFunctionDeclaration", "Lde/fraunhofer/aisec/cpg/graph/declarations/FunctionDeclaration;", "handleNode", "handleParameter", "handlePropertySignature", "Lde/fraunhofer/aisec/cpg/graph/declarations/FieldDeclaration;", "handleSourceFile", "Lde/fraunhofer/aisec/cpg/graph/declarations/TranslationUnitDeclaration;", "handleVariableDeclaration", "Lde/fraunhofer/aisec/cpg/graph/declarations/VariableDeclaration;", "cpg-library"})
public final class DeclarationHandler
extends Handler<Declaration, TypeScriptNode, TypeScriptLanguageFrontend> {
    public DeclarationHandler(@NotNull TypeScriptLanguageFrontend lang) {
        Intrinsics.checkNotNullParameter((Object)lang, (String)"lang");
        super(Declaration::new, (LanguageFrontend)lang);
        this.map.put(TypeScriptNode.class, new HandlerInterface(){

            @NotNull
            public final Declaration handle(@NotNull TypeScriptNode p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return DeclarationHandler.this.handleNode(p0);
            }

            @NotNull
            public final Function<?> getFunctionDelegate() {
                return (Function)new FunctionReferenceImpl(1, (Object)DeclarationHandler.this, DeclarationHandler.class, "handleNode", "handleNode(Lde/fraunhofer/aisec/cpg/frontends/typescript/TypeScriptNode;)Lde/fraunhofer/aisec/cpg/graph/declarations/Declaration;", 0);
            }

            public final boolean equals(@Nullable Object other) {
                return other instanceof HandlerInterface ? (other instanceof FunctionAdapter ? Intrinsics.areEqual(this.getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return this.getFunctionDelegate().hashCode();
            }
        });
    }

    private final Declaration handleNode(TypeScriptNode node) {
        switch (node.getType()) {
            case "SourceFile": {
                return this.handleSourceFile(node);
            }
            case "FunctionDeclaration": {
                return this.handleFunctionDeclaration(node);
            }
            case "MethodDeclaration": {
                return this.handleFunctionDeclaration(node);
            }
            case "Constructor": {
                return this.handleFunctionDeclaration(node);
            }
            case "ArrowFunction": {
                return this.handleFunctionDeclaration(node);
            }
            case "FunctionExpression": {
                return this.handleFunctionDeclaration(node);
            }
            case "Parameter": {
                return this.handleParameter(node);
            }
            case "PropertySignature": {
                return this.handlePropertySignature(node);
            }
            case "PropertyDeclaration": {
                return this.handlePropertySignature(node);
            }
            case "VariableDeclaration": {
                return this.handleVariableDeclaration(node);
            }
            case "InterfaceDeclaration": {
                return this.handleClassDeclaration(node);
            }
            case "ClassDeclaration": {
                return this.handleClassDeclaration(node);
            }
        }
        return new Declaration();
    }

    private final FieldDeclaration handlePropertySignature(TypeScriptNode node) {
        Type type;
        Type type2;
        String name = ((TypeScriptLanguageFrontend)this.lang).getIdentifierName$cpg_library(node);
        TypeScriptNode typeScriptNode = node.getTypeChildNode();
        if (typeScriptNode == null) {
            type2 = null;
        } else {
            TypeScriptNode it = typeScriptNode;
            boolean bl = false;
            type2 = (Type)((TypeScriptLanguageFrontend)this.lang).getTypeHandler().handle(it);
        }
        Type type3 = type2;
        if (type3 == null) {
            UnknownType unknownType = UnknownType.getUnknownType();
            Intrinsics.checkNotNullExpressionValue((Object)unknownType, (String)"getUnknownType()");
            type = unknownType;
        } else {
            type = type3;
        }
        Type type4 = type;
        FieldDeclaration field = NodeBuilder.newFieldDeclaration(name, type4, CollectionsKt.emptyList(), ((TypeScriptLanguageFrontend)this.lang).getCodeFromRawNode(node), ((TypeScriptLanguageFrontend)this.lang).getLocationFromRawNode(node), null, false);
        ((TypeScriptLanguageFrontend)this.lang).processAnnotations(field, node);
        return field;
    }

    /*
     * WARNING - void declaration
     */
    private final RecordDeclaration handleClassDeclaration(TypeScriptNode node) {
        String name = ((TypeScriptLanguageFrontend)this.lang).getIdentifierName$cpg_library(node);
        RecordDeclaration record = NodeBuilder.newRecordDeclaration(name, Intrinsics.areEqual((Object)node.getType(), (Object)"InterfaceDeclaration") ? "interface" : "class", ((TypeScriptLanguageFrontend)this.lang).getCodeFromRawNode(node), false);
        ((TypeScriptLanguageFrontend)this.lang).getScopeManager().enterScope(record);
        List<TypeScriptNode> list = node.getChildren();
        if (list != null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            TypeScriptNode it;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Iterable iterable = list;
            boolean $i$f$filter = false;
            void var8_7 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (TypeScriptNode)element$iv$iv;
                boolean bl = false;
                boolean bl2 = Intrinsics.areEqual((Object)it.getType(), (Object)"PropertySignature") || Intrinsics.areEqual((Object)it.getType(), (Object)"PropertyDeclaration") || Intrinsics.areEqual((Object)it.getType(), (Object)"Constructor") || Intrinsics.areEqual((Object)it.getType(), (Object)"MethodDeclaration");
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List list2 = (List)destination$iv$iv;
            $this$filter$iv = list2;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (TypeScriptNode)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                ((TypeScriptLanguageFrontend)this.lang).getScopeManager().addDeclaration((Declaration)this.handle(it));
                collection.add(Unit.INSTANCE);
            }
            List cfr_ignored_0 = (List)destination$iv$iv;
        }
        ((TypeScriptLanguageFrontend)this.lang).getScopeManager().leaveScope(record);
        ((TypeScriptLanguageFrontend)this.lang).processAnnotations(record, node);
        return record;
    }

    private final Declaration handleParameter(TypeScriptNode node) {
        Type type;
        Type type2;
        String name = ((TypeScriptLanguageFrontend)this.lang).getIdentifierName$cpg_library(node);
        TypeScriptNode typeScriptNode = node.getTypeChildNode();
        if (typeScriptNode == null) {
            type2 = null;
        } else {
            TypeScriptNode it = typeScriptNode;
            boolean bl = false;
            type2 = (Type)((TypeScriptLanguageFrontend)this.lang).getTypeHandler().handle(it);
        }
        Type type3 = type2;
        if (type3 == null) {
            UnknownType unknownType = UnknownType.getUnknownType();
            Intrinsics.checkNotNullExpressionValue((Object)unknownType, (String)"getUnknownType()");
            type = unknownType;
        } else {
            type = type3;
        }
        Type type4 = type;
        ParamVariableDeclaration param = NodeBuilder.newMethodParameterIn(name, type4, false, ((TypeScriptLanguageFrontend)this.lang).getCodeFromRawNode(node));
        return param;
    }

    @NotNull
    public final TranslationUnitDeclaration handleSourceFile(@NotNull TypeScriptNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        TranslationUnitDeclaration tu = NodeBuilder.newTranslationUnitDeclaration(node.getLocation().getFile(), ((TypeScriptLanguageFrontend)this.lang).getCodeFromRawNode(node));
        ((TypeScriptLanguageFrontend)this.lang).getScopeManager().resetToGlobal(tu);
        List list = node.getChildren();
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        for (TypeScriptNode childNode : list) {
            if (StringsKt.endsWith$default((String)childNode.getType(), (String)"Statement", (boolean)false, (int)2, null)) {
                Statement statement = (Statement)((TypeScriptLanguageFrontend)this.lang).getStatementHandler().handle(childNode);
                tu.addStatement(statement);
                continue;
            }
            Declaration decl = (Declaration)this.handle(childNode);
            ((TypeScriptLanguageFrontend)this.lang).getScopeManager().addDeclaration(decl);
        }
        return tu;
    }

    /*
     * WARNING - void declaration
     */
    private final FunctionDeclaration handleFunctionDeclaration(TypeScriptNode node) {
        TypeScriptNode it;
        FunctionDeclaration functionDeclaration;
        RecordDeclaration record;
        String name = ((TypeScriptLanguageFrontend)this.lang).getIdentifierName$cpg_library(node);
        String string = node.getType();
        if (Intrinsics.areEqual((Object)string, (Object)"MethodDeclaration")) {
            record = ((TypeScriptLanguageFrontend)this.lang).getScopeManager().getCurrentRecord();
            functionDeclaration = NodeBuilder.newMethodDeclaration(name, ((TypeScriptLanguageFrontend)this.lang).getCodeFromRawNode(node), false, record);
        } else if (Intrinsics.areEqual((Object)string, (Object)"Constructor")) {
            String string2;
            RecordDeclaration recordDeclaration = record = ((TypeScriptLanguageFrontend)this.lang).getScopeManager().getCurrentRecord();
            if (recordDeclaration == null) {
                string2 = "";
            } else {
                string2 = recordDeclaration.getName();
                if (string2 == null) {
                    string2 = "";
                }
            }
            functionDeclaration = NodeBuilder.newConstructorDeclaration(string2, ((TypeScriptLanguageFrontend)this.lang).getCodeFromRawNode(node), record);
        } else {
            functionDeclaration = NodeBuilder.newFunctionDeclaration(name, ((TypeScriptLanguageFrontend)this.lang).getCodeFromRawNode(node));
        }
        FunctionDeclaration func = functionDeclaration;
        TypeScriptNode typeScriptNode = node.getTypeChildNode();
        if (typeScriptNode != null) {
            it = typeScriptNode;
            boolean bl = false;
            func.setType((Type)((TypeScriptLanguageFrontend)this.lang).getTypeHandler().handle(it));
        }
        ((TypeScriptLanguageFrontend)this.lang).getScopeManager().enterScope(func);
        List<TypeScriptNode> list = node.getChildren();
        if (list != null) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = list;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                TypeScriptNode it2 = (TypeScriptNode)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it2.getType(), (Object)"Parameter")) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List list2 = (List)destination$iv$iv;
            Iterable $this$forEach$iv = list2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TypeScriptNode it3 = (TypeScriptNode)element$iv;
                boolean bl = false;
                Declaration param = ((TypeScriptLanguageFrontend)this.lang).getDeclarationHandler().handleNode(it3);
                if (func instanceof MethodDeclaration) {
                    ((TypeScriptLanguageFrontend)this.lang).processAnnotations(param, it3);
                }
                ((TypeScriptLanguageFrontend)this.lang).getScopeManager().addDeclaration(param);
            }
        }
        TypeScriptNode typeScriptNode2 = node.firstChild("Block");
        if (typeScriptNode2 != null) {
            it = typeScriptNode2;
            boolean bl = false;
            func.setBody((Statement)((TypeScriptLanguageFrontend)this.lang).getStatementHandler().handle(it));
        }
        TypeScriptNode typeScriptNode3 = node.firstChild("JsxElement");
        if (typeScriptNode3 != null) {
            it = typeScriptNode3;
            boolean bl = false;
            func.setBody((Statement)((TypeScriptLanguageFrontend)this.lang).getExpressionHandler().handle(it));
        }
        ((TypeScriptLanguageFrontend)this.lang).getScopeManager().leaveScope(func);
        if (func instanceof MethodDeclaration) {
            ((TypeScriptLanguageFrontend)this.lang).processAnnotations(func, node);
        }
        return func;
    }

    /*
     * WARNING - void declaration
     */
    private final VariableDeclaration handleVariableDeclaration(TypeScriptNode node) {
        String name = ((TypeScriptLanguageFrontend)this.lang).getIdentifierName$cpg_library(node);
        VariableDeclaration var = NodeBuilder.newVariableDeclaration(name, UnknownType.getUnknownType(), ((TypeScriptLanguageFrontend)this.lang).getCodeFromRawNode(node), false);
        var.setLocation(((TypeScriptLanguageFrontend)this.lang).getLocationFromRawNode(node));
        List<TypeScriptNode> list = node.getChildren();
        if (list != null) {
            Object v0;
            block3: {
                void $this$lastOrNull$iv;
                List<TypeScriptNode> list2 = list;
                boolean $i$f$lastOrNull = false;
                ListIterator iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
                while (iterator$iv.hasPrevious()) {
                    Object element$iv = iterator$iv.previous();
                    TypeScriptNode it = (TypeScriptNode)element$iv;
                    boolean bl = false;
                    if (!(!Intrinsics.areEqual((Object)it.getType(), (Object)"Identifier") && !Intrinsics.areEqual((Object)it.getType(), (Object)"ObjectBindingPattern"))) continue;
                    v0 = element$iv;
                    break block3;
                }
                v0 = null;
            }
            TypeScriptNode typeScriptNode = v0;
            if (typeScriptNode != null) {
                TypeScriptNode it = typeScriptNode;
                boolean bl = false;
                var.setInitializer((Expression)((TypeScriptLanguageFrontend)this.lang).getExpressionHandler().handle(it));
            }
        }
        return var;
    }
}

