/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.frontends.llvm;

import de.fraunhofer.aisec.cpg.frontends.Handler;
import de.fraunhofer.aisec.cpg.frontends.LanguageFrontend;
import de.fraunhofer.aisec.cpg.frontends.TranslationException;
import de.fraunhofer.aisec.cpg.frontends.llvm.LLVMIRLanguageFrontend;
import de.fraunhofer.aisec.cpg.frontends.llvm.LLVMIRLanguageFrontendKt;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.NodeBuilder;
import de.fraunhofer.aisec.cpg.graph.declarations.Declaration;
import de.fraunhofer.aisec.cpg.graph.declarations.FieldDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.RecordDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.VariableDeclaration;
import de.fraunhofer.aisec.cpg.graph.statements.CaseStatement;
import de.fraunhofer.aisec.cpg.graph.statements.CompoundStatement;
import de.fraunhofer.aisec.cpg.graph.statements.DeclarationStatement;
import de.fraunhofer.aisec.cpg.graph.statements.GotoStatement;
import de.fraunhofer.aisec.cpg.graph.statements.IfStatement;
import de.fraunhofer.aisec.cpg.graph.statements.LabelStatement;
import de.fraunhofer.aisec.cpg.graph.statements.ReturnStatement;
import de.fraunhofer.aisec.cpg.graph.statements.Statement;
import de.fraunhofer.aisec.cpg.graph.statements.SwitchStatement;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.ArrayCreationExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.BinaryOperator;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.CallExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.CastExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.ConditionalExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.ConstructExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Expression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.UnaryOperator;
import de.fraunhofer.aisec.cpg.graph.types.ObjectType;
import de.fraunhofer.aisec.cpg.graph.types.Type;
import de.fraunhofer.aisec.cpg.graph.types.TypeParser;
import de.fraunhofer.aisec.cpg.graph.types.UnknownType;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.llvm.LLVM.LLVMBasicBlockRef;
import org.bytedeco.llvm.LLVM.LLVMValueRef;
import org.bytedeco.llvm.global.LLVM;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u000bH\u0002J\u0010\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u000bH\u0002J\u0010\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u000bH\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J*\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010\u001b\u001a\u00020\u001aH\u0002J\u0010\u0010\u001c\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u000bH\u0002J\u0010\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u000bH\u0002J\u0010\u0010\u001e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u000bH\u0002J\u0010\u0010\u001f\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u000bH\u0002J\u0010\u0010 \u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u000bH\u0002J\u0010\u0010!\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u000bH\u0002J\u0010\u0010\"\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u000bH\u0002J\u0010\u0010#\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u000bH\u0002J\u0010\u0010$\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u000bH\u0002\u00a8\u0006%"}, d2={"Lde/fraunhofer/aisec/cpg/frontends/llvm/StatementHandler;", "Lde/fraunhofer/aisec/cpg/frontends/Handler;", "Lde/fraunhofer/aisec/cpg/graph/statements/Statement;", "Lorg/bytedeco/javacpp/Pointer;", "Lde/fraunhofer/aisec/cpg/frontends/llvm/LLVMIRLanguageFrontend;", "lang", "(Lde/fraunhofer/aisec/cpg/frontends/llvm/LLVMIRLanguageFrontend;)V", "declarationOrNot", "rhs", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/Expression;", "valueRef", "Lorg/bytedeco/llvm/LLVM/LLVMValueRef;", "extractBasicBlockLabel", "Lde/fraunhofer/aisec/cpg/graph/statements/LabelStatement;", "handleAlloca", "instr", "handleAtomiccmpxchg", "handleAtomicrmw", "handleBasicBlock", "Lde/fraunhofer/aisec/cpg/graph/statements/CompoundStatement;", "bb", "Lorg/bytedeco/llvm/LLVM/LLVMBasicBlockRef;", "handleBinaryOperator", "op", "", "unsigned", "", "unordered", "handleBrStatement", "handleFloatComparison", "handleFunctionCall", "handleInsertValue", "handleInstruction", "handleIntegerComparison", "handleLoad", "handleStore", "handleSwitchStatement", "cpg-library"})
public final class StatementHandler
extends Handler<Statement, Pointer, LLVMIRLanguageFrontend> {
    public StatementHandler(@NotNull LLVMIRLanguageFrontend lang) {
        Intrinsics.checkNotNullParameter((Object)lang, (String)"lang");
        super(Statement::new, (LanguageFrontend)lang);
        this.map.put(LLVMValueRef.class, arg_0 -> StatementHandler._init_$lambda-0(this, arg_0));
        this.map.put(LLVMBasicBlockRef.class, arg_0 -> StatementHandler._init_$lambda-1(this, arg_0));
    }

    private final Statement handleInstruction(LLVMValueRef instr) {
        LLVMValueRef $this$opCode$iv = instr;
        boolean $i$f$getOpCode = false;
        int opcode = LLVM.LLVMGetInstructionOpcode((LLVMValueRef)$this$opCode$iv);
        switch (opcode) {
            case 1: {
                ReturnStatement ret = NodeBuilder.newReturnStatement(((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr));
                int numOps = LLVM.LLVMGetNumOperands((LLVMValueRef)instr);
                if (numOps != 0) {
                    ret.setReturnValue(((LLVMIRLanguageFrontend)this.lang).getOperandValueAtIndex(instr, 0));
                }
                return ret;
            }
            case 2: {
                return this.handleBrStatement(instr);
            }
            case 3: {
                return this.handleSwitchStatement(instr);
            }
            case 4: {
                System.out.println((Object)"indirect br instruction");
                break;
            }
            case 5: {
                return this.handleFunctionCall(instr);
            }
            case 7: {
                return new Statement();
            }
            case 67: {
                System.out.println((Object)"call instruction");
                break;
            }
            case 66: {
                UnaryOperator fneg = NodeBuilder.newUnaryOperator("-", false, true, ((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr));
                fneg.setInput(((LLVMIRLanguageFrontend)this.lang).getOperandValueAtIndex(instr, 0));
                return fneg;
            }
            case 8: {
                return StatementHandler.handleBinaryOperator$default(this, instr, "+", false, false, 8, null);
            }
            case 9: {
                return StatementHandler.handleBinaryOperator$default(this, instr, "+", false, false, 8, null);
            }
            case 10: {
                return StatementHandler.handleBinaryOperator$default(this, instr, "-", false, false, 8, null);
            }
            case 11: {
                return StatementHandler.handleBinaryOperator$default(this, instr, "-", false, false, 8, null);
            }
            case 12: {
                return StatementHandler.handleBinaryOperator$default(this, instr, "*", false, false, 8, null);
            }
            case 13: {
                return StatementHandler.handleBinaryOperator$default(this, instr, "*", false, false, 8, null);
            }
            case 14: {
                return StatementHandler.handleBinaryOperator$default(this, instr, "+", true, false, 8, null);
            }
            case 15: {
                return StatementHandler.handleBinaryOperator$default(this, instr, "/", false, false, 8, null);
            }
            case 16: {
                return StatementHandler.handleBinaryOperator$default(this, instr, "/", false, false, 8, null);
            }
            case 17: {
                return StatementHandler.handleBinaryOperator$default(this, instr, "%", true, false, 8, null);
            }
            case 18: {
                return StatementHandler.handleBinaryOperator$default(this, instr, "%", false, false, 8, null);
            }
            case 19: {
                return StatementHandler.handleBinaryOperator$default(this, instr, "%", false, false, 8, null);
            }
            case 20: {
                return StatementHandler.handleBinaryOperator$default(this, instr, "<<", false, false, 8, null);
            }
            case 21: {
                return StatementHandler.handleBinaryOperator$default(this, instr, ">>", true, false, 8, null);
            }
            case 22: {
                return StatementHandler.handleBinaryOperator$default(this, instr, ">>", false, false, 8, null);
            }
            case 23: {
                return StatementHandler.handleBinaryOperator$default(this, instr, "&", false, false, 8, null);
            }
            case 24: {
                return StatementHandler.handleBinaryOperator$default(this, instr, "|", false, false, 8, null);
            }
            case 25: {
                return StatementHandler.handleBinaryOperator$default(this, instr, "^", false, false, 8, null);
            }
            case 26: {
                return this.handleAlloca(instr);
            }
            case 27: {
                return this.handleLoad(instr);
            }
            case 28: {
                return this.handleStore(instr);
            }
            case 29: {
                return this.declarationOrNot(((LLVMIRLanguageFrontend)this.lang).getExpressionHandler().handleGetElementPtr$cpg_library(instr), instr);
            }
            case 30: {
                System.out.println((Object)"trunc instruction");
                break;
            }
            case 31: {
                System.out.println((Object)"zext instruction");
                break;
            }
            case 32: {
                System.out.println((Object)"sext instruction");
                break;
            }
            case 33: {
                System.out.println((Object)"fptoui instruction");
                break;
            }
            case 34: {
                System.out.println((Object)"fptosi instruction");
                break;
            }
            case 35: {
                System.out.println((Object)"uitofp instruction");
                break;
            }
            case 36: {
                System.out.println((Object)"sitofp instruction");
                break;
            }
            case 37: {
                System.out.println((Object)"fptrunc instruction");
                break;
            }
            case 38: {
                System.out.println((Object)"fpext instruction");
                break;
            }
            case 39: {
                System.out.println((Object)"ptrtoint instruction");
                break;
            }
            case 40: {
                System.out.println((Object)"inttoptr instruction");
                break;
            }
            case 41: {
                System.out.println((Object)"bitcast instruction");
                break;
            }
            case 60: {
                System.out.println((Object)"addrspacecast instruction");
                break;
            }
            case 42: {
                return this.handleIntegerComparison(instr);
            }
            case 43: {
                return this.handleFloatComparison(instr);
            }
            case 44: {
                System.out.println((Object)"phi instruction");
                break;
            }
            case 45: {
                return this.handleFunctionCall(instr);
            }
            case 46: {
                return this.declarationOrNot(((LLVMIRLanguageFrontend)this.lang).getExpressionHandler().handleSelect(instr), instr);
            }
            case 47: {
                System.out.println((Object)"userop1 instruction");
                break;
            }
            case 48: {
                System.out.println((Object)"userop2 instruction");
                break;
            }
            case 49: {
                System.out.println((Object)"va_arg instruction");
                break;
            }
            case 50: {
                System.out.println((Object)"extractelement instruction");
                break;
            }
            case 51: {
                System.out.println((Object)"insertelement instruction");
                break;
            }
            case 52: {
                System.out.println((Object)"shufflevector instruction");
                break;
            }
            case 53: {
                return this.declarationOrNot(((LLVMIRLanguageFrontend)this.lang).getExpressionHandler().handleGetElementPtr$cpg_library(instr), instr);
            }
            case 54: {
                return this.handleInsertValue(instr);
            }
            case 68: {
                System.out.println((Object)"freeze instruction");
                break;
            }
            case 55: {
                System.out.println((Object)"fence instruction");
                break;
            }
            case 56: {
                return this.handleAtomiccmpxchg(instr);
            }
            case 57: {
                return this.handleAtomicrmw(instr);
            }
            case 58: {
                System.out.println((Object)"resume instruction");
                break;
            }
            case 59: {
                System.out.println((Object)"landingpad instruction");
                break;
            }
            case 61: {
                System.out.println((Object)"cleanupret instruction");
                break;
            }
            case 62: {
                System.out.println((Object)"catchret instruction");
                break;
            }
            case 63: {
                System.out.println((Object)"catchpad instruction");
                break;
            }
            case 64: {
                System.out.println((Object)"cleanuppad instruction");
                break;
            }
            case 65: {
                System.out.println((Object)"catchswitch instruction");
            }
        }
        Handler.log.error("Not handling instruction opcode {} yet", (Object)opcode);
        return new Statement();
    }

    private final Statement handleAlloca(LLVMValueRef instr) {
        ArrayCreationExpression array = NodeBuilder.newArrayCreationExpression(((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr));
        array.setType(((LLVMIRLanguageFrontend)this.lang).typeOf(instr));
        Expression size = ((LLVMIRLanguageFrontend)this.lang).getOperandValueAtIndex(instr, 0);
        array.addDimension(size);
        return this.declarationOrNot(array, instr);
    }

    private final Statement handleStore(LLVMValueRef instr) {
        BinaryOperator binOp = NodeBuilder.newBinaryOperator("=", ((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr));
        UnaryOperator dereference = NodeBuilder.newUnaryOperator("*", false, true, "");
        dereference.setInput(((LLVMIRLanguageFrontend)this.lang).getOperandValueAtIndex(instr, 1));
        binOp.setLhs(dereference);
        binOp.setRhs(((LLVMIRLanguageFrontend)this.lang).getOperandValueAtIndex(instr, 0));
        return binOp;
    }

    private final Statement handleLoad(LLVMValueRef instr) {
        UnaryOperator ref = NodeBuilder.newUnaryOperator("*", false, true, "");
        ref.setInput(((LLVMIRLanguageFrontend)this.lang).getOperandValueAtIndex(instr, 0));
        return this.declarationOrNot(ref, instr);
    }

    private final Statement handleIntegerComparison(LLVMValueRef instr) {
        String string;
        boolean unsigned = false;
        switch (LLVM.LLVMGetICmpPredicate((LLVMValueRef)instr)) {
            case 32: {
                string = "==";
                break;
            }
            case 33: {
                string = "!=";
                break;
            }
            case 34: {
                unsigned = true;
                string = ">";
                break;
            }
            case 35: {
                unsigned = true;
                string = ">=";
                break;
            }
            case 36: {
                unsigned = true;
                string = "<";
                break;
            }
            case 37: {
                unsigned = true;
                string = "<=";
                break;
            }
            case 38: {
                string = ">";
                break;
            }
            case 39: {
                string = ">=";
                break;
            }
            case 40: {
                string = "<";
                break;
            }
            case 41: {
                string = "<=";
                break;
            }
            default: {
                string = "unknown";
            }
        }
        String cmpPred = string;
        return StatementHandler.handleBinaryOperator$default(this, instr, cmpPred, unsigned, false, 8, null);
    }

    private final Statement handleFloatComparison(LLVMValueRef instr) {
        String string;
        boolean unordered = false;
        switch (LLVM.LLVMGetFCmpPredicate((LLVMValueRef)instr)) {
            case 0: {
                return NodeBuilder.newLiteral(false, TypeParser.createFrom("i1", true), "false");
            }
            case 1: {
                string = "==";
                break;
            }
            case 2: {
                string = ">";
                break;
            }
            case 3: {
                string = ">=";
                break;
            }
            case 4: {
                string = "<";
                break;
            }
            case 5: {
                string = "<=";
                break;
            }
            case 6: {
                string = "!=";
                break;
            }
            case 7: {
                string = "ord";
                break;
            }
            case 8: {
                string = "uno";
                break;
            }
            case 9: {
                unordered = true;
                string = "==";
                break;
            }
            case 10: {
                unordered = true;
                string = ">";
                break;
            }
            case 11: {
                unordered = true;
                string = ">=";
                break;
            }
            case 12: {
                unordered = true;
                string = "<";
                break;
            }
            case 13: {
                unordered = true;
                string = "<=";
                break;
            }
            case 14: {
                unordered = true;
                string = "!=";
                break;
            }
            case 15: {
                return NodeBuilder.newLiteral(true, TypeParser.createFrom("i1", true), "true");
            }
            default: {
                string = "unknown";
            }
        }
        String cmpPred = string;
        return this.handleBinaryOperator(instr, cmpPred, false, unordered);
    }

    private final Statement handleInsertValue(LLVMValueRef instr) {
        int numOps = LLVM.LLVMGetNumIndices((LLVMValueRef)instr);
        IntPointer indices = LLVM.LLVMGetIndices((LLVMValueRef)instr);
        LLVMIRLanguageFrontend lLVMIRLanguageFrontend = (LLVMIRLanguageFrontend)this.lang;
        LLVMValueRef lLVMValueRef = LLVM.LLVMGetOperand((LLVMValueRef)instr, (int)0);
        Intrinsics.checkNotNullExpressionValue((Object)lLVMValueRef, (String)"LLVMGetOperand(instr, 0)");
        Type baseType = lLVMIRLanguageFrontend.typeOf(lLVMValueRef);
        Expression operand = ((LLVMIRLanguageFrontend)this.lang).getOperandValueAtIndex(instr, 0);
        Expression valueToSet = ((LLVMIRLanguageFrontend)this.lang).getOperandValueAtIndex(instr, 1);
        Expression base = operand;
        Statement copy = new Statement();
        if (!(operand instanceof ConstructExpression) && (copy = this.declarationOrNot(operand, instr)) instanceof DeclarationStatement) {
            Declaration declaration = ((DeclarationStatement)copy).getSingleDeclaration();
            if (declaration == null) {
                throw new NullPointerException("null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.declarations.VariableDeclaration");
            }
            base = NodeBuilder.newDeclaredReferenceExpression(((DeclarationStatement)copy).getSingleDeclaration().getName(), ((VariableDeclaration)declaration).getType(), ((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr));
        }
        Expression expr = null;
        int n = 0;
        while (n < numOps) {
            FieldDeclaration field;
            RecordDeclaration record;
            int idx = n++;
            int index = indices.get((long)idx);
            if (base instanceof ConstructExpression) {
                if (idx == numOps - 1) {
                    ((ConstructExpression)base).setArgument(index, valueToSet);
                    return this.declarationOrNot(operand, instr);
                }
                Expression expression = ((ConstructExpression)base).getArguments().get(index);
                Intrinsics.checkNotNullExpressionValue((Object)expression, (String)"base.arguments[index]");
                base = expression;
                continue;
            }
            Type type = baseType;
            ObjectType objectType = type instanceof ObjectType ? (ObjectType)type : null;
            RecordDeclaration recordDeclaration = record = objectType == null ? null : objectType.getRecordDeclaration();
            if (record == null) {
                Handler.log.error("Could not find structure type with name {}, cannot continue", (Object)baseType.getTypeName());
                break;
            }
            Handler.log.debug("Trying to access a field within the record declaration of {}", (Object)record.getName());
            FieldDeclaration fieldDeclaration = field = record.getField(Intrinsics.stringPlus((String)"field_", (Object)index));
            Type type2 = fieldDeclaration == null ? null : fieldDeclaration.getType();
            if (type2 == null) {
                UnknownType unknownType = UnknownType.getUnknownType();
                Intrinsics.checkNotNullExpressionValue((Object)unknownType, (String)"getUnknownType()");
                type2 = unknownType;
            }
            baseType = type2;
            FieldDeclaration fieldDeclaration2 = field;
            FieldDeclaration fieldDeclaration3 = field;
            expr = NodeBuilder.newMemberExpression(base, (Type)(fieldDeclaration2 == null ? null : fieldDeclaration2.getType()), (String)(fieldDeclaration3 == null ? null : fieldDeclaration3.getName()), ".", "");
            Handler.log.info("{}", (Object)expr);
            base = expr;
        }
        CompoundStatement compoundStatement = NodeBuilder.newCompoundStatement(((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr));
        BinaryOperator assignment = NodeBuilder.newBinaryOperator("=", ((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr));
        assignment.setLhs(base);
        assignment.setRhs(valueToSet);
        compoundStatement.addStatement(copy);
        compoundStatement.addStatement(assignment);
        return compoundStatement;
    }

    private final Statement handleAtomiccmpxchg(LLVMValueRef instr) {
        String instrStr = ((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr);
        CompoundStatement compoundStatement = NodeBuilder.newCompoundStatement(instrStr);
        compoundStatement.setName("atomiccmpxchg");
        Expression ptr = ((LLVMIRLanguageFrontend)this.lang).getOperandValueAtIndex(instr, 0);
        Expression cmp = ((LLVMIRLanguageFrontend)this.lang).getOperandValueAtIndex(instr, 1);
        Expression value = ((LLVMIRLanguageFrontend)this.lang).getOperandValueAtIndex(instr, 2);
        UnaryOperator ptrDeref = NodeBuilder.newUnaryOperator("*", false, true, instrStr);
        ptrDeref.setInput(ptr);
        BinaryOperator cmpExpr = NodeBuilder.newBinaryOperator("==", instrStr);
        cmpExpr.setLhs(ptrDeref);
        cmpExpr.setRhs(cmp);
        String lhs = LLVM.LLVMGetValueName((LLVMValueRef)instr).getString();
        if (!Intrinsics.areEqual((Object)lhs, (Object)"")) {
            Type targetType = ((LLVMIRLanguageFrontend)this.lang).typeOf(instr);
            ConstructExpression construct = NodeBuilder.newConstructExpression("");
            ObjectType objectType = targetType instanceof ObjectType ? (ObjectType)targetType : null;
            construct.setInstantiates((Declaration)(objectType == null ? null : objectType.getRecordDeclaration()));
            construct.addArgument(ptrDeref);
            construct.addArgument(cmpExpr);
            Statement decl = this.declarationOrNot(construct, instr);
            compoundStatement.addStatement(decl);
        }
        BinaryOperator assignment = NodeBuilder.newBinaryOperator("=", instrStr);
        assignment.setLhs(ptrDeref);
        assignment.setRhs(value);
        IfStatement ifStatement = NodeBuilder.newIfStatement(instrStr);
        ifStatement.setCondition(cmpExpr);
        ifStatement.setThenStatement(assignment);
        compoundStatement.addStatement(ifStatement);
        return compoundStatement;
    }

    private final Statement handleAtomicrmw(LLVMValueRef instr) {
        Statement statement;
        String lhs = LLVM.LLVMGetValueName((LLVMValueRef)instr).getString();
        String instrStr = ((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr);
        int operation = LLVM.LLVMGetAtomicRMWBinOp((LLVMValueRef)instr);
        Expression ptr = ((LLVMIRLanguageFrontend)this.lang).getOperandValueAtIndex(instr, 0);
        Expression value = ((LLVMIRLanguageFrontend)this.lang).getOperandValueAtIndex(instr, 1);
        Type ty = value.getType();
        BinaryOperator exchOp = NodeBuilder.newBinaryOperator("=", instrStr);
        exchOp.setName("atomicrmw");
        UnaryOperator ptrDeref = NodeBuilder.newUnaryOperator("*", false, true, instrStr);
        ptrDeref.setInput(ptr);
        exchOp.setLhs(ptrDeref);
        switch (operation) {
            case 0: {
                exchOp.setRhs(value);
                break;
            }
            case 1: 
            case 11: {
                BinaryOperator binaryOperator = NodeBuilder.newBinaryOperator("+", instrStr);
                binaryOperator.setLhs(ptrDeref);
                binaryOperator.setRhs(value);
                exchOp.setRhs(binaryOperator);
                break;
            }
            case 2: 
            case 12: {
                BinaryOperator binaryOperator = NodeBuilder.newBinaryOperator("-", instrStr);
                binaryOperator.setLhs(ptrDeref);
                binaryOperator.setRhs(value);
                exchOp.setRhs(binaryOperator);
                break;
            }
            case 3: {
                BinaryOperator binaryOperator = NodeBuilder.newBinaryOperator("&", instrStr);
                binaryOperator.setLhs(ptrDeref);
                binaryOperator.setRhs(value);
                exchOp.setRhs(binaryOperator);
                break;
            }
            case 4: {
                BinaryOperator binaryOperator = NodeBuilder.newBinaryOperator("|", instrStr);
                binaryOperator.setLhs(ptrDeref);
                binaryOperator.setRhs(value);
                UnaryOperator unaryOperator = NodeBuilder.newUnaryOperator("~", false, true, instrStr);
                unaryOperator.setInput(binaryOperator);
                exchOp.setRhs(unaryOperator);
                break;
            }
            case 5: {
                BinaryOperator binaryOperator = NodeBuilder.newBinaryOperator("|", instrStr);
                binaryOperator.setLhs(ptrDeref);
                binaryOperator.setRhs(value);
                exchOp.setRhs(binaryOperator);
                break;
            }
            case 6: {
                BinaryOperator binaryOperator = NodeBuilder.newBinaryOperator("^", instrStr);
                binaryOperator.setLhs(ptrDeref);
                binaryOperator.setRhs(value);
                exchOp.setRhs(binaryOperator);
                break;
            }
            case 7: 
            case 8: {
                String operatorCode = operation == 8 ? "<" : ">";
                BinaryOperator condition = NodeBuilder.newBinaryOperator(operatorCode, instrStr);
                condition.setLhs(ptrDeref);
                condition.setRhs(value);
                ConditionalExpression conditional = NodeBuilder.newConditionalExpression(condition, ptrDeref, value, ty);
                exchOp.setRhs(conditional);
                break;
            }
            case 9: 
            case 10: {
                String operatorCode = operation == 10 ? "<" : ">";
                BinaryOperator condition = NodeBuilder.newBinaryOperator(operatorCode, instrStr);
                CastExpression castExprLhs = NodeBuilder.newCastExpression(((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr));
                castExprLhs.setCastType(TypeParser.createFrom(Intrinsics.stringPlus((String)"u", (Object)ty.getName()), true));
                castExprLhs.setExpression(ptrDeref);
                condition.setLhs(castExprLhs);
                CastExpression castExprRhs = NodeBuilder.newCastExpression(((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr));
                castExprRhs.setCastType(TypeParser.createFrom(Intrinsics.stringPlus((String)"u", (Object)ty.getName()), true));
                castExprRhs.setExpression(value);
                condition.setRhs(castExprRhs);
                ConditionalExpression conditional = NodeBuilder.newConditionalExpression(condition, ptrDeref, value, ty);
                exchOp.setRhs(conditional);
                break;
            }
            default: {
                throw new TranslationException("LLVMAtomicRMWBinOp " + operation + " not supported");
            }
        }
        if (!Intrinsics.areEqual((Object)lhs, (Object)"")) {
            CompoundStatement compoundStatement = NodeBuilder.newCompoundStatement(instrStr);
            Object[] objectArray = new Statement[]{this.declarationOrNot(ptrDeref, instr), exchOp};
            compoundStatement.setStatements(CollectionsKt.listOf((Object[])objectArray));
            statement = compoundStatement;
        } else {
            statement = exchOp;
        }
        return statement;
    }

    private final Statement handleBrStatement(LLVMValueRef instr) {
        if (LLVM.LLVMGetNumOperands((LLVMValueRef)instr) == 3) {
            IfStatement ifStatement = NodeBuilder.newIfStatement(((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr));
            Expression condition = ((LLVMIRLanguageFrontend)this.lang).getOperandValueAtIndex(instr, 0);
            ifStatement.setCondition(condition);
            GotoStatement elseGoto = NodeBuilder.INSTANCE.newGotoStatement(((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr));
            LLVMValueRef lLVMValueRef = LLVM.LLVMGetOperand((LLVMValueRef)instr, (int)1);
            Intrinsics.checkNotNullExpressionValue((Object)lLVMValueRef, (String)"LLVMGetOperand(instr, 1)");
            LabelStatement elseLabel = this.extractBasicBlockLabel(lLVMValueRef);
            elseGoto.setTargetLabel(elseLabel);
            elseGoto.setLabelName(elseLabel.getName());
            ifStatement.setElseStatement(elseGoto);
            GotoStatement ifGoto = NodeBuilder.INSTANCE.newGotoStatement(((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr));
            LLVMValueRef lLVMValueRef2 = LLVM.LLVMGetOperand((LLVMValueRef)instr, (int)2);
            Intrinsics.checkNotNullExpressionValue((Object)lLVMValueRef2, (String)"LLVMGetOperand(instr, 2)");
            LabelStatement thenLabelStatement = this.extractBasicBlockLabel(lLVMValueRef2);
            ifGoto.setTargetLabel(thenLabelStatement);
            ifGoto.setLabelName(thenLabelStatement.getName());
            ifStatement.setThenStatement(ifGoto);
            return ifStatement;
        }
        if (LLVM.LLVMGetNumOperands((LLVMValueRef)instr) == 1) {
            GotoStatement gotoStatement = NodeBuilder.INSTANCE.newGotoStatement(((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr));
            LLVMValueRef lLVMValueRef = LLVM.LLVMGetOperand((LLVMValueRef)instr, (int)0);
            Intrinsics.checkNotNullExpressionValue((Object)lLVMValueRef, (String)"LLVMGetOperand(instr, 0)");
            LabelStatement labelStatement = this.extractBasicBlockLabel(lLVMValueRef);
            gotoStatement.setLabelName(labelStatement.getName());
            gotoStatement.setTargetLabel(labelStatement);
            return gotoStatement;
        }
        throw new TranslationException("Wrong number of operands in br statement");
    }

    private final Statement handleSwitchStatement(LLVMValueRef instr) {
        Object caseLabelStatement;
        int numOps = LLVM.LLVMGetNumOperands((LLVMValueRef)instr);
        String nodeCode = ((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr);
        if (numOps < 2 || numOps % 2 != 0) {
            throw new TranslationException("Switch statement without operand and default branch");
        }
        Expression operand = ((LLVMIRLanguageFrontend)this.lang).getOperandValueAtIndex(instr, 0);
        SwitchStatement switchStatement = NodeBuilder.newSwitchStatement(nodeCode);
        switchStatement.selector = operand;
        CompoundStatement caseStatements = NodeBuilder.newCompoundStatement(nodeCode);
        int idx = 2;
        while (idx < numOps) {
            CaseStatement caseStatement = NodeBuilder.newCaseStatement(nodeCode);
            caseStatement.caseExpression = ((LLVMIRLanguageFrontend)this.lang).getOperandValueAtIndex(instr, idx);
            caseStatements.addStatement(caseStatement);
            int n = idx;
            idx = n + 1;
            LLVMValueRef lLVMValueRef = LLVM.LLVMGetOperand((LLVMValueRef)instr, (int)idx);
            Intrinsics.checkNotNullExpressionValue((Object)lLVMValueRef, (String)"LLVMGetOperand(instr, idx)");
            caseLabelStatement = this.extractBasicBlockLabel(lLVMValueRef);
            GotoStatement gotoStatement = NodeBuilder.INSTANCE.newGotoStatement(nodeCode);
            gotoStatement.setTargetLabel((LabelStatement)caseLabelStatement);
            gotoStatement.setLabelName(((Node)caseLabelStatement).getName());
            caseStatements.addStatement(gotoStatement);
            int n2 = idx;
            idx = n2 + 1;
        }
        caseStatements.addStatement(NodeBuilder.newDefaultStatement(nodeCode));
        caseLabelStatement = LLVM.LLVMGetOperand((LLVMValueRef)instr, (int)1);
        Intrinsics.checkNotNullExpressionValue((Object)caseLabelStatement, (String)"LLVMGetOperand(instr, 1)");
        LabelStatement defaultLabel = this.extractBasicBlockLabel((LLVMValueRef)caseLabelStatement);
        GotoStatement defaultGoto = NodeBuilder.INSTANCE.newGotoStatement(nodeCode);
        defaultGoto.setTargetLabel(defaultLabel);
        defaultGoto.setLabelName(defaultLabel.getName());
        caseStatements.addStatement(defaultGoto);
        switchStatement.setStatement(caseStatements);
        return switchStatement;
    }

    private final Statement handleFunctionCall(LLVMValueRef instr) {
        LLVMValueRef calledFunc = LLVM.LLVMGetCalledValue((LLVMValueRef)instr);
        String calledFuncName = LLVM.LLVMGetValueName((LLVMValueRef)calledFunc).getString();
        int max = LLVM.LLVMGetNumOperands((LLVMValueRef)instr) - 1;
        int idx = 0;
        if (calledFuncName.equals("")) {
            Expression opName = ((LLVMIRLanguageFrontend)this.lang).getOperandValueAtIndex(instr, max);
            calledFuncName = opName.getName();
        }
        LabelStatement catchLabel = null;
        LabelStatement continueLabel = null;
        LLVMValueRef $this$opCode$iv522222 = instr;
        boolean $i$f$getOpCode = false;
        if (LLVM.LLVMGetInstructionOpcode((LLVMValueRef)$this$opCode$iv522222) == 5) {
            int $this$opCode$iv522222 = max;
            max = $this$opCode$iv522222 + -1;
            LLVMValueRef $this$opCode$iv522222 = LLVM.LLVMGetOperand((LLVMValueRef)instr, (int)max);
            Intrinsics.checkNotNullExpressionValue((Object)$this$opCode$iv522222, (String)"LLVMGetOperand(instr, max)");
            catchLabel = this.extractBasicBlockLabel($this$opCode$iv522222);
            int $this$opCode$iv522222 = max;
            max = $this$opCode$iv522222 + -1;
            LLVMValueRef $this$opCode$iv522222 = LLVM.LLVMGetOperand((LLVMValueRef)instr, (int)max);
            Intrinsics.checkNotNullExpressionValue((Object)$this$opCode$iv522222, (String)"LLVMGetOperand(instr, max)");
            continueLabel = this.extractBasicBlockLabel($this$opCode$iv522222);
            int $this$opCode$iv522222 = max;
            max = $this$opCode$iv522222 + -1;
            Handler.log.info("Invoke expression: Usually continues at " + continueLabel.getName() + ", exception continues at " + catchLabel.getName());
        }
        CallExpression callExpr = NodeBuilder.newCallExpression(calledFuncName, calledFuncName, ((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr), false);
        while (idx < max) {
            Expression operandName = ((LLVMIRLanguageFrontend)this.lang).getOperandValueAtIndex(instr, idx);
            callExpr.addArgument(operandName);
            int n = idx;
            idx = n + 1;
        }
        return this.declarationOrNot(callExpr, instr);
    }

    private final Statement declarationOrNot(Expression rhs, LLVMValueRef valueRef) {
        Statement statement;
        LLVMValueRef $this$name$iv = valueRef;
        boolean $i$f$getName = false;
        String string = LLVM.LLVMGetValueName((LLVMValueRef)$this$name$iv).getString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"LLVMGetValueName(this).string");
        String lhs = string;
        String symbolName = LLVMIRLanguageFrontendKt.getSymbolName(valueRef);
        if (Intrinsics.areEqual((Object)lhs, (Object)"")) {
            lhs = ((LLVMIRLanguageFrontend)this.lang).guessSlotNumber(valueRef);
            symbolName = Intrinsics.stringPlus((String)"%", (Object)lhs);
        }
        if (!Intrinsics.areEqual((Object)lhs, (Object)"")) {
            VariableDeclaration decl = new VariableDeclaration();
            decl.setName(lhs);
            decl.setInitializer(rhs);
            ((LLVMIRLanguageFrontend)this.lang).getScopeManager().addDeclaration(decl);
            ((LLVMIRLanguageFrontend)this.lang).getBindingsCache().put(symbolName, decl);
            DeclarationStatement declStatement = new DeclarationStatement();
            declStatement.setSingleDeclaration(decl);
            statement = declStatement;
        } else {
            statement = rhs;
        }
        return statement;
    }

    private final CompoundStatement handleBasicBlock(LLVMBasicBlockRef bb) {
        CompoundStatement compound = NodeBuilder.newCompoundStatement("");
        LLVMValueRef instr = LLVM.LLVMGetFirstInstruction((LLVMBasicBlockRef)bb);
        while (instr != null) {
            Handler.log.debug("Parsing {}", (Object)((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr));
            Statement stmt = (Statement)((LLVMIRLanguageFrontend)this.lang).getStatementHandler().handle(instr);
            compound.addStatement(stmt);
            instr = LLVM.LLVMGetNextInstruction((LLVMValueRef)instr);
        }
        return compound;
    }

    private final Statement handleBinaryOperator(LLVMValueRef instr, String op, boolean unsigned, boolean unordered) {
        Expression declOp;
        CallExpression unorderedCall;
        Expression op1 = ((LLVMIRLanguageFrontend)this.lang).getOperandValueAtIndex(instr, 0);
        Expression op2 = ((LLVMIRLanguageFrontend)this.lang).getOperandValueAtIndex(instr, 1);
        Expression binaryOperator = null;
        BinaryOperator binOpUnordered = null;
        if (Intrinsics.areEqual((Object)op, (Object)"uno")) {
            binaryOperator = NodeBuilder.newCallExpression("isunordered", "isunordered", LLVM.LLVMPrintValueToString((LLVMValueRef)instr).getString(), false);
            ((CallExpression)binaryOperator).addArgument(op1);
            ((CallExpression)binaryOperator).addArgument(op2);
        } else if (Intrinsics.areEqual((Object)op, (Object)"ord")) {
            unorderedCall = NodeBuilder.newCallExpression("isunordered", "isunordered", LLVM.LLVMPrintValueToString((LLVMValueRef)instr).getString(), false);
            unorderedCall.addArgument(op1);
            unorderedCall.addArgument(op2);
            binaryOperator = NodeBuilder.newUnaryOperator("!", false, true, LLVM.LLVMPrintValueToString((LLVMValueRef)instr).getString());
            ((UnaryOperator)binaryOperator).setInput(unorderedCall);
        } else {
            binaryOperator = NodeBuilder.newBinaryOperator(op, ((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr));
            if (unsigned) {
                String op1Type = Intrinsics.stringPlus((String)"u", (Object)op1.getType().getTypeName());
                CastExpression castExprLhs = NodeBuilder.newCastExpression(((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr));
                castExprLhs.setCastType(TypeParser.createFrom(op1Type, true));
                castExprLhs.setExpression(op1);
                ((BinaryOperator)binaryOperator).setLhs(castExprLhs);
                String op2Type = Intrinsics.stringPlus((String)"u", (Object)op2.getType().getTypeName());
                CastExpression castExprRhs = NodeBuilder.newCastExpression(((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr));
                castExprRhs.setCastType(TypeParser.createFrom(op2Type, true));
                castExprRhs.setExpression(op2);
                ((BinaryOperator)binaryOperator).setRhs(castExprRhs);
            } else {
                ((BinaryOperator)binaryOperator).setLhs(op1);
                ((BinaryOperator)binaryOperator).setRhs(op2);
            }
            if (unordered) {
                binOpUnordered = NodeBuilder.newBinaryOperator("||", ((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr));
                binOpUnordered.setRhs(binaryOperator);
                unorderedCall = NodeBuilder.newCallExpression("isunordered", "isunordered", LLVM.LLVMPrintValueToString((LLVMValueRef)instr).getString(), false);
                unorderedCall.addArgument(op1);
                unorderedCall.addArgument(op2);
                binOpUnordered.setLhs(unorderedCall);
            }
        }
        Expression expression = declOp = unordered ? (Expression)binOpUnordered : binaryOperator;
        Intrinsics.checkNotNull((Object)expression);
        Statement decl = this.declarationOrNot(expression, instr);
        DeclarationStatement declarationStatement = decl instanceof DeclarationStatement ? (DeclarationStatement)decl : null;
        if (declarationStatement != null) {
            DeclarationStatement it = declarationStatement;
            boolean bl = false;
            Declaration declaration = ((DeclarationStatement)decl).getSingleDeclaration();
            if (declaration == null) {
                throw new NullPointerException("null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.declarations.VariableDeclaration");
            }
            ((LLVMIRLanguageFrontend)this.lang).getBindingsCache().put(LLVMIRLanguageFrontendKt.getSymbolName(instr), (VariableDeclaration)declaration);
        }
        return decl;
    }

    static /* synthetic */ Statement handleBinaryOperator$default(StatementHandler statementHandler, LLVMValueRef lLVMValueRef, String string, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 8) != 0) {
            bl2 = false;
        }
        return statementHandler.handleBinaryOperator(lLVMValueRef, string, bl, bl2);
    }

    private final LabelStatement extractBasicBlockLabel(LLVMValueRef valueRef) {
        LLVMBasicBlockRef bb = LLVM.LLVMValueAsBasicBlock((LLVMValueRef)valueRef);
        Ref.ObjectRef labelName = new Ref.ObjectRef();
        labelName.element = LLVM.LLVMGetBasicBlockName((LLVMBasicBlockRef)bb).getString();
        if (((String)labelName.element).equals("")) {
            String bbStr = LLVM.LLVMPrintValueToString((LLVMValueRef)valueRef).getString();
            Intrinsics.checkNotNullExpressionValue((Object)bbStr, (String)"bbStr");
            String[] stringArray = new String[]{"\n"};
            String firstLine = (String)StringsKt.split$default((CharSequence)((Object)StringsKt.trim((CharSequence)bbStr)).toString(), (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(0);
            String string = firstLine.substring(0, StringsKt.indexOf$default((CharSequence)firstLine, (String)":", (int)0, (boolean)false, (int)6, null));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            labelName.element = string;
        }
        LabelStatement labelStatement = ((LLVMIRLanguageFrontend)this.lang).getLabelMap().computeIfAbsent((String)labelName.element, arg_0 -> StatementHandler.extractBasicBlockLabel$lambda-3(labelName, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)labelStatement, (String)"lang.labelMap.computeIfA\u2026      label\n            }");
        LabelStatement labelStatement2 = labelStatement;
        return labelStatement2;
    }

    private static final Statement _init_$lambda-0(StatementHandler this$0, Pointer it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Pointer pointer = it;
        if (pointer == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.bytedeco.llvm.LLVM.LLVMValueRef");
        }
        return this$0.handleInstruction((LLVMValueRef)pointer);
    }

    private static final Statement _init_$lambda-1(StatementHandler this$0, Pointer it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Pointer pointer = it;
        if (pointer == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.bytedeco.llvm.LLVM.LLVMBasicBlockRef");
        }
        return this$0.handleBasicBlock((LLVMBasicBlockRef)pointer);
    }

    private static final LabelStatement extractBasicBlockLabel$lambda-3(Ref.ObjectRef $labelName, String it) {
        Intrinsics.checkNotNullParameter((Object)$labelName, (String)"$labelName");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        LabelStatement label = NodeBuilder.newLabelStatement((String)$labelName.element);
        Object object = $labelName.element;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"labelName");
        label.setName((String)object);
        return label;
    }
}

