/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.frontends.llvm;

import de.fraunhofer.aisec.cpg.TranslationConfiguration;
import de.fraunhofer.aisec.cpg.frontends.LanguageFrontend;
import de.fraunhofer.aisec.cpg.frontends.TranslationException;
import de.fraunhofer.aisec.cpg.frontends.llvm.DeclarationHandler;
import de.fraunhofer.aisec.cpg.frontends.llvm.ExpressionHandler;
import de.fraunhofer.aisec.cpg.frontends.llvm.StatementHandler;
import de.fraunhofer.aisec.cpg.graph.TypeManager;
import de.fraunhofer.aisec.cpg.graph.declarations.Declaration;
import de.fraunhofer.aisec.cpg.graph.declarations.RecordDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.TemplateDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.TranslationUnitDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.ValueDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.VariableDeclaration;
import de.fraunhofer.aisec.cpg.graph.statements.LabelStatement;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Expression;
import de.fraunhofer.aisec.cpg.graph.types.PointerType;
import de.fraunhofer.aisec.cpg.graph.types.Type;
import de.fraunhofer.aisec.cpg.graph.types.TypeParser;
import de.fraunhofer.aisec.cpg.graph.types.UnknownType;
import de.fraunhofer.aisec.cpg.passes.scopes.Scope;
import de.fraunhofer.aisec.cpg.passes.scopes.ScopeManager;
import de.fraunhofer.aisec.cpg.passes.scopes.StructureDeclarationScope;
import de.fraunhofer.aisec.cpg.passes.scopes.ValueDeclarationScope;
import de.fraunhofer.aisec.cpg.sarif.PhysicalLocation;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.llvm.LLVM.LLVMBasicBlockRef;
import org.bytedeco.llvm.LLVM.LLVMContextRef;
import org.bytedeco.llvm.LLVM.LLVMMemoryBufferRef;
import org.bytedeco.llvm.LLVM.LLVMModuleRef;
import org.bytedeco.llvm.LLVM.LLVMTypeRef;
import org.bytedeco.llvm.LLVM.LLVMValueRef;
import org.bytedeco.llvm.global.LLVM;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 H2\u00020\u0001:\u0001HB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u001d\u0010$\u001a\u0004\u0018\u00010\t\"\u0004\b\u0000\u0010%2\u0006\u0010&\u001a\u0002H%H\u0016\u00a2\u0006\u0002\u0010'J\u001d\u0010(\u001a\u0004\u0018\u00010)\"\u0004\b\u0000\u0010%2\u0006\u0010&\u001a\u0002H%H\u0016\u00a2\u0006\u0002\u0010*J\u0016\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200J\u000e\u00101\u001a\u00020\t2\u0006\u00102\u001a\u00020.J\u000e\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\tJ\u0010\u00106\u001a\u0002072\u0006\u00108\u001a\u000209H\u0016J)\u0010:\u001a\u00020;\"\u0004\b\u0000\u0010<\"\u0004\b\u0001\u0010%2\u0006\u0010=\u001a\u0002H<2\u0006\u0010\u000f\u001a\u0002H%H\u0016\u00a2\u0006\u0002\u0010>J/\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020B2\u0018\b\u0002\u0010C\u001a\u0012\u0012\u0004\u0012\u00020B0Dj\b\u0012\u0004\u0012\u00020B`EH\u0000\u00a2\u0006\u0002\bFJ\u000e\u0010G\u001a\u00020@2\u0006\u00102\u001a\u00020.R&\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001d\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u001e0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\fR\u0011\u0010 \u001a\u00020!\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#\u00a8\u0006I"}, d2={"Lde/fraunhofer/aisec/cpg/frontends/llvm/LLVMIRLanguageFrontend;", "Lde/fraunhofer/aisec/cpg/frontends/LanguageFrontend;", "config", "Lde/fraunhofer/aisec/cpg/TranslationConfiguration;", "scopeManager", "Lde/fraunhofer/aisec/cpg/passes/scopes/ScopeManager;", "(Lde/fraunhofer/aisec/cpg/TranslationConfiguration;Lde/fraunhofer/aisec/cpg/passes/scopes/ScopeManager;)V", "bindingsCache", "", "", "Lde/fraunhofer/aisec/cpg/graph/declarations/VariableDeclaration;", "getBindingsCache", "()Ljava/util/Map;", "setBindingsCache", "(Ljava/util/Map;)V", "ctx", "Lorg/bytedeco/llvm/LLVM/LLVMContextRef;", "getCtx", "()Lorg/bytedeco/llvm/LLVM/LLVMContextRef;", "setCtx", "(Lorg/bytedeco/llvm/LLVM/LLVMContextRef;)V", "declarationHandler", "Lde/fraunhofer/aisec/cpg/frontends/llvm/DeclarationHandler;", "getDeclarationHandler", "()Lde/fraunhofer/aisec/cpg/frontends/llvm/DeclarationHandler;", "expressionHandler", "Lde/fraunhofer/aisec/cpg/frontends/llvm/ExpressionHandler;", "getExpressionHandler", "()Lde/fraunhofer/aisec/cpg/frontends/llvm/ExpressionHandler;", "labelMap", "Lde/fraunhofer/aisec/cpg/graph/statements/LabelStatement;", "getLabelMap", "statementHandler", "Lde/fraunhofer/aisec/cpg/frontends/llvm/StatementHandler;", "getStatementHandler", "()Lde/fraunhofer/aisec/cpg/frontends/llvm/StatementHandler;", "getCodeFromRawNode", "T", "astNode", "(Ljava/lang/Object;)Ljava/lang/String;", "getLocationFromRawNode", "Lde/fraunhofer/aisec/cpg/sarif/PhysicalLocation;", "(Ljava/lang/Object;)Lde/fraunhofer/aisec/cpg/sarif/PhysicalLocation;", "getOperandValueAtIndex", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/Expression;", "instr", "Lorg/bytedeco/llvm/LLVM/LLVMValueRef;", "idx", "", "guessSlotNumber", "valueRef", "isKnownStructTypeName", "", "name", "parse", "Lde/fraunhofer/aisec/cpg/graph/declarations/TranslationUnitDeclaration;", "file", "Ljava/io/File;", "setComment", "", "S", "s", "(Ljava/lang/Object;Ljava/lang/Object;)V", "typeFrom", "Lde/fraunhofer/aisec/cpg/graph/types/Type;", "typeRef", "Lorg/bytedeco/llvm/LLVM/LLVMTypeRef;", "alreadyVisited", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "typeFrom$cpg_library", "typeOf", "Companion", "cpg-library"})
public final class LLVMIRLanguageFrontend
extends LanguageFrontend {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, LabelStatement> labelMap;
    @NotNull
    private final StatementHandler statementHandler;
    @NotNull
    private final DeclarationHandler declarationHandler;
    @NotNull
    private final ExpressionHandler expressionHandler;
    @Nullable
    private LLVMContextRef ctx;
    @NotNull
    private Map<String, VariableDeclaration> bindingsCache;
    @JvmField
    @NotNull
    public static List<String> LLVM_EXTENSIONS = CollectionsKt.listOf((Object)".ll");

    public LLVMIRLanguageFrontend(@NotNull TranslationConfiguration config, @Nullable ScopeManager scopeManager) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, scopeManager, "::");
        this.labelMap = new LinkedHashMap();
        this.statementHandler = new StatementHandler(this);
        this.declarationHandler = new DeclarationHandler(this);
        this.expressionHandler = new ExpressionHandler(this);
        this.bindingsCache = new LinkedHashMap();
    }

    @NotNull
    public final Map<String, LabelStatement> getLabelMap() {
        return this.labelMap;
    }

    @NotNull
    public final StatementHandler getStatementHandler() {
        return this.statementHandler;
    }

    @NotNull
    public final DeclarationHandler getDeclarationHandler() {
        return this.declarationHandler;
    }

    @NotNull
    public final ExpressionHandler getExpressionHandler() {
        return this.expressionHandler;
    }

    @Nullable
    public final LLVMContextRef getCtx() {
        return this.ctx;
    }

    public final void setCtx(@Nullable LLVMContextRef lLVMContextRef) {
        this.ctx = lLVMContextRef;
    }

    @NotNull
    public final Map<String, VariableDeclaration> getBindingsCache() {
        return this.bindingsCache;
    }

    public final void setBindingsCache(@NotNull Map<String, VariableDeclaration> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.bindingsCache = map;
    }

    @Override
    @NotNull
    public TranslationUnitDeclaration parse(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.bindingsCache.clear();
        TypeManager.getInstance().setLanguageFrontend(this);
        LLVMModuleRef mod = new LLVMModuleRef();
        LLVMMemoryBufferRef buf = new LLVMMemoryBufferRef();
        this.ctx = LLVM.LLVMContextCreate();
        ByteBuffer errorMessage = ByteBuffer.allocate(10000);
        int result = LLVM.LLVMCreateMemoryBufferWithContentsOfFile((BytePointer)new BytePointer(((Object)file.toPath()).toString()), (LLVMMemoryBufferRef)buf, (ByteBuffer)errorMessage);
        if (result != 0) {
            byte[] byArray = errorMessage.array();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"errorMessage.array()");
            String errorMsg = new String(byArray, Charsets.UTF_8);
            LLVM.LLVMContextDispose((LLVMContextRef)this.ctx);
            throw new TranslationException(Intrinsics.stringPlus((String)"Could not create memory buffer: ", (Object)errorMsg));
        }
        result = LLVM.LLVMParseIRInContext((LLVMContextRef)this.ctx, (LLVMMemoryBufferRef)buf, (LLVMModuleRef)mod, (ByteBuffer)errorMessage);
        if (result != 0) {
            byte[] byArray = errorMessage.array();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"errorMessage.array()");
            String errorMsg = new String(byArray, Charsets.UTF_8);
            LLVM.LLVMContextDispose((LLVMContextRef)this.ctx);
            throw new TranslationException(Intrinsics.stringPlus((String)"Could not parse IR: ", (Object)errorMsg));
        }
        TranslationUnitDeclaration tu = new TranslationUnitDeclaration();
        this.scopeManager.resetToGlobal(tu);
        LLVMValueRef global = LLVM.LLVMGetFirstGlobal((LLVMModuleRef)mod);
        while (global != null) {
            Declaration declaration = (Declaration)this.declarationHandler.handle(global);
            this.scopeManager.addDeclaration(declaration);
            global = LLVM.LLVMGetNextGlobal((LLVMValueRef)global);
        }
        LLVMValueRef func = LLVM.LLVMGetFirstFunction((LLVMModuleRef)mod);
        while (func != null) {
            Declaration declaration = (Declaration)this.declarationHandler.handle(func);
            this.scopeManager.addDeclaration(declaration);
            func = LLVM.LLVMGetNextFunction((LLVMValueRef)func);
        }
        LLVM.LLVMContextDispose((LLVMContextRef)this.ctx);
        return tu;
    }

    @NotNull
    public final Type typeOf(@NotNull LLVMValueRef valueRef) {
        Intrinsics.checkNotNullParameter((Object)valueRef, (String)"valueRef");
        LLVMTypeRef typeRef = LLVM.LLVMTypeOf((LLVMValueRef)valueRef);
        Intrinsics.checkNotNullExpressionValue((Object)typeRef, (String)"typeRef");
        return LLVMIRLanguageFrontend.typeFrom$cpg_library$default(this, typeRef, null, 2, null);
    }

    @NotNull
    public final Type typeFrom$cpg_library(@NotNull LLVMTypeRef typeRef, @NotNull ArrayList<LLVMTypeRef> alreadyVisited) {
        Intrinsics.checkNotNullParameter((Object)typeRef, (String)"typeRef");
        Intrinsics.checkNotNullParameter(alreadyVisited, (String)"alreadyVisited");
        if (alreadyVisited.contains(typeRef)) {
            Type type = TypeParser.createFrom(LLVM.LLVMPrintTypeToString((LLVMTypeRef)typeRef).getString(), false);
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"createFrom(LLVMPrintType\u2026g(typeRef).string, false)");
            return type;
        }
        alreadyVisited.add(typeRef);
        switch (LLVM.LLVMGetTypeKind((LLVMTypeRef)typeRef)) {
            case 11: {
                Object object = LLVM.LLVMGetElementType((LLVMTypeRef)typeRef);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"LLVMGetElementType(typeRef)");
                Type elementType = this.typeFrom$cpg_library((LLVMTypeRef)object, alreadyVisited);
                object = elementType.reference(PointerType.PointerOrigin.ARRAY);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"elementType.reference(Po\u2026Type.PointerOrigin.ARRAY)");
                return object;
            }
            case 12: {
                Object object = LLVM.LLVMGetElementType((LLVMTypeRef)typeRef);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"LLVMGetElementType(typeRef)");
                Type elementType = this.typeFrom$cpg_library((LLVMTypeRef)object, alreadyVisited);
                object = elementType.reference(PointerType.PointerOrigin.POINTER);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"elementType.reference(Po\u2026pe.PointerOrigin.POINTER)");
                return object;
            }
            case 10: {
                RecordDeclaration record = this.declarationHandler.handleStructureType(typeRef, alreadyVisited);
                Type type = record.toType();
                if (type == null) {
                    UnknownType unknownType = UnknownType.getUnknownType();
                    Intrinsics.checkNotNullExpressionValue((Object)unknownType, (String)"getUnknownType()");
                    type = unknownType;
                }
                return type;
            }
        }
        String typeStr = LLVM.LLVMPrintTypeToString((LLVMTypeRef)typeRef).getString();
        Type type = TypeParser.createFrom(typeStr, false);
        Intrinsics.checkNotNullExpressionValue((Object)type, (String)"createFrom(typeStr, false)");
        return type;
    }

    public static /* synthetic */ Type typeFrom$cpg_library$default(LLVMIRLanguageFrontend lLVMIRLanguageFrontend, LLVMTypeRef lLVMTypeRef, ArrayList arrayList, int n, Object object) {
        if ((n & 2) != 0) {
            arrayList = new ArrayList<LLVMTypeRef>();
        }
        return lLVMIRLanguageFrontend.typeFrom$cpg_library(lLVMTypeRef, arrayList);
    }

    @Override
    @Nullable
    public <T> String getCodeFromRawNode(T astNode) {
        if (astNode instanceof LLVMValueRef) {
            BytePointer code = LLVM.LLVMPrintValueToString((LLVMValueRef)((LLVMValueRef)astNode));
            return code.getString();
        }
        if (astNode instanceof LLVMBasicBlockRef) {
            return this.getCodeFromRawNode(LLVM.LLVMBasicBlockAsValue((LLVMBasicBlockRef)((LLVMBasicBlockRef)astNode)));
        }
        return null;
    }

    @Override
    @Nullable
    public <T> PhysicalLocation getLocationFromRawNode(T astNode) {
        return null;
    }

    @Override
    public <S, T> void setComment(S s, T ctx) {
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isKnownStructTypeName(@NotNull String name) {
        List list;
        block11: {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            ScopeManager scopeManager = this.scopeManager;
            Scope scope = this.scopeManager.getGlobalScope();
            boolean stopIfFound$iv = true;
            boolean $i$f$resolve = false;
            List declarations$iv = new ArrayList();
            for (Scope scope$iv = searchScope$iv; scope$iv != null; scope$iv = scope$iv.getParent()) {
                boolean bl;
                RecordDeclaration it;
                Iterable destination$iv$iv$iv;
                if (scope$iv instanceof ValueDeclarationScope) {
                    void $this$filterTo$iv$iv$iv;
                    void $this$filter$iv$iv;
                    void $this$filterIsInstanceTo$iv$iv$iv;
                    Iterable $this$filterIsInstance$iv$iv;
                    Iterable<ValueDeclaration> iterable = ((ValueDeclarationScope)scope$iv).getValueDeclarations();
                    Intrinsics.checkNotNullExpressionValue(iterable, (String)"scope.valueDeclarations");
                    iterable = iterable;
                    List list2 = declarations$iv;
                    boolean $i$f$filterIsInstance = false;
                    void var11_12 = $this$filterIsInstance$iv$iv;
                    destination$iv$iv$iv = new ArrayList();
                    boolean $i$f$filterIsInstanceTo = false;
                    for (Iterator element$iv$iv$iv : $this$filterIsInstanceTo$iv$iv$iv) {
                        if (!(element$iv$iv$iv instanceof RecordDeclaration)) continue;
                        destination$iv$iv$iv.add(element$iv$iv$iv);
                    }
                    $this$filterIsInstance$iv$iv = (List)destination$iv$iv$iv;
                    boolean $i$f$filter = false;
                    $this$filterIsInstanceTo$iv$iv$iv = $this$filter$iv$iv;
                    destination$iv$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Iterator element$iv$iv$iv : $this$filterTo$iv$iv$iv) {
                        it = (RecordDeclaration)((Object)element$iv$iv$iv);
                        bl = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)name)) continue;
                        destination$iv$iv$iv.add(element$iv$iv$iv);
                    }
                    list2.addAll((List)destination$iv$iv$iv);
                }
                if (scope$iv instanceof StructureDeclarationScope) {
                    List<TemplateDeclaration> $this$filterTo$iv$iv$iv;
                    void $this$filter$iv$iv;
                    void $this$filterIsInstanceTo$iv$iv$iv;
                    Iterator element$iv$iv$iv;
                    List<Declaration> $i$f$filter = ((StructureDeclarationScope)scope$iv).getStructureDeclarations();
                    Intrinsics.checkNotNullExpressionValue($i$f$filter, (String)"scope.structureDeclarations");
                    Iterable $this$filterIsInstance$iv$iv = $i$f$filter;
                    boolean $i$f$filterIsInstance = false;
                    destination$iv$iv$iv = $this$filterIsInstance$iv$iv;
                    Collection destination$iv$iv$iv2 = new ArrayList();
                    boolean $i$f$filterIsInstanceTo = false;
                    for (Object element$iv$iv$iv2 : $this$filterIsInstanceTo$iv$iv$iv) {
                        if (!(element$iv$iv$iv2 instanceof RecordDeclaration)) continue;
                        destination$iv$iv$iv2.add(element$iv$iv$iv2);
                    }
                    $this$filterIsInstance$iv$iv = (List)destination$iv$iv$iv2;
                    boolean $i$f$filter2 = false;
                    $this$filterIsInstanceTo$iv$iv$iv = $this$filter$iv$iv;
                    destination$iv$iv$iv2 = new ArrayList();
                    boolean $i$f$filterTo2 = false;
                    element$iv$iv$iv = $this$filterTo$iv$iv$iv.iterator();
                    while (element$iv$iv$iv.hasNext()) {
                        Object element$iv$iv$iv2;
                        element$iv$iv$iv2 = element$iv$iv$iv.next();
                        it = (RecordDeclaration)element$iv$iv$iv2;
                        bl = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)name)) continue;
                        destination$iv$iv$iv2.add(element$iv$iv$iv2);
                    }
                    List list$iv = (List)destination$iv$iv$iv2;
                    if (list$iv.isEmpty()) {
                        for (Declaration declaration$iv : ((StructureDeclarationScope)scope$iv).getStructureDeclarations()) {
                            void $this$filterTo$iv$iv$iv2;
                            void $this$filter$iv$iv2;
                            void $this$filterIsInstanceTo$iv$iv$iv2;
                            if (!(declaration$iv instanceof RecordDeclaration)) continue;
                            $this$filterTo$iv$iv$iv = ((RecordDeclaration)declaration$iv).getTemplates();
                            Intrinsics.checkNotNullExpressionValue($this$filterTo$iv$iv$iv, (String)"declaration.templates");
                            Iterable $this$filterIsInstance$iv$iv2 = $this$filterTo$iv$iv$iv;
                            boolean $i$f$filterIsInstance2 = false;
                            Iterable $i$f$filterTo2 = $this$filterIsInstance$iv$iv2;
                            Collection destination$iv$iv$iv3 = new ArrayList();
                            boolean $i$f$filterIsInstanceTo2 = false;
                            for (Object element$iv$iv$iv3 : $this$filterIsInstanceTo$iv$iv$iv2) {
                                if (!(element$iv$iv$iv3 instanceof RecordDeclaration)) continue;
                                destination$iv$iv$iv3.add(element$iv$iv$iv3);
                            }
                            $this$filterIsInstance$iv$iv2 = (List)destination$iv$iv$iv3;
                            boolean $i$f$filter3 = false;
                            $this$filterIsInstanceTo$iv$iv$iv2 = $this$filter$iv$iv2;
                            destination$iv$iv$iv3 = new ArrayList();
                            boolean $i$f$filterTo3 = false;
                            for (Object element$iv$iv$iv3 : $this$filterTo$iv$iv$iv2) {
                                it = (RecordDeclaration)element$iv$iv$iv3;
                                bl = false;
                                if (!Intrinsics.areEqual((Object)it.getName(), (Object)name)) continue;
                                destination$iv$iv$iv3.add(element$iv$iv$iv3);
                            }
                            list$iv = (List)destination$iv$iv$iv3;
                        }
                    }
                    declarations$iv.addAll(list$iv);
                }
                if (!(!((Collection)declarations$iv).isEmpty())) continue;
                list = declarations$iv;
                break block11;
            }
            list = declarations$iv;
        }
        return !((Collection)list).isEmpty();
    }

    @NotNull
    public final Expression getOperandValueAtIndex(@NotNull LLVMValueRef instr, int idx) {
        Intrinsics.checkNotNullParameter((Object)instr, (String)"instr");
        LLVMValueRef operand = LLVM.LLVMGetOperand((LLVMValueRef)instr, (int)idx);
        Object s = this.expressionHandler.handle(operand);
        if (s == null) {
            throw new NullPointerException("null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.statements.expressions.Expression");
        }
        return (Expression)s;
    }

    @NotNull
    public final String guessSlotNumber(@NotNull LLVMValueRef valueRef) {
        String string;
        String code;
        Intrinsics.checkNotNullParameter((Object)valueRef, (String)"valueRef");
        String string2 = code = this.getCodeFromRawNode(valueRef);
        if (string2 == null) {
            string = "";
        } else {
            Object object = new String[]{"="};
            List list = StringsKt.split$default((CharSequence)string2, (String[])object, (boolean)false, (int)0, (int)6, null);
            if (list == null) {
                string = "";
            } else {
                object = (String)CollectionsKt.firstOrNull((List)list);
                if (object == null) {
                    string = "";
                } else {
                    String string3 = ((Object)StringsKt.trim((CharSequence)((CharSequence)object))).toString();
                    if (string3 == null) {
                        string = "";
                    } else {
                        char[] cArray = new char[]{'%'};
                        string = StringsKt.trim((String)string3, (char[])cArray);
                        if (string == null) {
                            string = "";
                        }
                    }
                }
            }
        }
        return string;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lde/fraunhofer/aisec/cpg/frontends/llvm/LLVMIRLanguageFrontend$Companion;", "", "()V", "LLVM_EXTENSIONS", "", "", "cpg-library"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

