/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.frontends.llvm;

import de.fraunhofer.aisec.cpg.frontends.Handler;
import de.fraunhofer.aisec.cpg.frontends.LanguageFrontend;
import de.fraunhofer.aisec.cpg.frontends.llvm.LLVMIRLanguageFrontend;
import de.fraunhofer.aisec.cpg.frontends.llvm.LLVMIRLanguageFrontendKt;
import de.fraunhofer.aisec.cpg.graph.NodeBuilder;
import de.fraunhofer.aisec.cpg.graph.declarations.Declaration;
import de.fraunhofer.aisec.cpg.graph.declarations.FieldDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.RecordDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.VariableDeclaration;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.ArraySubscriptionExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.ConditionalExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.ConstructExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.DeclaredReferenceExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Expression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.InitializerListExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Literal;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.UnaryOperator;
import de.fraunhofer.aisec.cpg.graph.types.ObjectType;
import de.fraunhofer.aisec.cpg.graph.types.PointerType;
import de.fraunhofer.aisec.cpg.graph.types.Type;
import de.fraunhofer.aisec.cpg.graph.types.UnknownType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.SizeTPointer;
import org.bytedeco.llvm.LLVM.LLVMTypeRef;
import org.bytedeco.llvm.LLVM.LLVMValueRef;
import org.bytedeco.llvm.global.LLVM;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0003H\u0002J\u0010\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0003H\u0002J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\b\u001a\u00020\u0003H\u0002J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\f2\u0006\u0010\b\u001a\u00020\u0003H\u0002J\u0010\u0010\u0010\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0003H\u0002J\u0015\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b\u0013J\u0010\u0010\u0014\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0003H\u0002J\u0010\u0010\u0015\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0003H\u0002J\u000e\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0003J\u0010\u0010\u0017\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0003H\u0002J\u0018\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002\u00a8\u0006\u001e"}, d2={"Lde/fraunhofer/aisec/cpg/frontends/llvm/ExpressionHandler;", "Lde/fraunhofer/aisec/cpg/frontends/Handler;", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/Expression;", "Lorg/bytedeco/llvm/LLVM/LLVMValueRef;", "Lde/fraunhofer/aisec/cpg/frontends/llvm/LLVMIRLanguageFrontend;", "lang", "(Lde/fraunhofer/aisec/cpg/frontends/llvm/LLVMIRLanguageFrontend;)V", "handleConstantDataArrayValue", "valueRef", "handleConstantExprValueKind", "value", "handleConstantFP", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/Literal;", "", "handleConstantInt", "", "handleConstantStructValue", "handleGetElementPtr", "instr", "handleGetElementPtr$cpg_library", "handleNullPointer", "handleReference", "handleSelect", "handleValue", "initializeAsUndef", "type", "Lde/fraunhofer/aisec/cpg/graph/types/Type;", "code", "", "initializeAsZero", "cpg-library"})
public final class ExpressionHandler
extends Handler<Expression, LLVMValueRef, LLVMIRLanguageFrontend> {
    public ExpressionHandler(@NotNull LLVMIRLanguageFrontend lang) {
        Intrinsics.checkNotNullParameter((Object)lang, (String)"lang");
        super(Expression::new, (LanguageFrontend)lang);
        this.map.put(LLVMValueRef.class, arg_0 -> ExpressionHandler._init_$lambda-0(this, arg_0));
    }

    private final Expression handleValue(LLVMValueRef value) {
        Expression expression;
        int kind = LLVM.LLVMGetValueKind((LLVMValueRef)value);
        switch (kind) {
            case 10: {
                expression = this.handleConstantExprValueKind(value);
                break;
            }
            case 12: {
                expression = this.handleConstantStructValue(value);
                break;
            }
            case 16: {
                expression = this.handleConstantDataArrayValue(value);
                break;
            }
            case 18: {
                expression = this.handleConstantInt(value);
                break;
            }
            case 19: {
                expression = this.handleConstantFP(value);
                break;
            }
            case 20: {
                expression = this.handleNullPointer(value);
                break;
            }
            case 14: {
                Type type = ((LLVMIRLanguageFrontend)this.lang).typeOf(value);
                String string = ((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(value);
                Intrinsics.checkNotNull((Object)string);
                expression = this.initializeAsUndef(type, string);
                break;
            }
            case 15: {
                Type type = ((LLVMIRLanguageFrontend)this.lang).typeOf(value);
                String string = ((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(value);
                Intrinsics.checkNotNull((Object)string);
                expression = this.initializeAsZero(type, string);
                break;
            }
            case 0: 
            case 8: 
            case 24: {
                expression = this.handleReference(value);
                break;
            }
            default: {
                Handler.log.info("Not handling value kind {} in handleValue yet. Falling back to the legacy way. Please change", (Object)kind);
                Type cpgType = ((LLVMIRLanguageFrontend)this.lang).typeOf(value);
                String operandName = null;
                cpgType.getTypeName();
                if (LLVM.LLVMIsConstant((LLVMValueRef)value) == 1) {
                    if (LLVM.LLVMIsAGlobalAlias((LLVMValueRef)value) != null || LLVM.LLVMIsGlobalConstant((LLVMValueRef)value) == 1) {
                        LLVMValueRef aliasee = LLVM.LLVMAliasGetAliasee((LLVMValueRef)value);
                        String string = LLVM.LLVMPrintValueToString((LLVMValueRef)aliasee).getString();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"LLVMPrintValueToString(a\u2026                  .string");
                        operandName = string;
                        return NodeBuilder.newLiteral(operandName, cpgType, operandName);
                    }
                    return NodeBuilder.newLiteral(LLVM.LLVMPrintValueToString((LLVMValueRef)value).toString(), cpgType, LLVM.LLVMPrintValueToString((LLVMValueRef)value).toString());
                }
                if (LLVM.LLVMIsUndef((LLVMValueRef)value) == 1) {
                    return NodeBuilder.newDeclaredReferenceExpression("undef", cpgType, "undef");
                }
                if (LLVM.LLVMIsPoison((LLVMValueRef)value) == 1) {
                    return NodeBuilder.newDeclaredReferenceExpression("poison", cpgType, "poison");
                }
                Handler.log.error("Unknown expression");
                return new Expression();
            }
        }
        return expression;
    }

    private final Expression handleReference(LLVMValueRef valueRef) {
        LLVMValueRef $this$name$iv = valueRef;
        boolean $i$f$getName = false;
        String string = LLVM.LLVMGetValueName((LLVMValueRef)$this$name$iv).getString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"LLVMGetValueName(this).string");
        String name = string;
        String symbolName = LLVMIRLanguageFrontendKt.getSymbolName(valueRef);
        if (Intrinsics.areEqual((Object)name, (Object)"")) {
            name = ((LLVMIRLanguageFrontend)this.lang).guessSlotNumber(valueRef);
            symbolName = Intrinsics.stringPlus((String)"%", (Object)name);
        }
        Type type = ((LLVMIRLanguageFrontend)this.lang).typeOf(valueRef);
        DeclaredReferenceExpression ref = NodeBuilder.newDeclaredReferenceExpression(name, type, type.getTypeName() + ' ' + name);
        VariableDeclaration decl = ((LLVMIRLanguageFrontend)this.lang).getBindingsCache().get(symbolName);
        if (decl == null) {
            Handler.log.warn("Could not resolve reference " + symbolName + ". This should not happen.");
        } else {
            ref.setRefersTo(decl);
        }
        return ref;
    }

    private final Literal<Long> handleConstantInt(LLVMValueRef valueRef) {
        Type type = ((LLVMIRLanguageFrontend)this.lang).typeOf(valueRef);
        String string = type.getTypeName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"type.typeName");
        long value = StringsKt.startsWith$default((String)string, (String)"ui", (boolean)false, (int)2, null) ? LLVM.LLVMConstIntGetZExtValue((LLVMValueRef)valueRef) : LLVM.LLVMConstIntGetSExtValue((LLVMValueRef)valueRef);
        return NodeBuilder.newLiteral(value, type, String.valueOf(value));
    }

    private final Literal<Double> handleConstantFP(LLVMValueRef valueRef) {
        int[] losesInfo = new int[1];
        double value = LLVM.LLVMConstRealGetDouble((LLVMValueRef)valueRef, (int[])losesInfo);
        return NodeBuilder.newLiteral(value, ((LLVMIRLanguageFrontend)this.lang).typeOf(valueRef), String.valueOf(value));
    }

    private final Expression handleConstantExprValueKind(LLVMValueRef value) {
        Expression expression;
        int kind = LLVM.LLVMGetConstOpcode((LLVMValueRef)value);
        switch (kind) {
            case 29: {
                expression = this.handleGetElementPtr$cpg_library(value);
                break;
            }
            case 46: {
                expression = this.handleSelect(value);
                break;
            }
            default: {
                Handler.log.error("Not handling constant expression of opcode {} yet", (Object)kind);
                expression = new Expression();
            }
        }
        Expression expr = expression;
        return expr;
    }

    private final Expression handleConstantStructValue(LLVMValueRef value) {
        Type type = ((LLVMIRLanguageFrontend)this.lang).typeOf(value);
        ConstructExpression expr = NodeBuilder.newConstructExpression(((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(value));
        ObjectType objectType = type instanceof ObjectType ? (ObjectType)type : null;
        expr.setInstantiates((Declaration)(objectType == null ? null : objectType.getRecordDeclaration()));
        int n = 0;
        int n2 = LLVM.LLVMGetNumOperands((LLVMValueRef)value);
        while (n < n2) {
            int i;
            Object s;
            Expression arg = (s = this.handle(LLVM.LLVMGetOperand((LLVMValueRef)value, (int)(i = n++)))) instanceof Expression ? (Expression)s : null;
            expr.addArgument(arg);
        }
        return expr;
    }

    private final Expression handleConstantDataArrayValue(LLVMValueRef valueRef) {
        if (LLVM.LLVMIsConstantString((LLVMValueRef)valueRef) == 1) {
            String string = LLVM.LLVMGetAsString((LLVMValueRef)valueRef, (SizeTPointer)new SizeTPointer(0L)).getString();
            Literal<String> literal = NodeBuilder.newLiteral(string, ((LLVMIRLanguageFrontend)this.lang).typeOf(valueRef), ((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(valueRef));
            return literal;
        }
        InitializerListExpression list = NodeBuilder.newInitializerListExpression(((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(valueRef));
        LLVMTypeRef arrayType = LLVM.LLVMTypeOf((LLVMValueRef)valueRef);
        int length = LLVM.LLVMGetArrayLength((LLVMTypeRef)arrayType);
        List initializers = new ArrayList();
        int n = 0;
        while (n < length) {
            int i = n++;
            Object s = this.handle(LLVM.LLVMGetElementAsConstant((LLVMValueRef)valueRef, (int)i));
            if (s == null) {
                throw new NullPointerException("null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.statements.expressions.Expression");
            }
            Expression expr = (Expression)s;
            ((Collection)initializers).add(expr);
        }
        list.setInitializers(initializers);
        return list;
    }

    private final Expression initializeAsUndef(Type type, String code) {
        if (!((LLVMIRLanguageFrontend)this.lang).isKnownStructTypeName(type.getName()) && !StringsKt.contains$default((CharSequence)type.getName(), (CharSequence)"{", (boolean)false, (int)2, null)) {
            return NodeBuilder.newLiteral(null, type, code);
        }
        ConstructExpression expr = NodeBuilder.newConstructExpression(code);
        ObjectType objectType = type instanceof ObjectType ? (ObjectType)type : null;
        expr.setInstantiates((Declaration)(objectType == null ? null : objectType.getRecordDeclaration()));
        Declaration declaration = expr.getInstantiates();
        if (declaration == null) {
            throw new NullPointerException("null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.declarations.RecordDeclaration");
        }
        for (FieldDeclaration field : ((RecordDeclaration)declaration).getFields()) {
            Type type2 = field.getType();
            Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"field.type");
            Expression arg = this.initializeAsUndef(type2, code);
            expr.addArgument(arg);
        }
        return expr;
    }

    private final Expression initializeAsZero(Type type, String code) {
        if (!((LLVMIRLanguageFrontend)this.lang).isKnownStructTypeName(type.getName()) && !StringsKt.contains$default((CharSequence)type.getName(), (CharSequence)"{", (boolean)false, (int)2, null)) {
            return NodeBuilder.newLiteral(0, type, code);
        }
        ConstructExpression expr = NodeBuilder.newConstructExpression(code);
        ObjectType objectType = type instanceof ObjectType ? (ObjectType)type : null;
        expr.setInstantiates((Declaration)(objectType == null ? null : objectType.getRecordDeclaration()));
        Declaration declaration = expr.getInstantiates();
        if (declaration == null) {
            throw new NullPointerException("null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.declarations.RecordDeclaration");
        }
        for (FieldDeclaration field : ((RecordDeclaration)declaration).getFields()) {
            Type type2 = field.getType();
            Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"field.type");
            Expression arg = this.initializeAsZero(type2, code);
            expr.addArgument(arg);
        }
        return expr;
    }

    private final Expression handleNullPointer(LLVMValueRef value) {
        Type type = ((LLVMIRLanguageFrontend)this.lang).typeOf(value);
        return NodeBuilder.newLiteral(null, type, ((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(value));
    }

    @NotNull
    public final Expression handleGetElementPtr$cpg_library(@NotNull LLVMValueRef instr) {
        Expression operand;
        Intrinsics.checkNotNullParameter((Object)instr, (String)"instr");
        LLVMValueRef $this$opCode$iv = instr;
        boolean $i$f$getOpCode = false;
        boolean isGetElementPtr = LLVM.LLVMGetInstructionOpcode((LLVMValueRef)$this$opCode$iv) == 29 || LLVM.LLVMIsAConstantExpr((LLVMValueRef)instr) != null && LLVM.LLVMGetConstOpcode((LLVMValueRef)instr) == 29;
        int numOps = 0;
        int loopStart = 0;
        IntPointer indices = new IntPointer();
        if (isGetElementPtr) {
            numOps = LLVM.LLVMGetNumOperands((LLVMValueRef)instr);
            loopStart = 1;
        } else {
            numOps = LLVM.LLVMGetNumIndices((LLVMValueRef)instr);
            loopStart = 0;
            IntPointer intPointer = LLVM.LLVMGetIndices((LLVMValueRef)instr);
            Intrinsics.checkNotNullExpressionValue((Object)intPointer, (String)"LLVMGetIndices(instr)");
            indices = intPointer;
        }
        LLVMIRLanguageFrontend lLVMIRLanguageFrontend = (LLVMIRLanguageFrontend)this.lang;
        LLVMValueRef lLVMValueRef = LLVM.LLVMGetOperand((LLVMValueRef)instr, (int)0);
        Intrinsics.checkNotNullExpressionValue((Object)lLVMValueRef, (String)"LLVMGetOperand(instr, 0)");
        Type baseType = lLVMIRLanguageFrontend.typeOf(lLVMValueRef);
        Expression base = operand = ((LLVMIRLanguageFrontend)this.lang).getOperandValueAtIndex(instr, 0);
        Expression expr = new Expression();
        int n = loopStart;
        while (n < numOps) {
            RecordDeclaration record;
            Integer index;
            Object object;
            int idx = n++;
            if (isGetElementPtr) {
                operand = ((LLVMIRLanguageFrontend)this.lang).getOperandValueAtIndex(instr, idx);
                if (operand instanceof Literal) {
                    Object t = ((Literal)operand).getValue();
                    if (t == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                    }
                    object = (int)((Long)t).longValue();
                } else {
                    object = (DeclaredReferenceExpression)operand;
                }
            } else {
                object = index = Integer.valueOf(indices.get((long)idx));
            }
            if (baseType instanceof PointerType) {
                ArraySubscriptionExpression arrayExpr = NodeBuilder.newArraySubscriptionExpression("");
                arrayExpr.setArrayExpression(base);
                arrayExpr.setName(((Object)index).toString());
                arrayExpr.setSubscriptExpression(operand);
                expr = arrayExpr;
                Type type = baseType.dereference();
                Intrinsics.checkNotNullExpressionValue((Object)type, (String)"baseType.dereference()");
                baseType = type;
                base = expr;
                continue;
            }
            Type type = baseType;
            ObjectType objectType = type instanceof ObjectType ? (ObjectType)type : null;
            RecordDeclaration recordDeclaration = record = objectType == null ? null : objectType.getRecordDeclaration();
            if (record == null) {
                Handler.log.error("Could not find structure type with name {}, cannot continue", (Object)baseType.getTypeName());
                break;
            }
            Handler.log.debug("Trying to access a field within the record declaration of {}", (Object)record.getName());
            FieldDeclaration field = null;
            String fieldName = null;
            if (index instanceof Integer) {
                FieldDeclaration fieldDeclaration = field = record.getField(Intrinsics.stringPlus((String)"field_", (Object)index));
                fieldName = fieldDeclaration == null ? null : fieldDeclaration.getName();
            } else {
                field = null;
                fieldName = '[' + ((DeclaredReferenceExpression)operand).getName() + ']';
            }
            FieldDeclaration fieldDeclaration = field;
            Type type2 = fieldDeclaration == null ? null : fieldDeclaration.getType();
            if (type2 == null) {
                UnknownType unknownType = UnknownType.getUnknownType();
                Intrinsics.checkNotNullExpressionValue((Object)unknownType, (String)"getUnknownType()");
                type2 = unknownType;
            }
            baseType = type2;
            FieldDeclaration fieldDeclaration2 = field;
            expr = NodeBuilder.newMemberExpression(base, (Type)(fieldDeclaration2 == null ? null : fieldDeclaration2.getType()), fieldName, ".", "");
            Handler.log.info("{}", (Object)expr);
            base = expr;
        }
        if (isGetElementPtr) {
            UnaryOperator ref = NodeBuilder.newUnaryOperator("&", false, true, "");
            ref.setInput(expr);
            expr = ref;
        }
        return expr;
    }

    @NotNull
    public final Expression handleSelect(@NotNull LLVMValueRef instr) {
        Intrinsics.checkNotNullParameter((Object)instr, (String)"instr");
        Expression cond = ((LLVMIRLanguageFrontend)this.lang).getOperandValueAtIndex(instr, 0);
        Expression value1 = ((LLVMIRLanguageFrontend)this.lang).getOperandValueAtIndex(instr, 1);
        Expression value2 = ((LLVMIRLanguageFrontend)this.lang).getOperandValueAtIndex(instr, 2);
        ConditionalExpression conditionalExpr = NodeBuilder.newConditionalExpression(cond, value1, value2, value1.getType());
        return conditionalExpr;
    }

    private static final Expression _init_$lambda-0(ExpressionHandler this$0, LLVMValueRef it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        return this$0.handleValue(it);
    }
}

