/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.frontends.java;

import com.github.javaparser.ast.ImportDeclaration;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.AnnotationDeclaration;
import com.github.javaparser.ast.body.AnnotationMemberDeclaration;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.InitializerDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.nodeTypes.NodeWithAnnotations;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.resolution.UnsolvedSymbolException;
import com.github.javaparser.resolution.declarations.ResolvedConstructorDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedMethodDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedValueDeclaration;
import de.fraunhofer.aisec.cpg.frontends.Handler;
import de.fraunhofer.aisec.cpg.frontends.java.JavaLanguageFrontend;
import de.fraunhofer.aisec.cpg.graph.NodeBuilder;
import de.fraunhofer.aisec.cpg.graph.TypeManager;
import de.fraunhofer.aisec.cpg.graph.declarations.ConstructorDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.Declaration;
import de.fraunhofer.aisec.cpg.graph.declarations.EnumConstantDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.EnumDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.MethodDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.ParamVariableDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.RecordDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.VariableDeclaration;
import de.fraunhofer.aisec.cpg.graph.statements.CompoundStatement;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Expression;
import de.fraunhofer.aisec.cpg.graph.types.ParameterizedType;
import de.fraunhofer.aisec.cpg.graph.types.Type;
import de.fraunhofer.aisec.cpg.graph.types.TypeParser;
import de.fraunhofer.aisec.cpg.graph.types.UnknownType;
import de.fraunhofer.aisec.cpg.passes.scopes.RecordScope;
import de.fraunhofer.aisec.cpg.sarif.PhysicalLocation;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class DeclarationHandler
extends Handler<Declaration, BodyDeclaration, JavaLanguageFrontend> {
    public DeclarationHandler(JavaLanguageFrontend lang) {
        super(Declaration::new, lang);
        this.map.put(com.github.javaparser.ast.body.MethodDeclaration.class, decl -> this.handleMethodDeclaration((com.github.javaparser.ast.body.MethodDeclaration)decl));
        this.map.put(com.github.javaparser.ast.body.ConstructorDeclaration.class, decl -> this.handleConstructorDeclaration((com.github.javaparser.ast.body.ConstructorDeclaration)decl));
        this.map.put(ClassOrInterfaceDeclaration.class, decl -> this.handleClassOrInterfaceDeclaration((ClassOrInterfaceDeclaration)decl));
        this.map.put(FieldDeclaration.class, decl -> this.handleFieldDeclaration((FieldDeclaration)decl));
        this.map.put(com.github.javaparser.ast.body.EnumDeclaration.class, decl -> this.handleEnumDeclaration((com.github.javaparser.ast.body.EnumDeclaration)decl));
        this.map.put(com.github.javaparser.ast.body.EnumConstantDeclaration.class, decl -> this.handleEnumConstantDeclaration((com.github.javaparser.ast.body.EnumConstantDeclaration)decl));
    }

    private static void addImplicitReturn(BlockStmt body) {
        NodeList statements = body.getStatements();
        Statement lastStatement = null;
        if (!statements.isEmpty()) {
            lastStatement = (Statement)statements.get(statements.size() - 1);
        }
        if (lastStatement == null || !lastStatement.isReturnStmt()) {
            body.addStatement((Statement)new ReturnStmt());
        }
    }

    public ConstructorDeclaration handleConstructorDeclaration(com.github.javaparser.ast.body.ConstructorDeclaration constructorDecl) {
        ResolvedConstructorDeclaration resolvedConstructor = constructorDecl.resolve();
        ConstructorDeclaration declaration = NodeBuilder.newConstructorDeclaration(resolvedConstructor.getName(), constructorDecl.toString(), ((JavaLanguageFrontend)this.lang).getScopeManager().getCurrentRecord());
        ((JavaLanguageFrontend)this.lang).getScopeManager().addDeclaration(declaration);
        ((JavaLanguageFrontend)this.lang).getScopeManager().enterScope(declaration);
        declaration.addThrowTypes(constructorDecl.getThrownExceptions().stream().map(type -> TypeParser.createFrom(type.asString(), true)).collect(Collectors.toList()));
        for (Parameter parameter : constructorDecl.getParameters()) {
            ParamVariableDeclaration param = NodeBuilder.newMethodParameterIn(parameter.getNameAsString(), ((JavaLanguageFrontend)this.lang).getTypeAsGoodAsPossible(parameter, (ResolvedValueDeclaration)parameter.resolve()), parameter.isVarArgs(), parameter.toString());
            declaration.addParameter(param);
            ((JavaLanguageFrontend)this.lang).setCodeAndRegion(param, parameter);
            ((JavaLanguageFrontend)this.lang).getScopeManager().addDeclaration(param);
        }
        Type type2 = TypeParser.createFrom(((JavaLanguageFrontend)this.lang).getScopeManager().firstScopeOrNull(RecordScope.class::isInstance).getAstNode().getName(), true);
        declaration.setType(type2);
        BlockStmt body = constructorDecl.getBody();
        DeclarationHandler.addImplicitReturn(body);
        declaration.setBody((de.fraunhofer.aisec.cpg.graph.statements.Statement)((JavaLanguageFrontend)this.lang).getStatementHandler().handle(body));
        ((JavaLanguageFrontend)this.lang).processAnnotations(declaration, (NodeWithAnnotations<?>)constructorDecl);
        ((JavaLanguageFrontend)this.lang).getScopeManager().leaveScope(declaration);
        return declaration;
    }

    public MethodDeclaration handleMethodDeclaration(com.github.javaparser.ast.body.MethodDeclaration methodDecl) {
        ResolvedMethodDeclaration resolvedMethod = methodDecl.resolve();
        RecordDeclaration record = ((JavaLanguageFrontend)this.lang).getScopeManager().getCurrentRecord();
        MethodDeclaration functionDeclaration = NodeBuilder.newMethodDeclaration(resolvedMethod.getName(), methodDecl.toString(), methodDecl.isStatic(), record);
        VariableDeclaration receiver = NodeBuilder.newVariableDeclaration("this", record != null ? TypeParser.createFrom(record.getName(), false) : UnknownType.getUnknownType(), "this", false);
        functionDeclaration.setReceiver(receiver);
        ((JavaLanguageFrontend)this.lang).getScopeManager().enterScope(functionDeclaration);
        functionDeclaration.addThrowTypes(methodDecl.getThrownExceptions().stream().map(type -> TypeParser.createFrom(type.asString(), true)).collect(Collectors.toList()));
        for (Parameter parameter : methodDecl.getParameters()) {
            Type resolvedType = TypeManager.getInstance().getTypeParameter(functionDeclaration.getRecordDeclaration(), parameter.getType().toString());
            if (resolvedType == null) {
                resolvedType = ((JavaLanguageFrontend)this.lang).getTypeAsGoodAsPossible(parameter, (ResolvedValueDeclaration)parameter.resolve());
            }
            ParamVariableDeclaration param = NodeBuilder.newMethodParameterIn(parameter.getNameAsString(), resolvedType, parameter.isVarArgs(), parameter.toString());
            functionDeclaration.addParameter(param);
            ((JavaLanguageFrontend)this.lang).setCodeAndRegion(param, parameter);
            ((JavaLanguageFrontend)this.lang).processAnnotations(param, (NodeWithAnnotations<?>)parameter);
            ((JavaLanguageFrontend)this.lang).getScopeManager().addDeclaration(param);
        }
        functionDeclaration.setType(((JavaLanguageFrontend)this.lang).getReturnTypeAsGoodAsPossible(methodDecl, resolvedMethod));
        Optional o = methodDecl.getBody();
        if (o.isEmpty()) {
            ((JavaLanguageFrontend)this.lang).getScopeManager().leaveScope(functionDeclaration);
            return functionDeclaration;
        }
        BlockStmt body = (BlockStmt)o.get();
        DeclarationHandler.addImplicitReturn(body);
        functionDeclaration.setBody((de.fraunhofer.aisec.cpg.graph.statements.Statement)((JavaLanguageFrontend)this.lang).getStatementHandler().handle(body));
        ((JavaLanguageFrontend)this.lang).processAnnotations(functionDeclaration, (NodeWithAnnotations<?>)methodDecl);
        ((JavaLanguageFrontend)this.lang).getScopeManager().leaveScope(functionDeclaration);
        return functionDeclaration;
    }

    public RecordDeclaration handleClassOrInterfaceDeclaration(ClassOrInterfaceDeclaration classInterDecl) {
        String fqn = classInterDecl.getNameAsString();
        fqn = this.getAbsoluteName(fqn);
        RecordDeclaration recordDeclaration = NodeBuilder.newRecordDeclaration(fqn, "class", classInterDecl.toString());
        recordDeclaration.setSuperClasses(classInterDecl.getExtendedTypes().stream().map(((JavaLanguageFrontend)this.lang)::getTypeAsGoodAsPossible).collect(Collectors.toList()));
        recordDeclaration.setImplementedInterfaces(classInterDecl.getImplementedTypes().stream().map(((JavaLanguageFrontend)this.lang)::getTypeAsGoodAsPossible).collect(Collectors.toList()));
        TypeManager.getInstance().addTypeParameter(recordDeclaration, classInterDecl.getTypeParameters().stream().map(t -> new ParameterizedType(t.getNameAsString())).collect(Collectors.toList()));
        Map partitioned = ((JavaLanguageFrontend)this.lang).getContext().getImports().stream().collect(Collectors.partitioningBy(ImportDeclaration::isStatic, Collectors.mapping(i -> {
            Object iName = i.getNameAsString();
            if (i.isAsterisk() && !((String)iName).endsWith(".*")) {
                iName = (String)iName + ".*";
            }
            return iName;
        }, Collectors.toList())));
        recordDeclaration.setStaticImportStatements(partitioned.get(true));
        recordDeclaration.setImportStatements(partitioned.get(false));
        ((JavaLanguageFrontend)this.lang).getScopeManager().addDeclaration(recordDeclaration);
        ((JavaLanguageFrontend)this.lang).getScopeManager().enterScope(recordDeclaration);
        ((JavaLanguageFrontend)this.lang).getScopeManager().addDeclaration(recordDeclaration.getThis());
        for (BodyDeclaration decl : classInterDecl.getMembers()) {
            if (decl instanceof FieldDeclaration) {
                this.handle(decl);
                continue;
            }
            if (decl instanceof com.github.javaparser.ast.body.MethodDeclaration) {
                MethodDeclaration md = (MethodDeclaration)this.handle(decl);
                recordDeclaration.addMethod(md);
                continue;
            }
            if (decl instanceof com.github.javaparser.ast.body.ConstructorDeclaration) {
                ConstructorDeclaration c = (ConstructorDeclaration)this.handle(decl);
                recordDeclaration.addConstructor(c);
                continue;
            }
            if (decl instanceof ClassOrInterfaceDeclaration) {
                recordDeclaration.addDeclaration((Declaration)this.handle(decl));
                continue;
            }
            if (decl instanceof InitializerDeclaration) {
                InitializerDeclaration id = (InitializerDeclaration)decl;
                CompoundStatement initializerBlock = ((JavaLanguageFrontend)this.lang).getStatementHandler().handleBlockStatement((Statement)id.getBody());
                initializerBlock.setStaticBlock(id.isStatic());
                recordDeclaration.addStatement(initializerBlock);
                continue;
            }
            log.debug("Member {} of type {} is something that we do not parse yet: {}", new Object[]{decl, recordDeclaration.getName(), decl.getClass().getSimpleName()});
        }
        if (recordDeclaration.getConstructors().isEmpty()) {
            ConstructorDeclaration constructorDeclaration = NodeBuilder.newConstructorDeclaration(recordDeclaration.getName(), recordDeclaration.getName(), recordDeclaration);
            recordDeclaration.addConstructor(constructorDeclaration);
            ((JavaLanguageFrontend)this.lang).getScopeManager().addDeclaration(constructorDeclaration);
        }
        ((JavaLanguageFrontend)this.lang).processAnnotations(recordDeclaration, (NodeWithAnnotations<?>)classInterDecl);
        ((JavaLanguageFrontend)this.lang).getScopeManager().leaveScope(recordDeclaration);
        return recordDeclaration;
    }

    public de.fraunhofer.aisec.cpg.graph.declarations.FieldDeclaration handleFieldDeclaration(FieldDeclaration fieldDecl) {
        Type type;
        VariableDeclarator variable2 = fieldDecl.getVariable(0);
        List<String> modifiers = fieldDecl.getModifiers().stream().map(modifier -> modifier.getKeyword().asString()).collect(Collectors.toList());
        String joinedModifiers = String.join((CharSequence)" ", modifiers) + " ";
        PhysicalLocation location = ((JavaLanguageFrontend)this.lang).getLocationFromRawNode(fieldDecl);
        Expression initializer = variable2.getInitializer().map(((JavaLanguageFrontend)this.lang).getExpressionHandler()::handle).orElse(null);
        try {
            type = TypeManager.getInstance().getTypeParameter(((JavaLanguageFrontend)this.lang).getScopeManager().getCurrentRecord(), variable2.resolve().getType().describe());
            if (type == null) {
                type = TypeParser.createFrom(joinedModifiers + variable2.resolve().getType().describe(), true);
            }
        }
        catch (UnsolvedSymbolException | UnsupportedOperationException e) {
            String t = ((JavaLanguageFrontend)this.lang).recoverTypeFromUnsolvedException(e);
            if (t == null) {
                log.warn("Could not resolve type for {}", (Object)variable2);
                type = TypeParser.createFrom(joinedModifiers + variable2.getType().asString(), true);
            }
            type = TypeParser.createFrom(joinedModifiers + t, true);
            type.setTypeOrigin(Type.Origin.GUESSED);
        }
        de.fraunhofer.aisec.cpg.graph.declarations.FieldDeclaration fieldDeclaration = NodeBuilder.newFieldDeclaration(variable2.getName().asString(), type, modifiers, variable2.toString(), location, initializer, false);
        ((JavaLanguageFrontend)this.lang).getScopeManager().addDeclaration(fieldDeclaration);
        ((JavaLanguageFrontend)this.lang).processAnnotations(fieldDeclaration, (NodeWithAnnotations<?>)fieldDecl);
        return fieldDeclaration;
    }

    public EnumDeclaration handleEnumDeclaration(com.github.javaparser.ast.body.EnumDeclaration enumDecl) {
        String name = this.getAbsoluteName(enumDecl.getNameAsString());
        PhysicalLocation location = ((JavaLanguageFrontend)this.lang).getLocationFromRawNode(enumDecl);
        EnumDeclaration enumDeclaration = NodeBuilder.newEnumDeclaration(name, enumDecl.toString(), location);
        List<EnumConstantDeclaration> entries2 = enumDecl.getEntries().stream().map(e -> (EnumConstantDeclaration)this.handle(e)).collect(Collectors.toList());
        entries2.forEach(e -> e.setType(TypeParser.createFrom(enumDeclaration.getName(), true)));
        enumDeclaration.setEntries(entries2);
        List<Type> superTypes = enumDecl.getImplementedTypes().stream().map(((JavaLanguageFrontend)this.lang)::getTypeAsGoodAsPossible).collect(Collectors.toList());
        enumDeclaration.setSuperTypes(superTypes);
        return enumDeclaration;
    }

    public EnumConstantDeclaration handleEnumConstantDeclaration(com.github.javaparser.ast.body.EnumConstantDeclaration enumConstDecl) {
        return NodeBuilder.newEnumConstantDeclaration(enumConstDecl.getNameAsString(), enumConstDecl.toString(), ((JavaLanguageFrontend)this.lang).getLocationFromRawNode(enumConstDecl));
    }

    public Declaration handleAnnotationDeclaration(AnnotationDeclaration annotationConstDecl) {
        return new Declaration();
    }

    public Declaration handleAnnotationMemberDeclaration(AnnotationMemberDeclaration annotationMemberDecl) {
        return new Declaration();
    }

    private String getAbsoluteName(String name) {
        String prefix = ((JavaLanguageFrontend)this.lang).getScopeManager().getCurrentNamePrefix();
        name = (String)(prefix.length() > 0 ? prefix + ((JavaLanguageFrontend)this.lang).getNamespaceDelimiter() : "") + (String)name;
        return name;
    }
}

