/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.frontends;

import de.fraunhofer.aisec.cpg.frontends.FrontendUtils;
import de.fraunhofer.aisec.cpg.frontends.LanguageFrontend;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.declarations.NamespaceDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.TranslationUnitDeclaration;
import de.fraunhofer.aisec.cpg.helpers.SubgraphWalker;
import de.fraunhofer.aisec.cpg.sarif.PhysicalLocation;
import de.fraunhofer.aisec.cpg.sarif.Region;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lde/fraunhofer/aisec/cpg/frontends/FrontendUtils;", "", "()V", "Companion", "cpg-library"})
public final class FrontendUtils {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Logger LOGGER = LoggerFactory.getLogger(FrontendUtils.class);

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0002J\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J0\u0010\u0012\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0007R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lde/fraunhofer/aisec/cpg/frontends/FrontendUtils$Companion;", "", "()V", "LOGGER", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getEndColumnIndex", "", "posPrefix", "", "end", "matchCommentToNode", "", "comment", "location", "Lde/fraunhofer/aisec/cpg/sarif/Region;", "tu", "Lde/fraunhofer/aisec/cpg/graph/declarations/TranslationUnitDeclaration;", "parseColumnPositionsFromFile", "fileContent", "nodeLength", "nodeOffset", "startingLineNumber", "endingLineNumber", "cpg-library"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Region parseColumnPositionsFromFile(@NotNull String fileContent, int nodeLength, int nodeOffset, int startingLineNumber, int endingLineNumber) {
            Intrinsics.checkNotNullParameter((Object)fileContent, (String)"fileContent");
            int startColumn = 1;
            int n = nodeOffset - 1;
            if (2 <= n) {
                do {
                    int i;
                    if ((i = n--) >= fileContent.length()) {
                        LOGGER.warn("Requested index {} exceeds length of translation unit code ({})", (Object)i, (Object)fileContent.length());
                        return null;
                    }
                    if (fileContent.charAt(i) == '\n') break;
                    int n2 = startColumn;
                    startColumn = n2 + 1;
                } while (2 <= n);
            }
            int endColumn = this.getEndColumnIndex(fileContent, nodeOffset + nodeLength);
            Region region = new Region(startingLineNumber, startColumn, endingLineNumber, endColumn);
            return region;
        }

        private final int getEndColumnIndex(String posPrefix, int end) {
            int n;
            int mutableEnd = end;
            int column = 1;
            try {
                if (mutableEnd - 1 >= posPrefix.length() || posPrefix.charAt(mutableEnd - 1) == '\n') {
                    mutableEnd = Math.min(mutableEnd - 1, posPrefix.length() - 1);
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                LanguageFrontend.log.error("could not update end ", (Throwable)e);
            }
            if (2 <= (n = mutableEnd - 1)) {
                int i;
                while (posPrefix.charAt(i = n--) != '\n') {
                    int n2 = column;
                    column = n2 + 1;
                    if (2 <= n) continue;
                }
            }
            return column;
        }

        /*
         * WARNING - void declaration
         */
        public final void matchCommentToNode(@NotNull String comment, @NotNull Region location, @NotNull TranslationUnitDeclaration tu) {
            String string;
            int closestLine;
            Integer n;
            Node closest2;
            void $this$filterTo$iv$iv;
            Node it;
            void $this$flatMapTo$iv$iv;
            void $this$flatMap$iv;
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv;
            Set<Node> it2;
            Iterable<Node> $this$filterTo$iv$iv2;
            Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            Intrinsics.checkNotNullParameter((Object)tu, (String)"tu");
            List<Node> list = SubgraphWalker.flattenAST(tu);
            Intrinsics.checkNotNullExpressionValue(list, (String)"flattenAST(tu)");
            List<Node> nodes = list;
            Iterable $this$filter$iv = nodes;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo232 = false;
            for (Object t : $this$filterTo$iv$iv2) {
                Region nodeRegion;
                Region region;
                Iterator it3 = (Node)t;
                boolean bl = false;
                if (((Node)((Object)it3)).getLocation() == null) {
                    region = null;
                } else {
                    boolean bl2 = false;
                    region = ((PhysicalLocation)((Object)it2)).getRegion();
                }
                Region region2 = region;
                if (region == null) {
                    region2 = new Region();
                }
                boolean bl2 = !((nodeRegion = region2).getStartLine() > location.getStartLine() || nodeRegion.getEndLine() < location.getEndLine() || nodeRegion.getStartLine() == location.getStartLine() && nodeRegion.getStartColumn() > location.getStartColumn() || nodeRegion.getEndLine() == location.getEndLine() && nodeRegion.getEndColumn() < location.getEndColumn());
                if (!bl2) continue;
                destination$iv$iv.add(t);
            }
            List enclosingNodes = (List)destination$iv$iv;
            if (!enclosingNodes.contains(tu)) {
                enclosingNodes = CollectionsKt.plus((Collection)enclosingNodes, (Object)tu);
            }
            Node smallestEnclosingNode = (Node)CollectionsKt.first((List)CollectionsKt.sortedWith((Iterable)enclosingNodes, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Comparable comparable;
                    Integer n;
                    Comparable comparable2;
                    Node it = (Node)a;
                    boolean bl = false;
                    String string = it.getCode();
                    if (string == null) {
                        comparable2 = Integer.valueOf(10000);
                    } else {
                        n = string.length();
                        comparable2 = n;
                    }
                    it = (Node)b;
                    Comparable comparable3 = comparable2;
                    bl = false;
                    String string2 = it.getCode();
                    if (string2 == null) {
                        comparable = Integer.valueOf(10000);
                    } else {
                        n = string2.length();
                        comparable = n;
                    }
                    return ComparisonsKt.compareValues((Comparable)comparable3, (Comparable)comparable);
                }
            }));
            Set<Node> children = null;
            $this$filterTo$iv$iv2 = children = SubgraphWalker.getAstChildren(smallestEnclosingNode);
            Intrinsics.checkNotNullExpressionValue($this$filterTo$iv$iv2, (String)"children");
            $this$filterTo$iv$iv2 = $this$filterTo$iv$iv2;
            Set<Node> set = children;
            boolean $i$f$filterIsInstance = false;
            void $i$f$filterTo232 = $this$filterIsInstance$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean bl = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof NamespaceDeclaration)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv2;
            boolean $i$f$flatMap232 = false;
            $this$filterIsInstanceTo$iv$iv = $this$flatMap$iv;
            Iterable destination$iv$iv3 = new ArrayList();
            boolean bl3 = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                void $this$filterTo$iv$iv3;
                NamespaceDeclaration it4 = (NamespaceDeclaration)element$iv$iv;
                boolean bl4 = false;
                it2 = SubgraphWalker.getAstChildren(it4);
                Intrinsics.checkNotNullExpressionValue((Object)it2, (String)"getAstChildren(it)");
                Iterable $this$filter$iv2 = it2;
                boolean $i$f$filter2 = false;
                Iterable iterable2 = $this$filter$iv2;
                Collection destination$iv$iv32 = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv2 : $this$filterTo$iv$iv3) {
                    it = (Node)element$iv$iv2;
                    boolean bl42 = false;
                    if (!(!children.contains(it))) continue;
                    destination$iv$iv32.add(element$iv$iv2);
                }
                Iterable list$iv$iv = (List)destination$iv$iv32;
                CollectionsKt.addAll((Collection)destination$iv$iv3, (Iterable)list$iv$iv);
            }
            set.addAll((List)destination$iv$iv3);
            Set<Node> $i$f$flatMap232 = children;
            Intrinsics.checkNotNullExpressionValue($i$f$flatMap232, (String)"children");
            Iterable $this$filter$iv3 = $i$f$flatMap232;
            boolean $i$f$filter232 = false;
            destination$iv$iv3 = $this$filter$iv3;
            Collection collection = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Region nodeRegion;
                Region region;
                Node it5 = (Node)element$iv$iv;
                boolean bl5 = false;
                PhysicalLocation physicalLocation = it5.getLocation();
                if (physicalLocation == null) {
                    region = null;
                } else if (physicalLocation.getRegion() == null) {
                    region = null;
                } else {
                    Region it6;
                    boolean bl52 = false;
                    region = it6;
                }
                Region region3 = region;
                if (region == null) {
                    region3 = new Region();
                }
                boolean bl6 = (nodeRegion = region3).getStartLine() >= location.getEndLine() && (nodeRegion.getStartLine() > location.getEndLine() || nodeRegion.getStartColumn() >= location.getEndColumn());
                if (!bl6) continue;
                collection.add(element$iv$iv);
            }
            List successors = (List)collection;
            Function1[] $i$f$filter232 = new Function1[]{matchCommentToNode.closest.1.INSTANCE, matchCommentToNode.closest.2.INSTANCE};
            Node node = closest2 = (Node)CollectionsKt.firstOrNull((List)CollectionsKt.sortedWith((Iterable)successors, (Comparator)ComparisonsKt.compareBy((Function1[])$i$f$filter232)));
            if (node == null) {
                n = null;
            } else {
                PhysicalLocation physicalLocation = node.getLocation();
                if (physicalLocation == null) {
                    n = null;
                } else {
                    Region region = physicalLocation.getRegion();
                    n = region == null ? null : Integer.valueOf(region.getStartLine());
                }
            }
            int n2 = closestLine = n == null ? location.getEndLine() + 1 : n;
            if (closest2 == null || closestLine > location.getEndLine()) {
                int closestLine2;
                Integer n3;
                Node node2;
                void $this$filterTo$iv$iv4;
                Set<Node> set2 = children;
                Intrinsics.checkNotNullExpressionValue(set2, (String)"children");
                Iterable iterable3 = set2;
                boolean $i$f$filter332 = false;
                Iterable element$iv$iv = iterable3;
                Collection destination$iv$iv5 = new ArrayList();
                boolean $i$f$filterTo3 = false;
                for (Object element$iv$iv3 : $this$filterTo$iv$iv4) {
                    Node nodeRegion;
                    Node node3;
                    Node it7 = (Node)element$iv$iv3;
                    boolean bl7 = false;
                    PhysicalLocation physicalLocation = it7.getLocation();
                    if (physicalLocation == null) {
                        node3 = null;
                    } else if (physicalLocation.getRegion() == null) {
                        node3 = null;
                    } else {
                        boolean bl72 = false;
                        node3 = it;
                    }
                    Node node4 = node3;
                    if (node3 == null) {
                        node4 = new Region();
                    }
                    boolean bl8 = ((Region)((Object)(nodeRegion = node4))).getEndLine() <= location.getStartLine() && (((Region)((Object)nodeRegion)).getEndLine() < location.getStartLine() || ((Region)((Object)nodeRegion)).getEndColumn() <= location.getStartColumn());
                    if (!bl8) continue;
                    destination$iv$iv5.add(element$iv$iv3);
                }
                List predecessor = (List)destination$iv$iv5;
                Function1[] $i$f$filter332 = new Function1[]{matchCommentToNode.closestPredecessor.1.INSTANCE, matchCommentToNode.closestPredecessor.2.INSTANCE};
                Node node5 = node2 = (Node)CollectionsKt.lastOrNull((List)CollectionsKt.sortedWith((Iterable)predecessor, (Comparator)ComparisonsKt.compareBy((Function1[])$i$f$filter332)));
                if (node5 == null) {
                    n3 = null;
                } else {
                    PhysicalLocation physicalLocation = node5.getLocation();
                    if (physicalLocation == null) {
                        n3 = null;
                    } else {
                        Region region = physicalLocation.getRegion();
                        n3 = region == null ? null : Integer.valueOf(region.getEndLine());
                    }
                }
                int n4 = closestLine2 = n3 == null ? location.getStartLine() - 1 : n3;
                if (node2 != null && closestLine2 == location.getStartLine()) {
                    closest2 = node2;
                }
            }
            if (closest2 == null) {
                closest2 = smallestEnclosingNode;
            }
            if ((string = closest2.getComment()) == null) {
                string = "";
            }
            closest2.setComment(Intrinsics.stringPlus((String)string, (Object)comment));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

