/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg;

import de.fraunhofer.aisec.cpg.TranslationConfiguration;
import de.fraunhofer.aisec.cpg.TranslationResult;
import de.fraunhofer.aisec.cpg.frontends.LanguageFrontend;
import de.fraunhofer.aisec.cpg.frontends.TranslationException;
import de.fraunhofer.aisec.cpg.frontends.cpp.CXXLanguageFrontend;
import de.fraunhofer.aisec.cpg.frontends.golang.GoLanguageFrontend;
import de.fraunhofer.aisec.cpg.graph.TypeManager;
import de.fraunhofer.aisec.cpg.graph.declarations.TranslationUnitDeclaration;
import de.fraunhofer.aisec.cpg.helpers.Benchmark;
import de.fraunhofer.aisec.cpg.helpers.SubgraphWalker;
import de.fraunhofer.aisec.cpg.helpers.Util;
import de.fraunhofer.aisec.cpg.passes.Pass;
import de.fraunhofer.aisec.cpg.passes.scopes.ScopeManager;
import java.io.Closeable;
import java.io.File;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0005\u0018\u0000 .2\u00020\u0001:\u0002-.B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J0\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00162\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00100\u001f2\b\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020\u0010H\u0002J\u0006\u0010\u0007\u001a\u00020#J&\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00100%2\u0006\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020!H\u0002J,\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00100'2\u0006\u0010\u001d\u001a\u00020\u00162\u0006\u0010(\u001a\u00020\u001a2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020!0*H\u0002J,\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00100'2\u0006\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020!0*H\u0002J&\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00100'2\u0006\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\"\u0010\u000e\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0010\u0018\u00010\u000f*\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006/"}, d2={"Lde/fraunhofer/aisec/cpg/TranslationManager;", "", "config", "Lde/fraunhofer/aisec/cpg/TranslationConfiguration;", "(Lde/fraunhofer/aisec/cpg/TranslationConfiguration;)V", "getConfig", "()Lde/fraunhofer/aisec/cpg/TranslationConfiguration;", "isCancelled", "Ljava/util/concurrent/atomic/AtomicBoolean;", "passes", "", "Lde/fraunhofer/aisec/cpg/passes/Pass;", "getPasses", "()Ljava/util/List;", "frontendClass", "Ljava/lang/Class;", "Lde/fraunhofer/aisec/cpg/frontends/LanguageFrontend;", "", "getFrontendClass", "(Ljava/lang/String;)Ljava/lang/Class;", "analyze", "Ljava/util/concurrent/CompletableFuture;", "Lde/fraunhofer/aisec/cpg/TranslationResult;", "getFrontend", "extension", "scopeManager", "Lde/fraunhofer/aisec/cpg/passes/scopes/ScopeManager;", "handleCompletion", "", "result", "usedFrontends", "", "sourceLocation", "Ljava/io/File;", "f", "", "parse", "Ljava/util/Optional;", "parseParallel", "", "originalScopeManager", "sourceLocations", "", "parseSequentially", "runFrontends", "Builder", "Companion", "cpg-library"})
public final class TranslationManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TranslationConfiguration config;
    @NotNull
    private final AtomicBoolean isCancelled;
    private static final Logger log = LoggerFactory.getLogger(TranslationManager.class);

    private TranslationManager(TranslationConfiguration config) {
        this.config = config;
        this.isCancelled = new AtomicBoolean(false);
    }

    @NotNull
    public final TranslationConfiguration getConfig() {
        return this.config;
    }

    @NotNull
    public final CompletableFuture<TranslationResult> analyze() {
        TranslationResult result = new TranslationResult(this);
        CompletableFuture<TranslationResult> completableFuture = CompletableFuture.supplyAsync(() -> TranslationManager.analyze$lambda-2(this, result));
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"supplyAsync {\n          \u2026         result\n        }");
        return completableFuture;
    }

    @NotNull
    public final List<Pass> getPasses() {
        List<Pass> list = this.config.getRegisteredPasses();
        Intrinsics.checkNotNullExpressionValue(list, (String)"config.registeredPasses");
        return list;
    }

    public final boolean isCancelled() {
        return this.isCancelled.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Set<LanguageFrontend> runFrontends(TranslationResult result, TranslationConfiguration config, ScopeManager scopeManager) throws TranslationException {
        Set<LanguageFrontend> usedFrontends;
        Throwable $this$flatMapTo$iv$iv;
        List sourceLocations = new ArrayList(this.config.getSourceLocations());
        boolean useParallelFrontends = false;
        useParallelFrontends = config.useParallelFrontends;
        Iterable $this$flatMap$iv = sourceLocations;
        boolean $i$f$flatMap2 = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator = $this$flatMapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            List list;
            Object element$iv$iv = iterator.next();
            File file = (File)element$iv$iv;
            boolean bl = false;
            if (file.isDirectory()) {
                list = Files.find(file.toPath(), 999, TranslationManager::runFrontends$lambda-5$lambda-3, new FileVisitOption[0]).map(TranslationManager::runFrontends$lambda-5$lambda-4).collect(Collectors.toList());
            } else {
                if (useParallelFrontends) {
                    String string = Util.getExtension(file);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getExtension(file)");
                    if (Intrinsics.areEqual(this.getFrontendClass(string), GoLanguageFrontend.class)) {
                        log.warn("Parallel frontends are not yet supported for Go");
                        useParallelFrontends = false;
                    }
                }
                list = CollectionsKt.listOf((Object)file);
            }
            List list2 = list;
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"if (file.isDirectory) {\n\u2026f(file)\n                }");
            Iterable list$iv$iv = list2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List list = (List)destination$iv$iv;
        if (config.useUnityBuild) {
            File tmpFile = Files.createTempFile("compile", ".cpp", new FileAttribute[0]).toFile();
            tmpFile.deleteOnExit();
            Closeable $i$f$flatMap2 = new PrintWriter(tmpFile);
            $this$flatMapTo$iv$iv = null;
            try {
                PrintWriter writer = (PrintWriter)$i$f$flatMap2;
                boolean bl = false;
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    File it = (File)element$iv;
                    boolean bl2 = false;
                    if (!CXXLanguageFrontend.CXX_EXTENSIONS.contains(Util.getExtension(it))) continue;
                    if (config.getTopLevel() != null) {
                        Path topLevel = config.getTopLevel().toPath();
                        writer.write(StringsKt.trimIndent((String)("\n#include \"" + topLevel.relativize(it.toPath()) + "\"\n\n")));
                        continue;
                    }
                    writer.write(StringsKt.trimIndent((String)("\n#include \"" + it.getAbsolutePath() + "\"\n\n")));
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                $this$flatMapTo$iv$iv = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)$i$f$flatMap2, (Throwable)$this$flatMapTo$iv$iv);
            }
            sourceLocations = CollectionsKt.listOf((Object)tmpFile);
        } else {
            sourceLocations = list;
        }
        TypeManager.setTypeSystemActive(config.typeSystemActiveInFrontend);
        Set<LanguageFrontend> set = usedFrontends = useParallelFrontends ? this.parseParallel(result, scopeManager, sourceLocations) : this.parseSequentially(result, scopeManager, sourceLocations);
        if (!config.typeSystemActiveInFrontend) {
            TypeManager.setTypeSystemActive(true);
            List<TranslationUnitDeclaration> $i$f$flatMap2 = result.getTranslationUnits();
            Intrinsics.checkNotNullExpressionValue($i$f$flatMap2, (String)"result.translationUnits");
            Iterable $this$forEach$iv = $i$f$flatMap2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TranslationUnitDeclaration it = (TranslationUnitDeclaration)element$iv;
                boolean bl = false;
                Benchmark bench = new Benchmark(this.getClass(), Intrinsics.stringPlus((String)"Activating types for ", (Object)it.getName()), true);
                SubgraphWalker.activateTypes(it, scopeManager);
                bench.stop();
            }
        }
        return usedFrontends;
    }

    private final Set<LanguageFrontend> parseParallel(TranslationResult result, ScopeManager originalScopeManager, Collection<? extends File> sourceLocations) {
        Set usedFrontends = new LinkedHashSet();
        log.info("Parallel parsing started");
        List futures = new ArrayList();
        List parallelScopeManagers = new ArrayList();
        Map futureToFile = new IdentityHashMap();
        for (File file : sourceLocations) {
            ScopeManager scopeManager = new ScopeManager();
            parallelScopeManagers.add(scopeManager);
            CompletableFuture<Optional> future = CompletableFuture.supplyAsync(() -> TranslationManager.parseParallel$lambda-9(this, result, scopeManager, file));
            Intrinsics.checkNotNullExpressionValue(future, (String)"future");
            futures.add(future);
            Map map = futureToFile;
            CompletableFuture<Optional> completableFuture = future;
            map.put(completableFuture, file);
        }
        for (CompletableFuture completableFuture : futures) {
            try {
                ((Optional)completableFuture.get()).ifPresent(arg_0 -> TranslationManager.parseParallel$lambda-10(this, result, usedFrontends, futureToFile, completableFuture, arg_0));
            }
            catch (InterruptedException e) {
                log.error(Intrinsics.stringPlus((String)"Error parsing ", futureToFile.get(completableFuture)), (Throwable)e);
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                log.error(Intrinsics.stringPlus((String)"Error parsing ", futureToFile.get(completableFuture)), (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
        originalScopeManager.mergeFrom(parallelScopeManagers);
        Iterable $this$forEach$iv = usedFrontends;
        boolean bl = false;
        for (Object element$iv : $this$forEach$iv) {
            LanguageFrontend it = (LanguageFrontend)element$iv;
            boolean bl2 = false;
            it.setScopeManager(originalScopeManager);
        }
        log.info("Parallel parsing completed");
        return usedFrontends;
    }

    private final Set<LanguageFrontend> parseSequentially(TranslationResult result, ScopeManager scopeManager, Collection<? extends File> sourceLocations) throws TranslationException {
        Set usedFrontends = new LinkedHashSet();
        for (File file : sourceLocations) {
            log.info("Parsing {}", (Object)file.getAbsolutePath());
            this.parse(result, scopeManager, file).ifPresent(arg_0 -> TranslationManager.parseSequentially$lambda-12(this, result, usedFrontends, file, arg_0));
        }
        return usedFrontends;
    }

    /*
     * WARNING - void declaration
     */
    private final void handleCompletion(TranslationResult result, Set<LanguageFrontend> usedFrontends, File sourceLocation, LanguageFrontend f) {
        String $this$mapTo$iv$iv;
        usedFrontends.add(f);
        Iterable $this$map$iv = usedFrontends;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Object item$iv$iv = iterator.next();
            LanguageFrontend languageFrontend = (LanguageFrontend)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getClass());
        }
        if (((Collection)CollectionsKt.distinct((Iterable)((List)destination$iv$iv))).size() > 1) {
            log.error("Different frontends are used for multiple files. This will very likely break the following passes.");
        }
        Object object = result.getScratch().computeIfAbsent("sourceLocationsToFrontend", TranslationManager::handleCompletion$lambda-14);
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.String, kotlin.String>");
        }
        Map sfToFe = TypeIntrinsics.asMutableMap((Object)object);
        File file = sourceLocation;
        Intrinsics.checkNotNull((Object)file);
        $this$mapTo$iv$iv = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)$this$mapTo$iv$iv, (String)"sourceLocation!!.name");
        String string = f.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"f.javaClass.simpleName");
        sfToFe.put($this$mapTo$iv$iv, string);
        for (Pass pass : this.config.getRegisteredPasses()) {
            pass.setLang(f);
        }
    }

    private final Optional<LanguageFrontend> parse(TranslationResult result, ScopeManager scopeManager, File sourceLocation) throws TranslationException {
        Optional<LanguageFrontend> optional;
        LanguageFrontend frontend;
        block4: {
            frontend = null;
            try {
                optional = Util.getExtension(sourceLocation);
                Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"getExtension(sourceLocation)");
                frontend = this.getFrontend((String)((Object)optional), scopeManager);
                if (frontend == null) {
                    log.error("Found no parser frontend for {}", (Object)sourceLocation.getName());
                    if (this.config.failOnError) {
                        throw new TranslationException(Intrinsics.stringPlus((String)"Found no parser frontend for ", (Object)sourceLocation.getName()));
                    }
                    optional = Optional.empty();
                    Intrinsics.checkNotNullExpressionValue(optional, (String)"empty()");
                    return optional;
                }
                result.addTranslationUnit(frontend.parse(sourceLocation));
            }
            catch (TranslationException ex) {
                log.error("An error occurred during parsing of {}: {}", (Object)sourceLocation.getName(), (Object)ex.getMessage());
                if (!this.config.failOnError) break block4;
                throw ex;
            }
        }
        optional = Optional.ofNullable(frontend);
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"ofNullable(frontend)");
        return optional;
    }

    private final LanguageFrontend getFrontend(String extension, ScopeManager scopeManager) {
        Object object;
        Class<? extends LanguageFrontend> clazz = this.getFrontendClass(extension);
        if (clazz != null) {
            Object object2;
            try {
                object2 = new Class[]{TranslationConfiguration.class, ScopeManager.class};
                Constructor<? extends LanguageFrontend> constructor = clazz.getConstructor((Class<?>)object2);
                object2 = new Object[]{this.config, scopeManager};
                object2 = constructor.newInstance(object2);
            }
            catch (InstantiationException e) {
                log.error("Could not instantiate language frontend {}", (Object)clazz.getName(), (Object)e);
                object2 = null;
            }
            catch (IllegalAccessException e) {
                log.error("Could not instantiate language frontend {}", (Object)clazz.getName(), (Object)e);
                object2 = null;
            }
            catch (InvocationTargetException e) {
                log.error("Could not instantiate language frontend {}", (Object)clazz.getName(), (Object)e);
                object2 = null;
            }
            catch (NoSuchMethodException e) {
                log.error("Could not instantiate language frontend {}", (Object)clazz.getName(), (Object)e);
                object2 = null;
            }
            object = object2;
        } else {
            object = null;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final Class<? extends LanguageFrontend> getFrontendClass(String $this$frontendClass) {
        void $this$mapTo$iv$iv;
        Map.Entry it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.config.getFrontends().entrySet();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Map.Entry)element$iv$iv;
            boolean bl = false;
            if (!((List)it.getValue()).contains($this$frontendClass)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((Class)it.getKey());
        }
        return (Class)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final TranslationResult analyze$lambda-2(TranslationManager this$0, TranslationResult $result) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$result, (String)"$result");
        ScopeManager scopesBuildForAnalysis = new ScopeManager();
        Benchmark outerBench = new Benchmark(TranslationManager.class, "Translation into full graph", false, 4, null);
        Set passesNeedCleanup = new LinkedHashSet();
        Set<LanguageFrontend> frontendsNeedCleanup = null;
        try {
            Benchmark bench = new Benchmark(this$0.getClass(), "Frontend", false, 4, null);
            frontendsNeedCleanup = this$0.runFrontends($result, this$0.config, scopesBuildForAnalysis);
            bench.stop();
            for (Pass pass : this$0.config.getRegisteredPasses()) {
                Intrinsics.checkNotNullExpressionValue((Object)pass, (String)"pass");
                passesNeedCleanup.add(pass);
                bench = new Benchmark(pass.getClass(), "Executing Pass", false, 4, null);
                pass.accept($result);
                bench.stop();
                if (!$result.isCancelled()) continue;
                log.warn("Analysis interrupted, stopping Pass evaluation");
            }
            outerBench.stop();
        }
        catch (TranslationException ex) {
            try {
                throw new CompletionException(ex);
            }
            catch (Throwable throwable) {
                outerBench.stop();
                if (!this$0.config.disableCleanup) {
                    log.debug("Cleaning up {} Passes", (Object)passesNeedCleanup.size());
                    Iterable $this$forEach$iv = passesNeedCleanup;
                    boolean bl = false;
                    for (Object element$iv : $this$forEach$iv) {
                        Pass it = (Pass)element$iv;
                        boolean bl2 = false;
                        it.cleanup();
                    }
                    Set<LanguageFrontend> set = frontendsNeedCleanup;
                    log.debug("Cleaning up {} Frontends", (Object)(set == null ? null : Integer.valueOf(set.size())));
                    Set<LanguageFrontend> set2 = frontendsNeedCleanup;
                    if (set2 != null) {
                        Iterable iterable = set2;
                        boolean $i$f$forEach2 = false;
                        for (Object element$iv : iterable) {
                            LanguageFrontend it = (LanguageFrontend)element$iv;
                            boolean bl3 = false;
                            it.cleanup();
                        }
                    }
                    TypeManager.getInstance().cleanup();
                }
                throw throwable;
            }
        }
        if (!this$0.config.disableCleanup) {
            log.debug("Cleaning up {} Passes", (Object)passesNeedCleanup.size());
            Iterable $this$forEach$iv = passesNeedCleanup;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Pass it = (Pass)element$iv;
                boolean bl = false;
                it.cleanup();
            }
            Set<LanguageFrontend> set = frontendsNeedCleanup;
            log.debug("Cleaning up {} Frontends", (Object)(set == null ? null : Integer.valueOf(set.size())));
            Set<LanguageFrontend> set3 = frontendsNeedCleanup;
            if (set3 != null) {
                Iterable $this$forEach$iv3 = set3;
                boolean bl = false;
                for (Object element$iv : $this$forEach$iv3) {
                    LanguageFrontend it = (LanguageFrontend)element$iv;
                    boolean bl4 = false;
                    it.cleanup();
                }
            }
            TypeManager.getInstance().cleanup();
        }
        return $result;
    }

    private static final boolean runFrontends$lambda-5$lambda-3(Path $noName_0, BasicFileAttributes fileAttr) {
        Intrinsics.checkNotNullParameter((Object)fileAttr, (String)"fileAttr");
        return fileAttr.isRegularFile();
    }

    private static final File runFrontends$lambda-5$lambda-4(Path it) {
        return it.toFile();
    }

    private static final Optional parseParallel$lambda-9(TranslationManager this$0, TranslationResult $result, ScopeManager $scopeManager, File $sourceLocation) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$result, (String)"$result");
        Intrinsics.checkNotNullParameter((Object)$scopeManager, (String)"$scopeManager");
        Intrinsics.checkNotNullParameter((Object)$sourceLocation, (String)"$sourceLocation");
        try {
            return this$0.parse($result, $scopeManager, $sourceLocation);
        }
        catch (TranslationException e) {
            throw new RuntimeException(Intrinsics.stringPlus((String)"Error parsing ", (Object)$sourceLocation), e);
        }
    }

    private static final void parseParallel$lambda-10(TranslationManager this$0, TranslationResult $result, Set $usedFrontends, Map $futureToFile, CompletableFuture $future, LanguageFrontend f) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$result, (String)"$result");
        Intrinsics.checkNotNullParameter((Object)$usedFrontends, (String)"$usedFrontends");
        Intrinsics.checkNotNullParameter((Object)$futureToFile, (String)"$futureToFile");
        Intrinsics.checkNotNullParameter((Object)$future, (String)"$future");
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        this$0.handleCompletion($result, $usedFrontends, (File)$futureToFile.get($future), f);
    }

    private static final void parseSequentially$lambda-12(TranslationManager this$0, TranslationResult $result, Set $usedFrontends, File $sourceLocation, LanguageFrontend f) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$result, (String)"$result");
        Intrinsics.checkNotNullParameter((Object)$usedFrontends, (String)"$usedFrontends");
        Intrinsics.checkNotNullParameter((Object)$sourceLocation, (String)"$sourceLocation");
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        this$0.handleCompletion($result, $usedFrontends, $sourceLocation, f);
    }

    private static final Object handleCompletion$lambda-14(String it) {
        return new LinkedHashMap();
    }

    @JvmStatic
    @NotNull
    public static final Builder builder() {
        return Companion.builder();
    }

    public /* synthetic */ TranslationManager(TranslationConfiguration config, DefaultConstructorMarker $constructor_marker) {
        this(config);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0003\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lde/fraunhofer/aisec/cpg/TranslationManager$Builder;", "", "()V", "config", "Lde/fraunhofer/aisec/cpg/TranslationConfiguration;", "build", "Lde/fraunhofer/aisec/cpg/TranslationManager;", "cpg-library"})
    public static final class Builder {
        @NotNull
        private TranslationConfiguration config;

        public Builder() {
            TranslationConfiguration translationConfiguration = TranslationConfiguration.builder().build();
            Intrinsics.checkNotNullExpressionValue((Object)translationConfiguration, (String)"builder().build()");
            this.config = translationConfiguration;
        }

        @NotNull
        public final Builder config(@NotNull TranslationConfiguration config) {
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            this.config = config;
            return this;
        }

        @NotNull
        public final TranslationManager build() {
            return new TranslationManager(this.config, null);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0007R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lde/fraunhofer/aisec/cpg/TranslationManager$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "builder", "Lde/fraunhofer/aisec/cpg/TranslationManager$Builder;", "cpg-library"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Builder builder() {
            return new Builder();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

