/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.passes;

import de.fraunhofer.aisec.cpg.TranslationResult;
import de.fraunhofer.aisec.cpg.frontends.java.JavaLanguageFrontend;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.NodeBuilder;
import de.fraunhofer.aisec.cpg.graph.declarations.Declaration;
import de.fraunhofer.aisec.cpg.graph.declarations.EnumConstantDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.EnumDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.FieldDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.FunctionDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.MethodDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.RecordDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.TranslationUnitDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.ValueDeclaration;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.DeclaredReferenceExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.MemberCallExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.MemberExpression;
import de.fraunhofer.aisec.cpg.graph.types.FunctionPointerType;
import de.fraunhofer.aisec.cpg.graph.types.Type;
import de.fraunhofer.aisec.cpg.graph.types.TypeParser;
import de.fraunhofer.aisec.cpg.graph.types.UnknownType;
import de.fraunhofer.aisec.cpg.helpers.SubgraphWalker;
import de.fraunhofer.aisec.cpg.helpers.Util;
import de.fraunhofer.aisec.cpg.passes.Pass;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VariableUsageResolver
extends Pass {
    private static final Logger log = LoggerFactory.getLogger(VariableUsageResolver.class);
    private Map<Type, List<Type>> superTypesMap = new HashMap<Type, List<Type>>();
    private Map<Type, RecordDeclaration> recordMap = new HashMap<Type, RecordDeclaration>();
    private Map<Type, EnumDeclaration> enumMap = new HashMap<Type, EnumDeclaration>();
    private TranslationUnitDeclaration currTu;
    private SubgraphWalker.ScopedWalker walker;

    @Override
    public void cleanup() {
        this.superTypesMap.clear();
        if (this.recordMap != null) {
            this.recordMap.clear();
        }
        this.enumMap.clear();
    }

    @Override
    public void accept(TranslationResult result) {
        this.walker = new SubgraphWalker.ScopedWalker(this.lang);
        Iterator<TranslationUnitDeclaration> iterator = result.getTranslationUnits().iterator();
        while (iterator.hasNext()) {
            TranslationUnitDeclaration tu;
            this.currTu = tu = iterator.next();
            this.walker.clearCallbacks();
            this.walker.registerHandler((currClass, parent, currNode) -> this.walker.collectDeclarations((Node)currNode));
            this.walker.registerHandler(this::findRecordsAndEnums);
            this.walker.iterate(this.currTu);
        }
        Map<Type, List> currSuperTypes = this.recordMap.values().stream().collect(Collectors.toMap(r -> TypeParser.createFrom(r.getName(), true), RecordDeclaration::getSuperTypes));
        this.superTypesMap.putAll(currSuperTypes);
        for (TranslationUnitDeclaration tu : result.getTranslationUnits()) {
            this.walker.clearCallbacks();
            this.walker.registerHandler(this::resolveFieldUsages);
            this.walker.iterate(tu);
        }
        for (TranslationUnitDeclaration tu : result.getTranslationUnits()) {
            this.walker.clearCallbacks();
            this.walker.registerHandler(this::resolveLocalVarUsage);
            this.walker.iterate(tu);
        }
    }

    private void findRecordsAndEnums(Node node, RecordDeclaration curClass) {
        if (node instanceof RecordDeclaration) {
            Type type = TypeParser.createFrom(node.getName(), true);
            this.recordMap.putIfAbsent(type, (RecordDeclaration)node);
        } else if (node instanceof EnumDeclaration) {
            Type type = TypeParser.createFrom(node.getName(), true);
            this.enumMap.putIfAbsent(type, (EnumDeclaration)node);
        }
    }

    private Optional<? extends ValueDeclaration> resolveFunctionPtr(Type containingClass, DeclaredReferenceExpression reference) {
        if (!(reference.getType() instanceof FunctionPointerType)) {
            log.error("Can't resolve a function pointer without a function pointer type!");
            return Optional.empty();
        }
        FunctionPointerType fptrType = (FunctionPointerType)reference.getType();
        Optional<Object> target = Optional.empty();
        String functionName = reference.getName();
        Matcher matcher = Pattern.compile("(?:(?<class>.*)(?:\\.|::))?(?<function>.*)").matcher(reference.getName());
        if (matcher.matches()) {
            String cls = matcher.group("class");
            String finalFunctionName = functionName = matcher.group("function");
            if (cls == null) {
                log.error("Resolution of pointers to functions inside the current scope should have been done by the ScopeManager");
            } else {
                containingClass = TypeParser.createFrom(cls, true);
                if (this.recordMap.containsKey(containingClass)) {
                    target = this.recordMap.get(containingClass).getMethods().stream().map(FunctionDeclaration.class::cast).filter(f -> f.getName().equals(finalFunctionName) && f.getType().equals(fptrType.getReturnType()) && f.hasSignature(fptrType.getParameters())).findFirst();
                }
            }
        }
        if (target.isPresent()) {
            return target;
        }
        target = containingClass == null ? Optional.of(this.handleUnknownMethod(functionName, fptrType.getReturnType(), fptrType.getParameters())) : Optional.ofNullable(this.handleUnknownClassMethod(containingClass, functionName, fptrType.getReturnType(), fptrType.getParameters()));
        return target;
    }

    private void resolveLocalVarUsage(RecordDeclaration currentClass, Node parent, Node current) {
        if (current instanceof DeclaredReferenceExpression && !(current instanceof MemberExpression)) {
            List<String> path;
            DeclaredReferenceExpression ref = (DeclaredReferenceExpression)current;
            if (parent instanceof MemberCallExpression && current == ((MemberCallExpression)parent).getMember() && !(ref.getType() instanceof FunctionPointerType)) {
                return;
            }
            Optional<ValueDeclaration> refersTo = Optional.ofNullable(this.lang.getScopeManager().resolveReference(ref));
            Type recordDeclType = null;
            if (currentClass != null) {
                recordDeclType = TypeParser.createFrom(currentClass.getName(), true);
            }
            if (ref.getType() instanceof FunctionPointerType && refersTo.isEmpty()) {
                refersTo = this.resolveFunctionPtr(recordDeclType, ref);
            }
            if (refersTo.isEmpty() && !((DeclaredReferenceExpression)current).isStaticAccess() && recordDeclType != null && this.recordMap.containsKey(recordDeclType)) {
                ValueDeclaration field;
                if (current.getName().contains(this.lang.getNamespaceDelimiter())) {
                    path = Arrays.asList(current.getName().split(Pattern.quote(this.lang.getNamespaceDelimiter())));
                    recordDeclType = TypeParser.createFrom(String.join((CharSequence)this.lang.getNamespaceDelimiter(), path.subList(0, path.size() - 1)), true);
                }
                if ((field = this.resolveMember(recordDeclType, (DeclaredReferenceExpression)current)) != null) {
                    refersTo = Optional.of(field);
                }
            }
            if (refersTo.isEmpty() && current.getName().contains(this.lang.getNamespaceDelimiter())) {
                path = Arrays.asList(current.getName().split(Pattern.quote(this.lang.getNamespaceDelimiter())));
                recordDeclType = TypeParser.createFrom(String.join((CharSequence)this.lang.getNamespaceDelimiter(), path.subList(0, path.size() - 1)), true);
                ValueDeclaration field = this.resolveMember(recordDeclType, (DeclaredReferenceExpression)current);
                if (field != null) {
                    refersTo = Optional.of(field);
                }
            }
            if (refersTo.isPresent()) {
                ref.setRefersTo(refersTo.get());
            } else {
                Util.warnWithFileLocation(current, log, "Did not find a declaration for {}", ref.getName());
            }
        }
    }

    private void resolveFieldUsages(Node current, RecordDeclaration curClass) {
        if (current instanceof MemberExpression) {
            Type baseType;
            MemberExpression memberExpression = (MemberExpression)current;
            Declaration baseTarget = null;
            if (memberExpression.getBase() instanceof DeclaredReferenceExpression) {
                DeclaredReferenceExpression base = (DeclaredReferenceExpression)memberExpression.getBase();
                if (this.lang instanceof JavaLanguageFrontend && base.getName().equals("super")) {
                    if (curClass != null && !curClass.getSuperClasses().isEmpty()) {
                        Type superType = curClass.getSuperClasses().get(0);
                        RecordDeclaration superRecord = this.recordMap.get(superType);
                        if (superRecord == null) {
                            log.error("Could not find referring super type {} for {} in the record map. Will set the super type to java.lang.Object", (Object)superType.getTypeName(), (Object)curClass.getName());
                            base.setType(TypeParser.createFrom(Object.class.getName(), true));
                        } else {
                            baseTarget = superRecord.getThis();
                            base.setRefersTo(baseTarget);
                        }
                    } else {
                        Type objectType = TypeParser.createFrom(Object.class.getName(), true);
                        base.setType(objectType);
                    }
                } else {
                    baseTarget = this.resolveBase((DeclaredReferenceExpression)memberExpression.getBase());
                    base.setRefersTo(baseTarget);
                }
                if (baseTarget instanceof EnumDeclaration) {
                    String name = memberExpression.getName();
                    Optional<EnumConstantDeclaration> memberTarget = ((EnumDeclaration)baseTarget).getEntries().stream().filter(e -> e.getName().equals(name)).findFirst();
                    if (memberTarget.isPresent()) {
                        memberExpression.setRefersTo(memberTarget.get());
                        return;
                    }
                } else if (baseTarget instanceof RecordDeclaration) {
                    Type baseType2 = TypeParser.createFrom(baseTarget.getName(), true);
                    if (!this.recordMap.containsKey(baseType2)) {
                        Type containingT = baseType2;
                        Optional<Type> fqnResolvedType = this.recordMap.keySet().stream().filter(t -> t.getName().endsWith("." + containingT.getName())).findFirst();
                        if (fqnResolvedType.isPresent()) {
                            baseType2 = fqnResolvedType.get();
                        }
                    }
                    memberExpression.setRefersTo(this.resolveMember(baseType2, memberExpression));
                    return;
                }
            }
            if (!this.recordMap.containsKey(baseType = memberExpression.getBase().getType())) {
                Type containingT = baseType;
                Optional<Type> fqnResolvedType = this.recordMap.keySet().stream().filter(t -> t.getName().endsWith("." + containingT.getName())).findFirst();
                if (fqnResolvedType.isPresent()) {
                    baseType = fqnResolvedType.get();
                }
            }
            memberExpression.setRefersTo(this.resolveMember(baseType, memberExpression));
        }
    }

    private @Nullable Declaration resolveBase(DeclaredReferenceExpression reference) {
        ValueDeclaration declaration = this.lang.getScopeManager().resolveReference(reference);
        if (declaration != null) {
            return declaration;
        }
        if (this.enumMap.containsKey(reference.getType())) {
            return this.enumMap.get(reference.getType());
        }
        if (this.recordMap.containsKey(reference.getType())) {
            RecordDeclaration recordDeclaration = this.recordMap.get(reference.getType());
            if (reference.isStaticAccess()) {
                return recordDeclaration;
            }
            if (recordDeclaration.getThis() != null) {
                return recordDeclaration.getThis();
            }
            return recordDeclaration;
        }
        return null;
    }

    private ValueDeclaration resolveMember(Type containingClass, DeclaredReferenceExpression reference) {
        if (this.lang instanceof JavaLanguageFrontend && reference.getName().matches("(?<class>.+\\.)?super")) {
            return null;
        }
        String simpleName = Util.getSimpleName(this.lang.getNamespaceDelimiter(), reference.getName());
        Optional<FieldDeclaration> member = Optional.empty();
        if (!(containingClass instanceof UnknownType) && this.recordMap.containsKey(containingClass)) {
            member = this.recordMap.get(containingClass).getFields().stream().filter(f -> f.getName().equals(simpleName)).map(FieldDeclaration::getDefinition).findFirst();
        }
        if (member.isEmpty()) {
            member = this.superTypesMap.getOrDefault(containingClass, Collections.emptyList()).stream().map(this.recordMap::get).filter(Objects::nonNull).flatMap(r -> r.getFields().stream()).filter(f -> f.getName().equals(simpleName)).map(FieldDeclaration::getDefinition).findFirst();
        }
        return member.orElseGet(() -> this.handleUnknownField(containingClass, reference.getName(), reference.getType()));
    }

    private FieldDeclaration handleUnknownField(Type base, String name, Type type) {
        if (!this.recordMap.containsKey(base)) {
            return null;
        }
        List<FieldDeclaration> declarations = this.recordMap.get(base).getFields();
        Optional<FieldDeclaration> target = declarations.stream().filter(f -> f.getName().equals(name)).findFirst();
        if (target.isEmpty()) {
            FieldDeclaration declaration = NodeBuilder.newFieldDeclaration(name, type, Collections.emptyList(), "", null, null, false);
            this.recordMap.get(base).addField(declaration);
            declaration.setInferred(true);
            return declaration;
        }
        return target.get();
    }

    private MethodDeclaration handleUnknownClassMethod(Type base, String name, Type returnType, List<Type> signature) {
        if (!this.recordMap.containsKey(base)) {
            return null;
        }
        RecordDeclaration containingRecord = this.recordMap.get(base);
        Optional<MethodDeclaration> target = containingRecord.getMethods().stream().filter(f -> f.getName().equals(name)).filter(f -> f.getType().equals(returnType)).filter(f -> f.hasSignature(signature)).findFirst();
        if (target.isEmpty()) {
            MethodDeclaration declaration = NodeBuilder.newMethodDeclaration(name, "", false, containingRecord);
            declaration.setType(returnType);
            declaration.setParameters(Util.createInferredParameters(signature));
            containingRecord.addMethod(declaration);
            declaration.setInferred(true);
            return declaration;
        }
        return target.get();
    }

    private FunctionDeclaration handleUnknownMethod(String name, Type returnType, List<Type> signature) {
        Optional<FunctionDeclaration> target = this.currTu.getDeclarations().stream().filter(FunctionDeclaration.class::isInstance).map(FunctionDeclaration.class::cast).filter(f -> f.getName().equals(name)).filter(f -> f.getType().equals(returnType)).filter(f -> f.hasSignature(signature)).findFirst();
        if (target.isEmpty()) {
            FunctionDeclaration declaration = NodeBuilder.newFunctionDeclaration(name, "");
            declaration.setType(returnType);
            declaration.setParameters(Util.createInferredParameters(signature));
            this.currTu.addDeclaration(declaration);
            declaration.setInferred(true);
            return declaration;
        }
        return target.get();
    }
}

