/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.graph.types;

import de.fraunhofer.aisec.cpg.graph.edge.PropertyEdge;
import de.fraunhofer.aisec.cpg.graph.types.PointerType;
import de.fraunhofer.aisec.cpg.graph.types.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.neo4j.ogm.annotation.Relationship;

public class FunctionPointerType
extends Type {
    @Relationship(value="PARAMETERS", direction="OUTGOING")
    private List<PropertyEdge<Type>> parameters;
    private Type returnType;

    public void setParameters(List<Type> parameters) {
        this.parameters = PropertyEdge.transformIntoOutgoingPropertyEdgeList(parameters, this);
    }

    public void setReturnType(Type returnType) {
        this.returnType = returnType;
    }

    private FunctionPointerType() {
    }

    public FunctionPointerType(Type.Qualifier qualifier, Type.Storage storage, List<Type> parameters, Type returnType) {
        super("", storage, qualifier);
        this.parameters = PropertyEdge.transformIntoOutgoingPropertyEdgeList(parameters, this);
        this.returnType = returnType;
    }

    public FunctionPointerType(Type type, List<Type> parameters, Type returnType) {
        super(type);
        this.parameters = PropertyEdge.transformIntoOutgoingPropertyEdgeList(parameters, this);
        this.returnType = returnType;
    }

    public List<PropertyEdge<Type>> getParametersPropertyEdge() {
        return this.parameters;
    }

    public List<Type> getParameters() {
        return PropertyEdge.unwrap(this.parameters);
    }

    public Type getReturnType() {
        return this.returnType;
    }

    @Override
    public PointerType reference(PointerType.PointerOrigin pointerOrigin) {
        return new PointerType(this, pointerOrigin);
    }

    @Override
    public Type dereference() {
        return this;
    }

    @Override
    public Type duplicate() {
        ArrayList<Type> copiedParameters = new ArrayList<Type>(PropertyEdge.unwrap(this.parameters));
        return new FunctionPointerType(this, copiedParameters, this.returnType);
    }

    @Override
    public boolean isSimilar(Type t) {
        if (t instanceof FunctionPointerType) {
            if (this.returnType == null || ((FunctionPointerType)t).returnType == null) {
                return this.parameters.equals(((FunctionPointerType)t).parameters) && (this.returnType == ((FunctionPointerType)t).returnType || this.returnType == ((FunctionPointerType)t).getReturnType());
            }
            return this.parameters.equals(((FunctionPointerType)t).parameters) && (this.returnType == ((FunctionPointerType)t).returnType || this.returnType.equals(((FunctionPointerType)t).returnType));
        }
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FunctionPointerType)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FunctionPointerType that = (FunctionPointerType)o;
        return Objects.equals(this.getParameters(), that.getParameters()) && PropertyEdge.propertyEqualsList(this.parameters, that.parameters) && Objects.equals(this.returnType, that.returnType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.parameters, this.returnType);
    }

    @Override
    public String toString() {
        return "FunctionPointerType{parameters=" + this.parameters + ", returnType=" + this.returnType + ", typeName='" + this.getName() + "', storage=" + this.getStorage() + ", qualifier=" + this.getQualifier() + ", origin=" + this.getTypeOrigin() + "}";
    }
}

