/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.graph.declarations;

import de.fraunhofer.aisec.cpg.graph.declarations.Declaration;
import de.fraunhofer.aisec.cpg.graph.declarations.FunctionDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.ParamVariableDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.TemplateDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.TypeParamDeclaration;
import de.fraunhofer.aisec.cpg.graph.edge.Properties;
import de.fraunhofer.aisec.cpg.graph.edge.PropertyEdge;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.neo4j.ogm.annotation.Relationship;

public class FunctionTemplateDeclaration
extends TemplateDeclaration {
    @Relationship(value="REALIZATION", direction="OUTGOING")
    private List<PropertyEdge<FunctionDeclaration>> realization = new ArrayList<PropertyEdge<FunctionDeclaration>>();

    public List<FunctionDeclaration> getRealization() {
        return PropertyEdge.unwrap(this.realization);
    }

    @Override
    public List<Declaration> getRealizationDeclarations() {
        return new ArrayList<Declaration>(this.getRealization());
    }

    public List<PropertyEdge<FunctionDeclaration>> getRealizationPropertyEdge() {
        return this.realization;
    }

    public void addRealization(FunctionDeclaration realizedFunction) {
        PropertyEdge<FunctionDeclaration> propertyEdge = new PropertyEdge<FunctionDeclaration>(this, realizedFunction);
        propertyEdge.addProperty(Properties.INDEX, this.realization.size());
        this.realization.add(propertyEdge);
    }

    public void removeRealization(FunctionDeclaration realizedFunction) {
        this.realization.removeIf(propertyEdge -> ((FunctionDeclaration)propertyEdge.getEnd()).equals(realizedFunction));
    }

    @Override
    public void addDeclaration(@NonNull Declaration declaration) {
        if (declaration instanceof TypeParamDeclaration || declaration instanceof ParamVariableDeclaration) {
            this.addIfNotContains(this.parameters, declaration);
        } else if (declaration instanceof FunctionDeclaration) {
            this.addIfNotContains(this.realization, (FunctionDeclaration)declaration);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FunctionTemplateDeclaration that = (FunctionTemplateDeclaration)o;
        return this.realization.equals(that.realization) && this.parameters.equals(that.parameters);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode());
    }
}

