/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.graph;

import de.fraunhofer.aisec.cpg.graph.Annotation;
import de.fraunhofer.aisec.cpg.graph.Persistable;
import de.fraunhofer.aisec.cpg.graph.SubGraph;
import de.fraunhofer.aisec.cpg.graph.declarations.TypedefDeclaration;
import de.fraunhofer.aisec.cpg.graph.edge.Properties;
import de.fraunhofer.aisec.cpg.graph.edge.PropertyEdge;
import de.fraunhofer.aisec.cpg.helpers.LocationConverter;
import de.fraunhofer.aisec.cpg.processing.IVisitable;
import de.fraunhofer.aisec.cpg.sarif.PhysicalLocation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.ogm.annotation.GeneratedValue;
import org.neo4j.ogm.annotation.Id;
import org.neo4j.ogm.annotation.Relationship;
import org.neo4j.ogm.annotation.typeconversion.Convert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010#\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0010\u001e\n\u0002\b\r\n\u0002\u0010\u0000\n\u0002\b\n\b\u0016\u0018\u0000 j2\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002:\u0001jB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0014\u0010Q\u001a\u00020R2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060SJ\u000e\u0010T\u001a\u00020R2\u0006\u0010U\u001a\u00020\u0000J\u0014\u0010V\u001a\u00020R2\f\u0010W\u001a\b\u0012\u0004\u0012\u00020\u00000@J\u000e\u0010X\u001a\u00020R2\u0006\u0010Y\u001a\u00020\u0000J\u0014\u0010Z\u001a\u00020R2\f\u0010W\u001a\b\u0012\u0004\u0012\u00020\u00000@J\u000e\u0010[\u001a\u00020R2\u0006\u0010\\\u001a\u00020NJ\u0006\u0010]\u001a\u00020RJ\u0006\u0010^\u001a\u00020RJ\u0013\u0010_\u001a\u00020%2\b\u0010`\u001a\u0004\u0018\u00010aH\u0096\u0002J\b\u0010b\u001a\u00020\fH\u0016J\u0010\u0010c\u001a\u00020R2\b\u0010U\u001a\u0004\u0018\u00010\u0000J\u0010\u0010d\u001a\u00020R2\b\u0010Y\u001a\u0004\u0018\u00010\u0000J\u0016\u0010e\u001a\u00020R2\f\u0010f\u001a\b\u0012\u0004\u0012\u00020\u00000;H\u0002J\u000e\u0010g\u001a\u00020R2\u0006\u0010h\u001a\u00020\u0000J\b\u0010i\u001a\u00020\u0012H\u0016R$\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0014\"\u0004\b\u0019\u0010\u0016R\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0014\"\u0004\b\u001c\u0010\u0016R\"\u0010\u001d\u001a\u0004\u0018\u00010\u001e8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0010\n\u0002\u0010#\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001a\u0010$\u001a\u00020%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010&\"\u0004\b'\u0010(R\u001a\u0010)\u001a\u00020%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010&\"\u0004\b*\u0010(R \u0010+\u001a\u0004\u0018\u00010,8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R\u001a\u00101\u001a\u00020\u0012X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010\u0014\"\u0004\b3\u0010\u0016R$\u00104\u001a\b\u0012\u0004\u0012\u00020\u0000058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u00107\"\u0004\b8\u00109R0\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00000;2\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00000;8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b=\u0010\b\"\u0004\b>\u0010\nR>\u0010A\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00000@0\u00052\u0012\u0010?\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00000@0\u00058\u0006@DX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bB\u0010\b\"\u0004\bC\u0010\nR$\u0010D\u001a\b\u0012\u0004\u0012\u00020\u0000058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bE\u00107\"\u0004\bF\u00109R0\u0010G\u001a\b\u0012\u0004\u0012\u00020\u00000;2\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00000;8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bH\u0010\b\"\u0004\bI\u0010\nR>\u0010J\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00000@0\u00052\u0012\u0010?\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00000@0\u00058\u0006@DX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bK\u0010\b\"\u0004\bL\u0010\nR \u0010M\u001a\b\u0012\u0004\u0012\u00020N05X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bO\u00107\"\u0004\bP\u00109\u00a8\u0006k"}, d2={"Lde/fraunhofer/aisec/cpg/graph/Node;", "Lde/fraunhofer/aisec/cpg/processing/IVisitable;", "Lde/fraunhofer/aisec/cpg/graph/Persistable;", "()V", "annotations", "", "Lde/fraunhofer/aisec/cpg/graph/Annotation;", "getAnnotations", "()Ljava/util/List;", "setAnnotations", "(Ljava/util/List;)V", "argumentIndex", "", "getArgumentIndex", "()I", "setArgumentIndex", "(I)V", "code", "", "getCode", "()Ljava/lang/String;", "setCode", "(Ljava/lang/String;)V", "comment", "getComment", "setComment", "file", "getFile", "setFile", "id", "", "getId", "()Ljava/lang/Long;", "setId", "(Ljava/lang/Long;)V", "Ljava/lang/Long;", "isImplicit", "", "()Z", "setImplicit", "(Z)V", "isInferred", "setInferred", "location", "Lde/fraunhofer/aisec/cpg/sarif/PhysicalLocation;", "getLocation", "()Lde/fraunhofer/aisec/cpg/sarif/PhysicalLocation;", "setLocation", "(Lde/fraunhofer/aisec/cpg/sarif/PhysicalLocation;)V", "name", "getName", "setName", "nextDFG", "", "getNextDFG", "()Ljava/util/Set;", "setNextDFG", "(Ljava/util/Set;)V", "value", "", "nextEOG", "getNextEOG", "setNextEOG", "<set-?>", "Lde/fraunhofer/aisec/cpg/graph/edge/PropertyEdge;", "nextEOGEdges", "getNextEOGEdges", "setNextEOGEdges", "prevDFG", "getPrevDFG", "setPrevDFG", "prevEOG", "getPrevEOG", "setPrevEOG", "prevEOGEdges", "getPrevEOGEdges", "setPrevEOGEdges", "typedefs", "Lde/fraunhofer/aisec/cpg/graph/declarations/TypedefDeclaration;", "getTypedefs", "setTypedefs", "addAnnotations", "", "", "addNextDFG", "next", "addNextEOG", "propertyEdge", "addPrevDFG", "prev", "addPrevEOG", "addTypedef", "typedef", "clearNextEOG", "disconnectFromGraph", "equals", "other", "", "hashCode", "removeNextDFG", "removePrevDFG", "removePrevEOGEntries", "prevEOGs", "removePrevEOGEntry", "eog", "toString", "Companion", "cpg-library"})
public class Node
implements IVisitable<Node>,
Persistable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String name = "";
    @Nullable
    private String code;
    @Nullable
    private String comment;
    @Convert(value=LocationConverter.class)
    @Nullable
    private PhysicalLocation location;
    @Nullable
    private String file;
    @Relationship(value="EOG", direction="INCOMING")
    @NotNull
    private List<PropertyEdge<Node>> prevEOGEdges = new ArrayList();
    @Relationship(value="EOG", direction="OUTGOING")
    @NotNull
    private List<PropertyEdge<Node>> nextEOGEdges = new ArrayList();
    @Relationship(value="DFG", direction="INCOMING")
    @NotNull
    private Set<Node> prevDFG = new HashSet();
    @Relationship(value="DFG")
    @NotNull
    private Set<Node> nextDFG = new HashSet();
    @NotNull
    private Set<TypedefDeclaration> typedefs = new HashSet();
    private boolean isInferred;
    private boolean isImplicit;
    @Id
    @GeneratedValue
    @Nullable
    private Long id;
    private int argumentIndex;
    @SubGraph(value={"AST"})
    @NotNull
    private List<Annotation> annotations = new ArrayList();
    @JvmField
    @NotNull
    public static ToStringStyle TO_STRING_STYLE;
    @NotNull
    private static final Logger log;
    @NotNull
    public static final String EMPTY_NAME = "";

    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.name = string;
    }

    @Nullable
    public final String getCode() {
        return this.code;
    }

    public final void setCode(@Nullable String string) {
        this.code = string;
    }

    @Nullable
    public final String getComment() {
        return this.comment;
    }

    public final void setComment(@Nullable String string) {
        this.comment = string;
    }

    @Nullable
    public final PhysicalLocation getLocation() {
        return this.location;
    }

    public final void setLocation(@Nullable PhysicalLocation physicalLocation) {
        this.location = physicalLocation;
    }

    @Nullable
    public final String getFile() {
        return this.file;
    }

    public final void setFile(@Nullable String string) {
        this.file = string;
    }

    @NotNull
    public final List<PropertyEdge<Node>> getPrevEOGEdges() {
        return this.prevEOGEdges;
    }

    protected final void setPrevEOGEdges(@NotNull List<PropertyEdge<Node>> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.prevEOGEdges = list;
    }

    @NotNull
    public final List<PropertyEdge<Node>> getNextEOGEdges() {
        return this.nextEOGEdges;
    }

    protected final void setNextEOGEdges(@NotNull List<PropertyEdge<Node>> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.nextEOGEdges = list;
    }

    @NotNull
    public final List<Node> getPrevEOG() {
        return PropertyEdge.Companion.unwrap(this.prevEOGEdges, false);
    }

    public final void setPrevEOG(@NotNull List<? extends Node> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        List propertyEdgesEOG = new ArrayList();
        Iterator<? extends Node> iterator = value.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int idx = n++;
            Node prev = iterator.next();
            PropertyEdge<Node> propertyEdge = new PropertyEdge<Node>(prev, this);
            propertyEdge.addProperty(Properties.INDEX, idx);
            propertyEdgesEOG.add(propertyEdge);
        }
        this.prevEOGEdges = propertyEdgesEOG;
    }

    @NotNull
    public final List<Node> getNextEOG() {
        return PropertyEdge.Companion.unwrap$default(PropertyEdge.Companion, this.nextEOGEdges, false, 2, null);
    }

    public final void setNextEOG(@NotNull List<? extends Node> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.nextEOGEdges = PropertyEdge.Companion.transformIntoOutgoingPropertyEdgeList(value, this);
    }

    @NotNull
    public final Set<Node> getPrevDFG() {
        return this.prevDFG;
    }

    public final void setPrevDFG(@NotNull Set<Node> set) {
        Intrinsics.checkNotNullParameter(set, (String)"<set-?>");
        this.prevDFG = set;
    }

    @NotNull
    public final Set<Node> getNextDFG() {
        return this.nextDFG;
    }

    public final void setNextDFG(@NotNull Set<Node> set) {
        Intrinsics.checkNotNullParameter(set, (String)"<set-?>");
        this.nextDFG = set;
    }

    @NotNull
    public final Set<TypedefDeclaration> getTypedefs() {
        return this.typedefs;
    }

    public final void setTypedefs(@NotNull Set<TypedefDeclaration> set) {
        Intrinsics.checkNotNullParameter(set, (String)"<set-?>");
        this.typedefs = set;
    }

    public final boolean isInferred() {
        return this.isInferred;
    }

    public final void setInferred(boolean bl) {
        this.isInferred = bl;
    }

    public final boolean isImplicit() {
        return this.isImplicit;
    }

    public final void setImplicit(boolean bl) {
        this.isImplicit = bl;
    }

    @Nullable
    public final Long getId() {
        return this.id;
    }

    public final void setId(@Nullable Long l) {
        this.id = l;
    }

    public final int getArgumentIndex() {
        return this.argumentIndex;
    }

    public final void setArgumentIndex(int n) {
        this.argumentIndex = n;
    }

    @NotNull
    public final List<Annotation> getAnnotations() {
        return this.annotations;
    }

    public final void setAnnotations(@NotNull List<Annotation> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.annotations = list;
    }

    public final void removePrevEOGEntry(@NotNull Node eog) {
        Intrinsics.checkNotNullParameter((Object)eog, (String)"eog");
        this.removePrevEOGEntries(CollectionsKt.listOf((Object)eog));
    }

    private final void removePrevEOGEntries(List<? extends Node> prevEOGs) {
        for (Node node : prevEOGs) {
            List<PropertyEdge> remove = PropertyEdge.Companion.findPropertyEdgesByPredicate((Collection)this.prevEOGEdges, arg_0 -> Node.removePrevEOGEntries$lambda-0(node, arg_0));
            this.prevEOGEdges.removeAll((Collection)remove);
        }
    }

    public final void addPrevEOG(@NotNull PropertyEdge<Node> propertyEdge) {
        Intrinsics.checkNotNullParameter(propertyEdge, (String)"propertyEdge");
        this.prevEOGEdges.add(propertyEdge);
    }

    public final void addNextEOG(@NotNull PropertyEdge<Node> propertyEdge) {
        Intrinsics.checkNotNullParameter(propertyEdge, (String)"propertyEdge");
        this.nextEOGEdges.add(propertyEdge);
    }

    public final void clearNextEOG() {
        this.nextEOGEdges.clear();
    }

    public final void addNextDFG(@NotNull Node next) {
        Intrinsics.checkNotNullParameter((Object)next, (String)"next");
        this.nextDFG.add(next);
        next.prevDFG.add(this);
    }

    public final void removeNextDFG(@Nullable Node next) {
        if (next != null) {
            this.nextDFG.remove(next);
            next.prevDFG.remove(this);
        }
    }

    public final void addPrevDFG(@NotNull Node prev) {
        Intrinsics.checkNotNullParameter((Object)prev, (String)"prev");
        this.prevDFG.add(prev);
        prev.nextDFG.add(this);
    }

    public final void removePrevDFG(@Nullable Node prev) {
        if (prev != null) {
            this.prevDFG.remove(prev);
            prev.nextDFG.remove(this);
        }
    }

    public final void addTypedef(@NotNull TypedefDeclaration typedef) {
        Intrinsics.checkNotNullParameter((Object)typedef, (String)"typedef");
        this.typedefs.add(typedef);
    }

    public final void addAnnotations(@NotNull Collection<? extends Annotation> annotations) {
        Intrinsics.checkNotNullParameter(annotations, (String)"annotations");
        this.annotations.addAll(annotations);
    }

    public final void disconnectFromGraph() {
        List<PropertyEdge> remove;
        for (Node node : this.nextDFG) {
            node.prevDFG.remove(this);
        }
        this.nextDFG.clear();
        for (Node node : this.prevDFG) {
            node.nextDFG.remove(this);
        }
        this.prevDFG.clear();
        for (PropertyEdge propertyEdge : this.nextEOGEdges) {
            remove = PropertyEdge.Companion.findPropertyEdgesByPredicate((Collection)((Node)propertyEdge.getEnd()).prevEOGEdges, arg_0 -> Node.disconnectFromGraph$lambda-1(this, arg_0));
            ((Node)propertyEdge.getEnd()).prevEOGEdges.removeAll((Collection)remove);
        }
        this.nextEOGEdges.clear();
        for (PropertyEdge propertyEdge : this.prevEOGEdges) {
            remove = PropertyEdge.Companion.findPropertyEdgesByPredicate((Collection)propertyEdge.getStart().nextEOGEdges, arg_0 -> Node.disconnectFromGraph$lambda-2(this, arg_0));
            propertyEdge.getStart().nextEOGEdges.removeAll((Collection)remove);
        }
        this.prevEOGEdges.clear();
    }

    @NotNull
    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this, TO_STRING_STYLE);
        if (!Intrinsics.areEqual((Object)this.getName(), (Object)EMPTY_NAME)) {
            builder.append("name", (Object)this.getName());
        }
        String string = builder.append("location", (Object)this.location).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.append(\"location\", location).toString()");
        return string;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Node)) {
            return false;
        }
        return this.location == null || ((Node)other).location == null ? false : Intrinsics.areEqual((Object)this.getName(), (Object)((Node)other).getName()) && Intrinsics.areEqual((Object)this.code, (Object)((Node)other).code) && Intrinsics.areEqual((Object)this.comment, (Object)((Node)other).comment) && Intrinsics.areEqual((Object)this.location, (Object)((Node)other).location) && Intrinsics.areEqual((Object)this.file, (Object)((Node)other).file) && this.isImplicit == ((Node)other).isImplicit;
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.getName(), this.getClass()};
        return Objects.hash(objectArray);
    }

    private static final boolean removePrevEOGEntries$lambda-0(Node $n, PropertyEdge it) {
        Intrinsics.checkNotNullParameter((Object)$n, (String)"$n");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getStart() == $n;
    }

    private static final boolean disconnectFromGraph$lambda-1(Node this$0, PropertyEdge it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getStart(), (Object)this$0);
    }

    private static final boolean disconnectFromGraph$lambda-2(Node this$0, PropertyEdge it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual(it.getEnd(), (Object)this$0);
    }

    static {
        ToStringStyle toStringStyle = ToStringStyle.SHORT_PREFIX_STYLE;
        Intrinsics.checkNotNullExpressionValue((Object)toStringStyle, (String)"SHORT_PREFIX_STYLE");
        TO_STRING_STYLE = toStringStyle;
        toStringStyle = LoggerFactory.getLogger(Node.class);
        Intrinsics.checkNotNullExpressionValue((Object)toStringStyle, (String)"getLogger(Node::class.java)");
        log = toStringStyle;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lde/fraunhofer/aisec/cpg/graph/Node$Companion;", "", "()V", "EMPTY_NAME", "", "TO_STRING_STYLE", "Lorg/apache/commons/lang3/builder/ToStringStyle;", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "cpg-library"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        protected final Logger getLog() {
            return log;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

