/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.graph;

import de.fraunhofer.aisec.cpg.ExperimentalGraph;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.QueryBenchmark;
import de.fraunhofer.aisec.cpg.graph.QueryContext;
import java.io.Closeable;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import org.jetbrains.annotations.NotNull;
import org.opencypher.v9_0.ast.Clause;
import org.opencypher.v9_0.ast.Match;
import org.opencypher.v9_0.ast.Query;
import org.opencypher.v9_0.ast.QueryPart;
import org.opencypher.v9_0.ast.Return;
import org.opencypher.v9_0.ast.SingleQuery;
import org.opencypher.v9_0.ast.Statement;
import org.opencypher.v9_0.parser.CypherParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExperimentalGraph
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u000f\u001a\u00020\u0010J\u0011\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0004H\u0086\u0002J\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0016\u001a\u00020\u0017R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\u0005R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lde/fraunhofer/aisec/cpg/graph/Graph;", "", "nodes", "", "Lde/fraunhofer/aisec/cpg/graph/Node;", "(Ljava/util/List;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getNodes", "()Ljava/util/List;", "setNodes", "parser", "Lorg/opencypher/v9_0/parser/CypherParser;", "executeQuery", "query", "Lorg/opencypher/v9_0/ast/Query;", "plusAssign", "", "node", "queryText", "", "size", "", "cpg-library"})
public final class Graph {
    @NotNull
    private List<? extends Node> nodes;
    private final Logger logger;
    @NotNull
    private final CypherParser parser;

    public Graph(@NotNull List<? extends Node> nodes) {
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        this.nodes = nodes;
        this.logger = LoggerFactory.getLogger(Graph.class);
        this.parser = new CypherParser();
    }

    @NotNull
    public final List<Node> getNodes() {
        return this.nodes;
    }

    public final void setNodes(@NotNull List<? extends Node> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.nodes = list;
    }

    public final int size() {
        return this.nodes.size();
    }

    public final void plusAssign(@NotNull Node node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Graph graph = this;
        graph.nodes = CollectionsKt.plus((Collection)graph.nodes, (Object)node);
    }

    @NotNull
    public final List<Node> query(@NotNull String queryText) {
        Intrinsics.checkNotNullParameter((Object)queryText, (String)"queryText");
        Statement statement = this.parser.parse(queryText, null, null);
        if (statement == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.opencypher.v9_0.ast.Query");
        }
        Query query = (Query)statement;
        return this.executeQuery(query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<Node> executeQuery(@NotNull Query query) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        QueryContext ctx = new QueryContext(this);
        List<Node> list = null;
        boolean bl = false;
        list = CollectionsKt.emptyList();
        QueryBenchmark b = new QueryBenchmark(this, query);
        Closeable closeable = b;
        boolean bl2 = false;
        boolean bl3 = false;
        Throwable throwable = null;
        try {
            QueryBenchmark it = (QueryBenchmark)closeable;
            boolean bl4 = false;
            QueryPart queryPart = query.part();
            if (queryPart == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.opencypher.v9_0.ast.SingleQuery");
            }
            SingleQuery singleQuery = (SingleQuery)queryPart;
            for (Clause clause : singleQuery.clauses()) {
                if (clause instanceof Match) {
                    ctx.handleMatch$cpg_library((Match)clause);
                    continue;
                }
                if (!(clause instanceof Return)) continue;
                list = ctx.handleReturn$cpg_library((Return)clause);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        this.logger.info("Query took " + Duration.toString-impl((long)DurationKt.getMilliseconds((long)b.getDuration())));
        return list;
    }
}

