/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.frontends.typescript;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import de.fraunhofer.aisec.cpg.ExperimentalTypeScript;
import de.fraunhofer.aisec.cpg.TranslationConfiguration;
import de.fraunhofer.aisec.cpg.frontends.LanguageFrontend;
import de.fraunhofer.aisec.cpg.frontends.TranslationException;
import de.fraunhofer.aisec.cpg.frontends.typescript.DeclarationHandler;
import de.fraunhofer.aisec.cpg.frontends.typescript.ExpressionHandler;
import de.fraunhofer.aisec.cpg.frontends.typescript.StatementHandler;
import de.fraunhofer.aisec.cpg.frontends.typescript.TypeHandler;
import de.fraunhofer.aisec.cpg.frontends.typescript.TypeScriptNode;
import de.fraunhofer.aisec.cpg.graph.Annotation;
import de.fraunhofer.aisec.cpg.graph.AnnotationMember;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.NodeBuilder;
import de.fraunhofer.aisec.cpg.graph.TypeManager;
import de.fraunhofer.aisec.cpg.graph.declarations.TranslationUnitDeclaration;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.CallExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Expression;
import de.fraunhofer.aisec.cpg.passes.scopes.ScopeManager;
import de.fraunhofer.aisec.cpg.sarif.PhysicalLocation;
import de.fraunhofer.aisec.cpg.sarif.Region;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ExperimentalTypeScript
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 62\u00020\u0001:\u00016B\u001c\u0012\u000b\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u001d\u0010\u001c\u001a\u0004\u0018\u00010\u001d\"\u0004\b\u0000\u0010\u001e2\u0006\u0010\u001f\u001a\u0002H\u001eH\u0016\u00a2\u0006\u0002\u0010 J\u0015\u0010!\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020#H\u0000\u00a2\u0006\u0002\b$J\u001d\u0010%\u001a\u0004\u0018\u00010&\"\u0004\b\u0000\u0010\u001e2\u0006\u0010\u001f\u001a\u0002H\u001eH\u0016\u00a2\u0006\u0002\u0010'J\u0010\u0010(\u001a\u00020)2\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0016J\u0016\u0010.\u001a\u00020/2\u0006\u0010\"\u001a\u0002002\u0006\u0010\u001f\u001a\u00020#J)\u00101\u001a\u00020/\"\u0004\b\u0000\u00102\"\u0004\b\u0001\u0010\u001e2\u0006\u00103\u001a\u0002H22\u0006\u00104\u001a\u0002H\u001eH\u0016\u00a2\u0006\u0002\u00105R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u00067"}, d2={"Lde/fraunhofer/aisec/cpg/frontends/typescript/TypeScriptLanguageFrontend;", "Lde/fraunhofer/aisec/cpg/frontends/LanguageFrontend;", "config", "Lde/fraunhofer/aisec/cpg/TranslationConfiguration;", "Lorg/checkerframework/checker/nullness/qual/NonNull;", "scopeManager", "Lde/fraunhofer/aisec/cpg/passes/scopes/ScopeManager;", "(Lde/fraunhofer/aisec/cpg/TranslationConfiguration;Lde/fraunhofer/aisec/cpg/passes/scopes/ScopeManager;)V", "declarationHandler", "Lde/fraunhofer/aisec/cpg/frontends/typescript/DeclarationHandler;", "getDeclarationHandler", "()Lde/fraunhofer/aisec/cpg/frontends/typescript/DeclarationHandler;", "expressionHandler", "Lde/fraunhofer/aisec/cpg/frontends/typescript/ExpressionHandler;", "getExpressionHandler", "()Lde/fraunhofer/aisec/cpg/frontends/typescript/ExpressionHandler;", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "statementHandler", "Lde/fraunhofer/aisec/cpg/frontends/typescript/StatementHandler;", "getStatementHandler", "()Lde/fraunhofer/aisec/cpg/frontends/typescript/StatementHandler;", "typeHandler", "Lde/fraunhofer/aisec/cpg/frontends/typescript/TypeHandler;", "getTypeHandler", "()Lde/fraunhofer/aisec/cpg/frontends/typescript/TypeHandler;", "getCodeFromRawNode", "", "T", "astNode", "(Ljava/lang/Object;)Ljava/lang/String;", "getIdentifierName", "node", "Lde/fraunhofer/aisec/cpg/frontends/typescript/TypeScriptNode;", "getIdentifierName$cpg_library", "getLocationFromRawNode", "Lde/fraunhofer/aisec/cpg/sarif/PhysicalLocation;", "(Ljava/lang/Object;)Lde/fraunhofer/aisec/cpg/sarif/PhysicalLocation;", "handleDecorator", "Lde/fraunhofer/aisec/cpg/graph/Annotation;", "parse", "Lde/fraunhofer/aisec/cpg/graph/declarations/TranslationUnitDeclaration;", "file", "Ljava/io/File;", "processAnnotations", "", "Lde/fraunhofer/aisec/cpg/graph/Node;", "setComment", "S", "s", "ctx", "(Ljava/lang/Object;Ljava/lang/Object;)V", "Companion", "cpg-library"})
public final class TypeScriptLanguageFrontend
extends LanguageFrontend {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final DeclarationHandler declarationHandler;
    @NotNull
    private final StatementHandler statementHandler;
    @NotNull
    private final ExpressionHandler expressionHandler;
    @NotNull
    private final TypeHandler typeHandler;
    @NotNull
    private final ObjectMapper mapper;
    @JvmField
    @NotNull
    public static List<String> TYPESCRIPT_EXTENSIONS;
    @JvmField
    @NotNull
    public static List<String> JAVASCRIPT_EXTENSIONS;
    @NotNull
    private static final File parserFile;

    public TypeScriptLanguageFrontend(@NotNull TranslationConfiguration config, @Nullable ScopeManager scopeManager) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, scopeManager, ".");
        this.declarationHandler = new DeclarationHandler(this);
        this.statementHandler = new StatementHandler(this);
        this.expressionHandler = new ExpressionHandler(this);
        this.typeHandler = new TypeHandler(this);
        this.mapper = ExtensionsKt.jacksonObjectMapper();
    }

    @NotNull
    public final DeclarationHandler getDeclarationHandler() {
        return this.declarationHandler;
    }

    @NotNull
    public final StatementHandler getStatementHandler() {
        return this.statementHandler;
    }

    @NotNull
    public final ExpressionHandler getExpressionHandler() {
        return this.expressionHandler;
    }

    @NotNull
    public final TypeHandler getTypeHandler() {
        return this.typeHandler;
    }

    @NotNull
    public final ObjectMapper getMapper() {
        return this.mapper;
    }

    @Override
    @NotNull
    public TranslationUnitDeclaration parse(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!parserFile.exists()) {
            throw new TranslationException("parser.js not found @ " + parserFile.getAbsolutePath());
        }
        String[] stringArray = new String[]{"node", parserFile.getAbsolutePath(), file.getAbsolutePath()};
        Process p = Runtime.getRuntime().exec(stringArray);
        TypeScriptNode node = (TypeScriptNode)this.mapper.readValue(p.getInputStream(), TypeScriptNode.class);
        TypeManager.getInstance().setLanguageFrontend(this);
        Object s = this.declarationHandler.handle(node);
        if (s == null) {
            throw new NullPointerException("null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.declarations.TranslationUnitDeclaration");
        }
        return (TranslationUnitDeclaration)s;
    }

    @Override
    @Nullable
    public <T> String getCodeFromRawNode(T astNode) {
        if (astNode instanceof TypeScriptNode) {
            return ((TypeScriptNode)astNode).getCode();
        }
        return null;
    }

    @Override
    @Nullable
    public <T> PhysicalLocation getLocationFromRawNode(T astNode) {
        if (astNode instanceof TypeScriptNode) {
            PhysicalLocation location = new PhysicalLocation(new File(((TypeScriptNode)astNode).getLocation().getFile()).toURI(), new Region());
            return location;
        }
        return null;
    }

    @Override
    public <S, T> void setComment(S s, T ctx) {
    }

    @NotNull
    public final String getIdentifierName$cpg_library(@NotNull TypeScriptNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        String string = this.getCodeFromRawNode(node.firstChild("Identifier"));
        return string == null ? "" : string;
    }

    /*
     * WARNING - void declaration
     */
    public final void processAnnotations(@NotNull Node node, @NotNull TypeScriptNode astNode) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)astNode, (String)"astNode");
        List<TypeScriptNode> list = astNode.getChildren();
        if (list != null) {
            List list2;
            void $this$mapTo$iv$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = list;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                TypeScriptNode it = (TypeScriptNode)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getType(), (Object)"Decorator")) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List list3 = (List)destination$iv$iv;
            Iterable $this$map$iv = list3;
            boolean $i$f$map = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                TypeScriptNode bl = (TypeScriptNode)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                Annotation annotation = this.handleDecorator((TypeScriptNode)it);
                collection.add(annotation);
            }
            List list4 = list2 = (List)destination$iv$iv2;
            boolean bl = false;
            boolean bl3 = false;
            List it = list4;
            boolean bl4 = false;
            node.addAnnotations(it);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Annotation handleDecorator(TypeScriptNode node) {
        TypeScriptNode call = node.firstChild("CallExpression");
        if (call != null) {
            Collection<AnnotationMember> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object object;
            Object s = this.expressionHandler.handle(call);
            if (s == null) {
                throw new NullPointerException("null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.statements.expressions.CallExpression");
            }
            CallExpression call2 = (CallExpression)s;
            Annotation annotation = NodeBuilder.newAnnotation(call2.getName(), (String)((object = this.getCodeFromRawNode(node)) == null ? "" : object));
            object = call2.getArguments();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"call.arguments");
            object = (Iterable)object;
            Annotation annotation2 = annotation;
            boolean $i$f$map = false;
            void var7_11 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Expression expression = (Expression)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                String string = it.getCode();
                AnnotationMember annotationMember = NodeBuilder.newAnnotationMember("", (Expression)it, string == null ? "" : string);
                collection.add(annotationMember);
            }
            collection = (List)destination$iv$iv;
            annotation2.setMembers((List<AnnotationMember>)collection);
            call2.disconnectFromGraph();
            Intrinsics.checkNotNullExpressionValue((Object)annotation, (String)"annotation");
            return annotation;
        }
        String name = this.getIdentifierName$cpg_library(node);
        String string = this.getCodeFromRawNode(node);
        Annotation annotation = NodeBuilder.newAnnotation(name, string == null ? "" : string);
        Intrinsics.checkNotNullExpressionValue((Object)annotation, (String)"annotation");
        return annotation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        InputStream link;
        Companion = new Companion(null);
        Object object = new String[]{".ts", ".tsx"};
        TYPESCRIPT_EXTENSIONS = CollectionsKt.listOf((Object[])object);
        object = new String[]{".js", ".jsx"};
        JAVASCRIPT_EXTENSIONS = CollectionsKt.listOf((Object[])object);
        object = File.createTempFile("parser", ".js");
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"createTempFile(\"parser\", \".js\")");
        parserFile = object;
        InputStream inputStream = link = Companion.getClass().getResourceAsStream("/nodejs/parser.js");
        if (inputStream != null) {
            Closeable closeable = inputStream;
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl3 = false;
                LanguageFrontend.log.info("Extracting parser.js out of resources to {}", (Object)parserFile.getAbsoluteFile().toPath());
                CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                Long l = Files.copy(it, parserFile.getAbsoluteFile().toPath(), copyOptionArray);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lde/fraunhofer/aisec/cpg/frontends/typescript/TypeScriptLanguageFrontend$Companion;", "", "()V", "JAVASCRIPT_EXTENSIONS", "", "", "TYPESCRIPT_EXTENSIONS", "parserFile", "Ljava/io/File;", "cpg-library"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

