/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.frontends.typescript;

import de.fraunhofer.aisec.cpg.ExperimentalTypeScript;
import de.fraunhofer.aisec.cpg.frontends.Handler;
import de.fraunhofer.aisec.cpg.frontends.LanguageFrontend;
import de.fraunhofer.aisec.cpg.frontends.typescript.TypeScriptLanguageFrontend;
import de.fraunhofer.aisec.cpg.frontends.typescript.TypeScriptNode;
import de.fraunhofer.aisec.cpg.graph.NodeBuilder;
import de.fraunhofer.aisec.cpg.graph.declarations.Declaration;
import de.fraunhofer.aisec.cpg.graph.statements.CompoundStatement;
import de.fraunhofer.aisec.cpg.graph.statements.DeclarationStatement;
import de.fraunhofer.aisec.cpg.graph.statements.ReturnStatement;
import de.fraunhofer.aisec.cpg.graph.statements.Statement;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Expression;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@ExperimentalTypeScript
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003H\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u0003H\u0002J\u0010\u0010\f\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0003H\u0002J\u0010\u0010\r\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0003H\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\u0003H\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\u0003H\u0002\u00a8\u0006\u0012"}, d2={"Lde/fraunhofer/aisec/cpg/frontends/typescript/StatementHandler;", "Lde/fraunhofer/aisec/cpg/frontends/Handler;", "Lde/fraunhofer/aisec/cpg/graph/statements/Statement;", "Lde/fraunhofer/aisec/cpg/frontends/typescript/TypeScriptNode;", "Lde/fraunhofer/aisec/cpg/frontends/typescript/TypeScriptLanguageFrontend;", "lang", "(Lde/fraunhofer/aisec/cpg/frontends/typescript/TypeScriptLanguageFrontend;)V", "handleBlock", "Lde/fraunhofer/aisec/cpg/graph/statements/CompoundStatement;", "node", "handleExpressionStatement", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/Expression;", "handleFunctionDeclaration", "handleNode", "handleReturnStatement", "Lde/fraunhofer/aisec/cpg/graph/statements/ReturnStatement;", "handleVariableStatement", "Lde/fraunhofer/aisec/cpg/graph/statements/DeclarationStatement;", "cpg-library"})
public final class StatementHandler
extends Handler<Statement, TypeScriptNode, TypeScriptLanguageFrontend> {
    public StatementHandler(@NotNull TypeScriptLanguageFrontend lang) {
        Intrinsics.checkNotNullParameter((Object)lang, (String)"lang");
        super(Statement::new, (LanguageFrontend)lang);
        this.map.put(TypeScriptNode.class, this::handleNode);
    }

    private final Statement handleNode(TypeScriptNode node) {
        switch (node.getType()) {
            case "Block": {
                return this.handleBlock(node);
            }
            case "FirstStatement": {
                return this.handleVariableStatement(node);
            }
            case "VariableStatement": {
                return this.handleVariableStatement(node);
            }
            case "ExpressionStatement": {
                return this.handleExpressionStatement(node);
            }
            case "ReturnStatement": {
                return this.handleReturnStatement(node);
            }
            case "FunctionDeclaration": {
                return this.handleFunctionDeclaration(node);
            }
        }
        return new Statement();
    }

    private final Statement handleFunctionDeclaration(TypeScriptNode node) {
        DeclarationStatement statement = NodeBuilder.newDeclarationStatement(((TypeScriptLanguageFrontend)this.lang).getCodeFromRawNode(node));
        Declaration decl = (Declaration)((TypeScriptLanguageFrontend)this.lang).getDeclarationHandler().handle(node);
        statement.addToPropertyEdgeDeclaration(decl);
        ((TypeScriptLanguageFrontend)this.lang).getScopeManager().addDeclaration(decl);
        Intrinsics.checkNotNullExpressionValue((Object)statement, (String)"statement");
        return statement;
    }

    private final ReturnStatement handleReturnStatement(TypeScriptNode node) {
        TypeScriptNode typeScriptNode;
        ReturnStatement returnStmt = NodeBuilder.newReturnStatement(((TypeScriptLanguageFrontend)this.lang).getCodeFromRawNode(node));
        List<TypeScriptNode> list = node.getChildren();
        if (list != null && (typeScriptNode = (TypeScriptNode)CollectionsKt.first(list)) != null) {
            TypeScriptNode typeScriptNode2 = typeScriptNode;
            boolean bl = false;
            boolean bl2 = false;
            TypeScriptNode it = typeScriptNode2;
            boolean bl3 = false;
            returnStmt.setReturnValue((Expression)((TypeScriptLanguageFrontend)this.lang).getExpressionHandler().handle(it));
        }
        Intrinsics.checkNotNullExpressionValue((Object)returnStmt, (String)"returnStmt");
        return returnStmt;
    }

    private final CompoundStatement handleBlock(TypeScriptNode node) {
        CompoundStatement block = NodeBuilder.newCompoundStatement(((TypeScriptLanguageFrontend)this.lang).getCodeFromRawNode(node));
        List<TypeScriptNode> list = node.getChildren();
        if (list != null) {
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TypeScriptNode it = (TypeScriptNode)element$iv;
                boolean bl = false;
                block.addStatement((Statement)this.handle(it));
            }
        }
        Intrinsics.checkNotNullExpressionValue((Object)block, (String)"block");
        return block;
    }

    private final Expression handleExpressionStatement(TypeScriptNode node) {
        List<TypeScriptNode> list;
        Object s = ((TypeScriptLanguageFrontend)this.lang).getExpressionHandler().handle((list = node.getChildren()) == null ? null : (TypeScriptNode)CollectionsKt.first(list));
        Intrinsics.checkNotNullExpressionValue(s, (String)"this.lang.expressionHand\u2026e(node.children?.first())");
        return (Expression)s;
    }

    private final DeclarationStatement handleVariableStatement(TypeScriptNode node) {
        List<TypeScriptNode> nodes;
        DeclarationStatement statement = NodeBuilder.newDeclarationStatement(((TypeScriptLanguageFrontend)this.lang).getCodeFromRawNode(node));
        TypeScriptNode typeScriptNode = node.firstChild("VariableDeclarationList");
        List<TypeScriptNode> list = nodes = typeScriptNode == null ? null : typeScriptNode.getChildren();
        for (TypeScriptNode variableNode : list == null ? CollectionsKt.emptyList() : list) {
            Declaration decl = (Declaration)((TypeScriptLanguageFrontend)this.lang).getDeclarationHandler().handle(variableNode);
            statement.addToPropertyEdgeDeclaration(decl);
            ((TypeScriptLanguageFrontend)this.lang).getScopeManager().addDeclaration(decl);
        }
        Intrinsics.checkNotNullExpressionValue((Object)statement, (String)"statement");
        return statement;
    }
}

