/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.frontends.typescript;

import de.fraunhofer.aisec.cpg.ExperimentalTypeScript;
import de.fraunhofer.aisec.cpg.frontends.Handler;
import de.fraunhofer.aisec.cpg.frontends.LanguageFrontend;
import de.fraunhofer.aisec.cpg.frontends.typescript.TypeScriptLanguageFrontend;
import de.fraunhofer.aisec.cpg.frontends.typescript.TypeScriptNode;
import de.fraunhofer.aisec.cpg.graph.NodeBuilder;
import de.fraunhofer.aisec.cpg.graph.declarations.Declaration;
import de.fraunhofer.aisec.cpg.graph.statements.Statement;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.CallExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.DeclaredReferenceExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Expression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.ExpressionList;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.InitializerListExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.KeyValueExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Literal;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.MemberExpression;
import de.fraunhofer.aisec.cpg.graph.types.TypeParser;
import de.fraunhofer.aisec.cpg.graph.types.UnknownType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@ExperimentalTypeScript
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003H\u0002J\u0010\u0010\n\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0003H\u0002J\u0010\u0010\u000b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0003H\u0002J\u0010\u0010\f\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0003H\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\u0003H\u0002J\u0010\u0010\u000f\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0003H\u0002J\u0010\u0010\u0010\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0003H\u0002J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003H\u0002J\u0010\u0010\u0012\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0003H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\u0003H\u0002J\u0010\u0010\u0015\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0003H\u0002J\u0010\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\u0003H\u0002J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\t\u001a\u00020\u0003H\u0002\u00a8\u0006\u001a"}, d2={"Lde/fraunhofer/aisec/cpg/frontends/typescript/ExpressionHandler;", "Lde/fraunhofer/aisec/cpg/frontends/Handler;", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/Expression;", "Lde/fraunhofer/aisec/cpg/frontends/typescript/TypeScriptNode;", "Lde/fraunhofer/aisec/cpg/frontends/typescript/TypeScriptLanguageFrontend;", "lang", "(Lde/fraunhofer/aisec/cpg/frontends/typescript/TypeScriptLanguageFrontend;)V", "handeJsxElement", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/ExpressionList;", "node", "handleArrowFunction", "handleCallExpression", "handleIdentifier", "handleJsxAttribute", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/KeyValueExpression;", "handleJsxClosingElement", "handleJsxExpression", "handleJsxOpeningElement", "handleNode", "handleObjectLiteralExpression", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/InitializerListExpression;", "handlePropertyAccessExpression", "handlePropertyAssignment", "handleStringLiteral", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/Literal;", "", "cpg-library"})
public final class ExpressionHandler
extends Handler<Expression, TypeScriptNode, TypeScriptLanguageFrontend> {
    public ExpressionHandler(@NotNull TypeScriptLanguageFrontend lang) {
        Intrinsics.checkNotNullParameter((Object)lang, (String)"lang");
        super(Expression::new, (LanguageFrontend)lang);
        this.map.put(TypeScriptNode.class, this::handleNode);
    }

    private final Expression handleNode(TypeScriptNode node) {
        switch (node.getType()) {
            case "CallExpression": {
                return this.handleCallExpression(node);
            }
            case "PropertyAccessExpression": {
                return this.handlePropertyAccessExpression(node);
            }
            case "Identifier": {
                return this.handleIdentifier(node);
            }
            case "FirstTemplateToken": {
                return this.handleStringLiteral(node);
            }
            case "TemplateExpression": {
                return this.handleStringLiteral(node);
            }
            case "NoSubstitutionTemplateLiteral": {
                return this.handleStringLiteral(node);
            }
            case "StringLiteral": {
                return this.handleStringLiteral(node);
            }
            case "ObjectLiteralExpression": {
                return this.handleObjectLiteralExpression(node);
            }
            case "PropertyAssignment": {
                return this.handlePropertyAssignment(node);
            }
            case "ArrowFunction": {
                return this.handleArrowFunction(node);
            }
            case "FunctionExpression": {
                return this.handleArrowFunction(node);
            }
            case "JsxElement": {
                return this.handeJsxElement(node);
            }
            case "JsxOpeningElement": {
                return this.handleJsxOpeningElement(node);
            }
            case "JsxAttribute": {
                return this.handleJsxAttribute(node);
            }
            case "JsxText": {
                return this.handleStringLiteral(node);
            }
            case "JsxExpression": {
                return this.handleJsxExpression(node);
            }
            case "JsxClosingElement": {
                return this.handleJsxClosingElement(node);
            }
        }
        return new Expression();
    }

    private final KeyValueExpression handleJsxAttribute(TypeScriptNode node) {
        List<TypeScriptNode> list = node.getChildren();
        Expression key = (Expression)this.handle(list == null ? null : (TypeScriptNode)CollectionsKt.first(list));
        List<TypeScriptNode> list2 = node.getChildren();
        Expression value = (Expression)this.handle(list2 == null ? null : (TypeScriptNode)CollectionsKt.last(list2));
        KeyValueExpression keyValueExpression = NodeBuilder.newKeyValueExpression(key, value, ((TypeScriptLanguageFrontend)this.lang).getCodeFromRawNode(node));
        Intrinsics.checkNotNullExpressionValue((Object)keyValueExpression, (String)"newKeyValueExpression(ke\u2026getCodeFromRawNode(node))");
        KeyValueExpression keyValue = keyValueExpression;
        return keyValue;
    }

    private final Expression handleJsxClosingElement(TypeScriptNode node) {
        ExpressionList tag = NodeBuilder.newExpressionList(((TypeScriptLanguageFrontend)this.lang).getCodeFromRawNode(node));
        String string = ((TypeScriptLanguageFrontend)this.lang).getIdentifierName$cpg_library(node);
        boolean bl = false;
        boolean bl2 = false;
        String it = string;
        boolean bl3 = false;
        tag.setName("</" + it + ">");
        Intrinsics.checkNotNullExpressionValue((Object)tag, (String)"tag");
        return tag;
    }

    private final Expression handleJsxExpression(TypeScriptNode node) {
        List<TypeScriptNode> list = node.getChildren();
        Object s = this.handle(list == null ? null : (TypeScriptNode)CollectionsKt.first(list));
        Intrinsics.checkNotNullExpressionValue(s, (String)"this.handle(node.children?.first())");
        return (Expression)s;
    }

    /*
     * WARNING - void declaration
     */
    private final ExpressionList handleJsxOpeningElement(TypeScriptNode node) {
        List list;
        ExpressionList tag = NodeBuilder.newExpressionList(((TypeScriptLanguageFrontend)this.lang).getCodeFromRawNode(node));
        String string = ((TypeScriptLanguageFrontend)this.lang).getIdentifierName$cpg_library(node);
        boolean bl = false;
        boolean bl2 = false;
        Object it = string;
        boolean bl3 = false;
        tag.setName("<" + (String)it + ">");
        ExpressionList expressionList = tag;
        TypeScriptNode typeScriptNode = node.firstChild("JsxAttributes");
        if (typeScriptNode == null) {
            list = null;
        } else {
            List<TypeScriptNode> list2 = typeScriptNode.getChildren();
            if (list2 == null) {
                list = null;
            } else {
                Collection<Expression> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                it = list2;
                ExpressionList expressionList2 = expressionList;
                boolean $i$f$map = false;
                void var8_11 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it2;
                    TypeScriptNode typeScriptNode2 = (TypeScriptNode)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl4 = false;
                    Expression expression = (Expression)this.handle(it2);
                    collection.add(expression);
                }
                collection = (List)destination$iv$iv;
                expressionList = expressionList2;
                list = collection;
            }
        }
        string = list;
        expressionList.setExpressions((List<Statement>)(string == null ? CollectionsKt.emptyList() : string));
        Intrinsics.checkNotNullExpressionValue((Object)tag, (String)"tag");
        return tag;
    }

    /*
     * WARNING - void declaration
     */
    private final ExpressionList handeJsxElement(TypeScriptNode node) {
        List list;
        ExpressionList jsx;
        ExpressionList expressionList = jsx = NodeBuilder.newExpressionList(((TypeScriptLanguageFrontend)this.lang).getCodeFromRawNode(node));
        List<TypeScriptNode> list2 = node.getChildren();
        if (list2 == null) {
            list = null;
        } else {
            Collection<Expression> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = list2;
            ExpressionList expressionList2 = expressionList;
            boolean $i$f$map = false;
            void var6_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                TypeScriptNode typeScriptNode = (TypeScriptNode)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                Expression expression = (Expression)this.handle(it);
                collection.add(expression);
            }
            collection = (List)destination$iv$iv;
            expressionList = expressionList2;
            list = collection;
        }
        expressionList.setExpressions(list);
        Intrinsics.checkNotNullExpressionValue((Object)jsx, (String)"jsx");
        return jsx;
    }

    private final Expression handleArrowFunction(TypeScriptNode node) {
        Declaration func = (Declaration)((TypeScriptLanguageFrontend)this.lang).getDeclarationHandler().handle(node);
        DeclaredReferenceExpression ref = NodeBuilder.newDeclaredReferenceExpression("", UnknownType.getUnknownType(), ((TypeScriptLanguageFrontend)this.lang).getCodeFromRawNode(node));
        ref.setRefersTo(func);
        Intrinsics.checkNotNullExpressionValue((Object)ref, (String)"ref");
        return ref;
    }

    private final KeyValueExpression handlePropertyAssignment(TypeScriptNode node) {
        List<TypeScriptNode> list = node.getChildren();
        Expression key = (Expression)this.handle(list == null ? null : (TypeScriptNode)CollectionsKt.first(list));
        List<TypeScriptNode> list2 = node.getChildren();
        Expression value = (Expression)this.handle(list2 == null ? null : (TypeScriptNode)CollectionsKt.last(list2));
        KeyValueExpression keyValueExpression = NodeBuilder.newKeyValueExpression(key, value, ((TypeScriptLanguageFrontend)this.lang).getCodeFromRawNode(node));
        Intrinsics.checkNotNullExpressionValue((Object)keyValueExpression, (String)"newKeyValueExpression(ke\u2026getCodeFromRawNode(node))");
        KeyValueExpression keyValue = keyValueExpression;
        return keyValue;
    }

    /*
     * WARNING - void declaration
     */
    private final InitializerListExpression handleObjectLiteralExpression(TypeScriptNode node) {
        List list;
        InitializerListExpression ile;
        InitializerListExpression initializerListExpression = ile = NodeBuilder.newInitializerListExpression(((TypeScriptLanguageFrontend)this.lang).getCodeFromRawNode(node));
        List<TypeScriptNode> list2 = node.getChildren();
        if (list2 == null) {
            list = null;
        } else {
            Collection<Expression> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = list2;
            InitializerListExpression initializerListExpression2 = initializerListExpression;
            boolean $i$f$map = false;
            void var7_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                TypeScriptNode typeScriptNode = (TypeScriptNode)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                Expression expression = (Expression)this.handle(it);
                collection.add(expression);
            }
            collection = (List)destination$iv$iv;
            initializerListExpression = initializerListExpression2;
            list = collection;
        }
        List list3 = list;
        initializerListExpression.setInitializers(list3 == null ? CollectionsKt.emptyList() : list3);
        Intrinsics.checkNotNullExpressionValue((Object)ile, (String)"ile");
        return ile;
    }

    private final Literal<String> handleStringLiteral(TypeScriptNode node) {
        String string;
        Object object = ((TypeScriptLanguageFrontend)this.lang).getCodeFromRawNode(node);
        if (object == null) {
            string = null;
        } else {
            String string2;
            String string3 = object;
            boolean bl = false;
            String string4 = ((Object)StringsKt.trim((CharSequence)string3)).toString();
            string = string4 == null ? null : ((string3 = StringsKt.replace$default((String)string4, (String)"\"", (String)"", (boolean)false, (int)4, null)) == null ? null : ((string2 = StringsKt.replace$default((String)string3, (String)"`", (String)"", (boolean)false, (int)4, null)) == null ? null : StringsKt.replace$default((String)string2, (String)"'", (String)"", (boolean)false, (int)4, null)));
        }
        String value = string;
        object = NodeBuilder.newLiteral(value, TypeParser.createFrom("String", false), ((TypeScriptLanguageFrontend)this.lang).getCodeFromRawNode(node));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"newLiteral(\n            \u2026omRawNode(node)\n        )");
        return object;
    }

    private final Expression handleIdentifier(TypeScriptNode node) {
        String string;
        String string2 = ((TypeScriptLanguageFrontend)this.lang).getCodeFromRawNode(node);
        if (string2 == null) {
            string = null;
        } else {
            String string3 = string2;
            boolean bl = false;
            string = ((Object)StringsKt.trim((CharSequence)string3)).toString();
        }
        String name = string;
        DeclaredReferenceExpression ref = NodeBuilder.newDeclaredReferenceExpression(name, UnknownType.getUnknownType(), ((TypeScriptLanguageFrontend)this.lang).getCodeFromRawNode(node));
        Intrinsics.checkNotNullExpressionValue((Object)ref, (String)"ref");
        return ref;
    }

    private final Expression handlePropertyAccessExpression(TypeScriptNode node) {
        List<TypeScriptNode> list = node.getChildren();
        Expression base = (Expression)this.handle(list == null ? null : (TypeScriptNode)CollectionsKt.first(list));
        List<TypeScriptNode> list2 = node.getChildren();
        String name = ((TypeScriptLanguageFrontend)this.lang).getCodeFromRawNode(list2 == null ? null : (TypeScriptNode)CollectionsKt.last(list2));
        MemberExpression memberExpression = NodeBuilder.newMemberExpression(base, UnknownType.getUnknownType(), name, ".", ((TypeScriptLanguageFrontend)this.lang).getCodeFromRawNode(node));
        Intrinsics.checkNotNullExpressionValue((Object)memberExpression, (String)"memberExpression");
        return memberExpression;
    }

    private final Expression handleCallExpression(TypeScriptNode node) {
        Object fqn;
        Object object;
        Object call = null;
        TypeScriptNode propertyAccess = node.firstChild("PropertyAccessExpression");
        if (propertyAccess != null) {
            object = this.handle(propertyAccess);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.statements.expressions.MemberExpression");
            }
            MemberExpression memberExpression = (MemberExpression)object;
            DeclaredReferenceExpression member = NodeBuilder.newDeclaredReferenceExpression(memberExpression.getName(), memberExpression.getType(), memberExpression.getName());
            fqn = memberExpression.getName();
            CallExpression callExpression = NodeBuilder.newMemberCallExpression(memberExpression.getName(), (String)fqn, memberExpression.getBase(), member, ".", ((TypeScriptLanguageFrontend)this.lang).getCodeFromRawNode(node));
            Intrinsics.checkNotNullExpressionValue((Object)callExpression, (String)"newMemberCallExpression(\u2026e(node)\n                )");
            call = callExpression;
        } else {
            String name;
            String fqn2 = name = ((TypeScriptLanguageFrontend)this.lang).getIdentifierName$cpg_library(node);
            fqn = NodeBuilder.newCallExpression(name, fqn2, ((TypeScriptLanguageFrontend)this.lang).getCodeFromRawNode(node), false);
            Intrinsics.checkNotNullExpressionValue((Object)fqn, (String)"newCallExpression(name, \u2026FromRawNode(node), false)");
            call = fqn;
        }
        object = node.getChildren();
        List remainingNodes = object == null ? null : CollectionsKt.drop((Iterable)((Iterable)object), (int)1);
        object = remainingNodes;
        if (object != null) {
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TypeScriptNode it = (TypeScriptNode)element$iv;
                boolean bl = false;
                ((CallExpression)call).addArgument((Expression)this.handle(it));
            }
        }
        return (Expression)call;
    }
}

