/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.graph.types;

import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.types.FunctionPointerType;
import de.fraunhofer.aisec.cpg.graph.types.IncompleteType;
import de.fraunhofer.aisec.cpg.graph.types.ObjectType;
import de.fraunhofer.aisec.cpg.graph.types.ParameterizedType;
import de.fraunhofer.aisec.cpg.graph.types.PointerType;
import de.fraunhofer.aisec.cpg.graph.types.QualifierConverter;
import de.fraunhofer.aisec.cpg.graph.types.SecondOrderType;
import de.fraunhofer.aisec.cpg.graph.types.TypeParser;
import de.fraunhofer.aisec.cpg.graph.types.UnknownType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.NotNull;
import org.neo4j.ogm.annotation.Relationship;
import org.neo4j.ogm.annotation.typeconversion.Convert;

public abstract class Type
extends Node {
    public static final String UNKNOWN_TYPE_STRING = "UNKNOWN";
    @Relationship(value="SUPER_TYPE", direction="OUTGOING")
    protected @NonNull Set<Type> superTypes = new HashSet<Type>();
    protected @NonNull Storage storage = Storage.AUTO;
    protected boolean primitive = false;
    @Convert(value=QualifierConverter.class)
    protected Qualifier qualifier;
    protected Origin origin;

    public Type() {
        this.setName("");
        this.storage = Storage.AUTO;
        this.qualifier = new Qualifier(false, false, false, false);
    }

    public Type(String typeName) {
        this.setName(typeName);
        this.storage = Storage.AUTO;
        this.qualifier = new Qualifier();
        this.origin = Origin.UNRESOLVED;
    }

    public Type(Type type) {
        this.storage = type.storage;
        this.setName(type.getName());
        this.qualifier = new Qualifier(type.qualifier.isConst, type.qualifier.isVolatile, type.qualifier.isRestrict, type.qualifier.isAtomic);
        this.origin = type.origin;
    }

    public Type(String typeName, @Nullable Storage storage, Qualifier qualifier) {
        this.setName(typeName);
        this.storage = storage != null ? storage : Storage.AUTO;
        this.qualifier = qualifier;
        this.origin = Origin.UNRESOLVED;
    }

    public @NonNull Set<Type> getSuperTypes() {
        return this.superTypes;
    }

    public @NonNull Storage getStorage() {
        return this.storage;
    }

    public void setStorage(@NonNull Storage storage) {
        this.storage = storage;
    }

    public Qualifier getQualifier() {
        return this.qualifier;
    }

    public void setQualifier(Qualifier qualifier) {
        this.qualifier = qualifier;
    }

    public Origin getTypeOrigin() {
        return this.origin;
    }

    public void setTypeOrigin(Origin origin) {
        this.origin = origin;
    }

    public boolean isPrimitive() {
        return this.primitive;
    }

    public abstract Type reference(PointerType.PointerOrigin var1);

    public abstract Type dereference();

    public void refreshNames() {
    }

    public Type getRoot() {
        if (this instanceof SecondOrderType) {
            return ((SecondOrderType)((Object)this)).getElementType().getRoot();
        }
        return this;
    }

    public void setRoot(Type newRoot) {
        if (this instanceof SecondOrderType) {
            if (((SecondOrderType)((Object)this)).getElementType() instanceof SecondOrderType) {
                ((SecondOrderType)((Object)((SecondOrderType)((Object)this)).getElementType())).setElementType(newRoot);
            } else {
                ((SecondOrderType)((Object)this)).setElementType(newRoot);
            }
        }
    }

    public abstract Type duplicate();

    public String getTypeName() {
        return this.getName();
    }

    public int getReferenceDepth() {
        return 0;
    }

    public void setAdditionalTypeKeywords(String keywords) {
        List<String> separatedKeywords = TypeParser.separate(keywords);
        for (String keyword : separatedKeywords) {
            if (!TypeParser.isKnownSpecifier(keyword)) continue;
            if (TypeParser.isStorageSpecifier(keyword)) {
                ArrayList<String> specifiers = new ArrayList<String>();
                specifiers.add(keyword);
                this.setStorage(TypeParser.calcStorage(specifiers));
                continue;
            }
            if (!TypeParser.isQualifierSpecifier(keyword)) continue;
            ArrayList<String> qualifiers = new ArrayList<String>();
            qualifiers.add(keyword);
            this.setQualifier(TypeParser.calcQualifier(qualifiers, this.getQualifier()));
        }
    }

    public boolean isFirstOrderType() {
        return this instanceof ObjectType || this instanceof UnknownType || this instanceof FunctionPointerType || this instanceof IncompleteType || this instanceof ParameterizedType;
    }

    public boolean isSimilar(Type t) {
        if (this.equals(t)) {
            return true;
        }
        return this.getTypeName().equals(t.getTypeName());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Type)) {
            return false;
        }
        Type type = (Type)o;
        return Objects.equals(this.getName(), type.getName()) && this.storage == type.storage && Objects.equals(this.qualifier, type.qualifier);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.getName(), this.storage, this.qualifier});
    }

    @Override
    @NotNull
    public String toString() {
        return new ToStringBuilder((Object)this, TO_STRING_STYLE).append("name", (Object)this.getName()).toString();
    }

    public static class Qualifier {
        private boolean isConst;
        private boolean isVolatile;
        private boolean isRestrict;
        private boolean isAtomic;

        public Qualifier(boolean isConst, boolean isVolatile, boolean isRestrict, boolean isAtomic) {
            this.isConst = isConst;
            this.isVolatile = isVolatile;
            this.isRestrict = isRestrict;
            this.isAtomic = isAtomic;
        }

        public Qualifier() {
            this.isConst = false;
            this.isVolatile = false;
            this.isRestrict = false;
            this.isAtomic = false;
        }

        public boolean isConst() {
            return this.isConst;
        }

        public void setConst(boolean aConst) {
            this.isConst = aConst;
        }

        public boolean isVolatile() {
            return this.isVolatile;
        }

        public void setVolatile(boolean aVolatile) {
            this.isVolatile = aVolatile;
        }

        public boolean isRestrict() {
            return this.isRestrict;
        }

        public void setRestrict(boolean restrict) {
            this.isRestrict = restrict;
        }

        public boolean isAtomic() {
            return this.isAtomic;
        }

        public void setAtomic(boolean atomic) {
            this.isAtomic = atomic;
        }

        public Qualifier merge(Qualifier other) {
            return new Qualifier(this.isConst || other.isConst, this.isVolatile || other.isVolatile, this.isRestrict || other.isRestrict, this.isAtomic || other.isAtomic);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Qualifier)) {
                return false;
            }
            Qualifier qualifier = (Qualifier)o;
            return this.isConst == qualifier.isConst && this.isVolatile == qualifier.isVolatile && this.isRestrict == qualifier.isRestrict && this.isAtomic == qualifier.isAtomic;
        }

        public int hashCode() {
            return Objects.hash(this.isConst, this.isVolatile, this.isRestrict, this.isAtomic);
        }

        public String toString() {
            return "Qualifier{isConst=" + this.isConst + ", isVolatile=" + this.isVolatile + ", isRestrict=" + this.isRestrict + ", isAtomic=" + this.isAtomic + "}";
        }
    }

    public static enum Origin {
        RESOLVED,
        DATAFLOW,
        GUESSED,
        UNRESOLVED;

    }

    public static enum Storage {
        AUTO,
        EXTERN,
        STATIC,
        REGISTER;

    }
}

