/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.graph.statements.expressions;

import de.fraunhofer.aisec.cpg.graph.HasType;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.SubGraph;
import de.fraunhofer.aisec.cpg.graph.TypeManager;
import de.fraunhofer.aisec.cpg.graph.edge.PropertyEdge;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Expression;
import de.fraunhofer.aisec.cpg.graph.types.PointerType;
import de.fraunhofer.aisec.cpg.graph.types.Type;
import de.fraunhofer.aisec.cpg.graph.types.UnknownType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.neo4j.ogm.annotation.Relationship;

public class InitializerListExpression
extends Expression
implements HasType.TypeListener {
    @Relationship(value="INITIALIZERS", direction="OUTGOING")
    @SubGraph(value={"AST"})
    private List<PropertyEdge<Expression>> initializers = new ArrayList<PropertyEdge<Expression>>();

    public List<Expression> getInitializers() {
        return PropertyEdge.unwrap(this.initializers);
    }

    public List<PropertyEdge<Expression>> getInitializersPropertyEdge() {
        return this.initializers;
    }

    public void setInitializers(List<Expression> initializers) {
        if (this.initializers != null) {
            this.initializers.forEach(i -> {
                ((Expression)i.getEnd()).unregisterTypeListener(this);
                this.removePrevDFG((Node)i.getEnd());
            });
        }
        this.initializers = PropertyEdge.transformIntoOutgoingPropertyEdgeList(initializers, this);
        if (initializers != null) {
            initializers.forEach(i -> {
                i.registerTypeListener(this);
                this.addPrevDFG((Node)i);
            });
        }
    }

    @Override
    public void typeChanged(HasType src, HasType root, Type oldType) {
        HashSet<Type> subTypes;
        Type newType;
        if (!TypeManager.isTypeSystemActive()) {
            return;
        }
        if (!TypeManager.getInstance().isUnknown(this.type) && src.getPropagationType().equals(oldType)) {
            return;
        }
        Type previous = this.type;
        if (this.getInitializers().contains(src)) {
            Set<Type> types = this.initializers.parallelStream().map(PropertyEdge::getEnd).map(Expression::getType).filter(Objects::nonNull).map(t -> TypeManager.getInstance().registerType(t.reference(PointerType.PointerOrigin.ARRAY))).collect(Collectors.toSet());
            UnknownType alternative = !types.isEmpty() ? (Type)types.iterator().next() : UnknownType.getUnknownType();
            newType = TypeManager.getInstance().getCommonType(types).orElse(alternative);
            subTypes = new HashSet<Type>(this.getPossibleSubTypes());
            subTypes.remove(oldType);
            subTypes.addAll(types);
        } else {
            newType = src.getType();
            subTypes = new HashSet<Type>(this.getPossibleSubTypes());
            subTypes.remove(oldType);
            subTypes.add(newType);
        }
        this.setType(newType, root);
        this.setPossibleSubTypes(subTypes, root);
        if (!previous.equals(this.type)) {
            this.type.setTypeOrigin(Type.Origin.DATAFLOW);
        }
    }

    @Override
    public void possibleSubTypesChanged(HasType src, HasType root, Set<Type> oldSubTypes) {
        if (!TypeManager.isTypeSystemActive()) {
            return;
        }
        HashSet<Type> subTypes = new HashSet<Type>(this.getPossibleSubTypes());
        subTypes.addAll(src.getPossibleSubTypes());
        this.setPossibleSubTypes(subTypes, root);
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, Node.TO_STRING_STYLE).appendSuper(super.toString()).append("initializers", this.initializers).toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InitializerListExpression)) {
            return false;
        }
        InitializerListExpression that = (InitializerListExpression)o;
        return super.equals(that) && PropertyEdge.propertyEqualsList(this.initializers, that.initializers) && Objects.equals(this.getInitializers(), that.getInitializers());
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

