/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.graph.edge;

import de.fraunhofer.aisec.cpg.graph.edge.Properties;
import de.fraunhofer.aisec.cpg.graph.edge.PropertyEdgeConverterManager;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.neo4j.ogm.typeconversion.CompositeAttributeConverter;

public class PropertyEdgeConverter
implements CompositeAttributeConverter<Map<Properties, Object>> {
    private final Map<String, Function<Object, String>> serializer = PropertyEdgeConverterManager.getInstance().getSerializer();
    private final Map<String, Function<Object, Object>> deserializer = PropertyEdgeConverterManager.getInstance().getDeserializer();

    public Map<String, Object> toGraphProperties(Map<Properties, Object> value) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<Properties, Object> entry : value.entrySet()) {
            Object propertyValue = entry.getValue();
            if (this.serializer.containsKey(propertyValue.getClass().getName())) {
                String serializedProperty = this.serializer.get(propertyValue.getClass().getName()).apply(propertyValue);
                result.put(entry.getKey().name(), serializedProperty);
                continue;
            }
            result.put(entry.getKey().name(), propertyValue);
        }
        return result;
    }

    public Map<Properties, Object> toEntityAttribute(Map<String, ?> value) {
        EnumMap<Properties, Object> result = new EnumMap<Properties, Object>(Properties.class);
        for (Properties prop : Properties.values()) {
            if (this.deserializer.containsKey(prop.name())) {
                Object deserializedProperty = this.deserializer.get(prop.name()).apply(value.get(prop.name()));
                result.put(prop, deserializedProperty);
                continue;
            }
            result.put(prop, value.get(prop.name()));
        }
        return result;
    }
}

