/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg;

import de.fraunhofer.aisec.cpg.TranslationConfiguration;
import de.fraunhofer.aisec.cpg.TranslationResult;
import de.fraunhofer.aisec.cpg.frontends.LanguageFrontend;
import de.fraunhofer.aisec.cpg.frontends.TranslationException;
import de.fraunhofer.aisec.cpg.frontends.cpp.CXXLanguageFrontend;
import de.fraunhofer.aisec.cpg.frontends.golang.GoLanguageFrontend;
import de.fraunhofer.aisec.cpg.graph.TypeManager;
import de.fraunhofer.aisec.cpg.helpers.Benchmark;
import de.fraunhofer.aisec.cpg.helpers.SubgraphWalker;
import de.fraunhofer.aisec.cpg.helpers.Util;
import de.fraunhofer.aisec.cpg.passes.Pass;
import de.fraunhofer.aisec.cpg.passes.scopes.ScopeManager;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TranslationManager {
    private static final Logger log = LoggerFactory.getLogger(TranslationManager.class);
    private @NonNull TranslationConfiguration config;
    private AtomicBoolean isCancelled = new AtomicBoolean(false);

    private TranslationManager(@NonNull TranslationConfiguration config) {
        this.config = config;
    }

    public static Builder builder() {
        return new Builder();
    }

    public CompletableFuture<TranslationResult> analyze() {
        TranslationResult result = new TranslationResult(this);
        return CompletableFuture.supplyAsync(() -> {
            ScopeManager scopesBuildForAnalysis = new ScopeManager();
            Benchmark outerBench = new Benchmark(TranslationManager.class, "Translation into full graph");
            HashSet<Pass> passesNeedCleanup = new HashSet<Pass>();
            Set<LanguageFrontend> frontendsNeedCleanup = null;
            try {
                Benchmark bench = new Benchmark(this.getClass(), "Frontend");
                frontendsNeedCleanup = this.runFrontends(result, this.config, scopesBuildForAnalysis);
                bench.stop();
                for (Pass pass : this.config.getRegisteredPasses()) {
                    passesNeedCleanup.add(pass);
                    bench = new Benchmark(pass.getClass(), "Executing Pass");
                    pass.accept(result);
                    bench.stop();
                    if (!result.isCancelled()) continue;
                    log.warn("Analysis interrupted, stopping Pass evaluation");
                }
            }
            catch (TranslationException ex) {
                throw new CompletionException(ex);
            }
            finally {
                outerBench.stop();
                if (!this.config.disableCleanup) {
                    log.debug("Cleaning up {} Passes", (Object)passesNeedCleanup.size());
                    passesNeedCleanup.forEach(Pass::cleanup);
                    if (frontendsNeedCleanup != null) {
                        log.debug("Cleaning up {} Frontends", (Object)frontendsNeedCleanup.size());
                        frontendsNeedCleanup.forEach(LanguageFrontend::cleanup);
                    }
                    TypeManager.getInstance().cleanup();
                }
            }
            return result;
        });
    }

    public List<Pass> getPasses() {
        return this.config.getRegisteredPasses();
    }

    public boolean isCancelled() {
        return this.isCancelled.get();
    }

    private Set<LanguageFrontend> runFrontends(@NonNull TranslationResult result, @NonNull TranslationConfiguration config, @NonNull ScopeManager scopeManager) throws TranslationException {
        List<File> sourceLocations = new ArrayList<File>(this.config.getSourceLocations());
        if (config.useUnityBuild) {
            try {
                File tmpFile = Files.createTempFile("compile", ".cpp", new FileAttribute[0]).toFile();
                tmpFile.deleteOnExit();
                try (PrintWriter writer = new PrintWriter(tmpFile);){
                    for (int i = 0; i < sourceLocations.size(); ++i) {
                        File sourceLocation = (File)sourceLocations.get(i);
                        if (sourceLocation.isDirectory()) {
                            try (Stream<Path> stream = Files.find(sourceLocation.toPath(), 999, (p, fileAttr) -> fileAttr.isRegularFile(), new FileVisitOption[0]);){
                                sourceLocations.addAll(stream.map(Path::toFile).collect(Collectors.toSet()));
                                continue;
                            }
                        }
                        if (!CXXLanguageFrontend.CXX_EXTENSIONS.contains(Util.getExtension(sourceLocation))) continue;
                        if (config.getTopLevel() != null) {
                            Path topLevel = config.getTopLevel().toPath();
                            writer.write("#include \"" + topLevel.relativize(sourceLocation.toPath()) + "\"\n");
                            continue;
                        }
                        writer.write("#include \"" + sourceLocation.getAbsolutePath() + "\"\n");
                    }
                }
                sourceLocations = List.of(tmpFile);
            }
            catch (IOException e) {
                throw new TranslationException(e);
            }
        }
        boolean useParallelFrontends = config.useParallelFrontends;
        for (int i = 0; i < sourceLocations.size(); ++i) {
            File sourceLocation = (File)sourceLocations.get(i);
            if (sourceLocation.isDirectory()) {
                try (Stream<Path> stream = Files.find(sourceLocation.toPath(), 999, (p, fileAttr) -> fileAttr.isRegularFile(), new FileVisitOption[0]);){
                    sourceLocations.addAll(stream.map(Path::toFile).collect(Collectors.toSet()));
                    sourceLocations.remove(sourceLocation);
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
                continue;
            }
            if (!useParallelFrontends || this.getFrontendClass(Util.getExtension(sourceLocation)) != GoLanguageFrontend.class) continue;
            log.warn("Parallel frontends are not yet supported for Go");
            useParallelFrontends = false;
        }
        TypeManager.setTypeSystemActive(config.typeSystemActiveInFrontend);
        Set<LanguageFrontend> usedFrontends = useParallelFrontends ? this.parseParallel(result, scopeManager, sourceLocations) : this.parseSequentially(result, scopeManager, sourceLocations);
        if (!config.typeSystemActiveInFrontend) {
            TypeManager.setTypeSystemActive(true);
            result.getTranslationUnits().forEach(tu -> SubgraphWalker.activateTypes(tu, scopeManager));
        }
        return usedFrontends;
    }

    private Set<LanguageFrontend> parseParallel(@NonNull TranslationResult result, @NonNull ScopeManager originalScopeManager, Collection<File> sourceLocations) {
        HashSet<LanguageFrontend> usedFrontends = new HashSet<LanguageFrontend>();
        log.info("Parallel parsing started");
        ArrayList<CompletableFuture<Optional<LanguageFrontend>>> futures = new ArrayList<CompletableFuture<Optional<LanguageFrontend>>>();
        ArrayList<ScopeManager> parallelScopeManagers = new ArrayList<ScopeManager>();
        IdentityHashMap<CompletableFuture<Optional<LanguageFrontend>>, File> futureToFile = new IdentityHashMap<CompletableFuture<Optional<LanguageFrontend>>, File>();
        for (File file : sourceLocations) {
            ScopeManager scopeManager = new ScopeManager();
            parallelScopeManagers.add(scopeManager);
            CompletableFuture<Optional<LanguageFrontend>> future = this.getParsingFuture(result, scopeManager, file);
            futures.add(future);
            futureToFile.put(future, file);
        }
        for (CompletableFuture completableFuture : futures) {
            try {
                ((Optional)completableFuture.get()).ifPresent(f -> this.handleCompletion(result, (Set<LanguageFrontend>)usedFrontends, (File)futureToFile.get(future), (LanguageFrontend)f));
            }
            catch (InterruptedException | ExecutionException e) {
                log.error("Error parsing " + futureToFile.get(completableFuture), (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
        originalScopeManager.mergeFrom(parallelScopeManagers);
        usedFrontends.forEach(f -> f.setScopeManager(originalScopeManager));
        log.info("Parallel parsing completed");
        return usedFrontends;
    }

    private CompletableFuture<Optional<LanguageFrontend>> getParsingFuture(@NonNull TranslationResult result, @NonNull ScopeManager scopeManager, File sourceLocation) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.parse(result, scopeManager, sourceLocation);
            }
            catch (TranslationException e) {
                throw new RuntimeException("Error parsing " + sourceLocation, e);
            }
        });
    }

    private Set<LanguageFrontend> parseSequentially(@NonNull TranslationResult result, @NonNull ScopeManager scopeManager, Collection<File> sourceLocations) throws TranslationException {
        HashSet<LanguageFrontend> usedFrontends = new HashSet<LanguageFrontend>();
        for (File sourceLocation : sourceLocations) {
            log.info("Parsing {}", (Object)sourceLocation.getAbsolutePath());
            this.parse(result, scopeManager, sourceLocation).ifPresent(f -> this.handleCompletion(result, (Set<LanguageFrontend>)usedFrontends, sourceLocation, (LanguageFrontend)f));
        }
        return usedFrontends;
    }

    private void handleCompletion(@NonNull TranslationResult result, Set<LanguageFrontend> usedFrontends, File sourceLocation, LanguageFrontend f) {
        usedFrontends.add(f);
        if (usedFrontends.stream().map(Object::getClass).distinct().count() > 1L) {
            log.error("Different frontends are used for multiple files. This will very likely break the following passes.");
        }
        Map sfToFe = (Map)result.getScratch().computeIfAbsent("sourceLocationsToFrontend", x -> new HashMap());
        sfToFe.put(sourceLocation.getName(), f.getClass().getSimpleName());
        for (Pass pass : this.config.getRegisteredPasses()) {
            pass.setLang(f);
        }
    }

    private Optional<LanguageFrontend> parse(@NotNull TranslationResult result, @NotNull ScopeManager scopeManager, File sourceLocation) throws TranslationException {
        LanguageFrontend frontend;
        block4: {
            frontend = null;
            try {
                frontend = this.getFrontend(Util.getExtension(sourceLocation), scopeManager);
                if (frontend == null) {
                    log.error("Found no parser frontend for {}", (Object)sourceLocation.getName());
                    if (this.config.failOnError) {
                        throw new TranslationException("Found no parser frontend for " + sourceLocation.getName());
                    }
                    return Optional.empty();
                }
                result.addTranslationUnit(frontend.parse(sourceLocation));
            }
            catch (TranslationException ex) {
                log.error("An error occurred during parsing of {}: {}", (Object)sourceLocation.getName(), (Object)ex.getMessage());
                if (!this.config.failOnError) break block4;
                throw ex;
            }
        }
        return Optional.ofNullable(frontend);
    }

    private @Nullable LanguageFrontend getFrontend(String extension, ScopeManager scopeManager) {
        Class<? extends LanguageFrontend> clazz = this.getFrontendClass(extension);
        if (clazz != null) {
            try {
                return clazz.getConstructor(TranslationConfiguration.class, ScopeManager.class).newInstance(this.config, scopeManager);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                log.error("Could not instantiate language frontend {}", (Object)clazz.getName(), (Object)e);
                return null;
            }
        }
        return null;
    }

    private @Nullable Class<? extends LanguageFrontend> getFrontendClass(String extension) {
        return this.config.getFrontends().entrySet().stream().filter(entry -> ((List)entry.getValue()).contains(extension)).map(Map.Entry::getKey).findAny().orElse(null);
    }

    public @NonNull TranslationConfiguration getConfig() {
        return this.config;
    }

    public static class Builder {
        private TranslationConfiguration config;

        private Builder() {
        }

        public Builder config(TranslationConfiguration config) {
            this.config = config;
            return this;
        }

        public TranslationManager build() {
            return new TranslationManager(this.config);
        }
    }
}

