/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.graph.declarations;

import de.fraunhofer.aisec.cpg.graph.DeclarationHolder;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.SubGraph;
import de.fraunhofer.aisec.cpg.graph.declarations.ConstructorDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.Declaration;
import de.fraunhofer.aisec.cpg.graph.declarations.FieldDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.MethodDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.ValueDeclaration;
import de.fraunhofer.aisec.cpg.graph.edge.PropertyEdge;
import de.fraunhofer.aisec.cpg.graph.types.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.neo4j.ogm.annotation.Relationship;
import org.neo4j.ogm.annotation.Transient;

public class RecordDeclaration
extends Declaration
implements DeclarationHolder {
    private String kind;
    @Relationship(value="FIELDS", direction="OUTGOING")
    @SubGraph(value={"AST"})
    private List<PropertyEdge<FieldDeclaration>> fields = new ArrayList<PropertyEdge<FieldDeclaration>>();
    @Relationship(value="METHODS", direction="OUTGOING")
    @SubGraph(value={"AST"})
    private List<PropertyEdge<MethodDeclaration>> methods = new ArrayList<PropertyEdge<MethodDeclaration>>();
    @Relationship(value="CONSTRUCTORS", direction="OUTGOING")
    @SubGraph(value={"AST"})
    private List<PropertyEdge<ConstructorDeclaration>> constructors = new ArrayList<PropertyEdge<ConstructorDeclaration>>();
    @Relationship(value="RECORDS", direction="OUTGOING")
    @SubGraph(value={"AST"})
    private List<PropertyEdge<RecordDeclaration>> records = new ArrayList<PropertyEdge<RecordDeclaration>>();
    @Transient
    private List<Type> superClasses = new ArrayList<Type>();
    @Transient
    private List<Type> implementedInterfaces = new ArrayList<Type>();
    @Relationship
    private Set<RecordDeclaration> superTypeDeclarations = new HashSet<RecordDeclaration>();
    private List<String> importStatements = new ArrayList<String>();
    @Relationship
    private Set<Declaration> imports = new HashSet<Declaration>();
    private List<String> staticImportStatements = new ArrayList<String>();
    @Relationship
    private Set<ValueDeclaration> staticImports = new HashSet<ValueDeclaration>();

    @Override
    public void setName(@NonNull String name) {
        super.setName(name);
        for (PropertyEdge<ConstructorDeclaration> constructorEdge : this.constructors) {
            constructorEdge.getEnd().setName(name);
        }
    }

    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public List<FieldDeclaration> getFields() {
        return PropertyEdge.unwrap(this.fields);
    }

    public List<PropertyEdge<FieldDeclaration>> getFieldsPropertyEdge() {
        return this.fields;
    }

    public void addField(FieldDeclaration fieldDeclaration) {
        this.addIfNotContains(this.fields, fieldDeclaration);
    }

    public void removeField(FieldDeclaration fieldDeclaration) {
        this.fields.removeIf(propertyEdge -> ((FieldDeclaration)propertyEdge.getEnd()).equals(fieldDeclaration));
    }

    public @Nullable FieldDeclaration getField(String name) {
        return this.fields.stream().map(PropertyEdge::getEnd).filter(f -> f.getName().equals(name)).findFirst().orElse(null);
    }

    public void setFields(List<FieldDeclaration> fields) {
        this.fields = PropertyEdge.transformIntoOutgoingPropertyEdgeList(fields, this);
    }

    public FieldDeclaration getThis() {
        return this.fields.stream().map(PropertyEdge::getEnd).filter(f -> f.getName().equals("this")).findFirst().orElse(null);
    }

    public List<MethodDeclaration> getMethods() {
        return PropertyEdge.unwrap(this.methods);
    }

    public List<PropertyEdge<MethodDeclaration>> getMethodsPropertyEdge() {
        return this.methods;
    }

    public void addMethod(MethodDeclaration methodDeclaration) {
        this.addIfNotContains(this.methods, methodDeclaration);
    }

    public void removeMethod(MethodDeclaration methodDeclaration) {
        this.methods.removeIf(propertyEdge -> ((MethodDeclaration)propertyEdge.getEnd()).equals(methodDeclaration));
    }

    public void setMethods(List<MethodDeclaration> methods) {
        this.methods = PropertyEdge.transformIntoOutgoingPropertyEdgeList(methods, this);
    }

    public List<ConstructorDeclaration> getConstructors() {
        return PropertyEdge.unwrap(this.constructors);
    }

    public List<PropertyEdge<ConstructorDeclaration>> getConstructorsPropertyEdge() {
        return this.constructors;
    }

    public void setConstructors(List<ConstructorDeclaration> constructors) {
        this.constructors = PropertyEdge.transformIntoOutgoingPropertyEdgeList(constructors, this);
    }

    public void addConstructor(ConstructorDeclaration constructorDeclaration) {
        this.addIfNotContains(this.constructors, constructorDeclaration);
    }

    public void removeConstructor(ConstructorDeclaration constructorDeclaration) {
        this.constructors.removeIf(propertyEdge -> ((ConstructorDeclaration)propertyEdge.getEnd()).equals(constructorDeclaration));
    }

    public List<RecordDeclaration> getRecords() {
        return PropertyEdge.unwrap(this.records);
    }

    public List<PropertyEdge<RecordDeclaration>> getRecordsPropertyEdge() {
        return this.records;
    }

    public void setRecords(List<RecordDeclaration> records) {
        this.records = PropertyEdge.transformIntoOutgoingPropertyEdgeList(records, this);
    }

    public void removeRecord(RecordDeclaration recordDeclaration) {
        this.records.removeIf(propertyEdge -> ((RecordDeclaration)propertyEdge.getEnd()).equals(recordDeclaration));
    }

    public List<Type> getSuperTypes() {
        return Stream.of(this.superClasses, this.implementedInterfaces).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<Type> getSuperClasses() {
        return this.superClasses;
    }

    public void setSuperClasses(List<Type> superClasses) {
        this.superClasses = superClasses;
    }

    public List<Type> getImplementedInterfaces() {
        return this.implementedInterfaces;
    }

    public void setImplementedInterfaces(List<Type> implementedInterfaces) {
        this.implementedInterfaces = implementedInterfaces;
    }

    public Set<RecordDeclaration> getSuperTypeDeclarations() {
        return this.superTypeDeclarations;
    }

    public void setSuperTypeDeclarations(Set<RecordDeclaration> superTypeDeclarations) {
        this.superTypeDeclarations = superTypeDeclarations;
    }

    public Set<Declaration> getImports() {
        return this.imports;
    }

    public void setImports(Set<Declaration> imports) {
        this.imports = imports;
    }

    public Set<ValueDeclaration> getStaticImports() {
        return this.staticImports;
    }

    public void setStaticImports(Set<ValueDeclaration> staticImports) {
        this.staticImports = staticImports;
    }

    public List<String> getImportStatements() {
        return this.importStatements;
    }

    public void setImportStatements(List<String> importStatements) {
        this.importStatements = importStatements;
    }

    public List<String> getStaticImportStatements() {
        return this.staticImportStatements;
    }

    public void setStaticImportStatements(List<String> staticImportStatements) {
        this.staticImportStatements = staticImportStatements;
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, Node.TO_STRING_STYLE).appendSuper(super.toString()).append("name", (Object)this.name).append("kind", (Object)this.kind).append("superTypeDeclarations", this.superTypeDeclarations).append("fields", this.fields).append("methods", this.methods).append("constructors", this.constructors).append("records", this.records).toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RecordDeclaration)) {
            return false;
        }
        RecordDeclaration that = (RecordDeclaration)o;
        return super.equals(that) && Objects.equals(this.kind, that.kind) && Objects.equals(this.getFields(), that.getFields()) && PropertyEdge.propertyEqualsList(this.fields, that.fields) && Objects.equals(this.getMethods(), that.getMethods()) && PropertyEdge.propertyEqualsList(this.methods, that.methods) && Objects.equals(this.getConstructors(), that.getConstructors()) && PropertyEdge.propertyEqualsList(this.constructors, that.constructors) && Objects.equals(this.getRecords(), that.getRecords()) && PropertyEdge.propertyEqualsList(this.records, that.records) && Objects.equals(this.superClasses, that.superClasses) && Objects.equals(this.implementedInterfaces, that.implementedInterfaces) && Objects.equals(this.superTypeDeclarations, that.superTypeDeclarations);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public void addDeclaration(@NonNull Declaration declaration) {
        if (declaration instanceof ConstructorDeclaration) {
            this.addIfNotContains(this.constructors, (ConstructorDeclaration)declaration);
        } else if (declaration instanceof MethodDeclaration) {
            this.addIfNotContains(this.methods, (MethodDeclaration)declaration);
        } else if (declaration instanceof FieldDeclaration) {
            this.addIfNotContains(this.fields, (FieldDeclaration)declaration);
        } else if (declaration instanceof RecordDeclaration) {
            this.addIfNotContains(this.records, (RecordDeclaration)declaration);
        }
    }
}

