/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.graph.declarations;

import de.fraunhofer.aisec.cpg.graph.DeclarationHolder;
import de.fraunhofer.aisec.cpg.graph.SubGraph;
import de.fraunhofer.aisec.cpg.graph.declarations.Declaration;
import de.fraunhofer.aisec.cpg.graph.declarations.FieldDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.FunctionDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.RecordDeclaration;
import de.fraunhofer.aisec.cpg.helpers.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;

public class NamespaceDeclaration
extends Declaration
implements DeclarationHolder {
    @SubGraph(value={"AST"})
    private List<Declaration> declarations = new ArrayList<Declaration>();

    public List<FieldDeclaration> getFields() {
        return Util.filterCast(this.declarations, FieldDeclaration.class);
    }

    public List<FunctionDeclaration> getFunctions() {
        return Util.filterCast(this.declarations, FunctionDeclaration.class);
    }

    public List<RecordDeclaration> getRecords() {
        return Util.filterCast(this.declarations, RecordDeclaration.class);
    }

    public List<NamespaceDeclaration> getNamespaces() {
        return Util.filterCast(this.declarations, NamespaceDeclaration.class);
    }

    public List<Declaration> getDeclarations() {
        return this.declarations;
    }

    public <T extends Declaration> @NonNull Set<T> getDeclarationsByName(@NonNull String name, @NonNull Class<T> clazz) {
        return this.getDeclarations().stream().filter(declaration -> clazz.isAssignableFrom(declaration.getClass())).map(clazz::cast).filter(declaration -> Objects.equals(declaration.getName(), name)).collect(Collectors.toSet());
    }

    public <T> T getDeclarationAs(int i, Class<T> clazz) {
        return clazz.cast(this.getDeclarations().get(i));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NamespaceDeclaration)) {
            return false;
        }
        NamespaceDeclaration that = (NamespaceDeclaration)o;
        return super.equals(that) && Objects.equals(this.declarations, that.declarations);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public void addDeclaration(@NonNull Declaration declaration) {
        this.addIfNotContains(this.declarations, declaration);
    }
}

