/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.frontends;

import de.fraunhofer.aisec.cpg.frontends.HandlerInterface;
import de.fraunhofer.aisec.cpg.frontends.LanguageFrontend;
import de.fraunhofer.aisec.cpg.helpers.Util;
import java.lang.reflect.ParameterizedType;
import java.util.HashMap;
import java.util.function.Supplier;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Handler<S, T, L extends LanguageFrontend> {
    protected static final Logger log = LoggerFactory.getLogger(Handler.class);
    protected final HashMap<Class<? extends T>, HandlerInterface<S, T>> map = new HashMap();
    private final Supplier<S> configConstructor;
    protected L lang;
    private Class<S> typeOfT = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[1];

    public Handler(Supplier<S> configConstructor, L lang) {
        this.configConstructor = configConstructor;
        this.lang = lang;
    }

    public S handle(T ctx) {
        S ret;
        ASTNode astNode;
        if (ctx == null) {
            log.error("ctx is NULL. This can happen when ast children are optional in {}. Called by {}", this.getClass(), (Object)Thread.currentThread().getStackTrace()[2]);
            return null;
        }
        if (!((LanguageFrontend)this.lang).config.loadIncludes && ctx instanceof ASTNode && (astNode = (ASTNode)ctx).getFileLocation() != null && astNode.getFileLocation().getContextInclusionStatement() != null) {
            log.debug("Skip parsing include file" + astNode.getContainingFilename());
            return null;
        }
        Class<?> toHandle = ctx.getClass();
        HandlerInterface<S, T> handler = this.map.get(toHandle);
        while (handler == null) {
            handler = this.map.get(toHandle = toHandle.getSuperclass());
            if (handler != null && !ctx.getClass().getSimpleName().contains("LiteralExpr")) {
                Util.errorWithFileLocation(this.lang, ctx, log, "No handler for type {}, resolving for its superclass {}.", new Object[]{ctx.getClass(), toHandle});
            }
            if (toHandle != this.typeOfT && this.typeOfT.isAssignableFrom(toHandle)) continue;
        }
        if (handler != null) {
            S s = handler.handle(ctx);
            ((LanguageFrontend)this.lang).setCodeAndRegion(s, ctx);
            ((LanguageFrontend)this.lang).setComment(s, ctx);
            ret = s;
        } else {
            Util.errorWithFileLocation(this.lang, ctx, log, "Parsing of type {} is not supported (yet)", new Object[]{ctx.getClass()});
            ret = this.configConstructor.get();
        }
        ((LanguageFrontend)this.lang).process(ctx, ret);
        return ret;
    }
}

