/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.typeconversion;

import java.lang.reflect.Array;
import org.neo4j.ogm.typeconversion.AttributeConverter;

public class EnumArrayStringConverter
implements AttributeConverter<Enum[], String[]> {
    private final Class<? extends Enum> enumClass;

    public EnumArrayStringConverter(Class<? extends Enum> enumClass) {
        this.enumClass = enumClass;
    }

    @Override
    public String[] toGraphProperty(Enum[] value) {
        if (value == null) {
            return null;
        }
        String[] values2 = new String[value.length];
        int i = 0;
        for (Enum e : value) {
            values2[i++] = e.name();
        }
        return values2;
    }

    @Override
    public Enum[] toEntityAttribute(String[] stringValues) {
        if (stringValues == null) {
            return null;
        }
        Enum[] values2 = (Enum[])Array.newInstance(this.enumClass, stringValues.length);
        int i = 0;
        for (String value : stringValues) {
            values2[i++] = Enum.valueOf(this.enumClass, value);
        }
        return values2;
    }
}

