/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session.request;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.ogm.exception.OptimisticLockingException;
import org.neo4j.ogm.model.RowModel;
import org.neo4j.ogm.request.OptimisticLockingConfig;
import org.neo4j.ogm.request.Statement;
import org.neo4j.ogm.session.Neo4jSession;

public class OptimisticLockingChecker {
    private final Neo4jSession session;

    public OptimisticLockingChecker(Neo4jSession session) {
        this.session = session;
    }

    public void checkResultsCount(List<RowModel> models, Statement request) {
        OptimisticLockingConfig olConfig = request.optimisticLockingConfig().orElseThrow(() -> new IllegalArgumentException("Statement " + request + " doesn't require results count check"));
        StringBuilder message = new StringBuilder();
        if (olConfig.getExpectedResultsCount() != models.size()) {
            message.append("Optimistic locking exception failed. ");
            Map<String, Object> parameters = request.getParameters();
            Object type = parameters.get("type");
            List rows = (List)parameters.get("rows");
            if (rows != null) {
                HashMap<Long, Long> nodeIds = new HashMap<Long, Long>();
                HashMap<Long, Long> relIds = new HashMap<Long, Long>();
                for (Map map : rows) {
                    if (type.equals("node")) {
                        nodeIds.put((Long)map.get("nodeId"), (Long)map.get(olConfig.getVersionProperty()));
                        continue;
                    }
                    if (!type.equals("rel")) continue;
                    relIds.put((Long)map.get("relId"), (Long)map.get(olConfig.getVersionProperty()));
                }
                if (!models.isEmpty()) {
                    int idPosition = ArrayUtils.indexOf(models.get(0).variables(), "id");
                    for (RowModel model : models) {
                        Object id = model.getValues()[idPosition];
                        if (type.equals("node")) {
                            nodeIds.remove(id);
                            continue;
                        }
                        if (!type.equals("rel")) continue;
                        relIds.remove(id);
                    }
                }
                for (Map.Entry entry : nodeIds.entrySet()) {
                    Long nodeId = (Long)entry.getKey();
                    this.session.context().detachNodeEntity(nodeId);
                    message.append("Entity with type='").append(Arrays.toString(olConfig.getTypes())).append("' and id='").append(nodeId).append("' had incorrect version ").append(entry.getValue());
                }
                for (Map.Entry entry : relIds.entrySet()) {
                    Long relId = (Long)entry.getKey();
                    this.session.context().detachRelationshipEntity(relId);
                    message.append("Relationship entity with id ").append(relId).append(" had incorrect version ").append(entry.getValue());
                }
            } else {
                Object id = parameters.get("id");
                if (id != null && models.isEmpty()) {
                    if (type.equals("node")) {
                        this.session.context().detachNodeEntity((Long)id);
                    } else if (type.equals("rel")) {
                        this.session.context().detachRelationshipEntity((Long)id);
                    }
                }
            }
            throw new OptimisticLockingException(message.toString());
        }
    }
}

