/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.cypher.query;

import java.util.Map;
import org.neo4j.ogm.cypher.query.Pagination;
import org.neo4j.ogm.cypher.query.PagingAndSorting;
import org.neo4j.ogm.cypher.query.SortOrder;

public class PagingAndSortingQuery
implements PagingAndSorting {
    private Pagination pagination;
    private SortOrder sortOrder = new SortOrder();
    private String matchClause;
    private String returnClause;
    private final Map<String, Object> parameters;
    private boolean returnsPath = false;
    private boolean hasPredicate;
    private String variable;

    public PagingAndSortingQuery(String matchClause, String returnClause, Map<String, Object> parameters, boolean returnsPath, boolean hasPredicate) {
        this(matchClause, returnClause, parameters, returnsPath, hasPredicate, "n");
    }

    public PagingAndSortingQuery(String matchClause, String returnClause, Map<String, Object> parameters, boolean returnsPath, boolean hasPredicate, String variable2) {
        this.matchClause = matchClause;
        this.returnClause = returnClause;
        this.parameters = parameters;
        this.returnsPath = returnsPath;
        this.hasPredicate = hasPredicate;
        this.variable = variable2;
    }

    public String getStatement() {
        String sorting = this.sortOrder().asString();
        StringBuilder sb = new StringBuilder();
        sb.append(this.matchClause);
        if (!sorting.isEmpty()) {
            sb.append(sorting.replace("$", this.variable));
        }
        if (this.pagination != null) {
            sb.append(this.pagination.toString());
        }
        sb.append(this.returnClause);
        if (this.needsRowResult()) {
            sb.append(", ID(").append(this.variable).append(")");
        }
        return sb.toString();
    }

    public boolean needsRowResult() {
        return (this.sortOrder.hasSortClauses() || this.pagination != null || this.hasPredicate) && this.returnsPath;
    }

    @Override
    public PagingAndSortingQuery setPagination(Pagination pagination) {
        this.pagination = pagination;
        return this;
    }

    @Override
    public PagingAndSortingQuery setSortOrder(SortOrder sortOrder) {
        this.sortOrder = sortOrder;
        return this;
    }

    public void setReturnsPath(boolean returnsPath) {
        this.returnsPath = returnsPath;
    }

    private SortOrder sortOrder() {
        return this.sortOrder;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }
}

