/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.context;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import org.neo4j.ogm.exception.core.MappingException;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.metadata.DescriptorMappings;
import org.neo4j.ogm.metadata.FieldInfo;
import org.neo4j.ogm.metadata.MetaData;
import org.neo4j.ogm.metadata.reflect.EntityAccessManager;
import org.neo4j.ogm.metadata.reflect.EntityFactory;
import org.neo4j.ogm.metadata.reflect.GenericUtils;
import org.neo4j.ogm.model.RowModel;
import org.neo4j.ogm.session.EntityInstantiator;
import org.neo4j.ogm.support.ClassUtils;
import org.neo4j.ogm.support.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleUseEntityMapper {
    private static final Logger logger = LoggerFactory.getLogger(SingleUseEntityMapper.class);
    private final EntityFactory entityFactory;
    private final MetaData metadata;

    public SingleUseEntityMapper(MetaData mappingMetaData, EntityFactory entityFactory) {
        this.metadata = mappingMetaData;
        this.entityFactory = new EntityFactory(mappingMetaData);
    }

    public SingleUseEntityMapper(MetaData mappingMetaData, EntityInstantiator entityInstantiator) {
        this.metadata = mappingMetaData;
        this.entityFactory = new EntityFactory(mappingMetaData, entityInstantiator);
    }

    public <T> T map(Class<T> type, String[] columnNames, RowModel rowModel) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        for (int i = 0; i < rowModel.getValues().length; ++i) {
            properties.put(columnNames[i], rowModel.getValues()[i]);
        }
        T entity = this.entityFactory.newObject(type, properties);
        this.setPropertiesOnEntity(entity, properties);
        return entity;
    }

    public <T> T map(Class<T> type, Map<String, Object> row) {
        T entity = this.entityFactory.newObject(type, row);
        this.setPropertiesOnEntity(entity, row);
        return entity;
    }

    private void setPropertiesOnEntity(Object entity, Map<String, Object> propertyMap) {
        ClassInfo classInfo = this.resolveClassInfoFor(entity.getClass());
        for (Map.Entry<String, Object> propertyMapEntry : propertyMap.entrySet()) {
            this.writeProperty(classInfo, entity, propertyMapEntry);
        }
    }

    private ClassInfo resolveClassInfoFor(Class<?> type) {
        ClassInfo classInfo = this.metadata.classInfo(type.getName());
        if (classInfo != null) {
            return classInfo;
        }
        throw new MappingException("Error mapping to ad-hoc " + type + ".  At present, only @Result types that are discovered by the domain entity package scanning can be mapped.");
    }

    private void writeProperty(ClassInfo classInfo, Object instance, Map.Entry<String, Object> property) {
        FieldInfo fieldInfo;
        String key = property.getKey();
        FieldInfo writer = classInfo.getFieldInfo(key);
        if (writer == null && (fieldInfo = classInfo.relationshipFieldByName(key)) != null) {
            writer = fieldInfo;
        }
        if (writer == null) {
            logger.warn("Unable to find property: {} on class: {} for writing", (Object)key, (Object)classInfo.name());
        } else {
            Class<?> effectiveFieldType = writer.type();
            Class<?> elementType = writer.convertedType();
            if (elementType == null) {
                elementType = DescriptorMappings.getType(writer.getTypeDescriptor());
            }
            Predicate<Class> isCollectionLike = c -> c != null && c.isArray() || Iterable.class.isAssignableFrom((Class<?>)c);
            boolean targetIsCollection = isCollectionLike.test(effectiveFieldType);
            Object value = property.getValue();
            if (!targetIsCollection && GenericUtils.isGenericField(writer.getField()) && value != null && isCollectionLike.test(value.getClass())) {
                targetIsCollection = true;
            }
            if (this.metadata.classInfo(elementType) != null) {
                value = this.mapKnownEntityType(elementType, key, value, targetIsCollection);
            }
            if (targetIsCollection) {
                if (value == null) {
                    value = Collections.emptyList();
                } else if (value.getClass().isArray()) {
                    value = Arrays.asList((Object[])value);
                }
                value = effectiveFieldType.isArray() ? EntityAccessManager.merge(effectiveFieldType, value, new Object[0], elementType) : EntityAccessManager.merge(effectiveFieldType, value, Collections.emptyList(), elementType);
            }
            writer.write(instance, value);
        }
    }

    Object mapKnownEntityType(Class elementType, String property, Object value, boolean asCollection) {
        ArrayList<Object> nestedObjects = new ArrayList<Object>();
        for (Object nestedPropertyMap : CollectionUtils.iterableOf(value)) {
            if (nestedPropertyMap instanceof Map) {
                nestedObjects.add(this.map(elementType, (Map)nestedPropertyMap));
                continue;
            }
            if (elementType.isInstance(nestedPropertyMap) || ClassUtils.isEnum(elementType)) {
                nestedObjects.add(nestedPropertyMap);
                continue;
            }
            logger.warn("Cannot map {} to a nested result object for property {}", nestedPropertyMap, (Object)property);
        }
        if (asCollection) {
            return nestedObjects;
        }
        if (nestedObjects.size() > 1) {
            logger.warn("Cannot map property {} from result set: The result contains more than one entry for the property.", (Object)property);
            return value;
        }
        return nestedObjects.isEmpty() ? null : nestedObjects.get(0);
    }
}

