/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.context;

import java.lang.reflect.InvocationTargetException;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.neo4j.ogm.annotation.EndNode;
import org.neo4j.ogm.annotation.StartNode;
import org.neo4j.ogm.context.EntityCollector;
import org.neo4j.ogm.context.MappedRelationship;
import org.neo4j.ogm.context.MappingContext;
import org.neo4j.ogm.exception.core.MappingException;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.metadata.DescriptorMappings;
import org.neo4j.ogm.metadata.FieldInfo;
import org.neo4j.ogm.metadata.MetaData;
import org.neo4j.ogm.metadata.MethodInfo;
import org.neo4j.ogm.metadata.reflect.EntityAccessManager;
import org.neo4j.ogm.metadata.reflect.EntityFactory;
import org.neo4j.ogm.model.Edge;
import org.neo4j.ogm.model.GraphModel;
import org.neo4j.ogm.model.Node;
import org.neo4j.ogm.model.Property;
import org.neo4j.ogm.response.model.PropertyModel;
import org.neo4j.ogm.session.EntityInstantiator;
import org.neo4j.ogm.typeconversion.CompositeAttributeConverter;
import org.neo4j.ogm.utils.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphEntityMapper {
    private static final Logger logger = LoggerFactory.getLogger(GraphEntityMapper.class);
    private final MappingContext mappingContext;
    private final EntityFactory entityFactory;
    private final MetaData metadata;

    private static Map<String, ?> toMap(List<Property<String, Object>> propertyList) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Property<String, Object> property : propertyList) {
            map.put(property.getKey(), property.getValue());
        }
        return map;
    }

    public GraphEntityMapper(MetaData metaData, MappingContext mappingContext, EntityInstantiator entityInstantiator) {
        this.metadata = metaData;
        this.entityFactory = new EntityFactory(this.metadata, entityInstantiator);
        this.mappingContext = mappingContext;
    }

    <T> List<T> map(Class<T> type, List<GraphModel> listOfGraphModels) {
        return this.map(type, listOfGraphModels, (m3, n) -> true, Collections.emptyMap());
    }

    <T> List<T> map(Class<T> type, List<GraphModel> listOfGraphModels, BiFunction<GraphModel, Long, Boolean> additionalNodeFilter, Map<Long, Long> order) {
        LinkedHashSet<Long> mappedNodeIds = new LinkedHashSet<Long>();
        AbstractSet returnedNodeIds = order.isEmpty() ? new LinkedHashSet() : new TreeSet<Long>(Comparator.comparingLong(e -> order.getOrDefault(e, (Long)e)));
        LinkedHashSet<Long> mappedRelationshipIds = new LinkedHashSet<Long>();
        LinkedHashSet returnedRelationshipIds = new LinkedHashSet();
        Consumer<GraphModel> mapContentOfIndividualModel = graphModel -> this.mapContentOf((GraphModel)graphModel, additionalNodeFilter, returnedNodeIds, (Set<Long>)mappedRelationshipIds, returnedRelationshipIds, (Set<Long>)mappedNodeIds);
        listOfGraphModels.forEach(mapContentOfIndividualModel);
        this.executePostLoad(mappedNodeIds, mappedRelationshipIds);
        Predicate<Object> entityPresentAndCompatible = entity -> entity != null && type.isAssignableFrom(entity.getClass());
        List results = returnedNodeIds.stream().map(this.mappingContext::getNodeEntity).filter(entityPresentAndCompatible).map(type::cast).collect(Collectors.toList());
        if (results.isEmpty()) {
            results = returnedRelationshipIds.stream().map(this.mappingContext::getRelationshipEntity).filter(entityPresentAndCompatible).map(type::cast).collect(Collectors.toList());
        }
        return results;
    }

    private void mapContentOf(GraphModel graphModel, BiFunction<GraphModel, Long, Boolean> additionalNodeFilter, Set<Long> returnedNodeIds, Set<Long> mappedRelationshipIds, Set<Long> returnedRelationshipIds, Set<Long> mappedNodeIds) {
        Predicate<Long> includeInResult = id -> (Boolean)additionalNodeFilter.apply(graphModel, (Long)id);
        try {
            Set<Long> newNodeIds = this.mapNodes(graphModel);
            returnedNodeIds.addAll(newNodeIds.stream().filter(includeInResult).collect(Collectors.toList()));
            mappedNodeIds.addAll(newNodeIds);
            newNodeIds = this.mapRelationships(graphModel);
            returnedRelationshipIds.addAll(newNodeIds.stream().filter(includeInResult).collect(Collectors.toList()));
            mappedRelationshipIds.addAll(newNodeIds);
        }
        catch (MappingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MappingException("Error mapping GraphModel", e);
        }
    }

    private void executePostLoad(Set<Long> nodeIds, Set<Long> edgeIds) {
        Object o;
        for (Long id : nodeIds) {
            o = this.mappingContext.getNodeEntity(id);
            this.executePostLoad(o);
        }
        for (Long id : edgeIds) {
            o = this.mappingContext.getRelationshipEntity(id);
            if (o == null) continue;
            this.executePostLoad(o);
        }
    }

    private void executePostLoad(Object instance) {
        ClassInfo classInfo = this.metadata.classInfo(instance);
        MethodInfo postLoadMethod = classInfo.postLoadMethodOrNull();
        if (postLoadMethod == null) {
            return;
        }
        try {
            postLoadMethod.invoke(instance, new Object[0]);
        }
        catch (SecurityException e) {
            logger.warn("Cannot call PostLoad annotated method {} on class {}, security manager denied access.", postLoadMethod.getMethod().getName(), classInfo.name(), e);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            logger.warn("Cannot call PostLoad annotated method {} on class {}. Make sure it is public and has no arguments", postLoadMethod.getMethod().getName(), classInfo.name(), e);
        }
    }

    private Set<Long> mapNodes(GraphModel graphModel) {
        LinkedHashSet<Long> mappedNodeIds = new LinkedHashSet<Long>();
        for (Node node : graphModel.getNodes()) {
            Object entity = this.mappingContext.getNodeEntity(node.getId());
            if (entity == null) {
                ClassInfo clsi = this.metadata.resolve(node.getLabels());
                if (clsi == null) {
                    logger.debug("Could not find a class to map for labels " + Arrays.toString(node.getLabels()));
                    continue;
                }
                HashMap<String, Object> allProps = new HashMap<String, Object>(GraphEntityMapper.toMap(node.getPropertyList()));
                this.getCompositeProperties(node.getPropertyList(), clsi).forEach((k, v) -> allProps.put(k.getName(), v));
                entity = this.entityFactory.newObject(clsi.getUnderlyingClass(), allProps);
                EntityUtils.setIdentity(entity, node.getId(), this.metadata);
                this.setProperties(node.getPropertyList(), entity);
                this.setLabels(node, entity);
                this.mappingContext.addNodeEntity(entity, node.getId());
            }
            mappedNodeIds.add(node.getId());
        }
        return mappedNodeIds;
    }

    private Map<FieldInfo, Object> getCompositeProperties(List<Property<String, Object>> propertyList, ClassInfo classInfo) {
        HashMap<FieldInfo, Object> compositeValues = new HashMap<FieldInfo, Object>();
        Collection<FieldInfo> compositeFields = classInfo.fieldsInfo().compositeFields();
        if (compositeFields.size() > 0) {
            Map<String, ?> propertyMap = GraphEntityMapper.toMap(propertyList);
            for (FieldInfo field2 : compositeFields) {
                CompositeAttributeConverter converter = field2.getCompositeConverter();
                compositeValues.put(field2, converter.toEntityAttribute(propertyMap));
            }
        }
        return compositeValues;
    }

    private void setProperties(List<Property<String, Object>> propertyList, Object instance) {
        ClassInfo classInfo = this.metadata.classInfo(instance);
        this.getCompositeProperties(propertyList, classInfo).forEach((field2, v) -> field2.write(instance, v));
        for (Property<String, Object> property : propertyList) {
            this.writeProperty(classInfo, instance, property);
        }
    }

    private void setLabels(Node nodeModel, Object instance) {
        ClassInfo classInfo = this.metadata.classInfo(instance);
        FieldInfo labelFieldInfo = classInfo.labelFieldOrNull();
        if (labelFieldInfo != null) {
            Collection<String> staticLabels = classInfo.staticLabels();
            HashSet<String> dynamicLabels = new HashSet<String>();
            for (String label : nodeModel.getLabels()) {
                if (staticLabels.contains(label)) continue;
                dynamicLabels.add(label);
            }
            this.writeProperty(classInfo, instance, PropertyModel.with(labelFieldInfo.getName(), dynamicLabels));
        }
    }

    private void writeProperty(ClassInfo classInfo, Object instance, Property<?, ?> property) {
        FieldInfo writer = classInfo.getFieldInfo(property.getKey().toString());
        if (writer == null) {
            logger.debug("Unable to find property: {} on class: {} for writing", property.getKey(), (Object)classInfo.name());
        } else {
            Object value = property.getValue();
            if (writer.type().isArray() || Iterable.class.isAssignableFrom(writer.type())) {
                Class<?> paramType = writer.type();
                Class elementType = this.underlyingElementType(classInfo, property.getKey().toString());
                value = paramType.isArray() ? EntityAccessManager.merge(paramType, value, new Object[0], elementType) : EntityAccessManager.merge(paramType, value, Collections.emptyList(), elementType);
            }
            writer.write(instance, value);
        }
    }

    private Set<Long> mapRelationships(GraphModel graphModel) {
        HashSet<Long> mappedRelationshipIds = new HashSet<Long>();
        ArrayList<Edge> oneToMany = new ArrayList<Edge>();
        for (Edge edge : graphModel.getRelationships()) {
            Object source = this.mappingContext.getNodeEntity(edge.getStartNode());
            Object target = this.mappingContext.getNodeEntity(edge.getEndNode());
            if (source == null || target == null) {
                String messageFormat = "Relationship {} cannot be fully hydrated because one or more required node entities have not been part of the result set.";
                logger.warn(messageFormat, (Object)edge);
                continue;
            }
            mappedRelationshipIds.add(edge.getId());
            ClassInfo relationshipEntityClassInfo = this.getRelationshipEntity(edge);
            if (relationshipEntityClassInfo != null) {
                this.mapRelationshipEntity(oneToMany, edge, source, target, relationshipEntityClassInfo);
                continue;
            }
            oneToMany.add(edge);
        }
        if (!oneToMany.isEmpty()) {
            this.mapOneToMany(oneToMany);
        }
        return mappedRelationshipIds;
    }

    private void mapRelationshipEntity(List<Edge> oneToMany, Edge edge, Object source, Object target, ClassInfo relationshipEntityClassInfo) {
        ClassInfo sourceInfo;
        FieldInfo writer;
        logger.debug("Found relationship type: {} to map to RelationshipEntity: {}", (Object)edge.getType(), (Object)relationshipEntityClassInfo.name());
        Object relationshipEntity = this.mappingContext.getRelationshipEntity(edge.getId());
        if (relationshipEntity == null) {
            relationshipEntity = this.createRelationshipEntity(edge, source, target);
        }
        if ((writer = EntityAccessManager.getRelationalWriter(sourceInfo = this.metadata.classInfo(source), edge.getType(), "OUTGOING", relationshipEntity)) == null) {
            logger.debug("No writer for {}", target);
        } else if (writer.forScalar()) {
            writer.write(source, relationshipEntity);
            this.mappingContext.addRelationship(new MappedRelationship(edge.getStartNode(), edge.getType(), edge.getEndNode(), edge.getId(), source.getClass(), DescriptorMappings.getType(writer.getTypeDescriptor())));
        } else {
            oneToMany.add(edge);
        }
        ClassInfo targetInfo = this.metadata.classInfo(target);
        writer = EntityAccessManager.getRelationalWriter(targetInfo, edge.getType(), "INCOMING", relationshipEntity);
        if (writer == null) {
            logger.debug("No writer for {}", target);
        } else if (writer.forScalar()) {
            writer.write(target, relationshipEntity);
        } else {
            oneToMany.add(edge);
        }
    }

    private Object createRelationshipEntity(Edge edge, Object startEntity, Object endEntity) {
        ClassInfo relationClassInfo = this.getRelationshipEntity(edge);
        if (relationClassInfo == null) {
            throw new MappingException("Could not find a class to map for relation " + edge);
        }
        HashMap<String, Object> allProps = new HashMap<String, Object>(GraphEntityMapper.toMap(edge.getPropertyList()));
        this.getCompositeProperties(edge.getPropertyList(), relationClassInfo).forEach((k, v) -> allProps.put(k.getName(), v));
        allProps.put(relationClassInfo.getStartNodeReader().getName(), startEntity);
        allProps.put(relationClassInfo.getEndNodeReader().getName(), endEntity);
        Object relationshipEntity = this.entityFactory.newObject(relationClassInfo.getUnderlyingClass(), allProps);
        EntityUtils.setIdentity(relationshipEntity, edge.getId(), this.metadata);
        this.setProperties(edge.getPropertyList(), relationshipEntity);
        this.mappingContext.addRelationshipEntity(relationshipEntity, edge.getId());
        ClassInfo relEntityInfo = this.metadata.classInfo(relationshipEntity);
        FieldInfo startNodeWriter = relEntityInfo.getStartNodeReader();
        if (startNodeWriter == null) {
            throw new RuntimeException("Cannot find a writer for the StartNode of relational entity " + relEntityInfo.name());
        }
        startNodeWriter.write(relationshipEntity, startEntity);
        FieldInfo endNodeWriter = relEntityInfo.getEndNodeReader();
        if (endNodeWriter == null) {
            throw new RuntimeException("Cannot find a writer for the EndNode of relational entity " + relEntityInfo.name());
        }
        endNodeWriter.write(relationshipEntity, endEntity);
        return relationshipEntity;
    }

    private void mapOneToMany(Collection<Edge> oneToManyRelationships) {
        EntityCollector entityCollector = new EntityCollector();
        ArrayList<MappedRelationship> relationshipsToRegister = new ArrayList<MappedRelationship>();
        for (Edge edge : oneToManyRelationships) {
            FieldInfo incomingWriter;
            FieldInfo outgoingWriter;
            Object instance = this.mappingContext.getNodeEntity(edge.getStartNode());
            Object parameter = this.mappingContext.getNodeEntity(edge.getEndNode());
            Object relationshipEntity = this.mappingContext.getRelationshipEntity(edge.getId());
            if (relationshipEntity != null) {
                outgoingWriter = this.findIterableWriter(instance, relationshipEntity, edge.getType(), "OUTGOING");
                if (outgoingWriter != null) {
                    entityCollector.collectRelationship(edge.getStartNode(), DescriptorMappings.getType(outgoingWriter.getTypeDescriptor()), edge.getType(), "OUTGOING", edge.getId(), edge.getEndNode(), relationshipEntity);
                    relationshipsToRegister.add(new MappedRelationship(edge.getStartNode(), edge.getType(), edge.getEndNode(), edge.getId(), instance.getClass(), DescriptorMappings.getType(outgoingWriter.getTypeDescriptor())));
                }
                if ((incomingWriter = this.findIterableWriter(parameter, relationshipEntity, edge.getType(), "INCOMING")) == null) continue;
                entityCollector.collectRelationship(edge.getEndNode(), DescriptorMappings.getType(incomingWriter.getTypeDescriptor()), edge.getType(), "INCOMING", edge.getId(), edge.getStartNode(), relationshipEntity);
                relationshipsToRegister.add(new MappedRelationship(edge.getStartNode(), edge.getType(), edge.getEndNode(), edge.getId(), instance.getClass(), DescriptorMappings.getType(incomingWriter.getTypeDescriptor())));
                continue;
            }
            outgoingWriter = EntityAccessManager.getRelationalWriter(this.metadata.classInfo(instance), edge.getType(), "OUTGOING", parameter);
            if (outgoingWriter != null) {
                if (!outgoingWriter.forScalar()) {
                    entityCollector.collectRelationship(edge.getStartNode(), DescriptorMappings.getType(outgoingWriter.getTypeDescriptor()), edge.getType(), "OUTGOING", edge.getEndNode(), parameter);
                } else {
                    outgoingWriter.write(instance, parameter);
                }
                MappedRelationship mappedRelationship = new MappedRelationship(edge.getStartNode(), edge.getType(), edge.getEndNode(), null, instance.getClass(), DescriptorMappings.getType(outgoingWriter.getTypeDescriptor()));
                relationshipsToRegister.add(mappedRelationship);
            }
            if ((incomingWriter = EntityAccessManager.getRelationalWriter(this.metadata.classInfo(parameter), edge.getType(), "INCOMING", instance)) == null) continue;
            if (!incomingWriter.forScalar()) {
                entityCollector.collectRelationship(edge.getEndNode(), DescriptorMappings.getType(incomingWriter.getTypeDescriptor()), edge.getType(), "INCOMING", edge.getStartNode(), instance);
            } else {
                incomingWriter.write(parameter, instance);
            }
            relationshipsToRegister.add(new MappedRelationship(edge.getStartNode(), edge.getType(), edge.getEndNode(), null, instance.getClass(), DescriptorMappings.getType(incomingWriter.getTypeDescriptor())));
        }
        entityCollector.forCollectedEntities((sourceId, type, direction, targetType, entities) -> this.mapOneToMany(this.mappingContext.getNodeEntity(sourceId), targetType, entities, type, direction));
        for (MappedRelationship mappedRelationship : relationshipsToRegister) {
            this.mappingContext.addRelationship(mappedRelationship);
        }
    }

    private FieldInfo findIterableWriter(Object instance, Object parameter, String relationshipType, String relationshipDirection) {
        ClassInfo classInfo = this.metadata.classInfo(instance);
        return EntityAccessManager.getIterableField(classInfo, parameter.getClass(), relationshipType, relationshipDirection);
    }

    private void mapOneToMany(Object instance, Class<?> valueType, Object values2, String relationshipType, String relationshipDirection) {
        ClassInfo classInfo = this.metadata.classInfo(instance);
        FieldInfo writer = EntityAccessManager.getIterableField(classInfo, valueType, relationshipType, relationshipDirection);
        if (writer != null) {
            FieldInfo reader;
            if ((writer.type().isArray() || Iterable.class.isAssignableFrom(writer.type())) && (reader = EntityAccessManager.getIterableField(classInfo, valueType, relationshipType, relationshipDirection)) != null) {
                Object currentValues = reader.read(instance);
                values2 = writer.type().isArray() ? EntityAccessManager.merge(writer.type(), values2, (Object[])currentValues, valueType) : EntityAccessManager.merge(writer.type(), values2, (Collection)currentValues, valueType);
            }
            writer.write(instance, values2);
            return;
        }
        logger.debug("Unable to map iterable of type: {} onto property of {}", (Object)valueType, (Object)classInfo.name());
    }

    private ClassInfo getRelationshipEntity(Edge edge) {
        Object source = this.mappingContext.getNodeEntity(edge.getStartNode());
        Object target = this.mappingContext.getNodeEntity(edge.getEndNode());
        Set<ClassInfo> classInfos = this.metadata.classInfoByLabelOrType(edge.getType());
        for (ClassInfo classInfo : classInfos) {
            if (!this.nodeTypeMatches(classInfo, source, StartNode.class) || !this.nodeTypeMatches(classInfo, target, EndNode.class)) continue;
            Class<?> relationshipEntityClass = classInfo.getUnderlyingClass();
            if (this.declaresRelationshipTo(relationshipEntityClass, source.getClass(), edge.getType(), "OUTGOING")) {
                return classInfo;
            }
            if (!this.declaresRelationshipTo(relationshipEntityClass, target.getClass(), edge.getType(), "INCOMING")) continue;
            return classInfo;
        }
        if (classInfos.size() == 1) {
            ClassInfo classInfo = classInfos.iterator().next();
            if (this.nodeTypeMatches(classInfo, source, StartNode.class) && this.nodeTypeMatches(classInfo, target, EndNode.class)) {
                return classInfo;
            }
        } else if (classInfos.size() == 0) {
            if (logger.isDebugEnabled()) {
                logger.debug("Unable to find a matching @RelationshipEntity for {}", (Object)edge.toString());
            }
        } else {
            logger.error("Found more than one matching @RelationshipEntity for {} but cannot tell which one to use", (Object)edge.toString());
        }
        return null;
    }

    private boolean declaresRelationshipTo(Class to, Class by2, String relationshipName, String relationshipDirection) {
        return EntityAccessManager.getRelationalWriter(this.metadata.classInfo(by2.getName()), relationshipName, relationshipDirection, to) != null;
    }

    private boolean nodeTypeMatches(ClassInfo classInfo, Object node, Class<?> annotationClass) {
        FieldInfo field2;
        List<FieldInfo> fields = classInfo.findFields(annotationClass.getName());
        return fields.size() == 1 && (field2 = fields.get(0)).isTypeOf(node.getClass());
    }

    private Class underlyingElementType(ClassInfo classInfo, String propertyName) {
        FieldInfo fieldInfo = this.fieldInfoForPropertyName(propertyName, classInfo);
        Class<?> clazz = null;
        if (fieldInfo != null) {
            clazz = DescriptorMappings.getType(fieldInfo.getTypeDescriptor());
        }
        return clazz;
    }

    private FieldInfo fieldInfoForPropertyName(String propertyName, ClassInfo classInfo) {
        FieldInfo labelField = classInfo.labelFieldOrNull();
        if (labelField != null && labelField.getName().toLowerCase().equals(propertyName.toLowerCase())) {
            return labelField;
        }
        return classInfo.propertyField(propertyName);
    }
}

