/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.context;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.neo4j.ogm.context.DirectedRelationship;

class EntityCollector {
    private final Map<Long, Map<DirectedRelationship, Map<Class, Collection<TargetTriple>>>> collected = new HashMap<Long, Map<DirectedRelationship, Map<Class, Collection<TargetTriple>>>>();

    EntityCollector() {
    }

    public void collectRelationship(Long sourceId, Class startPropertyType, String relationshipType, String relationshipDirection, long relationshipId, long targetId, Object target) {
        this.record(sourceId, startPropertyType, relationshipType, relationshipDirection, new TargetTriple(relationshipId, targetId, target));
    }

    public void collectRelationship(Long sourceId, Class startPropertyType, String relationshipType, String relationshipDirection, long targetId, Object target) {
        this.record(sourceId, startPropertyType, relationshipType, relationshipDirection, new TargetTriple(targetId, target));
    }

    private void record(Long owningEntityId, Class startPropertyType, String relationshipType, String relationshipDirection, TargetTriple triple) {
        this.collected.computeIfAbsent(owningEntityId, k -> new HashMap());
        DirectedRelationship directedRelationship = new DirectedRelationship(relationshipType, relationshipDirection);
        this.collected.get(owningEntityId).computeIfAbsent(directedRelationship, k -> new HashMap());
        this.collected.get(owningEntityId).get(directedRelationship).computeIfAbsent(startPropertyType, k -> new HashSet());
        this.collected.get(owningEntityId).get(directedRelationship).get(startPropertyType).add(triple);
    }

    public void forCollectedEntities(CollectedHandler handler) {
        this.collected.forEach((sourceId, relationshipMap) -> relationshipMap.forEach((relationship, targetTypeMap) -> {
            String type = relationship.type();
            String direction = relationship.direction();
            targetTypeMap.forEach((targetType, entityTriples) -> {
                List<Object> entities = entityTriples.stream().map(TargetTriple::getTarget).collect(Collectors.toList());
                handler.handle((Long)sourceId, type, direction, (Class)targetType, (Collection<Object>)entities);
            });
        }));
    }

    private static class TargetTriple {
        private final long relationshipId;
        private final long targetGraphId;
        private final Object target;

        TargetTriple(long targetGraphId, Object target) {
            this.relationshipId = -1L;
            this.targetGraphId = targetGraphId;
            this.target = target;
        }

        TargetTriple(long relationshipId, long targetGraphId, Object target) {
            this.relationshipId = relationshipId;
            this.targetGraphId = targetGraphId;
            this.target = Objects.requireNonNull(target);
        }

        public long getRelationshipId() {
            return this.relationshipId;
        }

        public Object getTarget() {
            return this.target;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TargetTriple that = (TargetTriple)o;
            if (this.relationshipId != that.relationshipId) {
                return false;
            }
            return this.targetGraphId == that.targetGraphId;
        }

        public int hashCode() {
            int result = (int)(this.relationshipId ^ this.relationshipId >>> 32);
            result = 31 * result + (int)(this.targetGraphId ^ this.targetGraphId >>> 32);
            return result;
        }
    }

    static interface CollectedHandler {
        public void handle(Long var1, String var2, String var3, Class var4, Collection<Object> var5);
    }
}

