/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.sarif;

import com.google.common.base.Objects;
import de.fraunhofer.aisec.cpg.sarif.Region;
import java.net.URI;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class PhysicalLocation {
    private final @NonNull ArtifactLocation artifactLocation;
    private @NonNull Region region;

    public static @NonNull String locationLink(@Nullable PhysicalLocation location) {
        if (location != null) {
            return location.getArtifactLocation().getUri() + ":" + location.getRegion().getStartLine() + ":" + location.getRegion().getStartColumn();
        }
        return "unknown";
    }

    public PhysicalLocation(URI uri, @NonNull Region region) {
        this.artifactLocation = new ArtifactLocation(uri);
        this.region = region;
    }

    public void setRegion(@NonNull Region region) {
        this.region = region;
    }

    public @NonNull Region getRegion() {
        return this.region;
    }

    public @NonNull ArtifactLocation getArtifactLocation() {
        return this.artifactLocation;
    }

    public String toString() {
        return this.artifactLocation.toString() + "(" + this.region.toString() + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PhysicalLocation)) {
            return false;
        }
        PhysicalLocation that = (PhysicalLocation)o;
        return Objects.equal(this.artifactLocation, that.artifactLocation) && Objects.equal(this.region, that.region);
    }

    public int hashCode() {
        return Objects.hashCode(this.artifactLocation, this.region);
    }

    public static class ArtifactLocation {
        private final @NonNull URI uri;

        public ArtifactLocation(@NonNull URI uri) {
            this.uri = uri;
        }

        public @NonNull URI getUri() {
            return this.uri;
        }

        public String toString() {
            return this.uri.getPath().substring(this.uri.getPath().lastIndexOf(47) + 1);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ArtifactLocation)) {
                return false;
            }
            ArtifactLocation that = (ArtifactLocation)o;
            return Objects.equal(this.uri, that.uri);
        }

        public int hashCode() {
            return Objects.hashCode(this.uri);
        }
    }
}

